/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class Block
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private Prism d_prism;

    public Block(UnitPoint3D minPoint, UnitPoint3D maxPoint, Material mat) {
        this(minPoint, maxPoint, "Obstruction", mat);
    }

    public Block(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Material mat) {
        super(description);
        this.d_prism = new Prism(minPoint.x(Geometry.GEOM_LENGTH_UNIT), maxPoint.x(Geometry.GEOM_LENGTH_UNIT), minPoint.y(Geometry.GEOM_LENGTH_UNIT), maxPoint.y(Geometry.GEOM_LENGTH_UNIT), minPoint.z(Geometry.GEOM_LENGTH_UNIT), maxPoint.z(Geometry.GEOM_LENGTH_UNIT));
        this.initFaces(new Material[]{mat, mat, mat, mat, mat, mat});
    }

    public Block(UnitPoint3D[] eightPoints, String description, Material mat) {
        super(description);
        this.d_prism = new Prism(new Point3d[]{eightPoints[0].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[1].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[2].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[3].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[4].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[5].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[6].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), eightPoints[7].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT)});
        this.initFaces(new Material[]{mat, mat, mat, mat, mat, mat});
    }

    private void initFaces(Material[] materials) {
        this.d_faces = new Vector(6);
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            this.d_faces.add(new BlockFace(this, i, materials[i]));
        }
    }

    @Override
    public Task taskScaleObject(UnitPoint3D base, Tuple3d scale) {
        return null;
    }

    @Override
    public Task taskRotateObject(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        return null;
    }

    @Override
    public Task taskTranslateObject(UnitPoint3D delta) {
        return null;
    }

    @Override
    public Task taskMirrorObject(int plane, UnitDouble value) {
        return null;
    }

    @Override
    public Object clone() {
        Block clone = (Block)super.clone();
        Iterator<IFace> faceIter = clone.getFaceIterator();
        while (faceIter.hasNext()) {
            BlockFace f = (BlockFace)faceIter.next();
            f.d_block = clone;
        }
        clone.d_prism = (Prism)this.d_prism.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Block b = (Block)obj;
        return this.d_prism.equals(b.d_prism);
    }

    public void setPoint(int index, UnitPoint3D point) {
        Point3d p = this.d_prism.getPoint(index);
        p.x = point.x(Geometry.GEOM_LENGTH_UNIT);
        p.y = point.y(Geometry.GEOM_LENGTH_UNIT);
        p.z = point.z(Geometry.GEOM_LENGTH_UNIT);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("OBST");
        Vector<Double> coords = new Vector<Double>(6);
        Point3d minPoint = this.d_prism.getPoint(0);
        Point3d maxPoint = this.d_prism.getPoint(6);
        coords.add(minPoint.x);
        coords.add(maxPoint.x);
        coords.add(minPoint.y);
        coords.add(maxPoint.y);
        coords.add(minPoint.z);
        coords.add(maxPoint.z);
        rec.setValue("XB", coords);
        if (this.isUniformMaterial()) {
            rec.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            VectorFromArray<String> mats = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            Vector<String> mats = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                mats.add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            rec.setValue("SURF_ID6", mats);
        }
        rec.setComment(this.getName());
        recs.add(rec);
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        ((IFace)this.d_faces.get(faceIndex)).setMaterial(mat);
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return ((IFace)this.d_faces.get(faceIndex)).getMaterial();
    }

    @Override
    public String getTypeDescription() {
        return "Block";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Block d_block;
        private byte d_index;

        public BlockFace(Block block, byte index, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = index;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public String getName() {
            return "Face " + this.d_index;
        }

        @Override
        public void getGeometry(Geometry g) {
            Quad q = this.d_block.d_prism.getFace(this.d_index);
            g.addQuad(q);
        }

        @Override
        public void setMaterial(Material m) {
            super.setMaterial(m);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof BlockFace)) {
                return false;
            }
            BlockFace bf = (BlockFace)obj;
            return this.d_index == bf.d_index;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }
}

