/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class AUnalignedFDSObject
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    public static final byte FACE_XMIN = 0;
    public static final byte FACE_XMAX = 1;
    public static final byte FACE_YMIN = 2;
    public static final byte FACE_YMAX = 3;
    public static final byte FACE_ZMIN = 4;
    public static final byte FACE_ZMAX = 5;
    public static final byte FACE_AB = 0;
    public static final byte FACE_ABP = 1;
    public static final byte FACE_A = 2;
    public static final byte FACE_B = 3;
    public static final byte FACE_BOTTOM = 4;
    public static final byte FACE_TOP = 5;
    private UnitPoint2D d_a;
    private UnitPoint2D d_b;
    private UnitDouble d_top;
    private UnitDouble d_bottom;
    private UnitDouble d_thickness;
    private transient Vector2d d_lastThicknessVector = null;

    public AUnalignedFDSObject(Material mat) {
        this(null, mat);
    }

    public AUnalignedFDSObject(String description, Material mat) {
        this(new UnitPoint2D(0.0, 0.0, SI.METER), new UnitPoint2D(0.0, 0.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), description, mat);
    }

    public AUnalignedFDSObject(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, Material mat) {
        this(a, b, bottom, top, thickness, "Obstruction", mat);
    }

    public AUnalignedFDSObject(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, String description, Material mat) {
        super(description);
        assert (bottom == null || top == null || bottom.compareTo(top) <= 0);
        this.d_a = a;
        this.d_b = b;
        this.d_bottom = bottom;
        this.d_top = top;
        this.d_thickness = thickness;
        this.initFaces(new Material[]{mat, mat, mat, mat, mat, mat});
    }

    public static void fromLegacy(Wall oldObj, AUnalignedFDSObject newObj) {
        AbstractFDSObject.fromLegacy(oldObj, newObj);
        newObj.d_a = oldObj.getStartPoint();
        newObj.d_b = oldObj.getEndPoint();
        newObj.d_thickness = oldObj.getThickness();
        newObj.d_bottom = oldObj.getBottom();
        newObj.d_top = oldObj.getTop();
    }

    private void initFaces(Material[] materials) {
        this.d_faces = new Vector(6);
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            int fdsFaceIndex = this.internalFaceIndexToFDSIndex(i);
            this.d_faces.add(this.createFace(i, materials[fdsFaceIndex]));
        }
    }

    protected IFace createFace(byte internalFaceIndex, Material mat) {
        return new BlockFace(this, internalFaceIndex, mat);
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof AUnalignedFDSObject)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        AUnalignedFDSObject obj = (AUnalignedFDSObject)baseObject;
        Iterator<IFace> faceIter = this.getFaceIterator();
        while (faceIter.hasNext()) {
            BlockFace f = (BlockFace)faceIter.next();
            f.d_block = this;
        }
        this.d_a = (UnitPoint2D)obj.d_a.clone();
        this.d_b = (UnitPoint2D)obj.d_b.clone();
        this.d_top = (UnitDouble)obj.d_top.clone();
        this.d_bottom = (UnitDouble)obj.d_bottom.clone();
        this.d_thickness = (UnitDouble)obj.d_thickness.clone();
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AUnalignedFDSObject)) {
            return false;
        }
        AUnalignedFDSObject b = (AUnalignedFDSObject)obj;
        boolean equal = this.d_a.equals(b.d_a) && this.d_b.equals(b.d_b) && this.d_top.equals(b.d_top) && this.d_bottom.equals(b.d_bottom) && this.d_thickness.equals(b.d_thickness);
        return equal;
    }

    public UnitPoint2D getStartPoint() {
        return this.d_a;
    }

    public void setStartPoint(UnitPoint2D startPoint) {
        this.d_a = startPoint;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint2D getEndPoint() {
        return this.d_b;
    }

    public void setEndPoint(UnitPoint2D endPoint) {
        this.d_b = endPoint;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public void setBottom(UnitDouble bottom) {
        this.d_bottom = bottom;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public void setTop(UnitDouble top) {
        this.d_top = top;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public void setThickness(UnitDouble thickness) {
        this.d_thickness = thickness;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D delta) {
        this.d_a.x = this.d_a.x.add(delta.xu());
        this.d_a.y = this.d_a.y.add(delta.yu());
        this.d_b.x = this.d_b.x.add(delta.xu());
        this.d_b.y = this.d_b.y.add(delta.yu());
        this.d_top = this.d_top.add(delta.zu());
        this.d_bottom = this.d_bottom.add(delta.zu());
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void scale(UnitPoint3D base, Tuple3d scale) {
        assert (scale.x >= 0.0 && scale.y >= 0.0 && scale.z >= 0.0);
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Point2D.Double pta = this.getStartPoint().getValue(lu);
        Point2D.Double ptb = this.getEndPoint().getValue(lu);
        Point3d ptTop = new Point3d(0.0, 0.0, this.getTop().getValue(lu));
        Point3d ptBottom = new Point3d(0.0, 0.0, this.getBottom().getValue(lu));
        AUnalignedFDSObject.scalePoint(pta, base3d, scale);
        AUnalignedFDSObject.scalePoint(ptb, base3d, scale);
        AUnalignedFDSObject.scalePoint(ptTop, base3d, scale);
        AUnalignedFDSObject.scalePoint(ptBottom, base3d, scale);
        ADomainObject.pauseUpdates(this, false);
        this.setStartPoint(new UnitPoint2D(pta, lu));
        this.setEndPoint(new UnitPoint2D(ptb, lu));
        this.setTop(new UnitDouble(ptTop.z, lu));
        this.setBottom(new UnitDouble(ptBottom.z, lu));
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    private double scaleThickness(double thickness, UnitPoint3D base, Tuple3d scale) {
        double scaleFactor = Math.sqrt(scale.x * scale.x + scale.y * scale.y + scale.z * scale.z);
        return thickness * scaleFactor;
    }

    @Override
    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Matrix3d rot = AUnalignedFDSObject.getRotateMat(rotAxis, amount);
        Point2D.Double pta2d = this.getStartPoint().getValue(lu);
        Point2D.Double ptb2d = this.getEndPoint().getValue(lu);
        AUnalignedFDSObject.rotatePoint(pta2d, base3d, rot);
        AUnalignedFDSObject.rotatePoint(ptb2d, base3d, rot);
        ADomainObject.pauseUpdates(this, false);
        this.setStartPoint(new UnitPoint2D(pta2d, lu));
        this.setEndPoint(new UnitPoint2D(ptb2d, lu));
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void mirror(int plane, UnitDouble value) {
    }

    public UnitPoint2D getThicknessVector() {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Vector2d vec = this.getThicknessVector(this.d_thickness.getValue(lu), lu);
        return new UnitPoint2D(vec.x, vec.y, lu);
    }

    private Vector2d getThicknessVector(double thickness, Unit u) {
        Vector2d thick;
        double d_errTol = 1.0E-15;
        double dx = this.d_b.x.getValue(u) - this.d_a.x.getValue(u);
        double dy = this.d_b.y.getValue(u) - this.d_a.y.getValue(u);
        if (Math.abs(dx) < 1.0E-15 && Math.abs(dy) < 1.0E-15) {
            if (this.d_lastThicknessVector != null) {
                return this.d_lastThicknessVector;
            }
            thick = new Vector2d(1.0, 0.0);
        } else {
            thick = new Vector2d(-dy, dx);
            thick.normalize();
        }
        thick.scale(thickness);
        this.d_lastThicknessVector = new Vector2d(thick);
        return thick;
    }

    public boolean isAligned() {
        PyroMod pyMod = null;
        Iterator<PyroMod> iterator = this.getDomains().iterator();
        if (iterator.hasNext()) {
            PyroMod pm;
            pyMod = pm = iterator.next();
        }
        if (pyMod != null) {
            UnitDouble tol = pyMod.getAlignTol();
            UnitDouble xdiff = this.d_a.x.diff(this.d_b.x);
            UnitDouble ydiff = this.d_a.y.diff(this.d_b.y);
            return xdiff.compareTo(tol) <= 0 || ydiff.compareTo(tol) <= 0;
        }
        return this.d_a.x.tolEquals(this.d_b.x) || this.d_a.y.tolEquals(this.d_b.y);
    }

    @Override
    public boolean isRasterizable() {
        return !this.isAligned();
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry superGeom = new Geometry();
        super.getGeometry(superGeom);
        Point3D thisMin = superGeom.getMinPoint();
        return new UnitPoint3D(thisMin.x, thisMin.y, thisMin.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry superGeom = new Geometry();
        super.getGeometry(superGeom);
        Point3D thisMax = superGeom.getMaxPoint();
        return new UnitPoint3D(thisMax.x, thisMax.y, thisMax.z, Geometry.GEOM_LENGTH_UNIT);
    }

    protected abstract IFDSFragGenerator getFaceFragGenerator(IFace var1);

    @Override
    public void getGeometry(Geometry g) {
        super.getGeometry(g);
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
    }

    protected abstract void fillExtraRecords(FDSInputRecord var1);

    protected void fillMaterialRecords(FDSInputRecord rec) {
        int[] internalIndicies = new int[]{this.fdsFaceIndexToInternalIndex(0), this.fdsFaceIndexToInternalIndex(1), this.fdsFaceIndexToInternalIndex(2), this.fdsFaceIndexToInternalIndex(3), this.fdsFaceIndexToInternalIndex(4), this.fdsFaceIndexToInternalIndex(5)};
        if (this.isUniformMaterial()) {
            rec.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[1])).getMaterial() && ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[2])).getMaterial() && ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial() == ((IFace)this.d_faces.get(internalIndicies[3])).getMaterial()) {
            VectorFromArray<String> mats = new VectorFromArray<String>(((IFace)this.d_faces.get(internalIndicies[5])).getMaterial().getName(), ((IFace)this.d_faces.get(internalIndicies[0])).getMaterial().getName(), ((IFace)this.d_faces.get(internalIndicies[4])).getMaterial().getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            Vector<String> mats = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                BlockFace face = (BlockFace)this.d_faces.get(internalIndicies[i]);
                mats.add(face.getMaterial().getName());
            }
            rec.setValue("SURF_ID6", mats);
        }
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    protected int fdsFaceIndexToInternalIndex(int fdsIndex) {
        for (int m = 0; m < this.d_faces.size(); ++m) {
            int faceFDSIndex = this.internalFaceIndexToFDSIndex(m);
            if (fdsIndex != faceFDSIndex) continue;
            return m;
        }
        return -1;
    }

    private Vector3d getClosestAlignedAxisAB() {
        Vector3d[] axes;
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        Point2D.Double a2d = this.d_a.getValue(u);
        Point2D.Double b2d = this.d_b.getValue(u);
        Point3d a = new Point3d(((Point2D)a2d).getX(), ((Point2D)a2d).getY(), 0.0);
        Point3d b = new Point3d(((Point2D)b2d).getX(), ((Point2D)b2d).getY(), 0.0);
        Vector3d abVec = new Vector3d();
        abVec.sub(b, a);
        abVec.normalize();
        Vector3d closestAxis = Geometry.VEC3D_XPOS;
        double smallestDotDiff = Double.MAX_VALUE;
        for (Vector3d axis : axes = new Vector3d[]{Geometry.VEC3D_XNEG, Geometry.VEC3D_XPOS, Geometry.VEC3D_YNEG, Geometry.VEC3D_YPOS, Geometry.VEC3D_ZNEG, Geometry.VEC3D_ZPOS}) {
            double dot = abVec.dot(axis);
            double dotDiff = Math.abs(dot - 1.0);
            if (!(dotDiff < smallestDotDiff)) continue;
            smallestDotDiff = dotDiff;
            closestAxis = axis;
        }
        return closestAxis;
    }

    protected int internalFaceIndexToFDSIndex(int internalIndex) {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        double thickness = this.getThickness().getValue(u);
        Vector3d closestAxis = this.getClosestAlignedAxisAB();
        int orientation = closestAxis == Geometry.VEC3D_XPOS ? (thickness >= 0.0 ? 0 : 1) : (closestAxis == Geometry.VEC3D_XNEG ? (thickness >= 0.0 ? 2 : 3) : (closestAxis == Geometry.VEC3D_YPOS ? (thickness >= 0.0 ? 4 : 5) : (thickness >= 0.0 ? 6 : 7)));
        switch (orientation) {
            case 0: {
                switch (internalIndex) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return internalIndex;
            }
            case 1: {
                switch (internalIndex) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return internalIndex;
            }
            case 2: {
                switch (internalIndex) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return internalIndex;
            }
            case 3: {
                switch (internalIndex) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return internalIndex;
            }
            case 4: {
                switch (internalIndex) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return internalIndex;
            }
            case 5: {
                switch (internalIndex) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return internalIndex;
            }
            case 6: {
                switch (internalIndex) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return internalIndex;
            }
            case 7: {
                switch (internalIndex) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return internalIndex;
            }
        }
        return internalIndex;
    }

    @Override
    public void setMaterial(int fdsFaceIndex, Material mat) {
        int internalIndex = this.fdsFaceIndexToInternalIndex(fdsFaceIndex);
        ((IFace)this.d_faces.get(internalIndex)).setMaterial(mat);
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void fireDomainEvent(IDomainEvent evt) {
        ADomainObject.fireDomainEvent(this, evt);
    }

    public void resumeUpdates(IDomainEvent evt) {
        ADomainObject.resumeUpdates(this, evt);
    }

    @Override
    public Material getMaterial(int fdsFaceIndex) {
        int internalIndex = this.fdsFaceIndexToInternalIndex(fdsFaceIndex);
        return ((IFace)this.d_faces.get(internalIndex)).getMaterial();
    }

    public static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AUnalignedFDSObject d_block;
        private byte d_index;

        public BlockFace(AUnalignedFDSObject block, byte index, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = index;
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_index];
        }

        private Point3d[] getGeomVerts() {
            Point3d p3;
            Point3d p2;
            Point3d p1;
            Point3d p0;
            Unit u = Geometry.GEOM_LENGTH_UNIT;
            Point2D.Double a = this.d_block.d_a.getValue(u);
            Point2D.Double b = this.d_block.d_b.getValue(u);
            double thickness = this.d_block.d_thickness.getValue(u);
            Vector2d thick = this.d_block.getThicknessVector(thickness, u);
            switch (this.d_index) {
                case 0: {
                    p0 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_top.getValue(u));
                    p1 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_bottom.getValue(u));
                    p2 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_bottom.getValue(u));
                    p3 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_top.getValue(u));
                    break;
                }
                case 1: {
                    p0 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    p1 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_top.getValue(u));
                    p2 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_top.getValue(u));
                    p3 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    break;
                }
                case 2: {
                    p0 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_bottom.getValue(u));
                    p1 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_top.getValue(u));
                    p2 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_top.getValue(u));
                    p3 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    break;
                }
                case 3: {
                    p0 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_top.getValue(u));
                    p1 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_bottom.getValue(u));
                    p2 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    p3 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_top.getValue(u));
                    break;
                }
                case 4: {
                    p0 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_bottom.getValue(u));
                    p1 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    p2 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_bottom.getValue(u));
                    p3 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_bottom.getValue(u));
                    break;
                }
                case 5: {
                    p0 = new Point3d(((Point2D)a).getX(), ((Point2D)a).getY(), this.d_block.d_top.getValue(u));
                    p1 = new Point3d(((Point2D)b).getX(), ((Point2D)b).getY(), this.d_block.d_top.getValue(u));
                    p2 = new Point3d(((Point2D)b).getX() + thick.x, ((Point2D)b).getY() + thick.y, this.d_block.d_top.getValue(u));
                    p3 = new Point3d(((Point2D)a).getX() + thick.x, ((Point2D)a).getY() + thick.y, this.d_block.d_top.getValue(u));
                    break;
                }
                default: {
                    assert (false);
                    p3 = null;
                    p2 = null;
                    p1 = null;
                    p0 = null;
                }
            }
            if (thickness >= 0.0) {
                return new Point3d[]{p0, p1, p2, p3};
            }
            return new Point3d[]{p3, p2, p1, p0};
        }

        @Override
        public void getGeometry(Geometry g) {
            Point3d[] verts = this.getGeomVerts();
            Vector3d normal = null;
            switch (this.d_index) {
                case 4: {
                    normal = Geometry.VEC3D_ZNEG;
                    break;
                }
                case 5: {
                    normal = Geometry.VEC3D_ZPOS;
                }
            }
            PrimProps props = new PrimProps(this.getMaterial(), this.getGeometryColor());
            Quad q = new Quad(verts, normal, props);
            g.addQuad(q);
        }

        protected Color getGeometryColor() {
            return this.d_block.getColor();
        }

        protected AUnalignedFDSObject getBlock() {
            return this.d_block;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof BlockFace)) {
                return false;
            }
            BlockFace bf = (BlockFace)obj;
            return this.d_index == bf.d_index;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return Util.convertArray(Geometry.GEOM_LENGTH_UNIT, this.getGeomVerts());
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return this.d_block.getFaceFragGenerator(this);
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint2D d_pa;
        private UnitPoint2D d_pb;
        private UnitDouble d_top;
        private UnitDouble d_bottom;
        private UnitDouble d_thickness;
        private Material d_topMat;
        private Material d_bottomMat;

        public SaveGeomTask(int est) {
            super(est, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AUnalignedFDSObject.this, false);
            AUnalignedFDSObject.this.setTop(this.d_top);
            AUnalignedFDSObject.this.setBottom(this.d_bottom);
            AUnalignedFDSObject.this.setStartPoint(this.d_pa);
            AUnalignedFDSObject.this.setEndPoint(this.d_pb);
            AUnalignedFDSObject.this.setThickness(this.d_thickness);
            AUnalignedFDSObject.this.setMaterial(5, this.d_topMat);
            AUnalignedFDSObject.this.setMaterial(4, this.d_bottomMat);
            AUnalignedFDSObject.this.resumeUpdates(new FDSObjectDomainEvent(AUnalignedFDSObject.this, 5));
        }

        @Override
        public void run() {
            this.d_pa = (UnitPoint2D)AUnalignedFDSObject.this.getStartPoint().clone();
            this.d_pb = (UnitPoint2D)AUnalignedFDSObject.this.getEndPoint().clone();
            this.d_top = (UnitDouble)AUnalignedFDSObject.this.getTop().clone();
            this.d_bottom = (UnitDouble)AUnalignedFDSObject.this.getBottom().clone();
            this.d_thickness = (UnitDouble)AUnalignedFDSObject.this.getThickness().clone();
            this.d_topMat = AUnalignedFDSObject.this.getMaterial(5);
            this.d_bottomMat = AUnalignedFDSObject.this.getMaterial(4);
        }
    }
}

