/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.legacy_2006_2.domain.Texture;
import pyrosim.legacy_2006_2.domain.TextureInfo;

public class TextureDB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, TextureInfo> d_defaults = new HashMap<String, TextureInfo>();
    private Map<String, Texture> d_textures = new HashMap<String, Texture>();

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_textures = new HashMap<String, Texture>();
        this.d_defaults = new HashMap<String, TextureInfo>();
        ois.readInt();
        List inUse = (List)ois.readObject();
        for (TextureData td : inUse) {
            this.addToDB(td.id, td.img);
        }
    }

    public static TextureDB fromLegacy(pyrosim.legacy_2006_2.legacy.v17.TextureDB oldDB) {
        TextureDB db = new TextureDB();
        for (String texName : oldDB.keys()) {
            if (db.d_defaults.containsKey(texName)) continue;
            System.out.println("importing legacy texture " + texName + "...");
            pyrosim.legacy_2006_2.legacy.v17.TextureInfo oldTi = oldDB.get(texName);
            String fn = oldTi.getFileName();
            BufferedImage img = oldTi.getImage();
            db.addToDB(fn, img);
        }
        return db;
    }

    public void addToDB(String texID, BufferedImage img) {
        Texture tex = new Texture(texID, img);
        this.d_textures.put(texID, tex);
    }

    public TextureInfo addToDB(File file) {
        try {
            BufferedImage img = ImageIO.read(file);
            if (img != null) {
                this.d_textures.put(file.getName(), new Texture(file.getName(), img));
                TextureInfo ti = new TextureInfo(file.getName());
                this.d_defaults.put(file.getName(), ti);
                return ti;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Set<String> names() {
        return this.d_textures.keySet();
    }

    public Texture getTexture(String id) {
        return this.d_textures.get(id);
    }

    public void setDefaultInfo(String texname, TextureInfo defaultInfo) {
        this.d_defaults.put(texname, defaultInfo);
    }

    public TextureInfo getDefaultInfo(String texname) {
        return this.d_defaults.get(texname);
    }

    private static class TextureData
    implements Serializable {
        static final long serialVersionUID = 8878324277380607853L;
        private static final int VERSION = 1;
        public String id;
        public BufferedImage img;

        public TextureData(String id, BufferedImage img) {
            this.id = id;
            this.img = img;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeInt(1);
            oos.writeObject(this.id);
            if (this.img != null) {
                ImageIO.write((RenderedImage)this.img, "jpg", oos);
            } else {
                oos.writeObject(null);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.readInt();
            this.id = (String)ois.readObject();
            this.img = ImageIO.read(ois);
        }
    }
}

