/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v173.domain.devices.hvac;

import java.io.ObjectStreamException;
import java.util.Arrays;
import javax.vecmath.Point3d;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.legacy.v173.domain.devices.hvac.HvacDevice;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class NodeDevice
extends HvacDevice {
    static final long serialVersionUID = 1L;

    public NodeDevice(String devcId, IQuantity msr) {
        super(devcId, msr);
    }

    @Override
    public IGeom getDevcGeom() {
        IFilteredCollection<HvacNode> nodes = theUtil.filter(Arrays.asList(this.getQuantity()), HvacNode.class);
        if (nodes.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (this.getQuantity().get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
            assert (nodes.size() == 2);
        } else {
            HvacNode node = (HvacNode)nodes.iterator().next();
            Point3d pt = NodeDevice.getPointForNode(node);
            if (pt != null) {
                return new Point(pt);
            }
            System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", node.getName());
        }
        return EmptyGeom.INSTANCE;
    }

    private Object readResolve() throws ObjectStreamException {
        pyrosim.domain.devices.hvac.NodeDevice modernDevc = new pyrosim.domain.devices.hvac.NodeDevice(this.getName(), this.getQuantity());
        modernDevc.setGeom(this.getGeom());
        modernDevc.setTags(this.getTags());
        modernDevc.setCustomFDSProps(this.getCustomFDSProps());
        return modernDevc;
    }
}

