/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.Util;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.IFDSRecordParser;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.BoundaryParser;
import pyrosim.io.fds.v6.parsers.ControlParser;
import pyrosim.io.fds.v6.parsers.DeviceParser;
import pyrosim.io.fds.v6.parsers.ExSpecParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.GeomParser;
import pyrosim.io.fds.v6.parsers.GridParser;
import pyrosim.io.fds.v6.parsers.HoleParser;
import pyrosim.io.fds.v6.parsers.HvacParser;
import pyrosim.io.fds.v6.parsers.InitParser;
import pyrosim.io.fds.v6.parsers.IsofParser;
import pyrosim.io.fds.v6.parsers.MaterialParser;
import pyrosim.io.fds.v6.parsers.MoveParser;
import pyrosim.io.fds.v6.parsers.MultParser;
import pyrosim.io.fds.v6.parsers.ObstParser;
import pyrosim.io.fds.v6.parsers.ParticleParser;
import pyrosim.io.fds.v6.parsers.PinConnFinisher;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.Plot3dParser;
import pyrosim.io.fds.v6.parsers.ProfParser;
import pyrosim.io.fds.v6.parsers.PropParser;
import pyrosim.io.fds.v6.parsers.RampFinisher;
import pyrosim.io.fds.v6.parsers.RampParser;
import pyrosim.io.fds.v6.parsers.ReactionParser;
import pyrosim.io.fds.v6.parsers.SimParamsParser;
import pyrosim.io.fds.v6.parsers.SliceParser;
import pyrosim.io.fds.v6.parsers.SurfaceParser;
import pyrosim.io.fds.v6.parsers.TableParser;
import pyrosim.io.fds.v6.parsers.VentParser;
import pyrosim.io.fds.v6.parsers.ZoneParser;

public class FDS6Parser
extends FDSParser {
    @Override
    protected List<? extends IFDSRecordParser> createParsers(FDSParsingInfo pi) {
        FDS6ParsingInfo pi6 = (FDS6ParsingInfo)pi;
        ExSpecParser exSpecParser = new ExSpecParser(pi6);
        PinConnParser pinConnsParser = new PinConnParser(pi6);
        ControlParser ctrlParser = new ControlParser(pi6, pinConnsParser);
        PropParser propParser = new PropParser(pi6);
        ZoneParser zoneParser = new ZoneParser(pi6);
        SimParamsParser spParser = new SimParamsParser(pi6);
        VentParser ventParser = new VentParser(pi6, pinConnsParser, exSpecParser);
        MoveParser moveParser = new MoveParser(pi6);
        return Arrays.asList(new MultParser(pi6), new GridParser(pi6), zoneParser, new RampParser(pi6), new TableParser(pi6), exSpecParser, new ParticleParser(pi6, pinConnsParser), new ReactionParser(pi6), new InitParser(pi6, pinConnsParser), new MaterialParser(pi6), new SurfaceParser(pi6, zoneParser), new HvacParser(pi6, pinConnsParser, ventParser), ctrlParser, propParser, new DeviceParser(pi6, pinConnsParser, propParser), spParser, moveParser, new ObstParser(pi6, pinConnsParser, spParser), new GeomParser(pi6, moveParser), new HoleParser(pi6, pinConnsParser), ventParser, new ProfParser(pi6), new IsofParser(pi6), new Plot3dParser(pi6), new BoundaryParser(pi6, propParser), new SliceParser(pi6), pinConnsParser, new PinConnFinisher(pi6, pinConnsParser, ctrlParser), new RampFinisher(pi6, pinConnsParser), new TailParser());
    }

    @Override
    protected FDSParsingInfo createParsingInfo(String filename, PyroMod writeMod, PyroMod readMod) {
        return new FDS6ParsingInfo(filename, writeMod, readMod);
    }

    @Override
    protected Map<String, FDSRecordSpec> getRecordSpecs() {
        return FDS6Const.getRecordSpecs(false);
    }

    @Override
    protected String getFinishRecType() {
        return "TAIL";
    }

    @Override
    protected void parseRecords(List<FDSParseRecord> records, String filename, FDSParsingInfo parsingInfo) throws IOException, FDSParseException {
        super.parseRecords(records, filename, parsingInfo);
        for (IPyroObject obj : parsingInfo.getParseResult().extractedObjs) {
            if (!(obj instanceof ISignalSink)) continue;
            Util.deleteWires(((ISignalSink)obj).getInputPin());
        }
    }

    public Map<String, String> getUnsupportedRecords(FDSParsingInfo pi) {
        HashMap<String, String> unsupported = new HashMap<String, String>();
        for (IFDSRecordParser iFDSRecordParser : this.createParsers(pi)) {
            HashSet<String> types = new HashSet<String>();
            iFDSRecordParser.getRecordTypes(types);
            for (String type : types) {
                iFDSRecordParser.getUnsupportedFields(type, unsupported);
            }
        }
        return unsupported;
    }

    private static class TailParser
    implements IFDSRecordParser {
        private TailParser() {
        }

        @Override
        public void getRecordTypes(Set<String> types) {
            types.add("TAIL");
        }

        @Override
        public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        }

        @Override
        public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        }

        @Override
        public void postProcess() {
        }
    }
}

