/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.AdiabaticSurfTempGasMeasurer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FEDMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxGasMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.sprayers.ASprayer;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.devices.statistics.IStatGeom;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.PropParser;
import pyrosim.io.fds.v6.renderers.DeviceRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;

public class DeviceParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private final PropParser d_propParser;
    private final List<FDSParseRecord> d_aspSamplerRecs = new ArrayList<FDSParseRecord>();
    private final Map<FDSParseRecord, Set<IDevice>> d_parsedDevices = new LinkedHashMap<FDSParseRecord, Set<IDevice>>();

    public DeviceParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns, PropParser propParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        DeviceParser.getUnsupported(type, unsupportedFields);
    }

    public static void getUnsupported(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("CONVERSION_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("COORD_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("DRY", "UNSUPPORTED");
        unsupportedFields.put("EVACUATION", "UNSUPPORTED");
        unsupportedFields.put("HIDE_COORDINATES", "UNSUPPORTED");
        unsupportedFields.put("INIT_ID", "UNSUPPORTED");
        unsupportedFields.put("OUTPUT", "UNSUPPORTED");
        unsupportedFields.put("PIPE_INDEX", "UNSUPPORTED");
        unsupportedFields.put("QUANTITY2", "UNSUPPORTED");
        unsupportedFields.put("SMOOTHING_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("STATISTICS_START", "UNSUPPORTED");
        unsupportedFields.put("TIME_AVERAGED", "UNSUPPORTED");
        unsupportedFields.put("UNITS", "UNSUPPORTED");
        unsupportedFields.put("VELO_INDEX", "UNSUPPORTED");
        unsupportedFields.put("X_ID", "UNSUPPORTED");
        unsupportedFields.put("Y_ID", "UNSUPPORTED");
        unsupportedFields.put("Z_ID", "UNSUPPORTED");
        unsupportedFields.put("CABLE_MASS_PER_LENGTH", "UNSUPPORTED");
        unsupportedFields.put("CABLE_DIAMETER", "UNSUPPORTED");
        unsupportedFields.put("CABLE_FAILURE_TEMPERATURE", "UNSUPPORTED");
        unsupportedFields.put("CABLE_JACKET_THICKNESS", "UNSUPPORTED");
        unsupportedFields.put("MOVE_ID", "UNSUPPORTED");
        unsupportedFields.put("SURF_ID", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        return this.processDevc(rec);
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (FDSParseRecord rec : this.d_aspSamplerRecs) {
            String aspID = (String)rec.get("DEVC_ID");
            if (aspID == null) continue;
            String samplerID = (String)rec.get("ID");
            UnitDouble flowrate = (UnitDouble)rec.get("FLOWRATE", true);
            UnitDouble delay = (UnitDouble)rec.get("DELAY", true);
            AspiratorSampler sampler = (AspiratorSampler)this.getContainer().getDevices().get(samplerID);
            Aspirator asp = (Aspirator)this.getContainer().getDevices().get(aspID);
            if (asp == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find aspirator: %s"), aspID));
            }
            asp.setSamplerLine(new Aspirator.SamplerLine(sampler, flowrate, delay));
        }
    }

    private IQuantity parseQuantity(FDSParseRecord devcRec, FDSParseRecord propRec, String failAction, boolean quantityRequired, boolean throwError) throws FDSRecordFormatException {
        String nodeIdKey;
        String ductIdKey;
        String matlIdKey;
        String specIdKey;
        String partIdKey;
        String quantKey;
        FDSParseRecord quantitySource = devcRec;
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null) {
            quantitySource = propRec;
            deviceType = (String)propRec.get("QUANTITY", false);
            if (deviceType == null) {
                return null;
            }
        }
        if (quantitySource.getType().equals("DEVC")) {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = "MATL_ID";
            ductIdKey = "DUCT_ID";
            nodeIdKey = "NODE_ID";
        } else {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = null;
            ductIdKey = null;
            nodeIdKey = null;
        }
        return this.parseQuantity(quantitySource, quantKey, partIdKey, specIdKey, matlIdKey, ductIdKey, nodeIdKey, 0L, failAction, quantityRequired, throwError, true);
    }

    private QuantityStat getStat(FDSParseRecord rec, Map<String, String> advancedProps, Set<QuantityStat.Type> types, String statKey, QuantityStat legacyStat) {
        String statStr = (String)rec.get(statKey, false);
        if (statStr == null) {
            if (legacyStat != null && types.contains((Object)legacyStat.type)) {
                return legacyStat;
            }
            return null;
        }
        Optional<QuantityStat> stat = types.stream().map(type -> QuantityStat.fromFds(type, statStr)).filter(s -> s != null).findFirst();
        if (stat.isEmpty()) {
            this.addWarning(rec, String.format(Intl.intl("Unknown statistic assigned to '%1$s': '%2$s'"), statKey, statStr), Intl.intl("Adding to advanced records."));
            advancedProps.put(statKey, "'" + statStr + "'");
            return null;
        }
        return stat.get();
    }

    protected boolean processDevc(FDSParseRecord devcRec) throws FDSRecordFormatException {
        FDSParseRecord propRec;
        String propID;
        HashMap<String, String> aprops = new HashMap<String, String>();
        QuantityStat legacyStat = this.getStat(devcRec, aprops, Set.of(QuantityStat.Type.SPATIAL, QuantityStat.Type.TEMPORAL), "STATISTICS", null);
        QuantityStat spatialStat = this.getStat(devcRec, aprops, Set.of(QuantityStat.Type.SPATIAL), "SPATIAL_STATISTIC", legacyStat);
        QuantityStat temporalStat = this.getStat(devcRec, aprops, Set.of(QuantityStat.Type.TEMPORAL), "TEMPORAL_STATISTIC", legacyStat);
        boolean idFab = false;
        String id = (String)devcRec.get("ID");
        if (id == null || id.trim().equals("")) {
            id = this.getNames(IDevice.class).generateName();
            idFab = true;
        }
        if ((propID = (String)devcRec.get("PROP_ID")) == null) {
            propRec = PropParser.getDefaultProp();
        } else {
            propRec = this.d_propParser.getProp(propID);
            if (propRec == null) {
                throw new FDSRecordFormatException(devcRec, String.format(Intl.intl("PROP record, %s, could not be found."), propID));
            }
        }
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null && (deviceType = (String)propRec.get("QUANTITY", false)) == null) {
            this.addWarning(devcRec, Intl.intl("The device type could not be determined from the DEVC or PROP record."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        ParsedDevc<IDevice> parsedDevice = null;
        SoftException exception = null;
        try {
            if (propRec.contains("PART_ID")) {
                parsedDevice = this.parseSprayer(devcRec, propRec, id, deviceType);
            } else if (deviceType.equals(Quantity.SPRINKLER_LINK_TEMPERATURE.fdsName)) {
                parsedDevice = this.parseSprinklerLink(devcRec, propRec, id);
            } else if (deviceType.equals(Quantity.LINK_TEMPERATURE.fdsName)) {
                parsedDevice = this.parseHeatDetector(devcRec, propRec, id);
            } else if (deviceType.equals("spot obscuration") || deviceType.equals(Quantity.CHAMBER_OBSCURATION.fdsName)) {
                parsedDevice = this.parseSmokeDetector(devcRec, propRec, id);
            } else if (deviceType.equalsIgnoreCase(Quantity.ASPIRATION.fdsName)) {
                parsedDevice = this.parseAspirator(devcRec, propRec, id);
            } else {
                if (deviceType.equals(Quantity.CABLE_TEMPERATURE.fdsName)) {
                    throw new SoftException(Intl.intl("%s is not supported."), deviceType);
                }
                if (FDS6QuantityMap.isLegacyFlowQuantity(deviceType)) {
                    parsedDevice = this.parseLegacyFlowMeasurer(devcRec, propRec, id, deviceType);
                } else if (this.isFlowMeasuerer(devcRec, spatialStat, temporalStat)) {
                    parsedDevice = this.parseFlowMeasurer(devcRec, propRec, id, deviceType);
                } else if (this.isStatisticsDevc(devcRec, spatialStat, temporalStat)) {
                    parsedDevice = this.parseStatisticsDevc(devcRec, propRec, aprops, id, deviceType, spatialStat, temporalStat);
                } else {
                    IQuantity msr = this.parseQuantity(devcRec, propRec, Intl.intl("Adding to additional records section."), true, false);
                    if (msr == null) {
                        return false;
                    }
                    Quantity quant = msr.get();
                    if (msr.equals(Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")))) {
                        parsedDevice = this.parseSootDensityDevice(devcRec, propRec, id);
                    } else if (quant.equals((Object)Quantity.PATH_OBSCURATION)) {
                        parsedDevice = this.parsePathObscurationMeasurer(devcRec, propRec, id);
                    } else if (quant.equals((Object)Quantity.LAYER_HEIGHT)) {
                        parsedDevice = this.parseLayerInfoMeasurer(devcRec, propRec, id, true, false, false);
                    } else if (quant.equals((Object)Quantity.UPPER_TEMPERATURE)) {
                        parsedDevice = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, true, false);
                    } else if (quant.equals((Object)Quantity.LOWER_TEMPERATURE)) {
                        parsedDevice = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, false, true);
                    } else if (quant.equals((Object)Quantity.TIME)) {
                        parsedDevice = this.parseClock(devcRec, propRec, id);
                    } else if (GasPointMeasurer.getQuantityFilter().test(msr.get())) {
                        parsedDevice = this.parseGasPointMeasurer(devcRec, propRec, id, msr);
                    } else if (SolidPointMeasurer.getQuantityFilter().test(msr.get())) {
                        parsedDevice = this.parseSolidPointMeasurer(devcRec, propRec, id, msr);
                    } else if (AABoxMeasurer.getQuantityFilter().test(msr.get())) {
                        parsedDevice = this.parseAABoxMeasurer(devcRec, propRec, id, msr);
                    } else if (HvacDevice.isValidQuantity(msr)) {
                        parsedDevice = this.parseHvacDevc(deviceType, devcRec, propRec, msr, id, temporalStat);
                    }
                }
            }
        }
        catch (SoftException e) {
            exception = e;
        }
        if (parsedDevice == null) {
            this.addWarning(devcRec, exception != null ? exception.getLocalizedMessage() : Intl.intl("Unknown device type encountered."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        Object device = parsedDevice.devc;
        boolean addSourceConnections = false;
        if (!idFab && device instanceof ISignalSource) {
            addSourceConnections = true;
        }
        boolean addSinkConnections = false;
        if (device == Clock.INSTANCE) {
            this.d_pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), id);
        } else {
            if (!(device instanceof Timer) && device instanceof ISignalSink) {
                addSinkConnections = true;
            }
            this.addUnsupportedCustomFDSProps((ICustomFDSPropsContainer)device, devcRec);
            if (propID != null && !propRec.empty() && this.getResult().unparsedRecords.contains(propRec) && !this.d_propParser.addUnsupportedCustomFDSProps((ICustomFDSPropsContainer)device, propRec)) {
                aprops.put("PROP_ID", "'" + propID + "'");
            }
            HashMap<String, String> advancedProps = new HashMap<String, String>(device.getCustomFDSProps("DEVC").getProps());
            advancedProps.putAll(aprops);
            device.setCustomFDSProps("DEVC", CustomFDSProps.get(advancedProps));
            int exists = this.existsStatus(devcRec, device, IDevice.class);
            if (exists != 0) {
                return this.convertToReturn(exists);
            }
            if (addSourceConnections) {
                DeviceParser.markSignalSource(device, this.d_pinConns, parsedDevice.getFdsPinId);
            }
            if (addSinkConnections) {
                DeviceParser.markSignalSink(devcRec, device, this.d_pinConns);
            }
            this.getContainer().getDevices().add((IPyroObject)device);
            this.flagObjectAdded((IPyroObject)device);
            Set devcContainer = this.d_parsedDevices.getOrDefault(devcRec, new HashSet());
            devcContainer.add(device);
            this.d_parsedDevices.put(devcRec, devcContainer);
        }
        return true;
    }

    private static <T extends IDevice> void markSignalSource(T devc, PinConnParser pinConns, BiFunction<? super T, ? super IOutPin, String> getFdsPinId) {
        ISignalSource source = (ISignalSource)((Object)devc);
        Iterator<? extends IOutPin> iterator = source.getOutputPins().iterator();
        while (iterator.hasNext()) {
            IOutPin pin;
            IOutPin finalPin = pin = iterator.next();
            pinConns.addOutputName(finalPin, getFdsPinId.apply(devc, pin));
        }
        if (devc instanceof Timer) {
            pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), devc.getName());
        }
    }

    private static void markSignalSink(FDSParseRecord devcRec, IDevice devc, PinConnParser pinConns) {
        String cid;
        String did;
        if (devc instanceof IFreezable) {
            did = "NO_UPDATE_DEVC_ID";
            cid = "NO_UPDATE_CTRL_ID";
        } else {
            did = "DEVC_ID";
            cid = "CTRL_ID";
        }
        DeviceParser.markSingleInputForRetrieval(devcRec, (ISignalSink)((Object)devc), pinConns, did, cid);
    }

    private ParsedDevc<IDevice> parseAABoxMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        UnitAABox box = DeviceParser.parseAABox(devcRec, "DEVC", "XB", true);
        AABoxMeasurer msrr = new AABoxMeasurer(id, msr, box);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        this.consumeProps((IDevice)msrr, propRec, new String[0]);
        return new ParsedDevc<IDevice>(msrr, (devc, pin) -> devc.getName());
    }

    private boolean isFlowMeasuerer(FDSParseRecord rec, QuantityStat spatialStat, QuantityStat temporalStat) {
        if (spatialStat == null) {
            return false;
        }
        if (temporalStat != null) {
            return false;
        }
        if (!rec.contains("XB")) {
            return false;
        }
        if (spatialStat != QuantityStat.STAT_SURFACE_INTEGRAL && spatialStat != QuantityStat.STAT_AREA_INTEGRAL) {
            return false;
        }
        String deviceType = rec.getString("QUANTITY");
        if (deviceType == null) {
            return false;
        }
        return this.getQuantityMap().isFlowMeasureQuantity(deviceType);
    }

    private ParsedDevc<FlowMeasurer> parseFlowMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String deviceType) throws FDSRecordFormatException {
        Integer ior;
        boolean countPositive;
        int flowDir = 2;
        FDSArray parseBounds = devcRec.getArray("QUANTITY_RANGE", true);
        boolean countNegative = (Double)parseBounds.get(0) < 0.0;
        boolean bl = countPositive = (Double)parseBounds.get(1) > 0.0;
        if (countNegative && !countPositive) {
            flowDir = 1;
        } else if (!countNegative && countPositive) {
            flowDir = 0;
        } else if (!countNegative && !countPositive) {
            this.addWarning(new FDSParseWarning(devcRec, Intl.intl("Unable to interpret flow direction."), String.format(Intl.intl("Parameter %s ignored."), "QUANTITY_RANGE")));
        }
        IQuantity quant = this.getQuantityMap().parseFlowQuantity(this.getParsingInfo(), devcRec, "QUANTITY", null, "SPEC_ID", null, null, null, true);
        if (quant.get().quantityType == QuantityType.SOLID && (ior = (Integer)devcRec.get("IOR")) != null) {
            switch (ior) {
                case 0: {
                    flowDir = 2;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    flowDir = 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    flowDir = 0;
                }
            }
        }
        AARectangle rect = this.parseAARectangle(devcRec);
        FlowMeasurer msrr = new FlowMeasurer(id, quant, rect, flowDir);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return new ParsedDevc<FlowMeasurer>(msrr, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<FlowMeasurer> parseLegacyFlowMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String deviceType) throws FDSRecordFormatException {
        Integer ior;
        int flowDir;
        String trimmed = deviceType.trim();
        char lastChar = trimmed.charAt(trimmed.length() - 1);
        Stream<Quantity> legQuants = this.getQuantityMap().getQuantity(switch (lastChar) {
            case '-' -> {
                flowDir = 1;
                yield trimmed.substring(0, trimmed.length() - 1).trim();
            }
            case '+' -> {
                flowDir = 0;
                yield trimmed.substring(0, trimmed.length() - 1).trim();
            }
            default -> {
                flowDir = 2;
                yield trimmed;
            }
        });
        Optional<Quantity> foundLegQuant = legQuants.filter(q -> FlowMeasurer.getQuantityFilter().test((Quantity)((Object)q))).findFirst();
        if (foundLegQuant.isEmpty()) {
            throw new FDSRecordFormatException(devcRec, Intl.intl("Invalid flow direction specified."));
        }
        Quantity legQuant = foundLegQuant.get();
        if (legQuant.quantityType == QuantityType.SOLID && (ior = (Integer)devcRec.get("IOR")) != null) {
            switch (ior) {
                case 0: {
                    flowDir = 2;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    flowDir = 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    flowDir = 0;
                }
            }
        }
        AARectangle rect = this.parseAARectangle(devcRec);
        Quantity quant = this.getQuantityMap().convertLegacyFlowQuantity(legQuant, rect.d_plane);
        FlowMeasurer msrr = new FlowMeasurer(id, quant.create(), rect, flowDir);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return new ParsedDevc<FlowMeasurer>(msrr, (devc, pin) -> devc.getName());
    }

    private boolean isStatisticsDevc(FDSParseRecord devcRec, QuantityStat spatialStat, QuantityStat temporalStat) {
        return !this.isHvacDevice(devcRec) && (spatialStat != null || temporalStat != null || devcRec.getInteger("POINTS", true) > 1 && (devcRec.contains("XBP") || devcRec.contains("XB")));
    }

    private boolean isHvacDevice(FDSParseRecord rec) {
        return rec.contains("DUCT_ID") || rec.contains("NODE_ID");
    }

    private ParsedDevc<StatisticsDevc> parseStatisticsDevc(FDSParseRecord devcRec, FDSParseRecord propRec, Map<String, String> advancedDevcProps, String id, String quantityStr, QuantityStat spatialStat, QuantityStat temporalStat) throws FDSRecordFormatException, SoftException {
        IStatGeom statGeom;
        String statDevcType = Intl.intl("Statistics Device");
        BiFunction<UnitPoint3D[], Boolean, IStatGeom> parseAsArray = (xbp, required) -> {
            boolean isTimeHistory;
            Integer numPoints = devcRec.getInteger("POINTS", false);
            if (numPoints == null) {
                if (!required.booleanValue()) {
                    return null;
                }
                numPoints = devcRec.getInteger("POINTS", true);
                this.addWarning(devcRec, String.format(Intl.intl("Use of %1$s also requires %2$s."), "XBP", "POINTS"), String.format(Intl.intl("Assuming %s is %d."), "POINTS", numPoints));
            }
            IStatGeom.ArrayProfile profile = (isTimeHistory = devcRec.getOptional("TIME_HISTORY").orElse(false).booleanValue()) ? IStatGeom.ArrayProfile.TIME_VARYING : IStatGeom.ArrayProfile.STEADY_STATE;
            UnitDouble dx = devcRec.getUnitDouble("DX", true);
            UnitDouble dy = devcRec.getUnitDouble("DY", true);
            UnitDouble dz = devcRec.getUnitDouble("DZ", true);
            return new IStatGeom.LinearArray(profile, xbp[0].getPoint3dValue(Geometry.LU), xbp[1].getPoint3dValue(Geometry.LU), new Point3d(dx.get(Geometry.LU), dy.get(Geometry.LU), dz.get(Geometry.LU)), numPoints);
        };
        if (devcRec.contains("XBP")) {
            UnitPoint3D[] xbp2 = DeviceParser.parseXBP(devcRec, Intl.intl("Array Device"), "XBP", true);
            statGeom = parseAsArray.apply(xbp2, true);
        } else if (devcRec.contains("XB")) {
            UnitPoint3D[] xb = DeviceParser.parseXB(devcRec, statDevcType, "XB", true);
            IStatGeom asArray = parseAsArray.apply(xb, false);
            statGeom = asArray != null ? asArray : new IStatGeom.Box(xb[0].getPoint3dValue(Geometry.LU), xb[1].getPoint3dValue(Geometry.LU));
        } else if (devcRec.contains("XYZ")) {
            UnitPoint3D xyz = DeviceParser.parseLoc(devcRec, statDevcType, "XYZ", true);
            statGeom = new IStatGeom.Point(xyz.getPoint3dValue(Geometry.LU));
        } else {
            throw new SoftException(Intl.intl("Statistics device must specify geometry with %1$s, %2$s, or %3$s."), "XBP", "XB", "XYZ");
        }
        IQuantity quantity = this.parseQuantity(devcRec, propRec, "", false, false);
        if (quantity == null) {
            return null;
        }
        BiFunction<String, Set, IStatGeom> makeGeomCompatible = (statType, types) -> {
            if (types.contains((Object)statGeom.getType())) {
                return statGeom;
            }
            Supplier<String> getGeomTypesMsg = () -> {
                String typesStr = types.stream().map(type -> type.name).collect(Collectors.joining(Intl.intl(", ")));
                return String.format(Intl.intl("%1$s statistics require one of the following types of geometry: %2$s"), statType, typesStr);
            };
            Supplier<IStatGeom> getIncompatibleGeom = () -> {
                this.addWarning(devcRec, (String)getGeomTypesMsg.get(), String.format(Intl.intl("Using supplied geometry that may be incompatible with the specified %s statistic."), statType));
                return statGeom;
            };
            IStatGeom iStatGeom = statGeom;
            Objects.requireNonNull(iStatGeom);
            IStatGeom selector0$temp = iStatGeom;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IStatGeom.Box.class, IStatGeom.LinearArray.class, IStatGeom.Point.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    AARectangle asRect;
                    IStatGeom.Box box = (IStatGeom.Box)selector0$temp;
                    if (types.contains((Object)IStatGeom.Type.RECTANGLE) && (asRect = AARectangle.construct(box.min, box.max, 1.0E-9, false)) != null) {
                        yield new IStatGeom.Rectangle(asRect);
                    }
                    if (types.contains((Object)IStatGeom.Type.POINT)) {
                        yield new IStatGeom.Point(box.getBoundingBox(new AABox()).getCenter());
                    }
                    yield getIncompatibleGeom.get();
                }
                case 1 -> {
                    IStatGeom.LinearArray array = (IStatGeom.LinearArray)selector0$temp;
                    if (types.contains((Object)IStatGeom.Type.POINT_ARRAY)) {
                        yield new IStatGeom.LinearArray(array.profile, array.p1, array.p2, IStatGeom.POINT_ARRAY, array.numPoints);
                    }
                    yield getIncompatibleGeom.get();
                }
                case 2 -> {
                    Grid grid;
                    IStatGeom.Point point = (IStatGeom.Point)selector0$temp;
                    if (types.contains((Object)IStatGeom.Type.GRID) && (grid = this.getGridForPoint(point.loc)) != null) {
                        this.addWarning(devcRec, getGeomTypesMsg.get(), String.format(Intl.intl("Using the Mesh:'%s' as the geometry."), grid.getName()));
                        yield new IStatGeom.GridGeom(grid);
                    }
                    yield getIncompatibleGeom.get();
                }
                default -> getIncompatibleGeom.get();
            };
        };
        IStatGeom finalGeom = spatialStat != null ? makeGeomCompatible.apply(Intl.intl("Spatial"), spatialStat.geomTypes) : (temporalStat != null ? makeGeomCompatible.apply(Intl.intl("Temporal"), temporalStat.geomTypes) : statGeom);
        StatisticsDevc devc = new StatisticsDevc(id, quantity, spatialStat, temporalStat, finalGeom);
        devc.setAlarmInfo(DeviceParser.parseAlarm(devcRec, devc.getUnitType()));
        if (!PropParser.isDefaultProp(propRec)) {
            boolean supported = this.d_propParser.addCustomFDSProps(devc, propRec, Filters.reject("ID"), true);
            assert (supported);
            this.getResult().unparsedRecords.remove(propRec);
        }
        BiFunction<StatisticsDevc, IOutPin, String> getPinId = (device, pin) -> devc.getName();
        if (devc.getStatGeom().getArrayProfile() == IStatGeom.ArrayProfile.TIME_VARYING) {
            getPinId = (device, pin) -> {
                if (pin instanceof StatisticsDevc.IStatOutPin) {
                    StatisticsDevc.IStatOutPin statPin = (StatisticsDevc.IStatOutPin)pin;
                    return DeviceRenderer.getTimeVaryingPinName(device.getName(), statPin);
                }
                assert (false);
                return device.getName();
            };
        }
        return new ParsedDevc<StatisticsDevc>(devc, getPinId);
    }

    private Grid getGridForPoint(Point3d loc3d) {
        for (PyroMod mod : this.getParsingInfo().getSourceContainers()) {
            for (Grid grid : ((APyroObject)mod.getGridManager()).flatten(Grid.class)) {
                Point3d min = grid.getMinPoint().getValue(SI.METER);
                Point3d max = grid.getMaxPoint().getValue(SI.METER);
                if (!(loc3d.x >= min.x) || !(loc3d.x <= max.x) || !(loc3d.y >= min.y) || !(loc3d.y <= max.y) || !(loc3d.z >= min.z) || !(loc3d.z <= max.z)) continue;
                return grid;
            }
        }
        return null;
    }

    private ParsedDevc<IDevice> parseLayerInfoMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, boolean height, boolean upperTemp, boolean lowerTemp) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        LayerMeasurer msrr = new LayerMeasurer(id, height, upperTemp, lowerTemp, beam);
        if (height) {
            msrr.getHeightInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getHeightInfo().getPin()));
        }
        if (upperTemp) {
            msrr.getUpperTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getUpperTempInfo().getPin()));
        }
        if (lowerTemp) {
            msrr.getLowerTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getLowerTempInfo().getPin()));
        }
        this.consumeProps((IDevice)msrr, propRec, new String[0]);
        return new ParsedDevc<IDevice>(msrr, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<PathObscurationMeasurer> parsePathObscurationMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        PathObscurationMeasurer obj = new PathObscurationMeasurer(id, beam);
        obj.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, obj.getQuantity().get()));
        this.consumeProps((IDevice)obj, propRec, new String[0]);
        return new ParsedDevc<PathObscurationMeasurer>(obj, (devc, pin) -> devc.getName());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, IDoubleOutPin pin) {
        return DeviceParser.parseAlarm(devcRec, pin.getUnitType());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, Quantity msr) {
        return DeviceParser.parseAlarm(devcRec, msr.unitType);
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, int unitType) {
        Double val = devcRec.getDouble("SETPOINT", false);
        if (val == null) {
            return null;
        }
        Unit unit = SIUS.unit(unitType);
        UnitDouble setpoint = new UnitDouble(val, unit);
        return new AlarmInfo(setpoint, DeviceParser.parseTripFlags(devcRec));
    }

    private static int parseTripFlags(FDSParseRecord devcRec) {
        int tripFlags = 0;
        if (devcRec.getBoolean("INITIAL_STATE", true).booleanValue()) {
            tripFlags |= 2;
        }
        if (devcRec.getBoolean("LATCH", true).booleanValue()) {
            tripFlags |= 1;
        }
        if (devcRec.getInteger("TRIP_DIRECTION", true) <= 0) {
            tripFlags |= 4;
        }
        return tripFlags;
    }

    private ParsedDevc<Aspirator> parseAspirator(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitDouble bypassFlowrate = (UnitDouble)devcRec.get("BYPASS_FLOWRATE", true);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Aspirator asp = new Aspirator(id, bypassFlowrate, loc);
        asp.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, asp.getQuantity().get()));
        return new ParsedDevc<Aspirator>(asp, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<AspiratorSampler> parseAspiratorSampler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        AspiratorSampler sampler = new AspiratorSampler(id, loc);
        sampler.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, sampler.getQuantity().get()));
        this.d_aspSamplerRecs.add(devcRec);
        return new ParsedDevc<AspiratorSampler>(sampler, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<? extends IDevice> parseSootDensityDevice(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        if (devcRec.contains("FLOWRATE") || devcRec.contains("DELAY") || devcRec.contains("DEVC_ID")) {
            return this.parseAspiratorSampler(devcRec, propRec, id);
        }
        return this.parseGasPointMeasurer(devcRec, propRec, id, Quantity.SPEC_DENSITY.create(ExSpecList.getPredefinedSpecies("SOOT")));
    }

    private ParsedDevc<? extends IDevice> parseClock(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        AlarmInfo ai = DeviceParser.parseAlarm(devcRec, Quantity.TIME);
        CustomFDSProps cprops = this.getUnsupportedCustomVals(devcRec);
        if (cprops == CustomFDSProps.EMPTY && PropParser.isDefaultProp(propRec) && devcRec.getString("NO_UPDATE_CTRL_ID") == null && devcRec.getString("NO_UPDATE_DEVC_ID") == null) {
            ADevice devc = ai == null ? Clock.INSTANCE : new Timer(id, ai.setpoint, TripFlags.initiallyOn(ai.tripFlags));
            return new ParsedDevc<IDevice>(devc, (d, pin) -> d.getName());
        }
        return this.parseGasPointMeasurer(devcRec, propRec, id, Quantity.TIME.create());
    }

    private void consumeProps(IDevice devc, FDSParseRecord propRec, String ... preConsumed) {
        this.consumeProps(devc, propRec, new HashSet<String>(Arrays.asList(preConsumed)));
    }

    private void consumeProps(IDevice devc, FDSParseRecord propRec, Collection<String> preConsumed) {
        if (!PropParser.isDefaultProp(propRec)) {
            preConsumed.add("ID");
            boolean supported = this.d_propParser.addCustomFDSProps(devc, propRec, Filters.reject(preConsumed), true);
            assert (supported);
            this.getResult().unparsedRecords.remove(propRec);
        }
    }

    private ParsedDevc<IDevice> parseGasPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        if (devcRec.get("IOR") != null) {
            this.addWarning(new FDSParseWarning(devcRec, String.format(Intl.intl("IOR is only used with devices attached to a solid surface. DEVC ID: %s"), id), Intl.intl("Ignoring IOR for Gas Point Measurer")));
        }
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        GasPointMeasurer devc = switch (msr.get()) {
            case Quantity.THERMOCOUPLE -> {
                GasPointMeasurer msrr = new Thermocouple(id, propRec.getUnitDouble("DIAMETER", true), propRec.getDouble("EMISSIVITY", true), propRec.getUnitDouble("DENSITY", true), propRec.getUnitDouble("SPECIFIC_HEAT", true), loc);
                msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
                this.consumeProps((IDevice)msrr, propRec, "DIAMETER", "EMISSIVITY", "DENSITY", "SPECIFIC_HEAT");
                yield msrr;
            }
            case Quantity.GAUGE_HEAT_FLUX_GAS -> {
                GasPointMeasurer msrr = new GaugeHeatFluxGasMeasurer(id, propRec.getUnitDouble("GAUGE_TEMPERATURE", true), propRec.getUnitDouble("HEAT_TRANSFER_COEFFICIENT", true), loc);
                msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
                this.consumeProps((IDevice)msrr, propRec, "GAUGE_TEMPERATURE", "HEAT_TRANSFER_COEFFICIENT");
                yield msrr;
            }
            case Quantity.FED -> {
                GasPointMeasurer msrr = new FEDMeasurer(id, propRec.getInteger("FED_ACTIVITY", true), loc);
                msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
                this.consumeProps((IDevice)msrr, propRec, "FED_ACTIVITY");
                yield msrr;
            }
            case Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS -> {
                GasPointMeasurer msrr = new AdiabaticSurfTempGasMeasurer(id, propRec.getDouble("EMISSIVITY", true), propRec.getUnitDouble("HEAT_TRANSFER_COEFFICIENT", true), loc);
                msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
                this.consumeProps((IDevice)msrr, propRec, "EMISSIVITY", "HEAT_TRANSFER_COEFFICIENT");
                yield msrr;
            }
            default -> {
                GasPointMeasurer msrr = new GasPointMeasurer(id, msr, loc);
                msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
                this.consumeProps((IDevice)msrr, propRec, new String[0]);
                yield msrr;
            }
        };
        return new ParsedDevc<IDevice>(devc, (d, pin) -> d.getName());
    }

    private ParsedDevc<IDevice> parseSolidPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        SolidPointMeasurer solidPointMeasurer;
        AttachedPointLoc loc = this.parseAttachedPointLoc(devcRec);
        Quantity quantity = msr.get();
        Objects.requireNonNull(quantity);
        Quantity quantity2 = quantity;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INSIDE_WALL_TEMPERATURE", "PRESSURE_COEFFICIENT", "GAUGE_HEAT_FLUX", Quantity.class}, (Quantity)quantity2, n)) {
                case 0: {
                    SolidPointMeasurer result = new InnerTempMeasurer(id, devcRec.getUnitDouble("DEPTH", true), loc);
                    this.consumeProps((IDevice)result, propRec, new String[0]);
                    solidPointMeasurer = result;
                    break block6;
                }
                case 1: {
                    SolidPointMeasurer result = new PressureCoeffMeasurer(id, propRec.getUnitDouble("CHARACTERISTIC_VELOCITY", true), loc);
                    this.consumeProps((IDevice)result, propRec, "CHARACTERISTIC_VELOCITY");
                    solidPointMeasurer = result;
                    break block6;
                }
                case 2: {
                    SolidPointMeasurer result = new GaugeHeatFluxMeasurer(id, propRec.getUnitDouble("GAUGE_TEMPERATURE", true), propRec.getDouble("GAUGE_EMISSIVITY", true), propRec.getUnitDouble("HEAT_TRANSFER_COEFFICIENT", true), loc);
                    this.consumeProps((IDevice)result, propRec, "GAUGE_TEMPERATURE", "GAUGE_EMISSIVITY", "HEAT_TRANSFER_COEFFICIENT");
                    solidPointMeasurer = result;
                    break block6;
                }
                case 3: {
                    Quantity q = quantity2;
                    if (!SolidDensityMeasurer.getQuantityFilter().test(msr.get())) {
                        n = 4;
                        continue block6;
                    }
                    SolidPointMeasurer result = new SolidDensityMeasurer(id, (ObjectQuantity)msr, devcRec.getUnitDouble("DEPTH", true), loc);
                    this.consumeProps((IDevice)result, propRec, new String[0]);
                    solidPointMeasurer = result;
                    break block6;
                }
                default: {
                    SolidPointMeasurer result = new SolidPointMeasurer(id, msr, loc);
                    this.consumeProps((IDevice)result, propRec, new String[0]);
                    solidPointMeasurer = result;
                    break block6;
                }
            }
            break;
        }
        SolidPointMeasurer msrr = solidPointMeasurer;
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return new ParsedDevc<IDevice>(msrr, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<? extends ASprayer> parseSprayer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String quantity) throws FDSRecordFormatException {
        if (quantity.equals(Quantity.SPRINKLER_LINK_TEMPERATURE.fdsName)) {
            return this.parseSprinkler(devcRec, propRec, id);
        }
        if (quantity.equals("CONTROL")) {
            return this.parseGenericNozzle(devcRec, propRec, id);
        }
        return this.parseMeasuringNozzle(devcRec, propRec, id);
    }

    private ParsedDevc<Sprinkler> parseSprinkler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel linkModel = this.d_propParser.parseSprinklerLinkModel(propRec);
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.TraditionalModel linkMod = new Sprinkler.TraditionalModel(linkModel, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(id, sprayModel, linkMod, loc);
        return new ParsedDevc<Sprinkler>(sprinkler, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<Nozzle> parseGenericNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Nozzle nozzle = new Nozzle(id, sprayModel, loc);
        return new ParsedDevc<Nozzle>(nozzle, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<ASprayer> parseMeasuringNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        IQuantity msr = this.parseQuantity(devcRec, propRec, "", false, false);
        if (msr == null || !Sprinkler.QuantityModel.getQuantityFilter().test(msr.get())) {
            return null;
        }
        Double setPoint = (Double)devcRec.get("SETPOINT", true);
        if (setPoint == null) {
            return null;
        }
        UnitDouble setPointU = new UnitDouble(setPoint, SIUS.unit(msr.get().unitType));
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.QuantityModel linkMod = new Sprinkler.QuantityModel(msr, setPointU, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprk = new Sprinkler(id, sprayModel, linkMod, loc);
        return new ParsedDevc<ASprayer>(sprk, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<SprinklerLink> parseSprinklerLink(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel model = this.d_propParser.parseSprinklerLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SprinklerLink link = new SprinklerLink(id, model, loc);
        link.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return new ParsedDevc<SprinklerLink>(link, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<IDetector> parseSmokeDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SmokeLinkModel model = this.d_propParser.parseSmokeLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SmokeDetector det = new SmokeDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return new ParsedDevc<IDetector>(det, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<IDetector> parseHeatDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        HeatLinkModel model = this.d_propParser.parseHeatLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        HeatDetector det = new HeatDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return new ParsedDevc<IDetector>(det, (devc, pin) -> devc.getName());
    }

    private ParsedDevc<IDevice> parseHvacDevc(String quantity, FDSParseRecord devcRec, FDSParseRecord propRec, IQuantity msr, String devcId, QuantityStat temporalStat) throws FDSRecordFormatException {
        HvacDevice result = switch (msr.get().quantityType) {
            case QuantityType.HVAC_DUCT -> new DuctDevice(devcId, msr);
            case QuantityType.HVAC_NODE -> new NodeDevice(devcId, msr);
            default -> null;
        };
        result.setTemporalStat(temporalStat);
        result.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, result.getUnitType()));
        this.consumeProps((IDevice)result, propRec, new String[0]);
        return result != null ? new ParsedDevc<IDevice>(result, (devc, pin) -> devc.getName()) : null;
    }

    private AARectangle parseAARectangle(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D[] xb = DeviceParser.parseXB(rec, "DEVC", "XB", true);
        if (xb[0].x() == xb[1].x()) {
            return new AARectangle(0, xb[0].x(), xb[0].y(), xb[0].z(), xb[1].y(), xb[1].z(), false);
        }
        if (xb[0].y() == xb[1].y()) {
            return new AARectangle(1, xb[0].y(), xb[0].x(), xb[0].z(), xb[1].x(), xb[1].z(), false);
        }
        if (xb[0].z() == xb[1].z()) {
            return new AARectangle(2, xb[0].z(), xb[0].x(), xb[0].y(), xb[1].x(), xb[1].y(), false);
        }
        throw new FDSRecordFormatException(rec, Intl.intl("XB must specify a plane."));
    }

    private FreePointLoc parseFreePointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", false, false);
        if (loc == null) {
            UnitLineSeg3D xb = DeviceParser.parseLineSeg3D(rec, "DEVC", "XB", true);
            loc = xb.getP1().add(xb.getP2()).scale(0.5);
        }
        Point geom = new Point(loc.getPoint3dValue(Geometry.LU));
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        FDSArray orientArr = rec.getArray("ORIENTATION", true);
        Vector3d orient = new Vector3d((Double)orientArr.get(0), (Double)orientArr.get(1), (Double)orientArr.get(2));
        return new FreePointLoc(geom, orient, rot);
    }

    private AttachedPointLoc parseAttachedPointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", true);
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        Integer ior = (Integer)rec.get("IOR");
        Vector3d angle = null;
        if (ior == null) {
            FDSArray orientArr = rec.getArray("ORIENTATION", true);
            angle = new Vector3d((Double)orientArr.get(0), (Double)orientArr.get(1), (Double)orientArr.get(2));
        } else {
            angle = GeomUtil.toWorldVec(ior);
        }
        return new AttachedPointLoc(loc, angle, rot);
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, Set<IDevice>> kvPair : this.d_parsedDevices.entrySet()) {
            FDSParseRecord rec = kvPair.getKey();
            for (IDevice devc : kvPair.getValue()) {
                if (!(devc instanceof ISignalSink) || !Util.isCycle((ISignalSink)((Object)devc))) continue;
                this.addWarning(new FDSParseWarning(rec, Intl.intl("Device activation includes a cyclic definition."), String.format(Intl.intl("Activation inputs removed from device %s."), devc.getName())));
                ((ISignalSink)((Object)devc)).getInputPin().disconnectAll();
            }
        }
    }

    private record ParsedDevc<T extends IDevice>(T devc, BiFunction<? super T, ? super IOutPin, String> getFdsPinId) {
    }

    private static class SoftException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SoftException(String msg) {
            super(msg);
        }

        private SoftException(String format, Object ... args) {
            this(String.format(format, args));
        }
    }
}

