/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import pyrosim.domain.ExSpec;

public class PredefSpeciesLoader {
    public static Collection<ExSpec> getSpecies() {
        HashMap<String, PredefSpeciesRow> specs = new HashMap<String, PredefSpeciesRow>();
        PredefSpeciesLoader.load(specs);
        return specs.values().stream().map(row -> row.backing).collect(Collectors.toSet());
    }

    private static void load(Map<String, PredefSpeciesRow> idToRowvals) {
        JSONParser parser = new JSONParser();
        try (InputStream stream = PredefSpeciesLoader.class.getResourceAsStream("fdsspecies.json");){
            if (stream == null) {
                System.err.println("fdsspecies.json resource could not be found.");
                return;
            }
            String input = IOUtils.toString(stream, StandardCharsets.UTF_8);
            JSONArray speciesArray = (JSONArray)parser.parse(StringUtils.substring(input, 1));
            for (Object object : speciesArray) {
                JSONObject speciesObject = (JSONObject)object;
                String species = PredefSpeciesLoader.getValue(speciesObject, "Species");
                String pr = PredefSpeciesLoader.getValue(speciesObject, "Pr");
                String liquid = PredefSpeciesLoader.getValue(speciesObject, "Liquid");
                String gibbs = PredefSpeciesLoader.getValue(speciesObject, "Gibbs");
                String chemical = PredefSpeciesLoader.getValue(speciesObject, "Chemical");
                String tempRange = PredefSpeciesLoader.getValue(speciesObject, "Temp. Range");
                String radCal = PredefSpeciesLoader.getValue(speciesObject, "RadCal");
                String ek = PredefSpeciesLoader.getValue(speciesObject, "epsilon/k");
                String deltaHf = PredefSpeciesLoader.getValue(speciesObject, "Delta H_{f}");
                String sigma = PredefSpeciesLoader.getValue(speciesObject, "sigma");
                String[] temps = tempRange.split(" ");
                idToRowvals.putIfAbsent(species, new PredefSpeciesRow(species, chemical, radCal, PredefSpeciesLoader.safeParse(temps[0], Double::parseDouble), PredefSpeciesLoader.safeParse(temps[1], Double::parseDouble), PredefSpeciesLoader.safeParse(pr, Double::parseDouble), PredefSpeciesLoader.safeParse(ek, Double::parseDouble), PredefSpeciesLoader.safeParse(deltaHf, Double::parseDouble), PredefSpeciesLoader.safeParse(sigma, Double::parseDouble), "Y".equals(liquid), "Y".equals(gibbs)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getValue(JSONObject speciesObject, String key) {
        return (String)((JSONObject)speciesObject.get(key)).get("Value");
    }

    private static <T> T safeParse(String string, Function<String, T> converter) {
        if (NumberUtils.isNumber(string)) {
            return converter.apply(string);
        }
        return converter.apply("0");
    }

    private static class PredefSpeciesRow {
        public final String name;
        public final String chemical;
        public final String radCal;
        public final double minTempRange;
        public final double maxTempRange;
        public final double pr;
        public final double ek;
        public final double deltaHf;
        public final double sigma;
        public final boolean isLiquid;
        public final boolean isGibbs;
        public final ExSpec backing;

        public PredefSpeciesRow(String name, String chemical, String radCal, double minTempRange, double maxTempRange, double pr, double ek, double deltaHf, double sigma, boolean isLiquid, boolean isGibbs) {
            this.name = name;
            this.chemical = chemical;
            this.radCal = radCal;
            this.minTempRange = minTempRange;
            this.maxTempRange = maxTempRange;
            this.pr = pr;
            this.ek = ek;
            this.deltaHf = deltaHf;
            this.sigma = sigma;
            this.isLiquid = isLiquid;
            this.isGibbs = isGibbs;
            this.backing = new ExSpec(name, 0);
            this.backing.setChemFormula(this.chemical);
        }

        public String toString() {
            String format = "Species{name='%s', chemical='%s', radCal='%s', minTempRange=%.2f, maxTempRange=%.2f, pr=%.2f, ek=%.2f, deltaHf=%.2f, sigma=%.2f, isLiquid=%b, isGibbs=%b}";
            return String.format(format, this.name, this.chemical, this.radCal, this.minTempRange, this.maxTempRange, this.pr, this.ek, this.deltaHf, this.sigma, this.isLiquid, this.isGibbs);
        }
    }
}

