/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.APyroObject;
import pyrosim.domain.AWriteablePyroObject;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.GridRefinement;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimError;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.scenario.ScenarioList;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.view.ViewList;
import pyrosim.gui.actions.ExportPyroFloorsAction;
import pyrosim.gui.actions.ExportPyroViewsAction;
import pyrosim.io.GE1File;
import pyrosim.io.PyroGeomFile;
import pyrosim.io.fds.FDSEnabledFilter;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.INIWriter;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public abstract class FDSRenderer {
    private final PyroMod d_model;
    private final FDSRenderProps d_props;
    private final RENDER_ORIGIN d_callOrigin;
    private static final Predicate<IHole> s_animatedHoles = h -> FDSRenderer.getCtrlBridge(h) != null;

    public Collection<IPyroObject> collectPyroObjects() {
        LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
        objs.add(this.d_model.getSimParams());
        objs.addAll(this.d_model.getObstructions().flatten());
        objs.addAll(this.d_model.getGridManager().flatten());
        objs.addAll(this.d_model.getBridges().flatten());
        objs.addAll(Util.sort(this.d_model.getZoneMgr()));
        objs.addAll(Util.sort(this.d_model.getExSpecList().getInitialFractions()));
        if (this.d_model.getExSpecList().getBackgroundSpecies() != null) {
            objs.add(this.d_model.getExSpecList().getBackgroundSpecies());
        }
        objs.addAll(this.d_model.getReactions().getActiveReactions());
        objs.addAll(((APyroObject)this.d_model.getHvacList()).flatten(HvacLeak.class));
        objs.addAll(this.d_model.getDevices().flatten());
        objs.add(this.d_model.getBoundaryOutput());
        objs.add(this.d_model.getPlot3d());
        objs.add(this.d_model.getHvacNodeOutput());
        objs.add(this.d_model.getHvacDuctOutput());
        objs.addAll(this.d_model.getIsofList().flatten());
        objs.addAll(this.d_model.getProfList().flatten());
        objs.addAll(this.d_model.getSlcfList().flatten());
        objs.addAll(this.d_model.getSlcf3dList().flatten());
        objs.addAll(this.d_model.getViews().flatten());
        if (this.d_model.getFdsEvacEnabled()) {
            objs.addAll(this.d_model.getPersList().flatten());
            objs.addAll(this.d_model.getExitList().flatten());
            objs.addAll(this.d_model.getEvacList().flatten());
            objs.addAll(this.d_model.getEntrList().flatten());
            objs.addAll(this.d_model.getEvhoList().flatten());
            objs.addAll(this.d_model.getDoorList().flatten());
            objs.addAll(this.d_model.getCorrList().flatten());
            objs.addAll(this.d_model.getEvssList().flatten());
        }
        objs.addAll(this.collectForceToWriteObjs());
        assert (!objs.contains(null));
        return theUtil.filter(objs, new FDSEnabledFilter());
    }

    private Collection<IPyroObject> collectForceToWriteObjs() {
        ArrayList<IPyroObject> objs = new ArrayList<IPyroObject>();
        Predicate<IPyroObject> p = o -> o instanceof AWriteablePyroObject && ((AWriteablePyroObject)o).isForceWrite();
        objs.addAll(this.d_model.getExSpecList().flatten(p));
        objs.addAll(this.d_model.getReactions().flatten(p));
        objs.addAll(this.d_model.getSurfaceMgr().flatten(p));
        objs.addAll(this.d_model.getMaterialMgr().flatten(p));
        objs.addAll(this.d_model.getPartList().flatten(p));
        objs.addAll(this.d_model.getHeatLinkModels().flatten(p));
        objs.addAll(this.d_model.getSmokeLinkModels().flatten(p));
        objs.addAll(this.d_model.getSprinklerLinkModels().flatten(p));
        objs.addAll(this.d_model.getSprayModels().flatten(p));
        objs.addAll(this.d_model.getHvacList().flatten(p));
        objs.addAll(this.d_model.getControls().flatten(p));
        return objs;
    }

    public abstract void renderObjects(IFDSRecordRenderer var1, Collection<? extends IPyroObject> var2, DepSnapshot var3, Map<IImage, String> var4);

    protected abstract void renderFileForVersion(File var1, Collection<? extends IPyroObject> var2, DepSnapshot var3) throws IOException;

    protected FDSRenderer(PyroMod model, FDSRenderProps props, RENDER_ORIGIN origin) {
        this.d_model = model;
        this.d_props = props.clone();
        this.d_callOrigin = origin;
    }

    public FDSRenderProps getProps() {
        return this.d_props;
    }

    protected PyroMod getModel() {
        return this.d_model;
    }

    protected RENDER_ORIGIN getRenderOrigin() {
        return this.d_callOrigin;
    }

    public void renderFile(File file) throws IOException {
        this.renderFile(file, this.collectPyroObjects());
    }

    public void renderFile(File file, Collection<? extends IPyroObject> pyroObjects) throws IOException {
        Prep fobjs = this.prepareObjs(pyroObjects, PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM), this.d_model.getUnprocessedRecords());
        this.renderFileForVersion(file, fobjs.objs, fobjs.deps);
    }

    public void renderAllObjects(IFDSRecordRenderer props, Map<IImage, String> imgFilenames) {
        Collection<IPyroObject> allObjs = this.collectPyroObjects();
        this.renderObjects(props, allObjs, imgFilenames);
    }

    public void renderObjects(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs, Map<IImage, String> imgFilenames) {
        Prep prep = this.prepareObjs(objs, false, "");
        this.renderObjects(props, prep.objs, prep.deps, imgFilenames);
    }

    private static boolean getAdditionalRecordsHasGeom(String unproc) {
        if (unproc.isEmpty()) {
            return false;
        }
        try {
            HashSet<String> types = Sets.fromArrayHS("OBST", "HOLE", "VENT");
            Pattern recPattern = Pattern.compile("&\\s*([a-zA-Z0-9]+)[^/&]*/");
            Matcher matcher = recPattern.matcher(unproc);
            while (matcher.find()) {
                String type = matcher.group(1);
                if (!types.contains(type.toUpperCase())) continue;
                return true;
            }
        }
        catch (Throwable t) {
            assert (false);
            t.printStackTrace();
        }
        return false;
    }

    public Prep prepareObjs(Collection<? extends IPyroObject> objs, boolean writePyroGeom, String unprocRecords) {
        LinkedIdentityHashSet<IPyroObject> finalObjs = new LinkedIdentityHashSet<IPyroObject>((Collection<IPyroObject>)objs);
        LinkedIdentityHashMap<IPyroObject, IPyroObject> splitObjs = new LinkedIdentityHashMap<IPyroObject, IPyroObject>();
        if (writePyroGeom || this.d_model.getRastOptions().isFdsGeomEnabled()) {
            this.d_props.setLinkPyroGeom(!FDSRenderer.getAdditionalRecordsHasGeom(unprocRecords));
            FDSRenderer.splitObstructions(this.d_props, this.d_model.getRastOptions(), finalObjs);
        }
        FDSRenderer.refineMeshes(this.d_props, finalObjs, splitObjs);
        DepSnapshot dp = new DepSnapshot();
        for (IPyroObject obj : finalObjs) {
            dp.takeSnapshot(obj);
        }
        return new Prep(finalObjs, splitObjs, dp);
    }

    protected static boolean writeGE1(File outDir, String filename, PyroMod model, Map<IImage, String> imgFilenames) throws IOException {
        return GE1File.writeFile(new File(outDir, filename).getAbsolutePath(), model, imgFilenames);
    }

    private static ControlBridge getCtrlBridge(ISignalSink o) {
        ControlBridge octrl;
        if (!o.getInputPin().getConnections().isEmpty() && !(octrl = (ControlBridge)o.getInputPin().getConnectedSources().iterator().next()).getInputPin().getConnections().isEmpty()) {
            return octrl;
        }
        return null;
    }

    private static Function<IObstruction, Predicate<IHole>> getObstPrecutHoleFilter(RasterizationOptions rastOptions, boolean pyroGeomLinked) {
        Predicate<Object> baseFilter = !pyroGeomLinked ? Filters.alwaysFalse() : s_animatedHoles;
        boolean immersed = rastOptions.isFdsGeomEnabled();
        if (immersed) {
            return obj -> obj.getOptions(128) ? Filters.alwaysTrue() : baseFilter;
        }
        return obj -> baseFilter;
    }

    protected static boolean writeGeom(File outDir, String filename, PyroMod model, Collection<? extends IPyroObject> allObjs, boolean linked, Map<IObstruction, List<Integer>> obstIxes, Map<Vent, Integer> ventIxes, boolean force) throws IOException {
        Function<IObstruction, Predicate<IHole>> precutHoles = FDSRenderer.getObstPrecutHoleFilter(model.getRastOptions(), linked);
        Function<IObstruction, Predicate<IHole>> holeFilters = obst -> ((Predicate)precutHoles.apply((IObstruction)obst)).negate();
        return PyroGeomFile.write(outDir, filename, model, allObjs, linked, obstIxes, ventIxes, force, holeFilters);
    }

    private static void splitObstructions(FDSRenderProps props, RasterizationOptions rastOptions, Collection<IPyroObject> objs) {
        if (theUtil.filter(objs, IObstruction.class).isEmpty() || theUtil.filter(objs, IHole.class).isEmpty()) {
            return;
        }
        Function<IObstruction, Predicate<IHole>> holeFilters = FDSRenderer.getObstPrecutHoleFilter(rastOptions, props.getLinkPyroGeom());
        RTree<IHole> holeSearch = new RTree<IHole>();
        LinkedHashSet<Predicate<IHole>> uniqueFilters = new LinkedHashSet<Predicate<IHole>>();
        for (IObstruction obst : theUtil.filter(objs, IObstruction.class)) {
            uniqueFilters.add(holeFilters.apply(obst));
        }
        Predicate potHoleFilter = Predicates.or(theUtil.toArray(uniqueFilters, Predicate.class));
        IFilteredCollection<IHole> potentialHoles = theUtil.filter(objs, IHole.class, potHoleFilter);
        if (potentialHoles.isEmpty()) {
            return;
        }
        for (IHole hole : potentialHoles) {
            holeSearch.insert(hole.getBounds(), hole);
        }
        Set toRemove = Collections.synchronizedSet(new LinkedIdentityHashSet());
        List<Pair> toAdd = Collections.synchronizedList(new ArrayList());
        ExecutorService threads = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (IPyroObject obj : objs) {
            if (!(obj instanceof IObstruction)) continue;
            IObstruction obst = (IObstruction)obj;
            Predicate<IHole> holeFilter = holeFilters.apply(obst);
            threads.submit(() -> {
                Supplier<Collection<? extends IHole>> getNearHoles = () -> {
                    ArrayList potHoles = new ArrayList();
                    holeSearch.find(new AABoxTest(obst.getBounds(), 1.0E-6), (h, ctmt) -> {
                        if (holeFilter.test((IHole)h)) {
                            potHoles.add(h);
                        }
                    });
                    return potHoles;
                };
                List<Pair<IObstruction, IHole>> resultObsts = obst.intersectHoles(getNearHoles, s_animatedHoles, obst.getDefaultFillSurface());
                if (resultObsts.isEmpty()) {
                    return;
                }
                toRemove.add(obj);
                for (Pair<IObstruction, IHole> pair : resultObsts) {
                    if (pair.v2 == null) {
                        toAdd.add(pair);
                        continue;
                    }
                    assert (FDSRenderer.getCtrlBridge((ISignalSink)pair.v2) != null);
                    toAdd.add(pair);
                    toRemove.add((IPyroObject)pair.v2);
                }
            });
        }
        threads.shutdown();
        try {
            threads.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        objs.removeAll(toRemove);
        HashMap<Pair, ControlBridge> newCtrls = new HashMap<Pair, ControlBridge>();
        for (Pair p : toAdd) {
            IObstruction obst = (IObstruction)p.v1;
            IHole hole = (IHole)p.v2;
            if (hole != null) {
                ControlBridge holeCtrl = FDSRenderer.getCtrlBridge(hole);
                assert (holeCtrl != null);
                ControlBridge obstCtrl = FDSRenderer.getCtrlBridge(obst);
                ControlBridge ctrl = newCtrls.computeIfAbsent(new Pair<ControlBridge, ControlBridge>(obstCtrl, holeCtrl), pair -> {
                    String bridgeName = String.format("%s_invert", holeCtrl.getName());
                    AControl newLogic = new NotOp();
                    newLogic.getInputPin().connect(holeCtrl.getInputPin().getConnections().iterator().next());
                    if (obstCtrl != null) {
                        bridgeName = String.format("%s_and_%s", obstCtrl.getName(), bridgeName);
                        AndOp and = new AndOp();
                        and.getInputPin().connect(newLogic.getOutputPins().get(0));
                        and.getInputPin().connect(obstCtrl.getInputPin().getConnections().iterator().next());
                        newLogic = and;
                    }
                    ControlBridge ictrl = new ControlBridge(bridgeName);
                    ictrl.getInputPin().connect(newLogic.getOutputPins().get(0));
                    return ictrl;
                });
                obst.getInputPin().disconnectAll();
                obst.getInputPin().connect(ctrl.getOutputPins().get(0));
            }
            objs.add(obst);
        }
    }

    private static void refineMeshes(FDSRenderProps props, Set<IPyroObject> objs, Map<IPyroObject, IPyroObject> splitObjs) {
        block9: {
            try {
                IFilteredCollection<GridRefinement> refinements = theUtil.filter(objs, GridRefinement.class, APyroObject::isEnabled);
                if (refinements.isEmpty()) {
                    return;
                }
                LinkedIdentityHashSet<Grid> meshes = new LinkedIdentityHashSet<Grid>((Collection<Grid>)theUtil.filter(objs, Grid.class, APyroObject::isEnabled));
                RefinementZoneUtil.RefinementResults results = RefinementZoneUtil.refineMeshes(meshes, refinements, (SimError err) -> {});
                for (Grid grid : results.rootGrids()) {
                    RefinementZoneUtil.RefinementTree gridTree = results.getTree(grid);
                    if (!gridTree.isLeaf() || gridTree.grid() != grid) continue;
                    meshes.remove(grid);
                }
                DepSnapshot snapshot = new DepSnapshot();
                snapshot.takeSnapshot(objs);
                for (Grid grid : meshes) {
                    LinkedIdentityHashSet dependents = new LinkedIdentityHashSet();
                    snapshot.findAllDependents(IDirectDependent.class, Predicates.alwaysTrue(), grid, (dep, link) -> {
                        if (link == null) {
                            assert (false);
                            return;
                        }
                        switch (link) {
                            case REQUIRED: {
                                assert (false) : "FDSRenderer.refineMeshes does not support REQUIRED dependencies on meshes. You will need to add special handling to refineMeshes";
                                break;
                            }
                            case STRONG: {
                                assert (false) : "FDSRenderer.refineMeshes does not support STRONG dependencies on meshes. You will need to add special handling to refineMeshes";
                                break;
                            }
                            case WEAK: {
                                if (dep instanceof IPyroObject) {
                                    IPyroObject pyroObj = (IPyroObject)((Object)dep);
                                    if (snapshot.getDependents(pyroObj).isEmpty()) {
                                        dependents.add(pyroObj);
                                        break;
                                    }
                                    assert (false) : "FDSRenderer.refineMeshes does not currently support having a mesh dependent also have a dependent of its own in the data model. Add handling when the need arises.";
                                    break;
                                }
                                assert (false) : "FDSRenderer.refineMeshes does not dependencies on meshes that do not come from an IPyroObject. You will need to add special handling to refineMeshes";
                                break;
                            }
                        }
                    });
                    for (IPyroObject dep2 : dependents) {
                        objs.remove(dep2);
                        IPyroObject newDevc = (IPyroObject)dep2.clone();
                        ((IDirectDependent)((Object)newDevc)).taskReplaceDep(grid, null).run();
                        objs.add(newDevc);
                        splitObjs.put(newDevc, dep2);
                    }
                }
                List<RefinementZoneUtil.RefinementTree> list = results.streamParents().toList();
                for (RefinementZoneUtil.RefinementTree parent : list) {
                    for (RefinementZoneUtil.RefinementTree leaf : parent.branches()) {
                        if (!leaf.isLeaf()) continue;
                        splitObjs.put(leaf.grid(), parent.grid());
                    }
                }
                objs.removeAll(meshes);
                for (Grid grid : results.rootGrids()) {
                    List<Grid> splitGrids = results.getTree(grid).streamLeaves().toList();
                    objs.addAll(splitGrids);
                }
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
    }

    protected static void write(File outDir, String filename, boolean writeGE1, Collection<? extends IPyroObject> objs) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outDir, filename)));){
            AABox gridBounds = new AABox();
            for (Grid grid : Hierarchy.flatten(objs, Grid.class)) {
                gridBounds.add(grid.getBounds());
            }
            INIWriter writer = new INIWriter(gridBounds);
            writer.write(out, writeGE1, PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1), !PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS), objs);
        }
    }

    protected static void writeViews(File outDir, String filename, ViewList views) {
        try {
            ExportPyroViewsAction.writeViewsFile(new File(outDir, filename), views);
        }
        catch (IOException e) {
            System.out.println(String.format("Could not write file: %s", filename));
        }
    }

    protected static void writeFloors(File outDir, String filename, FloorManager floors) {
        try {
            ExportPyroFloorsAction.writeFloorsFile(new File(outDir, filename), floors);
        }
        catch (IOException e) {
            System.out.println(String.format("Could not write file: %s", filename));
        }
    }

    protected static Map<IImage, String> copyImages(MaterialDB texDB, File outDir, Collection<? extends IPyroObject> objs) {
        LinkedIdentityHashMap<IImage, String> imgFNMap = new LinkedIdentityHashMap<IImage, String>();
        for (Surface surface : theUtil.filter(objs, Surface.class)) {
            Texture tex;
            Material ti = surface.getAppearance();
            if (ti == null || (tex = ti.getAttributes().getTexture(MatChannel.DIFFUSE)) == null) continue;
            imgFNMap.put(tex.image, null);
        }
        for (Map.Entry entry : imgFNMap.entrySet()) {
            IImage img = (IImage)entry.getKey();
            String fn = FDSRenderer.writeImage(outDir, img.getFilename(), img);
            entry.setValue(fn);
        }
        return imgFNMap;
    }

    protected static String writeImage(File outDir, String imgName, IImage img) {
        File imageFile = new File(img.getFilename());
        String imageName = imageFile.getName();
        File outputImageFile = new File(outDir, imageName);
        int saveOptions = 1;
        if (!outputImageFile.exists()) {
            System.out.printf("Saving image %s...", imageName);
            img.save(outputImageFile.getAbsolutePath(), saveOptions);
            System.out.println("Done");
        } else if (FDSRenderer.getWriteAlternateImage(img, outputImageFile)) {
            String imageNameAlt = String.format("%d-%dx%d.png", imgName.hashCode(), img.getWidth(), img.getHeight());
            outputImageFile = new File(outDir, imageNameAlt);
            System.out.printf("A file called \"%s\" already exists! Using alternate name \"%s\"%n", imageName, imageNameAlt);
            img.save(outputImageFile.getPath(), saveOptions);
            imageName = imageNameAlt;
        }
        return imageName;
    }

    private static boolean getWriteAlternateImage(IImage img, File outputImageFile) {
        String outPath = outputImageFile.getPath();
        IStreamSrc src = FileSystem.INSTANCE.getStreamSrc(outPath, 3);
        try {
            Image existing = Image.load(outPath, src);
            if (img.makeHashable().equals(existing)) {
                System.out.printf("Image \"%s\" already exists and is equal. Write skipped.%n", outputImageFile.getName());
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String generateChid(String fdsInputFileName, String scenarioName) {
        CharsetEncoder enc;
        Object chid = "fdschid";
        if (fdsInputFileName != null) {
            String fnChid = FilenameUtils.removeExtension(fdsInputFileName);
            fnChid.trim();
            if (!fnChid.isEmpty()) {
                chid = fnChid;
            }
        }
        if (scenarioName != null && !scenarioName.trim().isEmpty()) {
            chid = (String)chid + "-" + scenarioName.trim();
        }
        if (!(enc = StandardCharsets.US_ASCII.newEncoder()).canEncode((CharSequence)chid)) {
            chid = Integer.toUnsignedString(((String)chid).hashCode());
        }
        chid = ((String)chid).replaceAll("[. ]", "_");
        int maxLen = 50;
        if (((String)chid).length() > 50) {
            chid = ((String)chid).substring(0, 50);
        }
        assert (FDSRenderer.isValidChid((String)chid));
        return chid;
    }

    public static String getDefaultScenarioNameForChid(ScenarioList scenarios) {
        if (scenarios.flatten().size() < 2) {
            return null;
        }
        return scenarios.getActive().getName();
    }

    public static boolean isValidChid(String chid) {
        return !Objects.isNull(chid) && !chid.isEmpty() && StandardCharsets.US_ASCII.newEncoder().canEncode(chid) && chid.length() <= 50;
    }

    public static String getProperTitle(String requestedTitle, int maxTitleLength) {
        if (requestedTitle == null) {
            return null;
        }
        String newTitle = requestedTitle.trim();
        if (newTitle.length() > maxTitleLength) {
            newTitle = newTitle.substring(0, maxTitleLength);
        }
        return newTitle;
    }

    public static enum RENDER_ORIGIN {
        DEFAULT,
        RUN_FDS,
        RUN_FDS_CLOUD,
        RUN_FDS_CLUSTER,
        RUN_FDS_MPI;

    }

    public static class Prep {
        public final Collection<? extends IPyroObject> objs;
        public final DepSnapshot deps;
        public final Map<IPyroObject, IPyroObject> splitObjs;

        public Prep(Collection<? extends IPyroObject> objs, Map<IPyroObject, IPyroObject> splitObjs, DepSnapshot deps) {
            this.objs = objs;
            this.splitObjs = splitObjs;
            this.deps = deps;
        }
    }

    public static class Filenames {
        public final File dir;
        public final String chid;
        public final String fds;
        public final String ge1;
        public final String geom;
        public final String ini;
        public final String views;
        public final String floors;

        public Filenames(File runFolder, String chid) {
            this.fds = chid + ".fds";
            this.dir = runFolder;
            this.chid = chid;
            this.ge1 = chid + ".ge1";
            this.geom = chid + ".pyrogeom";
            this.ini = chid + ".ini";
            this.views = chid + ".views";
            this.floors = chid + ".pyrofloors";
        }
    }
}

