/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.GeomProximity;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IGeomSource;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.GridDisplay;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class PyroGeomFile {
    private static void addParents(IPyroObject obj, LinkedIdentityHashSet<IPyroObject> parents) {
        IPyroObject parent = obj.getParent();
        if (parent != null && parent != obj.getDomain()) {
            PyroGeomFile.addParents(parent, parents);
            parents.add(parent);
        }
    }

    public static boolean write(File outDir, String filename, final PyroMod model, Collection<? extends IPyroObject> allObjs, boolean linked, Map<IObstruction, List<Integer>> obstIxes, Map<Vent, Integer> ventIxes, boolean force, final Function<IObstruction, Predicate<IHole>> allowedCuttingHoles) throws IOException {
        File f = new File(outDir, filename);
        ArrayList<TeciGeomWriter.DefaultObj> objects = new ArrayList<TeciGeomWriter.DefaultObj>();
        Predicate<Surface> surfFilter = Filters.reject(model.getSurfaceMgr().get(PredefSurf.MIRROR), model.getSurfaceMgr().get(PredefSurf.OPEN), model.getSurfaceMgr().get(PredefSurf.PERIODIC));
        Surface defSurf = model.getSimParams().getMisc().getSurfDefault();
        final Collection<Grid> grids = Hierarchy.flatten(allObjs, Grid.class, new EnabledFilter());
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS) && surfFilter.test(defSurf)) {
            LinkedIdentityHashSet<IPyroObject> gridObjs = new LinkedIdentityHashSet<IPyroObject>();
            Collection<Vent> vents = Hierarchy.flatten(allObjs, Vent.class);
            GridMergeUtil.MergeResult mergedGrids = GridMergeUtil.mergeGrids(grids, vents);
            Map<Grid, GridMergeUtil.BoundaryInfo> gridFaces = mergedGrids.faces;
            for (Grid g : gridFaces.keySet()) {
                PyroGeomFile.addParents(g, gridObjs);
                gridObjs.add(g);
            }
            for (IPyroObject obj2 : gridObjs) {
                if (obj2 instanceof GridList) {
                    GridList comp = (GridList)obj2;
                    IPyroObject parent = comp.getParent();
                    objects.add(new TeciGeomWriter.DefaultObj(TeciGeomWriter.Type.GROUP, comp.getName(), DisplayGeom.EMPTY, true, Collections.emptyList(), comp.getResultsId(), parent != null ? parent.getResultsId() : 0L));
                    continue;
                }
                if (!(obj2 instanceof Grid)) continue;
                Grid g = (Grid)obj2;
                GridMergeUtil.BoundaryInfo boundaryInfo = gridFaces.get(g);
                Point3d gcenter = g.getBounds().getCenter();
                for (Face face : boundaryInfo.faces) {
                    if (!(face.plane.dot(gcenter) < 0.0)) continue;
                    face.flipOrient();
                }
                GridDisplay.DisplayData ddata = GridDisplay.generateDisplayData(boundaryInfo.faces, boundaryInfo.boundaryEdges, defSurf, true);
                IGeomNode geom2 = ddata.getGeom(true);
                int options = 2;
                IPrimProps.Face fprops = new IPrimProps.Face(defSurf.getColor(), defSurf.getAppearance() == null ? null : defSurf, options);
                IPyroObject parent = g.getParent();
                objects.add(new TeciGeomWriter.DefaultObj(linked ? TeciGeomWriter.Type.FDS_MESH : TeciGeomWriter.Type.GENERIC, g.getName(), new DisplayGeom(geom2, (IPrimProps)fprops), g.isVisible(), Collections.emptyList(), g.getResultsId(), parent != null ? parent.getResultsId() : 0L));
            }
        }
        GeomLocator locator = new GeomLocator();
        final GeomProximity geomProx = new GeomProximity(locator);
        theUtil.filter(allObjs, IGeomSource.class).forEach(geom -> {
            locator.add((IDisplayableGeomSrc)geom);
            if (geom.registerProximity()) {
                geomProx.add((IGeomSource)geom);
            }
        });
        Collection leafObjs = Hierarchy.flatten(allObjs, IModelObj.class, new TypeFilter(GenericGeomSrc.class, ISurfObj.class)).stream().filter(obj -> obj.isEnabled() && (!(obj instanceof Vent) || surfFilter.test(((Vent)obj).getSurface()))).collect(Collectors.toList());
        LinkedIdentityHashSet<IPyroObject> objs = new LinkedIdentityHashSet<IPyroObject>();
        for (IPyroObject obj3 : leafObjs) {
            PyroGeomFile.addParents(obj3, objs);
            objs.add(obj3);
        }
        ArrayList bgImages = new ArrayList();
        final GridMergeUtil.MergeResult[] mergedGrids = new GridMergeUtil.MergeResult[]{null};
        IPyroDisplayProps dprop = new IPyroDisplayProps(){

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public Predicate<IHole> getHoleFilter(IObstruction obst) {
                return (Predicate)allowedCuttingHoles.apply(obst);
            }

            @Override
            public GeomProximity getGeomProximity(IPyroObject obj) {
                geomProx.update();
                return geomProx;
            }

            @Override
            public Surface getFillSurface(IObstruction obj) {
                return model.getSurfaceMgr().get(PredefSurf.INERT);
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (mergedGrids[0] == null) {
                    mergedGrids[0] = GridMergeUtil.mergeGrids(grids, Collections.emptyList());
                }
                return mergedGrids[0];
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }

            @Override
            public boolean isWireframe(Object o) {
                return false;
            }
        };
        for (IPyroObject pobj : objs) {
            if (pobj instanceof ModelComposite) {
                ModelComposite comp = (ModelComposite)pobj;
                IPyroObject parent = comp.getParent();
                objects.add(new TeciGeomWriter.DefaultObj(TeciGeomWriter.Type.GROUP, comp.getName(), DisplayGeom.EMPTY, true, Collections.emptyList(), comp.getResultsId(), parent != null ? parent.getResultsId() : 0L));
                continue;
            }
            IModelObj obj4 = (IModelObj)pobj;
            TeciGeomWriter.Type type = TeciGeomWriter.Type.GENERIC;
            List<Integer> ids = Collections.emptyList();
            if (linked) {
                if (obj4 instanceof Vent) {
                    type = TeciGeomWriter.Type.FDS_VENT;
                    Integer vix = ventIxes.get((Vent)obj4);
                    if (vix != null) {
                        ids = Collections.singleton(vix);
                    }
                } else if (obj4 instanceof IObstruction) {
                    type = TeciGeomWriter.Type.FDS_OBST;
                    ids = obstIxes.getOrDefault((IObstruction)obj4, Collections.emptyList());
                }
            }
            DisplayGeom dg = obj4.getDisplayGeom(dprop);
            IPyroObject parent = obj4.getParent();
            objects.add(new TeciGeomWriter.DefaultObj(type, obj4.getName(), dg, obj4.isVisible(), ids, obj4.getResultsId(), parent != null ? parent.getResultsId() : 0L));
        }
        if (!force && objects.isEmpty() && bgImages.isEmpty()) {
            f.delete();
            return false;
        }
        TeciGeomWriter.writeVis(f, new TeciGeomWriter.Options(PyroPrefs.getDouble(PyroPrefs.DISPLAY_EDGE_ERROR), PyroPrefs.getDouble(PyroPrefs.DISPLAY_FACE_ERROR)), objects, bgImages);
        return true;
    }
}

