/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ChangeOrderTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.ObjectTableModel;
import thunderheadeng.gui.table.TableColProp;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class SlcfDialog
extends guiDialog {
    private static final long serialVersionUID = -281526882433842190L;
    private final PyroMod d_pyroMod;
    private final guiTableEditor d_editor;
    private final guiTable d_table;
    private Unit d_lengthUnit;
    private final Map<PlanarSlice, PlanarSlice> d_cloneToOGSliceMap;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public SlcfDialog(JFrame parent) {
        super((Window)parent, Intl.intl("Animated Planar Slices"), 9);
        PyroSim app = PyroSim.getApp();
        this.d_pyroMod = app.getMediator();
        UnitSystem system = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lengthUnit = system.getLengthUnit();
        this.d_cloneToOGSliceMap = new IdentityHashMap<PlanarSlice, PlanarSlice>();
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        QuantityComboBox qCombo = new QuantityComboBox(128L, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> quantComboCell = new ComboBoxTableCell<IQuantity>(qCombo);
        Pair<guiTable, ObjectTableModel<PlanarSlice>> tableAndModelPair = guiTableUtil.objectTable(() -> new PlanarSlice(0, new UnitDouble(0.0, SI.METER), null, true, true, ""), List.of(new TableColProp<PlanarSlice>(Intl.intl("Name"), Intl.intl("Name"), String.class, slice -> slice.getName(), (slice, val) -> slice.setName(val instanceof String ? (String)val : ""), new DefaultCellEditor(new JTextField()), new DefaultTableCellRenderer()), new TableColProp<PlanarSlice>(Intl.intl("XYZ Plane"), Intl.intl("XYZ Plane"), String.class, slice -> switch (slice.getPlane()) {
            case 0 -> "X";
            case 1 -> "Y";
            case 2 -> "Z";
            default -> "";
        }, (slice, val) -> {
            if (val instanceof String) {
                String planeStr;
                slice.setPlane(switch (planeStr = (String)val) {
                    case "X" -> 0;
                    case "Y" -> 1;
                    case "Z" -> 2;
                    default -> 0;
                });
            }
        }, null, new DefaultTableCellRenderer()), new TableColProp<PlanarSlice>(Intl.intl("Plane Value"), Intl.intl("Plane Value"), UnitDouble.class, slice -> slice.getLocation(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setLocation(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<PlanarSlice>(Intl.intl("Gas Phase Quantity"), Intl.intl("Gas Phase Quantity"), IQuantity.class, slice -> slice.getQuantity(), (slice, val) -> {
            if (val instanceof IQuantity) {
                IQuantity quant = (IQuantity)val;
                slice.setQuantity(quant);
            }
        }, quantComboCell, quantComboCell), new TableColProp<PlanarSlice>(Intl.intl("Use Vector?"), Intl.intl("Use Vector?"), String.class, slice -> slice.includeFlowVector() ? OPT_YES : OPT_NO, (slice, val) -> {
            if (val != null) {
                slice.setIncludeFlowVector(val.equals(OPT_YES));
            }
        }, null, new DefaultTableCellRenderer()), new TableColProp<PlanarSlice>(Intl.intl("Cell Centered?"), Intl.intl("Cell Centered?"), String.class, slice -> slice.isCellCentered() ? OPT_YES : OPT_NO, (slice, val) -> {
            if (val != null) {
                slice.setCellCentered(val.equals(OPT_YES));
            }
        }, null, new DefaultTableCellRenderer())), 24);
        this.d_table = (guiTable)tableAndModelPair.v1;
        this.d_editor = this.hasSubGroup() ? new guiTableEditor(this.d_table, 22) : new guiTableEditor(this.d_table, 30);
        this.d_table.setNullValuesAllowed(false);
        this.d_table.setColumnOptions(1, "X", "Y", "Z");
        QuantityUtil.TypeFilter qFilter = new QuantityUtil.TypeFilter(128L, QuantityType.GAS);
        this.d_table.setClipboard(3, (guiTableClipboard)new QuantityClipboard(qFilter));
        this.d_table.setColumnOptions(4, OPT_YES, OPT_NO);
        this.d_table.setColumnOptions(5, OPT_YES, OPT_NO);
        this.loadData();
        int height = this.d_table.getRowHeight();
        this.d_table.setRowHeight(height + 1);
        this.d_table.autoSizeColumns(200);
        GridBagUtil.add(dlgPanel, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!this.noTwoPointsSame()) {
            String msg = Intl.intl("Error: Duplicate values of the same quantity are not permitted.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private Collection<PlanarSlice> getAllSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcfList()).flatten(PlanarSlice.class);
    }

    private boolean hasSubGroup() {
        for (IPyroObject slice : this.d_pyroMod.getSlcfList().getChildren()) {
            if (slice.getMembers().size() == 0) continue;
            return true;
        }
        return false;
    }

    public void setInitialSel(Collection<? extends PlanarSlice> slices) {
        this.d_table.clearSelection();
        this.d_table.setColumnSelectionInterval(0, this.d_table.getColumnCount() - 1);
        for (Slice slice : slices) {
            int ix = Util.indexOf(this.getAllSlices(), slice);
            if (ix < 0) continue;
            this.d_table.addRowSelectionInterval(ix, ix);
        }
    }

    private List<PlanarSlice> initCloneMap(Collection<PlanarSlice> ogSlices) {
        ArrayList<PlanarSlice> copies = new ArrayList<PlanarSlice>(ogSlices.size());
        for (PlanarSlice og : ogSlices) {
            PlanarSlice copy = (PlanarSlice)og.clone();
            copies.add(copy);
            this.d_cloneToOGSliceMap.put(copy, og);
        }
        return copies;
    }

    public void loadData() {
        Collection<PlanarSlice> slices = this.getAllSlices();
        int numRows = slices.size();
        if (numRows > 0) {
            ObjectTableModel tableMod = (ObjectTableModel)this.d_table.getModel();
            List<PlanarSlice> clones = this.initCloneMap(slices);
            tableMod.setRows(clones);
        }
    }

    public void saveData() {
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(this.d_pyroMod);
        final HashMap<PlanarSlice, PlanarSlice> refToPreEditProps = new HashMap<PlanarSlice, PlanarSlice>();
        final LinkedIdentityHashSet<PlanarSlice> enteredSlices = new LinkedIdentityHashSet<PlanarSlice>((Collection<PlanarSlice>)this.getTableEntries());
        ArrayList<PlanarSlice> modelSlices = new ArrayList<PlanarSlice>();
        ArrayList<PlanarSlice> addSlices = new ArrayList<PlanarSlice>();
        ArrayList<PlanarSlice> deleteSlices = new ArrayList<PlanarSlice>();
        for (PlanarSlice planarSlice : enteredSlices) {
            if (!this.d_cloneToOGSliceMap.containsKey(planarSlice)) {
                addSlices.add(planarSlice);
                modelSlices.add(planarSlice);
            }
            if (!this.d_cloneToOGSliceMap.containsKey(planarSlice)) continue;
            modelSlices.add(this.d_cloneToOGSliceMap.get(planarSlice));
        }
        for (Map.Entry entry : this.d_cloneToOGSliceMap.entrySet()) {
            if (!enteredSlices.contains(entry.getKey())) {
                deleteSlices.add((PlanarSlice)entry.getValue());
                continue;
            }
            PlanarSlice og = (PlanarSlice)entry.getValue();
            refToPreEditProps.put(og, (PlanarSlice)og.clone());
        }
        compTask.addTask(new AUndoableTask(){

            @Override
            public void undo() {
                for (Map.Entry kvPair : refToPreEditProps.entrySet()) {
                    ((PlanarSlice)kvPair.getKey()).restoreFrom((PlanarSlice)kvPair.getValue());
                }
            }

            @Override
            public void run() {
                for (PlanarSlice entered : enteredSlices) {
                    if (!SlcfDialog.this.d_cloneToOGSliceMap.containsKey(entered)) continue;
                    SlcfDialog.this.d_cloneToOGSliceMap.get(entered).restoreFrom(entered);
                }
            }
        });
        compTask.addTask(Tasks.delete(deleteSlices));
        compTask.addTask(new AddTask((IPyroObject)this.d_pyroMod.getSlcfList(), addSlices));
        if (!this.hasSubGroup()) {
            compTask.addTask(new ChangeOrderTask(this.d_pyroMod.getSlcfList(), children -> modelSlices));
        }
        this.d_pyroMod.getTaskManager().exec(compTask, Intl.intl("Save Slices"));
    }

    private List<PlanarSlice> getTableEntries() {
        return ((ObjectTableModel)this.d_editor.getTable().getModel()).getRows();
    }

    private boolean noTwoPointsSame() {
        HashSet<PlanarSlice.PlanarSliceHash> hashes = new HashSet<PlanarSlice.PlanarSliceHash>();
        TableModel model = this.d_editor.getTable().getModel();
        for (int m = 0; m < model.getRowCount(); ++m) {
            String name = (String)model.getValueAt(m, 0);
            String strplane = (String)model.getValueAt(m, 1);
            int plane = strplane.equals("X") ? 0 : (strplane.equals("Y") ? 1 : 2);
            PlanarSlice.PlanarSliceHash hash = new PlanarSlice.PlanarSliceHash(plane, (UnitDouble)model.getValueAt(m, 2), (IQuantity)model.getValueAt(m, 3), name);
            if (hashes.add(hash)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (result == 1) {
            this.saveData();
        }
        return result;
    }
}

