/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.gui.output.MeasurementTableModel;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;

public class QuantitySetUIModel {
    private final AMeasurementSet d_measurementSet;
    private MeasurementTableModel d_model;
    private final guiTable d_tEnabledQuantities;
    private final JScrollPane d_spEnabledQuantities;
    private final guiLabel d_lNumberQuantsChosen;
    private final guiLabel d_velSignLbl;
    private final guiComboBox<VelocitySign> d_velSignCB;
    private final int d_maxQuantities;

    public QuantitySetUIModel(AMeasurementSet mset, String desc, int maxQuants) {
        this.d_measurementSet = mset;
        this.d_maxQuantities = maxQuants;
        this.d_model = new MeasurementTableModel(mset.getOutputType(), desc);
        this.d_tEnabledQuantities = new guiTable((TableModel)this.d_model, 0);
        this.d_tEnabledQuantities.setCellSelectionEnabled(false);
        this.d_tEnabledQuantities.setShowVerticalLines(false);
        this.d_spEnabledQuantities = new JScrollPane(this.d_tEnabledQuantities);
        this.d_lNumberQuantsChosen = new guiLabel(Intl.intl("0 Quantities Chosen"));
        this.d_lNumberQuantsChosen.setForeground(Color.BLUE);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn checkCol = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        checkCol.setMaxWidth(checkCol.getPreferredWidth());
        this.d_velSignLbl = new guiLabel(Intl.intl("Velocity Sign:"));
        this.d_velSignCB = new guiComboBox<VelocitySign>(VelocitySign.values());
        this.d_velSignLbl.setToolTipText("PLOT3D_VELO_INDEX");
        this.loadValues();
        this.d_model.addTableModelListener(evt -> {
            this.updateNumQuantsSelected();
            this.updateVelSign();
        });
    }

    public void loadValues() {
        this.d_model.loadValues(this.d_measurementSet.getQuantities());
        if (this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
            this.d_velSignCB.setSelectedItem((Object)this.d_measurementSet.getVelocitySign());
        }
        this.updateNumQuantsSelected();
        this.updateVelSign();
    }

    public void selectQuantities(Set<IQuantity> quants) {
        for (IQuantity quant : quants) {
            Integer ix = this.d_model.getIxMap().get(quant);
            this.d_tEnabledQuantities.setValueAt(Boolean.TRUE, ix, 0);
        }
    }

    public Collection<IQuantity> getSelectedQuantities() {
        return this.d_model.saveValues();
    }

    public void updateUI() {
        this.d_tEnabledQuantities.updateUI();
    }

    protected Task getSaveTask() {
        final Collection<IQuantity> measurements = this.getSelectedQuantities();
        return new AUndoableTask(){
            private List<IQuantity> d_oldMeasurements;
            private VelocitySign d_oldVelocitySign;

            @Override
            public void undo() {
                QuantitySetUIModel.this.d_measurementSet.setQuantities(this.d_oldMeasurements);
                QuantitySetUIModel.this.d_measurementSet.setVelocitySign(this.d_oldVelocitySign);
            }

            @Override
            public void run() {
                this.d_oldMeasurements = new ArrayList<IQuantity>(QuantitySetUIModel.this.d_measurementSet.getQuantities());
                QuantitySetUIModel.this.d_measurementSet.setQuantities(measurements);
                this.d_oldVelocitySign = QuantitySetUIModel.this.d_measurementSet.getVelocitySign();
                if (QuantitySetUIModel.this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
                    QuantitySetUIModel.this.d_measurementSet.setVelocitySign(QuantitySetUIModel.this.d_velSignCB.getSelectedItem());
                }
            }
        };
    }

    public boolean isValidSelCount() {
        return this.countSelQuantities() < this.d_maxQuantities;
    }

    public int countSelQuantities() {
        int count = 0;
        for (int n = 0; n < this.d_tEnabledQuantities.getRowCount(); ++n) {
            Boolean value = (Boolean)this.d_tEnabledQuantities.getValueAt(n, 0);
            boolean selected = value;
            if (!selected) continue;
            ++count;
        }
        return count;
    }

    public int getMaxAllowedQuants() {
        return this.d_maxQuantities;
    }

    public void updateNumQuantsSelected() {
        int count = this.countSelQuantities();
        Color c = count > this.d_maxQuantities ? Color.RED : Color.BLUE;
        this.d_lNumberQuantsChosen.setForeground(c);
        String text = this.d_maxQuantities < Integer.MAX_VALUE ? String.format(Intl.intl("%d/%d Quantities Chosen"), count, this.d_maxQuantities) : String.format(Intl.intl("%d Quantities Chosen"), count);
        this.d_lNumberQuantsChosen.setText(text);
    }

    public void updateVelSign() {
        Integer ix = this.d_model.getIxMap().get(Quantity.VELOCITY.create());
        if (ix != null) {
            boolean enabled = this.d_model.getEnableStatus(ix);
            this.d_velSignLbl.setEnabled(enabled);
            this.d_velSignCB.setEnabled(enabled);
        }
    }

    protected boolean isMsrSelected(IQuantity msr) {
        return this.d_model.isMsrSelected(msr);
    }

    public boolean containsQauntity(IQuantity quantity) {
        return this.d_model.getIxMap().containsKey(quantity);
    }

    protected void updateMeasurementTableModel() {
        Collection<IQuantity> quantities = this.d_model.saveValues();
        this.d_model = new MeasurementTableModel(this.d_measurementSet.getOutputType());
        this.d_tEnabledQuantities.setModel(this.d_model);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn checkCol = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        checkCol.setMaxWidth(checkCol.getPreferredWidth());
        this.d_model.addTableModelListener(e -> {
            this.updateNumQuantsSelected();
            this.updateVelSign();
        });
        this.d_model.loadValues(new HashSet<IQuantity>(quantities));
    }

    public JScrollPane getspEnabledQuantities() {
        return this.d_spEnabledQuantities;
    }

    public guiLabel getNumberQuantsChosen() {
        return this.d_lNumberQuantsChosen;
    }

    public guiLabel getVelSignLbl() {
        return this.d_velSignLbl;
    }

    public guiComboBox<VelocitySign> getVelSignCB() {
        return this.d_velSignCB;
    }

    public guiTable getQuantitiesTable() {
        return this.d_tEnabledQuantities;
    }

    public void clearSelection() {
        for (int i = 0; i < this.d_tEnabledQuantities.getRowCount(); ++i) {
            this.d_tEnabledQuantities.setValueAt(Boolean.FALSE, i, 0);
        }
        this.d_tEnabledQuantities.updateUI();
        this.updateNumQuantsSelected();
    }
}

