/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Window;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;

public class SplitMeshDlg
extends guiDialog {
    private static final long serialVersionUID = 2921449540230054081L;
    private guiComboBox<Geometry.Axis> d_cbAxis = new guiComboBox<Geometry.Axis>(Geometry.Axis.values());
    private ValueField<UnitDouble> d_value = ValueFields.udFld(UnitSystem.getSource(0));

    public SplitMeshDlg(Window owner, UnitSystem usys, AABox bounds) {
        super(owner, Intl.intl("Split Mesh"), 9);
        AABoxGeomEditor boundsDisp = new AABoxGeomEditor(false, true);
        boundsDisp.setEnabled(false);
        boundsDisp.load(new AABoxGeom(bounds));
        GridBagHelper baggins = new GridBagHelper(this.getDialogPane());
        baggins.addRow(Intl.intl("Split Near:"), this.d_cbAxis, "=", this.d_value);
        baggins.addFilledRow(new TitleSeparator(Intl.intl("Bounding Box")));
        baggins.addFilledRow(boundsDisp);
    }

    public Geometry.Axis getAxis() {
        return this.d_cbAxis.getSelectedItem();
    }

    public UnitDouble getValue() {
        return (UnitDouble)this.d_value.getValue();
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }
}

