/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.swing.Box;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Grid;
import pyrosim.domain.GridRefinement;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimError;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.BackgroundCompute;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.WarningReport;

public class GridRefinementPanel
extends guiPanel {
    private final PyroMod d_pyMod = PyroSim.getApp().getMediator();
    private GridRefinement d_currentRefinement;
    private final ValueField<UnitDouble> d_minX = ValueFields.udFld(UnitSystem.getSource(0));
    private final ValueField<UnitDouble> d_minY = ValueFields.udFld(UnitSystem.getSource(0));
    private final ValueField<UnitDouble> d_minZ = ValueFields.udFld(UnitSystem.getSource(0));
    private final ValueField<UnitDouble> d_maxX = ValueFields.udFld(UnitSystem.getSource(0));
    private final ValueField<UnitDouble> d_maxY = ValueFields.udFld(UnitSystem.getSource(0));
    private final ValueField<UnitDouble> d_maxZ = ValueFields.udFld(UnitSystem.getSource(0));
    private final guiComboBox<GridRefinement.RefinementAmount> d_refinementAmount = guiUtil.newCombo(amount -> new Pair<String, String>(amount.getName(), amount.getDesc()), GridRefinement.RefinementAmount.values());
    private final guiLabel d_labCellsIncludingEmbedded = new guiLabel();
    private final guiLabel d_labCellsOutsideEmbedded = new guiLabel();
    private final guiLabel d_labTotalCellsInModel = new guiLabel();
    private final HTMLBtn d_btnRefinementWarnings = new HTMLBtn(Intl.intl("There were some problems applying this refinement zone."));
    private BackgroundCompute<RefinementZoneUtil.RefinementResults> d_cellCountCompute;

    public GridRefinementPanel() {
        super(new MigLayout("gapx 12"));
        guiPanel headerPanel = new guiPanel(new MigLayout("insets 0, gapx 12, gapy 6"));
        headerPanel.setFocusTraversalPolicy(new CoordsFocusTP());
        headerPanel.setFocusTraversalPolicyProvider(true);
        headerPanel.add((Component)new guiLabel(Intl.intl("Refinement Zone Boundary:")), "span, wrap 12");
        headerPanel.add(Box.createHorizontalGlue());
        headerPanel.add(new guiLabel(Intl.intl("Min X:")));
        headerPanel.add(this.d_minX);
        headerPanel.add(new guiLabel(Intl.intl("Min Y:")));
        headerPanel.add(this.d_minY);
        headerPanel.add(new guiLabel(Intl.intl("Min Z:")));
        headerPanel.add(this.d_minZ, "wrap");
        headerPanel.add(Box.createHorizontalGlue());
        headerPanel.add(new guiLabel(Intl.intl("Max X:")));
        headerPanel.add(this.d_maxX);
        headerPanel.add(new guiLabel(Intl.intl("Max Y:")));
        headerPanel.add(this.d_maxY);
        headerPanel.add(new guiLabel(Intl.intl("Max Z:")));
        headerPanel.add(this.d_maxZ, "wrap");
        this.add((Component)headerPanel, "span, wrap 12");
        this.add((Component)new guiSeparator(), "span, growx, wrap 12");
        this.add(new guiLabel(Intl.intl("Refinement:")));
        this.add(this.d_refinementAmount, "span, wrap 12");
        this.add((Component)this.d_labCellsIncludingEmbedded, "span, wrap 6");
        this.add((Component)this.d_labCellsOutsideEmbedded, "span, wrap 6");
        this.add((Component)this.d_labTotalCellsInModel, "span, wrap 6");
        this.add((Component)this.d_btnRefinementWarnings, "span, wrap");
        UpdateComponentsListener ucl = new UpdateComponentsListener();
        this.d_minX.addValueChangeListener(ucl);
        this.d_minY.addValueChangeListener(ucl);
        this.d_minZ.addValueChangeListener(ucl);
        this.d_maxX.addValueChangeListener(ucl);
        this.d_maxY.addValueChangeListener(ucl);
        this.d_maxZ.addValueChangeListener(ucl);
        this.d_refinementAmount.addItemListener(ucl);
    }

    public void updateTotalCells() {
        if (!this.validateData(false, false)) {
            this.d_labCellsIncludingEmbedded.setText(String.format(Intl.intl("Number of cells, including embedded refinement: %s"), ""));
            this.d_labCellsOutsideEmbedded.setText(String.format(Intl.intl("Number of cells without outside refinement: %s"), ""));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), ""));
            this.d_btnRefinementWarnings.clearListeners();
            this.d_btnRefinementWarnings.setVisible(false);
            return;
        }
        GridRefinement oldRefinement = this.d_currentRefinement;
        GridRefinement newRefinement = this.getGridRefinement();
        newRefinement.setEnabled(oldRefinement == null || oldRefinement.isEnabled());
        Collection<Grid> allGrids = this.d_pyMod.getGridManager().flatten(Grid.class, APyroObject::isEnabled);
        List<GridRefinement> allRefinements = ((APyroObject)this.d_pyMod.getGridManager()).flatten(GridRefinement.class).stream().map(refinement -> refinement != oldRefinement ? refinement : newRefinement).filter(APyroObject::isEnabled).toList();
        Function<Long, String> formatCells = i -> NumberFormat.getNumberInstance(Locale.getDefault()).format(i);
        if (this.d_cellCountCompute != null) {
            this.d_cellCountCompute.cancel();
        }
        WarningReport<SimError> warnings = SimError.makeWarningReport();
        this.d_cellCountCompute = BackgroundCompute.start(50L, () -> RefinementZoneUtil.refineMeshes(allGrids, allRefinements, warnings::addWarning), results -> {
            this.d_labCellsIncludingEmbedded.setText(String.format(Intl.intl("Number of cells, including embedded refinement: %s"), formatCells.apply(RefinementZoneUtil.countCells(results, newRefinement))));
            this.d_labCellsOutsideEmbedded.setText(String.format(Intl.intl("Number of cells outside embedded refinement: %s"), formatCells.apply(RefinementZoneUtil.countUnrefinedCells(results, newRefinement))));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), formatCells.apply(RefinementZoneUtil.countAllCells(results))));
            boolean hasWarning = warnings.getWarnings().stream().flatMap(warning -> warning.causeObjs.stream()).anyMatch(obj -> obj == newRefinement);
            if (hasWarning) {
                this.d_btnRefinementWarnings.setVisible(true);
                this.d_btnRefinementWarnings.clearListeners();
                this.d_btnRefinementWarnings.addActionListener(evt -> {
                    WarningDlg dlg = new WarningDlg((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("Mesh Refinement Warnings"), Intl.intl("There were some problems applying mesh refinements."), warnings);
                    dlg.doModal();
                });
            } else {
                this.d_btnRefinementWarnings.clearListeners();
                this.d_btnRefinementWarnings.setVisible(false);
            }
        }, 500L, () -> {
            this.d_labCellsIncludingEmbedded.setText(String.format(Intl.intl("Number of cells, including embedded refinement: %s"), Intl.intl("Calculating...")));
            this.d_labCellsOutsideEmbedded.setText(String.format(Intl.intl("Number of cells outside embedded refinement: %s"), Intl.intl("Calculating...")));
            this.d_labTotalCellsInModel.setText(String.format(Intl.intl("Total number of cells in model: %s"), Intl.intl("Calculating...")));
            this.d_btnRefinementWarnings.setVisible(false);
            this.d_btnRefinementWarnings.clearListeners();
        });
    }

    public void setValues(GridRefinement refinement) {
        this.d_currentRefinement = refinement;
        if (refinement != null) {
            this.d_minX.setValue(refinement.getMinPoint().xu());
            this.d_minY.setValue(refinement.getMinPoint().yu());
            this.d_minZ.setValue(refinement.getMinPoint().zu());
            this.d_maxX.setValue(refinement.getMaxPoint().xu());
            this.d_maxY.setValue(refinement.getMaxPoint().yu());
            this.d_maxZ.setValue(refinement.getMaxPoint().zu());
            this.d_refinementAmount.setSelectedItem((Object)refinement.getRefinementAmount());
        } else {
            Unit u = UnitSystem.getSource(0).getUnit();
            this.d_minX.setValue(new UnitDouble(0.0, u));
            this.d_minY.setValue(new UnitDouble(0.0, u));
            this.d_minZ.setValue(new UnitDouble(0.0, u));
            this.d_maxX.setValue(new UnitDouble(1.0, u));
            this.d_maxY.setValue(new UnitDouble(1.0, u));
            this.d_maxZ.setValue(new UnitDouble(1.0, u));
            this.d_refinementAmount.setSelectedItem((Object)GridRefinement.RefinementAmount.X2);
        }
    }

    public GridRefinement getGridRefinement() {
        UnitPoint3D minPt = new UnitPoint3D((UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue());
        UnitPoint3D maxPt = new UnitPoint3D((UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue());
        return new GridRefinement(Intl.intl("Mesh Refinement"), minPt, maxPt, this.d_refinementAmount.getSelectedItem());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (((UnitDouble)this.d_minX.getValue()).ge((UnitDouble)this.d_maxX.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minX, Intl.intl("Min X must be less than Max X."));
        }
        if (((UnitDouble)this.d_minY.getValue()).ge((UnitDouble)this.d_maxY.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minY, Intl.intl("Min Y must be less than Max Y."));
        }
        if (((UnitDouble)this.d_minZ.getValue()).ge((UnitDouble)this.d_maxZ.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, showWarn, allowModify, this.d_minZ, Intl.intl("Min Z must be less than Max Z."));
        }
        return true;
    }

    private class CoordsFocusTP
    extends FocusTraversalPolicy {
        private CoordsFocusTP() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(GridRefinementPanel.this.d_minX)) {
                return GridRefinementPanel.this.d_maxX;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxX)) {
                return GridRefinementPanel.this.d_minY;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_minY)) {
                return GridRefinementPanel.this.d_maxY;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxY)) {
                return GridRefinementPanel.this.d_minZ;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_minZ)) {
                return GridRefinementPanel.this.d_maxZ;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxZ)) {
                return null;
            }
            return GridRefinementPanel.this.d_minX;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(GridRefinementPanel.this.d_minX)) {
                return null;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxX)) {
                return GridRefinementPanel.this.d_minX;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_minY)) {
                return GridRefinementPanel.this.d_maxX;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxY)) {
                return GridRefinementPanel.this.d_minY;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_minZ)) {
                return GridRefinementPanel.this.d_maxY;
            }
            if (aComponent.equals(GridRefinementPanel.this.d_maxZ)) {
                return GridRefinementPanel.this.d_minZ;
            }
            return GridRefinementPanel.this.d_minX;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return GridRefinementPanel.this.d_minX;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return GridRefinementPanel.this.d_maxZ;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return GridRefinementPanel.this.d_minX;
        }
    }

    private class UpdateComponentsListener
    implements PropertyChangeListener,
    ItemListener {
        private UpdateComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GridRefinementPanel.this.updateTotalCells();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            GridRefinementPanel.this.updateTotalCells();
        }
    }
}

