/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.geom.Geometry;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class PointListEditor
extends guiPanel {
    private static final long serialVersionUID = -805333547767312186L;
    private final guiDefaultTableModel d_model;
    private final guiTable d_table;
    private final boolean d_autoWrap;
    private final int d_maxNumRows;

    public PointListEditor(boolean autoWrap) {
        this(autoWrap, Integer.MAX_VALUE);
    }

    public PointListEditor(boolean autoWrap, int maxNumRows) {
        super(new GridBagLayout());
        this.d_autoWrap = autoWrap;
        this.d_maxNumRows = maxNumRows;
        Class[] clazzes = new Class[]{UnitDouble.class, UnitDouble.class, UnitDouble.class};
        String[] headers = new String[]{Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z")};
        guiTableEditor editor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, clazzes, 0, maxNumRows, 24), 30);
        this.d_table = editor.getTable();
        guiTable.UnitDoubleEditor cellEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getLengthUnit());
        this.d_table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        this.d_table.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        this.d_table.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.d_table.setNullValuesAllowed(false);
        this.d_model = (guiDefaultTableModel)this.d_table.getModel();
        guiLabel lbl = new guiLabel(Intl.intl("Points:"));
        GridBagUtil.add(this, lbl, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 18);
        GridBagUtil.add(this, editor, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
    }

    public void markRows(int ... rows) {
        if (rows.length > 0) {
            this.d_table.getSelectionModel().clearSelection();
            for (int ix : rows) {
                this.d_table.getSelectionModel().addSelectionInterval(ix, ix);
            }
        }
    }

    public int getNumPoints() {
        return this.d_model.getRowCount();
    }

    public int getMaxNumRows() {
        return this.d_maxNumRows;
    }

    public void load(Collection<Point3d> points) {
        Unit lu = PyroSim.getApp().getUnitSystem().getLengthUnit();
        this.d_model.setNumRows(points.size());
        int ix = 0;
        for (Point3d p : points) {
            this.d_model.setValueAt(UnitDouble.from(p.x, Geometry.LU, lu), ix, 0);
            this.d_model.setValueAt(UnitDouble.from(p.y, Geometry.LU, lu), ix, 1);
            this.d_model.setValueAt(UnitDouble.from(p.z, Geometry.LU, lu), ix, 2);
            ++ix;
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (allowModify) {
            int rowId;
            ArrayList<Integer> remRows = new ArrayList<Integer>();
            Point3d first = null;
            Tuple3d prev = null;
            for (int row = 0; row < this.d_model.getRowCount(); ++row) {
                UnitDouble x = (UnitDouble)this.d_model.getValueAt(row, 0);
                UnitDouble y = (UnitDouble)this.d_model.getValueAt(row, 1);
                UnitDouble z = (UnitDouble)this.d_model.getValueAt(row, 2);
                assert (x != null && y != null && z != null);
                Point3d p = new Point3d(x.getValue(Geometry.LU), y.getValue(Geometry.LU), z.getValue(Geometry.LU));
                if (first == null) {
                    first = p;
                }
                if (p.equals(prev)) {
                    remRows.add(row);
                }
                prev = p;
            }
            if (this.d_autoWrap && prev != null && prev.equals(first) && !remRows.contains(rowId = this.d_model.getRowCount() - 1)) {
                remRows.add(rowId);
            }
            if (!remRows.isEmpty()) {
                int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Points table contains duplicate entries. Would you like to remove the duplicates?"), Intl.intl("Duplicate Points"), 1);
                if (option == 0) {
                    for (int m = remRows.size() - 1; m >= 0; --m) {
                        this.d_model.removeRow((Integer)remRows.get(m));
                    }
                } else if (option != 1) {
                    return false;
                }
            }
            if (this.d_model.getRowCount() > this.getMaxNumRows()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl(String.format("There must be at most %d entries.", this.getMaxNumRows())), Intl.intl("Too many Entries"), 0);
                }
                return false;
            }
        }
        return true;
    }

    public List<Point3d> save() {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        for (int row = 0; row < this.d_model.getRowCount(); ++row) {
            UnitDouble x = (UnitDouble)this.d_model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)this.d_model.getValueAt(row, 1);
            UnitDouble z = (UnitDouble)this.d_model.getValueAt(row, 2);
            if (x == null || y == null || z == null) {
                return null;
            }
            Point3d p = new Point3d(x.getValue(Geometry.LU), y.getValue(Geometry.LU), z.getValue(Geometry.LU));
            points.add(p);
        }
        return points;
    }

    public guiDefaultTableModel getTableModel() {
        return (guiDefaultTableModel)this.d_table.getModel();
    }
}

