/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.SimParams;
import pyrosim.domain.geom.InitRegion;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NamedSorter;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.SortCache;

public class InitEditor
implements ModelObjectDialog.IEditor<InitRegion> {
    private static final String MASS_FRAC_TITLE = Intl.intl("Mass Fraction");
    private static final String VOL_FRAC_TITLE = Intl.intl("Volume Fraction");
    private final guiMultiStateCheckBox d_tempCB = new guiMultiStateCheckBox(Intl.intl("Temperature:"));
    private final ValueField<UnitDouble> d_tempFld = ValueFields.udFld(UnitSystem.getSource(1));
    private final guiMultiStateCheckBox d_densityCB;
    private final ValueField<UnitDouble> d_densityFld;
    private final guiRadioButton d_massFracRB;
    private final guiRadioButton d_volFracRB;
    private final guiButtonGroup d_specFracGroup;
    private final guiTable d_specTbl;
    private final SortCache<ExSpec> d_specs;

    public InitEditor(PyroMod domain) {
        this.d_tempFld.setNullAllowed(true);
        this.d_tempCB.addActionListener(e -> this.d_tempFld.requestFocusInWindow());
        LinkStatus.link((AbstractButton)this.d_tempCB, this.d_tempFld);
        this.d_densityCB = new guiMultiStateCheckBox(Intl.intl("Density:"));
        this.d_densityFld = ValueFields.udFld(UnitSystem.getSource(4));
        this.d_densityCB.addActionListener(e -> this.d_densityFld.requestFocusInWindow());
        this.d_densityFld.setNullAllowed(true);
        LinkStatus.link((AbstractButton)this.d_densityCB, this.d_densityFld);
        this.d_specs = this.sortSpecs(domain);
        this.d_specTbl = InitEditor.prepareSpecTbl(this.d_specs);
        this.d_massFracRB = new guiRadioButton(Intl.intl("Species as Mass Fraction"));
        this.d_volFracRB = new guiRadioButton(Intl.intl("Species as Volume Fraction"));
        this.d_specFracGroup = new guiButtonGroup(this.d_massFracRB, this.d_volFracRB);
        ItemListener tableUpdater = e -> {
            Object newHeader = "";
            UnitSystem us = PyroSim.getApp().getUnitSystem();
            if (this.d_massFracRB.isSelected()) {
                newHeader = MASS_FRAC_TITLE + " (" + us.getMassFractionUnit().toString() + ")";
            }
            if (this.d_volFracRB.isSelected()) {
                newHeader = VOL_FRAC_TITLE + " (" + us.getMassFractionUnit().toString() + ")";
            }
            this.d_specTbl.getColumnModel().getColumn(1).setHeaderValue(newHeader);
            this.d_specTbl.setEnabled(true);
            this.d_specTbl.updateUI();
        };
        this.d_massFracRB.setSelected(true);
        this.d_massFracRB.addItemListener(tableUpdater);
        this.d_volFracRB.addItemListener(tableUpdater);
    }

    @Override
    public boolean isControllable(InitRegion obj) {
        return obj.isControllable();
    }

    private SortCache<ExSpec> sortSpecs(PyroMod domain) {
        ExSpecList exSpecs = domain.getExSpecList();
        return new SortCache<ExSpec>(exSpecs.flatten(), new NamedSorter());
    }

    private static guiTable prepareSpecTbl(SortCache<ExSpec> specs) {
        UnitSystem us = PyroSim.getApp().getUnitSystem();
        guiTable specTbl = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Species"), String.format(Intl.intl("Mass Fraction (%s)"), us.getMassFractionUnit())}, new Class[]{String.class, Double.class}, specs.size(), specs.size(), 0);
        for (int m = 0; m < specs.size(); ++m) {
            specTbl.setValueAt(specs.get(m).getName(), m, 0);
        }
        specTbl.setColumnEditable(0, false);
        return specTbl;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Initial Region Properties");
    }

    @Override
    public Class<InitRegion> getType() {
        return InitRegion.class;
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void add(ModelObjectDialog dlg, guiPanel basePanel) {
        this.add(basePanel);
    }

    public void add(guiPanel basePanel) {
        TitleSeparator title = new TitleSeparator(Intl.intl("Initial Environment Properties"));
        JScrollPane specSP = new JScrollPane(this.d_specTbl);
        int width = this.d_specTbl.autoSizeColumns();
        specSP.setPreferredSize(new Dimension(width, 100));
        String indent = "gapleft 18";
        assert (basePanel.getLayout() instanceof MigLayout);
        basePanel.add((Component)title, "span, grow, wrap");
        basePanel.add((Component)this.d_tempCB, indent);
        basePanel.add(this.d_tempFld, "grow 0, wrap");
        basePanel.add((Component)this.d_densityCB, indent);
        basePanel.add(this.d_densityFld, "grow 0, wrap");
        basePanel.add((Component)this.d_massFracRB, indent + ", span, wrap");
        basePanel.add((Component)this.d_volFracRB, indent + ", span, wrap");
        basePanel.add((Component)specSP, indent + ", span, grow");
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends InitRegion> objs, boolean showWarn, boolean allowModify) {
        for (int m = 0; m < this.d_specs.size(); ++m) {
            guiLabel bgMsg;
            int option;
            Double dv;
            ExSpec spec = this.d_specs.get(m);
            if (!ExSpecList.Predefined.AIR.spec.equals(spec) || (dv = (Double)this.d_specTbl.getValueAt(m, 1)) == null || dv == 0.0 || (option = JOptionPane.showConfirmDialog(parent, bgMsg = new guiLabel(PyroGuiUtil.encodeToHtmlLabel(Intl.intl("AIR is usually the background species and should be set to 0. It will\nautomatically account for any unspecified mass fraction. If you have\ndefined a custom background species other than AIR, click OK to ignore\nthis warning."))), Intl.intl("Warning"), 2, 2)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void load(PyroMod domain, Collection<? extends InitRegion> objs) {
        SimParams.Environment env = domain.getSimParams().getEnvironment();
        InitEditor.loadCB(this.d_tempCB, this.d_tempFld, env.getAmbTemp(), InitRegion.tempProp, objs);
        InitEditor.loadCB(this.d_densityCB, this.d_densityFld, null, InitRegion.densityProp, objs);
        this.loadExSpec(InitRegion.specTypeProp, objs);
    }

    private static void loadCB(guiMultiStateCheckBox cb, ValueField<UnitDouble> fld, UnitDouble defVal, Composite.IObjectProp<InitRegion, UnitDouble> prop, Collection<? extends InitRegion> objs) {
        Object val = Composite.getProperty(prop, objs);
        if (val == Composite.NON_UNIFORM) {
            cb.setState(2);
            fld.setValue(null);
        } else if (val == null) {
            cb.setSelected(false);
            fld.setValue(defVal);
        } else {
            cb.setSelected(true);
            fld.setValue((UnitDouble)val);
        }
    }

    private void loadExSpec(Composite.IObjectProp<InitRegion, InitRegion.SpecFractionType> typeProp, Collection<? extends InitRegion> objs) {
        Object typeVal = Composite.getProperty(typeProp, objs);
        Unit unit = null;
        if (typeVal == Composite.NON_UNIFORM) {
            this.d_specFracGroup.clearSelection();
            this.d_specTbl.setEnabled(false);
            return;
        }
        if (typeVal.equals((Object)InitRegion.SpecFractionType.MASS_FRACTION)) {
            this.d_massFracRB.setSelected(true);
            unit = PyroSim.getApp().getUnitSystem().getMassFractionUnit();
        } else if (typeVal.equals((Object)InitRegion.SpecFractionType.VOLUME_FRACTION)) {
            this.d_volFracRB.setSelected(true);
            unit = PyroSim.getApp().getUnitSystem().getVolumeFractionUnit();
        }
        if (unit != null) {
            InitRegion.SpecFracProp prop = new InitRegion.SpecFracProp();
            for (int m = 0; m < this.d_specs.size(); ++m) {
                ExSpec spec;
                prop.currSpec = spec = this.d_specs.get(m);
                Object val = Composite.getProperty(prop, objs);
                val = val == Composite.NON_UNIFORM ? null : Double.valueOf(((UnitDouble)val).getValue(unit));
                this.d_specTbl.setValueAt(val, m, 1);
            }
        }
    }

    @Override
    public void save(PyroMod domain, Collection<? extends InitRegion> objs) {
        InitEditor.saveCB(this.d_tempCB, this.d_tempFld, InitRegion.tempProp, objs);
        InitEditor.saveCB(this.d_densityCB, this.d_densityFld, InitRegion.densityProp, objs);
        this.saveExSpec(InitRegion.specTypeProp, objs);
    }

    private static void saveCB(guiMultiStateCheckBox cb, ValueField<UnitDouble> fld, Composite.IObjectProp<InitRegion, UnitDouble> prop, Collection<? extends InitRegion> objs) {
        if (cb.getState() == 2) {
            return;
        }
        if (!cb.isSelected()) {
            Composite.setProperty(prop, null, objs);
        } else if (fld.getValue() != null) {
            Composite.setProperty(prop, (UnitDouble)fld.getValue(), objs);
        }
    }

    private void saveExSpec(Composite.IObjectProp<InitRegion, InitRegion.SpecFractionType> typeProp, Collection<? extends InitRegion> objs) {
        Unit unit = null;
        InitRegion.SpecFractionType type = null;
        if (!this.d_massFracRB.isSelected() && !this.d_volFracRB.isSelected()) {
            return;
        }
        if (this.d_massFracRB.isSelected()) {
            unit = PyroSim.getApp().getUnitSystem().getMassFractionUnit();
            type = InitRegion.SpecFractionType.MASS_FRACTION;
        } else if (this.d_volFracRB.isSelected()) {
            unit = PyroSim.getApp().getUnitSystem().getVolumeFractionUnit();
            type = InitRegion.SpecFractionType.VOLUME_FRACTION;
        }
        if (unit != null && type != null) {
            Composite.setProperty(typeProp, type, objs);
            InitRegion.SpecFracProp prop = new InitRegion.SpecFracProp();
            for (int m = 0; m < this.d_specs.size(); ++m) {
                ExSpec spec;
                prop.currSpec = spec = this.d_specs.get(m);
                Double dv = (Double)this.d_specTbl.getValueAt(m, 1);
                if (dv == null) continue;
                UnitDouble ud = new UnitDouble(dv, unit);
                Composite.setProperty(prop, ud, objs);
            }
        }
    }
}

