/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.comboboxes.CompositeComboBox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class GroupChooserDlg<T extends IPyroObject>
extends guiDialog {
    private static final long serialVersionUID = -4199541409539742471L;
    private Composite<T> d_root;
    private Collection<T> d_selected;
    private PyroMod d_mediator;
    private CompositeComboBox<T> d_group;
    private guiCheckBox d_createCB;
    private guiTextField d_newGroupFld;

    public GroupChooserDlg(Window owner, Composite<T> root, Composite<T> initial, Collection<T> selected) {
        super(owner, Intl.intl("Change Group"), 9);
        this.d_root = root;
        this.d_selected = selected;
        this.d_mediator = PyroSim.getApp().getMediator();
        this.d_createCB = new guiCheckBox(Intl.intl("New Subgroup") + ":");
        this.d_newGroupFld = new guiTextField(Intl.intl("New Group"));
        this.d_newGroupFld.setEnabled(false);
        this.d_group = new CompositeComboBox<T>(root);
        if (initial != null) {
            this.d_group.setSelectedComposite(initial);
        }
        this.d_createCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupChooserDlg.this.d_newGroupFld.setEnabled(GroupChooserDlg.this.d_createCB.isSelected());
            }
        });
        guiPanel p = this.getDialogPane();
        p.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        GridBagUtil.add(p, new guiLabel(Intl.intl("Group") + ":"), x++, y, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_group, x++, y++, 1, 1, 0, 6, 0, 0, 1, 1.0, 1.0, 17);
        GridBagUtil.add(p, this.d_createCB, 0, y, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_newGroupFld, 1, y, 1, 1, 6, 6, 0, 0, 1, 1.0, 1.0, 17);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        for (IPyroObject o : this.d_selected) {
            Composite group;
            if (!(o instanceof Composite) || !Hierarchy.isDescendent(group = (Composite)o, this.getGroup())) continue;
            this.showMessageBox(Intl.intl("Invalid group destination."));
            return false;
        }
        return true;
    }

    public Composite<T> getGroup() {
        return (Composite)this.d_group.getSelectedItem();
    }

    @Override
    public int doModal() {
        int res = super.doModal();
        return res;
    }

    public boolean isCreateNew() {
        return this.d_createCB.isSelected();
    }

    public String getNewText() {
        return this.d_newGroupFld.getText();
    }
}

