/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.IDetector;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;

public class TripFlagsPanel
extends guiPanel {
    private static final long serialVersionUID = -7791514091886585215L;
    private final guiMultiStateCheckBox d_initStateCB;
    private final guiMultiStateCheckBox d_latchCB = new guiMultiStateCheckBox(Intl.intl("Trigger only once"));

    public TripFlagsPanel() {
        this.d_initStateCB = new guiMultiStateCheckBox(Intl.intl("Initially activated"));
        int[] flags = new int[]{1};
        this.load(flags);
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_latchCB, 0);
        gb.addRow(this.d_initStateCB, 0);
        gb.finalizeRows();
    }

    public void load(int[] flags) {
        boolean latch = Arrays.stream(flags).allMatch(f -> TripFlags.latch(f));
        if (latch) {
            this.d_latchCB.setSelected(latch);
        } else {
            latch = Arrays.stream(flags).allMatch(f -> !TripFlags.latch(f));
            if (latch) {
                this.d_latchCB.setSelected(!latch);
            } else {
                this.d_latchCB.setState(2);
            }
        }
        boolean initOn = Arrays.stream(flags).allMatch(f -> TripFlags.initiallyOn(f));
        if (initOn) {
            this.d_initStateCB.setSelected(initOn);
        } else {
            initOn = Arrays.stream(flags).allMatch(f -> !TripFlags.initiallyOn(f));
            if (initOn) {
                this.d_initStateCB.setSelected(!initOn);
            } else {
                this.d_initStateCB.setState(2);
            }
        }
    }

    public void save(Collection<IDetector> devices) {
        int latchCBState = this.d_latchCB.getState();
        int initOnCBState = this.d_initStateCB.getState();
        if (latchCBState == 2 && initOnCBState == 2) {
            return;
        }
        boolean latchFlag = true;
        boolean initOnFlag = false;
        boolean descendingFlag = false;
        if (latchCBState != 2) {
            latchFlag = this.d_latchCB.isSelected();
        }
        if (initOnCBState != 2) {
            initOnFlag = this.d_initStateCB.isSelected();
        }
        for (IDetector d : devices) {
            int oldflag = d.getTripFlags();
            boolean newLatchFlag = latchFlag;
            boolean newInitOnFlag = initOnFlag;
            if (latchCBState == 2) {
                newLatchFlag = TripFlags.latch(oldflag);
            }
            if (initOnCBState == 2) {
                newInitOnFlag = TripFlags.initiallyOn(oldflag);
            }
            d.setTripFlags(TripFlags.toFlags(newLatchFlag, newInitOnFlag, descendingFlag));
        }
    }
}

