/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.DryPipeComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SprayModelComboBox;
import pyrosim.gui.comboboxes.SprinklerLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;

public class SprinklerEditor
extends ADevcEditor<Sprinkler> {
    private final SprinklerDataPanel d_sprinklerDataPanel;

    public SprinklerEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this.d_sprinklerDataPanel = new SprinklerDataPanel(pyMod, mode);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Sprinkler");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SPRK");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_sprinklerDataPanel;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        HashSet<String> types = new HashSet<String>(super.getFDSPreviewTypes());
        types.add("PROP");
        types.add("CTRL");
        return types;
    }

    @Override
    public Collection<Sprinkler> create() {
        return Arrays.asList(new Sprinkler("", this.d_sprinklerDataPanel.getSprayModel().orElse(SprinklerDataPanel.getDefaultSprayModel(PyroSim.getApp().getMediator())), this.d_sprinklerDataPanel.getLinkModel().orElse(null), new FreePointLoc()));
    }

    @Override
    public void load(Collection<Sprinkler> sprinklers) {
        this.d_sprinklerDataPanel.setSprayModel(sprinklers.stream().map(e -> e.getSprayModel()).toList());
        this.d_sprinklerDataPanel.setPipe(sprinklers.stream().map(s -> s.getDryPipe()).toList());
        this.d_sprinklerDataPanel.setLinkModel(sprinklers.stream().map(s -> s.getLinkModel()).toList());
    }

    @Override
    public void save(Collection<Sprinkler> sprk) {
        Optional<Sprinkler.LinkModel> optional;
        DryPipe dp;
        Optional<SprayModel> model = this.d_sprinklerDataPanel.getSprayModel();
        if (model.isPresent()) {
            for (Sprinkler sprinkler : sprk) {
                sprinkler.setSprayModel(model.get());
            }
        }
        if ((dp = (DryPipe)this.d_sprinklerDataPanel.d_dryPipeCombo.getSelectedItem()) != null) {
            if (dp == DryPipeComboBox.NONE_ENTRY) {
                for (Sprinkler s : sprk) {
                    s.setDryPipe(null);
                }
            } else {
                for (Sprinkler s : sprk) {
                    s.setDryPipe(dp);
                }
            }
        }
        if ((optional = this.d_sprinklerDataPanel.getLinkModel()).isPresent()) {
            UnitSystem us = PyroSim.getApp().getUnitSystem();
            for (Sprinkler s : sprk) {
                s.setLinkModel(optional.get(), us.getUnit(optional.get().getOutputQuantity().get().unitType));
            }
        } else {
            this.d_sprinklerDataPanel.d_linkModPnl.saveCustomLinkModel(sprk);
        }
    }

    public static class SprinklerDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -555686495219689805L;
        protected final LinkModelPanel d_linkModPnl;
        private final SprayModelComboBox d_sprayCombo;
        private final DryPipeComboBox d_dryPipeCombo;

        public SprinklerDataPanel(PyroMod pyMod, IDevcEditor.Mode mode) {
            this.setLayout(new GridBagLayout());
            int row = 0;
            guiLabel sprayLab = new guiLabel(Intl.intl("Spray Model") + ":");
            this.d_sprayCombo = new SprayModelComboBox(pyMod.getSprayModels());
            JButton d_editSpray = new JButton(Intl.intl("Edit") + "...");
            d_editSpray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editSprayModel((SprayModel)d_sprayCombo.getSelectedItem());
                }
            });
            this.selectDefault(pyMod);
            guiLabel pipeLbl = new guiLabel(Intl.intl("Dry Pipe:"));
            this.d_dryPipeCombo = new DryPipeComboBox(pyMod.getDevices());
            JButton newPipeBtn = new JButton(Intl.intl("New..."));
            newPipeBtn.addActionListener(Actions.NEW_DRY_PIPE_ACTION);
            TitleSeparator linkTitle = new TitleSeparator(Intl.intl("Activator"));
            this.d_linkModPnl = new LinkModelPanel(pyMod, mode);
            GridBagUtil.add(this, sprayLab, 0, ++row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_sprayCombo, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, d_editSpray, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, pipeLbl, 0, ++row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dryPipeCombo, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, newPipeBtn, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, linkTitle, 0, ++row, 3, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_linkModPnl, 0, ++row, 3, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        }

        private void selectDefault(PyroMod pyMod) {
            SprayModel defSpray = pyMod.getSprayModels().getDefaultWaterSpray(pyMod.getPartList());
            if (defSpray != null) {
                this.d_sprayCombo.setSelectedItem(defSpray);
            } else {
                this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
            }
        }

        protected static SprayModel getDefaultSprayModel(PyroMod pyMod) {
            return pyMod.getSprayModels().getDefaultWaterSpray(pyMod.getPartList());
        }

        public Optional<SprayModel> getSprayModel() {
            if (this.d_sprayCombo.getSelectedIndex() != -1) {
                return Optional.of((SprayModel)this.d_sprayCombo.getSelectedItem());
            }
            return Optional.empty();
        }

        public void setSprayModel(Collection<SprayModel> sprayModels) {
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_sprayCombo, sprayModels);
        }

        public void setPipe(Collection<DryPipe> pipes) {
            this.d_dryPipeCombo.setSelectedforMultipleDevices(pipes);
        }

        public Optional<Sprinkler.LinkModel> getLinkModel() {
            return this.d_linkModPnl.getLinkModel();
        }

        public void setLinkModel(Collection<Sprinkler.LinkModel> spkLinks) {
            this.d_linkModPnl.load(spkLinks);
        }
    }

    public static class LinkModelPanel
    extends guiPanel {
        private static final long serialVersionUID = 1109286038572904723L;
        private final guiRadioButton d_tradRB;
        private final guiComboBox<SprinklerLinkModel> d_linkCombo;
        private final guiRadioButton d_quantRB;
        private final guiComboBox<IQuantity> d_msrCombo;
        private final ButtonGroup d_bg;
        private final ValueField<UnitDouble> d_setpointFld;
        private final guiMultiStateCheckBox d_triggerOnceCB = new guiMultiStateCheckBox(Intl.intl("Trigger Only Once"));
        private final guiMultiStateCheckBox d_initOnCB = new guiMultiStateCheckBox(Intl.intl("Initially Activated"));

        public LinkModelPanel(PyroMod pyMod, IDevcEditor.Mode mode) {
            super(new GridBagLayout());
            this.setLinkModelCheckboxState(mode == IDevcEditor.Mode.EDIT);
            this.d_tradRB = new guiRadioButton(Intl.intl("Temperature Link:"));
            this.d_linkCombo = new SprinklerLinkModelComboBox(pyMod.getSprinklerLinkModels());
            JButton editLinkBtn = new JButton(Intl.intl("Edit..."));
            editLinkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Actions.editSprinklerLinkModels(d_linkCombo.getSelectedItem());
                }
            });
            LinkStatus.link((AbstractButton)this.d_tradRB, this.d_linkCombo, editLinkBtn);
            this.d_quantRB = new guiRadioButton(Intl.intl("Quantity:"));
            Predicate<Quantity> filter = Sprinkler.QuantityModel.getQuantityFilter();
            this.d_msrCombo = new QuantityComboBox(filter);
            this.d_setpointFld = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_msrCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        IQuantity m = d_msrCombo.getSelectedItem();
                        IUnitSrc u = UnitSystem.getSource(m.get().unitType);
                        ValueFields.setUnitSource(d_setpointFld, u);
                    }
                }
            });
            LinkStatus.link((AbstractButton)this.d_quantRB, this.d_msrCombo, this.d_setpointFld);
            this.d_bg = new ButtonGroup();
            this.d_bg.add(this.d_tradRB);
            this.d_bg.add(this.d_quantRB);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_tradRB, this.d_linkCombo, 1.0, editLinkBtn, 0);
            gb.addRow(this.d_quantRB, this.d_msrCombo, 1.0, this.d_setpointFld, 0);
            gb.addRow(this.d_triggerOnceCB, 0);
            gb.addRow(this.d_initOnCB, 0);
            gb.finalizeRows();
            this.d_tradRB.setSelected(true);
            this.d_msrCombo.setSelectedItem(Quantity.TEMPERATURE.create());
            this.d_setpointFld.setValue(new UnitDouble(74.0, SI.CELSIUS));
            this.d_triggerOnceCB.setSelected(true);
        }

        private void setLinkModelCheckboxState(boolean isThreeState) {
            if (isThreeState) {
                this.d_triggerOnceCB.setMode(1);
                this.d_initOnCB.setMode(1);
            } else {
                this.d_triggerOnceCB.setMode(0);
                this.d_initOnCB.setMode(0);
            }
        }

        public void load(Collection<Sprinkler.LinkModel> models) {
            Sprinkler.LinkModel model = models.iterator().next();
            if (DeviceEditorUtil.testIfAllElementsAreEqual(models, model)) {
                if (models.size() == 1) {
                    this.setLinkModelCheckboxState(false);
                }
                if (model instanceof Sprinkler.TraditionalModel) {
                    this.d_tradRB.setSelected(true);
                    this.d_linkCombo.setSelectedItem(((Sprinkler.TraditionalModel)model).d_link);
                } else {
                    Sprinkler.QuantityModel qmodel = (Sprinkler.QuantityModel)model;
                    this.d_quantRB.setSelected(true);
                    this.d_msrCombo.setSelectedItem(qmodel.d_quantity);
                    this.d_setpointFld.setValue(qmodel.d_setPoint);
                }
            } else {
                this.d_linkCombo.setSelectedItem(-1);
                this.d_msrCombo.setSelectedItem(-1);
                this.d_setpointFld.setValue(null);
                this.d_bg.clearSelection();
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(models.stream().map(s -> s.d_latch), Boolean.valueOf(model.d_latch))) {
                this.d_triggerOnceCB.setSelected(model.d_latch);
            } else {
                this.d_triggerOnceCB.setState(2);
            }
            if (DeviceEditorUtil.testIfAllElementsAreEqual(models.stream().map(s -> s.d_initState), Boolean.valueOf(model.d_initState))) {
                this.d_initOnCB.setSelected(model.d_initState);
            } else {
                this.d_initOnCB.setState(2);
            }
        }

        public Optional<Sprinkler.LinkModel> getLinkModel() {
            int latchState = this.d_triggerOnceCB.getState();
            int initState = this.d_initOnCB.getState();
            if (latchState == 2 || initState == 2) {
                return Optional.empty();
            }
            boolean latch = true;
            boolean initOn = false;
            if (latchState == 0) {
                latch = false;
            }
            if (initState == 1) {
                initOn = true;
            }
            if (this.d_tradRB.isSelected()) {
                return Optional.of(new Sprinkler.TraditionalModel(this.d_linkCombo.getSelectedItem(), initOn, latch));
            }
            if (this.d_quantRB.isSelected()) {
                return Optional.of(new Sprinkler.QuantityModel(this.d_msrCombo.getSelectedItem(), (UnitDouble)this.d_setpointFld.getValue(), initOn, latch));
            }
            return Optional.empty();
        }

        protected void saveCustomLinkModel(Collection<Sprinkler> sprk) {
            int latchState = this.d_triggerOnceCB.getState();
            int initOnState = this.d_initOnCB.getState();
            Boolean latch = false;
            Boolean initOn = true;
            latch = latchState == 2 ? null : Boolean.valueOf(latchState == 1);
            initOn = initOnState == 2 ? null : Boolean.valueOf(initOnState == 1);
            Optional<IQuantity> quantOpt = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_msrCombo);
            Optional<SprinklerLinkModel> tradOpt = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_linkCombo);
            UnitSystem us = PyroSim.getApp().getUnitSystem();
            Boolean oldLatch = latch;
            Boolean oldInitOn = initOn;
            Sprinkler.LinkModel mod = null;
            for (Sprinkler s : sprk) {
                if (latch == null) {
                    oldLatch = s.getLinkModel().d_latch;
                }
                if (initOn == null) {
                    oldInitOn = s.getLinkModel().d_initState;
                }
                if (quantOpt.isPresent()) {
                    mod = new Sprinkler.QuantityModel(quantOpt.get(), (UnitDouble)this.d_setpointFld.getValue(), oldInitOn, oldLatch);
                } else if (tradOpt.isPresent()) {
                    mod = new Sprinkler.TraditionalModel(tradOpt.get(), oldInitOn, oldLatch);
                }
                if (mod == null) continue;
                s.setLinkModel(mod, us.getUnit(mod.getOutputQuantity().get().unitType));
            }
        }
    }
}

