/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.AttachedPointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class SolidPointDeviceEditor
extends ADevcEditor<SolidPointMeasurer> {
    private final SolidPointDeviceDataPanel d_dataPanel;

    public SolidPointDeviceEditor(IDevcEditor.Mode mode) {
        this.d_dataPanel = new SolidPointDeviceDataPanel(mode);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Solid-phase Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SOLID");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new AttachedPointGeomEditor();
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        Optional<IQuantity> q = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_dataPanel.d_measCombo);
        final AlarmInfoPanel alarmPanel = q.isPresent() ? new AlarmInfoPanel(q.get()) : new AlarmInfoPanel(28, 0);
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Optional<IQuantity> msr = DeviceEditorUtil.getSelectedItemOrEmpty(SolidPointDeviceEditor.this.d_dataPanel.d_measCombo);
                if (msr.isPresent()) {
                    alarmPanel.setCurrentMsr(msr.get());
                }
            }
        });
        return alarmPanel;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public Collection<SolidPointMeasurer> create() {
        return Arrays.asList(this.d_dataPanel.create());
    }

    @Override
    public void load(Collection<SolidPointMeasurer> spm) {
        this.d_dataPanel.load(spm);
    }

    @Override
    public void save(Collection<SolidPointMeasurer> msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public boolean enableAlarmPanel() {
        return this.d_dataPanel.enableAlarmPanel();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component parent, Collection<SolidPointMeasurer> loadedObjs, boolean showWarn, boolean allowModify) {
        if (loadedObjs == null) {
            return true;
        }
        return loadedObjs.stream().allMatch(loadedObj -> MsrDeviceEditorUtil.validateData(parent, loadedObjs, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify));
    }

    public class SolidPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1726105864786556448L;
        private final IDevcEditor.Mode d_mode;
        private final QuantityComboBox d_measCombo;
        private final GuageHeatFluxProps d_heatFluxPanel;
        private final PressureCoeffProps d_pressCoeffPanel;
        private final DepthProps d_surfDepthPanel;

        public SolidPointDeviceDataPanel(IDevcEditor.Mode mode) {
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            String nullName = "";
            if (mode == IDevcEditor.Mode.CREATE) {
                nullName = null;
            }
            this.d_measCombo = new QuantityComboBox(nullName, SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
            this.d_heatFluxPanel = new GuageHeatFluxProps();
            this.d_pressCoeffPanel = new PressureCoeffProps();
            this.d_surfDepthPanel = new DepthProps(new UnitDouble(0.0, SI.METER));
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_measCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    SolidPointDeviceDataPanel.this.updateCardSelect();
                }
            });
            if (mode == IDevcEditor.Mode.EDIT) {
                this.d_measCombo.setEnabled(false);
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gb.addRow(this.d_heatFluxPanel, 0);
            gb.addRow(this.d_pressCoeffPanel, 0);
            gb.addRow(this.d_surfDepthPanel, 0);
            gb.finalizeRows();
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            if (this.d_measCombo.getSelectedItem() != null) {
                IQuantity sel = (IQuantity)this.d_measCombo.getSelectedItem();
                this.d_heatFluxPanel.setVisible(sel.get().equals((Object)Quantity.GAUGE_HEAT_FLUX));
                this.d_pressCoeffPanel.setVisible(sel.get().equals((Object)Quantity.PRESSURE_COEFFICIENT));
                this.d_surfDepthPanel.setVisible(sel.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE) || sel.get().equals((Object)Quantity.MATL_SOLID_DENSITY));
            } else {
                this.d_heatFluxPanel.setVisible(false);
                this.d_pressCoeffPanel.setVisible(false);
                this.d_surfDepthPanel.setVisible(false);
            }
            PyroGuiUtil.pack(this);
        }

        private boolean enableAlarmPanel() {
            Optional<IQuantity> opt = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo);
            if (opt.isPresent() && this.d_mode == IDevcEditor.Mode.EDIT && (Objects.equals((Object)opt.get().get(), (Object)Quantity.GAUGE_HEAT_FLUX) || Objects.equals((Object)opt.get().get(), (Object)Quantity.PRESSURE_COEFFICIENT) || Objects.equals((Object)opt.get().get(), (Object)Quantity.INSIDE_WALL_TEMPERATURE))) {
                return true;
            }
            return this.d_measCombo.isEnabled();
        }

        public void load(Collection<SolidPointMeasurer> spm) {
            boolean enableCombo = this.d_mode == IDevcEditor.Mode.CREATE;
            Predicate<Quantity> msrFilter = this.d_measCombo.getFilter();
            SolidPointMeasurer first = spm.iterator().next();
            boolean multiDevcTypes = spm.stream().map(s -> s.getClass()).distinct().toList().size() > 1;
            this.d_measCombo.setSelectedItem(null);
            if (!multiDevcTypes && first instanceof GaugeHeatFluxMeasurer) {
                UnitDouble gaugeTemp = ((GaugeHeatFluxMeasurer)first).getGaugeTemperature();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(m -> ((GaugeHeatFluxMeasurer)m).getGaugeTemperature()), gaugeTemp)) {
                    this.d_heatFluxPanel.setTemp(gaugeTemp);
                } else {
                    this.d_heatFluxPanel.setTemp(null);
                }
                double gaugeEmiss = ((GaugeHeatFluxMeasurer)first).getGaugeEmissivity();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(s -> ((GaugeHeatFluxMeasurer)s).getGaugeEmissivity()), Double.valueOf(gaugeEmiss))) {
                    this.d_heatFluxPanel.setEmiss(gaugeEmiss);
                } else {
                    this.d_heatFluxPanel.setEmiss(null);
                }
                UnitDouble htCoeff = ((GaugeHeatFluxMeasurer)first).getHeatTransferCoefficient();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(s -> ((GaugeHeatFluxMeasurer)s).getHeatTransferCoefficient()), htCoeff)) {
                    this.d_heatFluxPanel.setCoeff(htCoeff);
                } else {
                    this.d_heatFluxPanel.setCoeff(null);
                }
                this.d_measCombo.setEnabled(enableCombo);
            } else if (!multiDevcTypes && first instanceof PressureCoeffMeasurer) {
                UnitDouble charVel = ((PressureCoeffMeasurer)first).getCharacteristicVel();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(s -> ((PressureCoeffMeasurer)s).getCharacteristicVel()), charVel)) {
                    this.d_pressCoeffPanel.setVel(charVel);
                } else {
                    this.d_pressCoeffPanel.setVel(null);
                }
                this.d_measCombo.setEnabled(enableCombo);
            } else if (!multiDevcTypes && first instanceof InnerTempMeasurer) {
                UnitDouble depth = ((InnerTempMeasurer)first).getDepth();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(s -> ((InnerTempMeasurer)s).getDepth()), depth)) {
                    this.d_surfDepthPanel.setDepth(depth);
                } else {
                    this.d_surfDepthPanel.setDepth(null);
                }
                this.d_measCombo.setEnabled(enableCombo);
            } else if (!multiDevcTypes && first instanceof SolidDensityMeasurer) {
                UnitDouble depth = ((SolidDensityMeasurer)first).getDepth();
                if (DeviceEditorUtil.testIfAllElementsAreEqual(spm.stream().map(s -> ((SolidDensityMeasurer)s).getDepth()), depth)) {
                    this.d_surfDepthPanel.setDepth(depth);
                } else {
                    this.d_surfDepthPanel.setDepth(null);
                }
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    msrFilter = msrFilter.and(SolidDensityMeasurer.getQuantityFilter());
                }
            } else if (this.d_mode == IDevcEditor.Mode.EDIT) {
                EnumSet<Quantity> invalidMsrs = EnumSet.of(Quantity.GAUGE_HEAT_FLUX, Quantity.PRESSURE_COEFFICIENT, Quantity.INSIDE_WALL_TEMPERATURE);
                msrFilter = msrFilter.and(Filters.reject(invalidMsrs));
                msrFilter = msrFilter.and(SolidDensityMeasurer.getQuantityFilter().negate());
                this.d_measCombo.setEnabled(spm.stream().map(s -> s.getQuantity().get()).distinct().count() == 1L);
            }
            DeviceEditorUtil.setComboBoxSelectionForMultipleDevices(this.d_measCombo, spm.stream().map(e -> e.getQuantity()).toList());
            this.d_measCombo.setFilter(msrFilter);
            this.updateCardSelect();
        }

        public SolidPointMeasurer create() {
            SolidPointMeasurer spm = new SolidPointMeasurer("", (IQuantity)this.d_measCombo.getSelectedItem(), new AttachedPointLoc());
            Optional<IQuantity> msrt = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo);
            if (msrt.isPresent()) {
                if (Objects.equals((Object)msrt.get().get(), (Object)Quantity.GAUGE_HEAT_FLUX)) {
                    spm = new GaugeHeatFluxMeasurer("", this.d_heatFluxPanel.getTemp().orElse(null), this.d_heatFluxPanel.getEmiss().orElse(1.0), this.d_heatFluxPanel.getCoeff().orElse(null), new AttachedPointLoc());
                } else if (Objects.equals((Object)msrt.get().get(), (Object)Quantity.PRESSURE_COEFFICIENT)) {
                    spm = new PressureCoeffMeasurer("", this.d_pressCoeffPanel.getVel().orElse(SIUS.newud(1.0, 8)), new AttachedPointLoc());
                } else if (Objects.equals((Object)msrt.get().get(), (Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
                    spm = new InnerTempMeasurer("", this.d_surfDepthPanel.getDepth().orElse(new UnitDouble(0.0, SI.METER)), new AttachedPointLoc());
                } else if (Objects.equals((Object)msrt.get().get(), (Object)Quantity.MATL_SOLID_DENSITY)) {
                    spm = new SolidDensityMeasurer("", (ObjectQuantity)msrt.get(), this.d_surfDepthPanel.getDepth().orElse(new UnitDouble(0.0, SI.METER)), new AttachedPointLoc());
                }
            }
            return spm;
        }

        public void save(Collection<SolidPointMeasurer> msr) {
            SolidPointMeasurer first = msr.iterator().next();
            if (first instanceof GaugeHeatFluxMeasurer) {
                if (this.d_heatFluxPanel.getTemp().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((GaugeHeatFluxMeasurer)m).setGaugeTemperature(this.d_heatFluxPanel.getTemp().get());
                    }
                }
                if (this.d_heatFluxPanel.getEmiss().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((GaugeHeatFluxMeasurer)m).setGaugeEmissivity(this.d_heatFluxPanel.getEmiss().get());
                    }
                }
                if (this.d_heatFluxPanel.getCoeff().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((GaugeHeatFluxMeasurer)m).setHeatTransferCoefficient(this.d_heatFluxPanel.getCoeff().get());
                    }
                }
            } else if (first instanceof PressureCoeffMeasurer) {
                if (this.d_pressCoeffPanel.getVel().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((PressureCoeffMeasurer)m).setCharacteristicVel(this.d_pressCoeffPanel.getVel().get());
                    }
                }
            } else if (first instanceof InnerTempMeasurer) {
                if (this.d_surfDepthPanel.getDepth().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((InnerTempMeasurer)m).setDepth(this.d_surfDepthPanel.getDepth().get());
                    }
                }
            } else if (first instanceof SolidDensityMeasurer) {
                this.saveMsr(msr);
                if (this.d_surfDepthPanel.getDepth().isPresent()) {
                    for (SolidPointMeasurer m : msr) {
                        ((SolidDensityMeasurer)m).setDepth(this.d_surfDepthPanel.getDepth().get());
                    }
                }
            } else {
                this.saveMsr(msr);
            }
        }

        private void saveMsr(Collection<SolidPointMeasurer> devc) {
            Optional<IQuantity> opt = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_measCombo);
            if (opt.isPresent()) {
                IQuantity newMsr = opt.get();
                Unit newUnit = PyroSim.getApp().getUnitSystem().getUnit(newMsr.get().unitType);
                for (AMeasuringDevc aMeasuringDevc : devc) {
                    aMeasuringDevc.setQuantity(newMsr, newUnit);
                }
            }
        }
    }

    public static class DepthProps
    extends guiPanel {
        private static final long serialVersionUID = -2411132089444480219L;
        private ValueField<UnitDouble> d_depth;

        public DepthProps(UnitDouble defValue) {
            this.setLayout(new GridBagLayout());
            guiLabel depthLab = new guiLabel(Intl.intl("Surface Depth") + ":");
            this.d_depth = ValueFields.udFld(defValue, UnitSystem.getSource(0));
            this.d_depth.setNullAllowed(true);
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(depthLab, this.d_depth, 0);
            gbh.finalizeRows();
        }

        public Optional<UnitDouble> getDepth() {
            return Optional.ofNullable((UnitDouble)this.d_depth.getValue());
        }

        public void setDepth(UnitDouble depth) {
            this.d_depth.setValue(depth);
        }
    }

    public static class PressureCoeffProps
    extends guiPanel {
        private static final long serialVersionUID = 9038362831755486092L;
        private ValueField<UnitDouble> d_vel;

        public PressureCoeffProps() {
            guiLabel velLab = new guiLabel(Intl.intl("Characteristic Velocity") + ":");
            this.d_vel = ValueFields.udFld(new PressureCoeffMeasurer("", null).getCharacteristicVel(), UnitSystem.getSource(8));
            this.d_vel.setNullAllowed(true);
            this.setLayout(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(velLab, this.d_vel, 0);
            gbh.finalizeRows();
        }

        public Optional<UnitDouble> getVel() {
            return Optional.ofNullable((UnitDouble)this.d_vel.getValue());
        }

        public void setVel(UnitDouble vel) {
            this.d_vel.setValue(vel);
        }
    }

    public static class GuageHeatFluxProps
    extends guiPanel {
        private static final long serialVersionUID = -6098232058307237925L;
        private ValueField<UnitDouble> d_temp;
        private ValueField<Double> d_emiss;
        private ValueField<UnitDouble> d_coeff;
        private guiCheckBox d_enableCoeff;

        public GuageHeatFluxProps() {
            guiLabel tempLab = new guiLabel(Intl.intl("Gauge Temperature:"));
            this.d_temp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_temp.setNullAllowed(true);
            ValueFields.getFormat(this.d_temp).alias(null, "TMPA");
            this.d_temp.setValue(null);
            guiLabel emissLab = new guiLabel(Intl.intl("Gauge Emissivity:"));
            this.d_emiss = ValueFields.doubleFld(1.0, DoubleVR.between(0.0, 1.0, false, true));
            this.d_emiss.setNullAllowed(true);
            this.d_enableCoeff = new guiCheckBox(Intl.intl("Enable Heat Transfer Coefficient:"));
            this.d_coeff = ValueFields.udFld(UnitSystem.getSource(81));
            this.d_coeff.setNullAllowed(true);
            this.d_coeff.setEnabled(false);
            this.d_enableCoeff.addChangeListener(evt -> this.d_coeff.setEnabled(this.d_enableCoeff.isSelected()));
            this.setLayout(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(tempLab, this.d_temp, 0);
            gbh.addRow(emissLab, this.d_emiss, 0);
            gbh.addRow(this.d_enableCoeff, this.d_coeff, 0);
            gbh.finalizeRows();
        }

        public Optional<UnitDouble> getTemp() {
            return Optional.ofNullable((UnitDouble)this.d_temp.getValue());
        }

        public void setTemp(UnitDouble temp) {
            this.d_temp.setValue(temp);
        }

        public Optional<Double> getEmiss() {
            return Optional.ofNullable((Double)this.d_emiss.getValue());
        }

        public void setEmiss(Double emiss) {
            this.d_emiss.setValue(emiss);
        }

        public Optional<UnitDouble> getCoeff() {
            if (this.d_enableCoeff.isSelected()) {
                return Optional.ofNullable((UnitDouble)this.d_coeff.getValue());
            }
            return Optional.empty();
        }

        public void setCoeff(UnitDouble coeff) {
            this.d_enableCoeff.setSelected(coeff != null);
            this.d_coeff.setValue(this.d_enableCoeff.isSelected() ? coeff : new UnitDouble(0.0, SIUS.unit(81)));
        }
    }
}

