/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Optional;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.gui.IGridBagAdder;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NamePnl
extends guiPanel
implements IGridBagAdder {
    private static final long serialVersionUID = 7595994933846914872L;
    private final PyroMod d_pyMod;
    private String d_loadedName;
    private final guiTextField d_nameFld;

    public NamePnl(PyroMod pyMod, String defaultName) {
        this.d_pyMod = pyMod;
        this.d_nameFld = new guiTextField(pyMod.getNames(IDevice.class).generateValidName(defaultName));
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(Intl.intl("Name:"), this.d_nameFld, 0, 1.0);
    }

    public guiTextField getNameField() {
        return this.d_nameFld;
    }

    protected void setDefaultName(String defaultName) {
        this.d_nameFld.setText(this.d_pyMod.getNames(IDevice.class).generateValidName(defaultName));
    }

    public void load(String name) {
        this.d_nameFld.setText(name);
        this.d_loadedName = name;
    }

    public Optional<String> save() {
        String fld = this.d_nameFld.getText();
        if (fld.startsWith("<") && fld.endsWith(">")) {
            return Optional.empty();
        }
        return Optional.of(fld);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_nameFld.getText().equals(this.d_loadedName)) {
            return true;
        }
        String name = this.d_nameFld.getText().trim();
        if (name.length() < 1) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this.d_nameFld), Intl.intl("Please enter a name."));
            }
            if (allowModify) {
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        if (this.d_pyMod.getNames(IDevice.class).isRegistered(name)) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this.d_nameFld), String.format(Intl.intl("There is already a device named %s.\nPlease enter another name."), name));
            }
            if (allowModify) {
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        return true;
    }
}

