/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.HeatLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;

public class HeatDetectorEditor
extends ADevcEditor<HeatDetector> {
    private final HeatDetectorDataPanel d_dataPanel;

    public HeatDetectorEditor(PyroMod pyMod) {
        this.d_dataPanel = new HeatDetectorDataPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Heat Detector");
    }

    @Override
    public String getDefName() {
        return Intl.intl("HD");
    }

    @Override
    public void load(Collection<HeatDetector> heatDetector) {
        HeatLinkModel first = heatDetector.iterator().next().getModel();
        if (DeviceEditorUtil.testIfAllElementsAreEqual(heatDetector.stream().map(h -> h.getModel()).toList(), first)) {
            this.d_dataPanel.setHeatLinkModel(first);
        } else {
            this.d_dataPanel.setHeatLinkModel(null);
        }
    }

    @Override
    public Collection<HeatDetector> create() {
        return Arrays.asList(new HeatDetector("", this.d_dataPanel.getHeatLinkModel().orElse(null), new FreePointLoc()));
    }

    @Override
    public void save(Collection<HeatDetector> hd) {
        Optional<HeatLinkModel> mod = this.d_dataPanel.getHeatLinkModel();
        if (mod.isPresent()) {
            for (HeatDetector h : hd) {
                h.setModel(mod.get());
            }
        }
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class HeatDetectorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -5913785177024606267L;
        private final guiComboBox<HeatLinkModel> d_linkCombo;

        public HeatDetectorDataPanel(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_linkCombo = new HeatLinkModelComboBox(pyMod.getHeatLinkModels(), "");
            this.d_linkCombo.setMinimumSize(this.d_linkCombo.getPreferredSize());
            JButton d_editHeatLink = new JButton(Intl.intl("Edit") + "...");
            d_editHeatLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editHeatLinkModels(d_linkCombo.getSelectedItem());
                    if (d_linkCombo.getSelectedItem() == null && d_linkCombo.getItemCount() > 0) {
                        d_linkCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Link:"), this.d_linkCombo, d_editHeatLink, 0);
            gb.finalizeRows();
        }

        public Optional<HeatLinkModel> getHeatLinkModel() {
            return DeviceEditorUtil.getSelectedItemOrEmpty(this.d_linkCombo);
        }

        public void setHeatLinkModel(HeatLinkModel hlm) {
            this.d_linkCombo.setSelectedItem(hlm);
        }
    }
}

