/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import thunderheadeng.gui.guiComboBox;

public class DeviceEditorUtil {
    public static <T> void setComboBoxSelectionForMultipleDevices(guiComboBox<T> comboBox, Collection<T> deviceProps) {
        T first = deviceProps.iterator().next();
        if (deviceProps.size() == 1) {
            comboBox.setSelectedItem(first);
        } else if (DeviceEditorUtil.testIfAllElementsAreEqual(deviceProps, first)) {
            comboBox.setSelectedItem(first);
        } else {
            comboBox.setSelectedItem(null);
        }
    }

    public static <T> void setComboBoxIndexForMultipleDevices(guiComboBox<Integer> comboBox, Collection<Integer> ix) {
        Integer first = ix.iterator().next();
        if (ix.size() == 1) {
            comboBox.setSelectedIndex(first);
        } else if (DeviceEditorUtil.testIfAllElementsAreEqual(ix, first)) {
            comboBox.setSelectedIndex(first);
        } else {
            comboBox.setSelectedIndex(-1);
        }
    }

    public static <T> boolean testIfAllElementsAreEqual(Collection<T> elements, T firstElement) {
        return DeviceEditorUtil.testIfAllElementsAreEqual(elements.stream(), firstElement);
    }

    public static <T> boolean testIfAllElementsAreEqual(Collection<T> elements) {
        T first = elements.iterator().next();
        return DeviceEditorUtil.testIfAllElementsAreEqual(elements, first);
    }

    public static <T> boolean testIfAllElementsAreEqual(Stream<T> elementsStream, T firstElement) {
        if (firstElement == null) {
            return elementsStream.allMatch(o -> firstElement == o);
        }
        return elementsStream.allMatch(firstElement::equals);
    }

    public static <T> boolean testIfAllElementsAreSameClass(Collection<T> elem) {
        return DeviceEditorUtil.testIfAllElementsAreEqual(elem.stream().map(e -> e.getClass()).toList());
    }

    public static <T> boolean testifAllAreGasPointMeasurers(Collection<T> elem) {
        return elem.stream().allMatch(e -> e instanceof GasPointMeasurer);
    }

    public static <T> Optional<T> getSelectedItemOrEmpty(guiComboBox<T> comboBox) {
        if (comboBox.getSelectedItem() != null && comboBox.isEnabled()) {
            return Optional.of(comboBox.getSelectedItem());
        }
        return Optional.empty();
    }
}

