/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FEDMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.devices.AspiratorEditor;
import pyrosim.gui.devices.AspiratorSamplerEditor;
import pyrosim.gui.devices.DryPipeEditor;
import pyrosim.gui.devices.FlowMeasurerEditor;
import pyrosim.gui.devices.GasPointDevcEditor;
import pyrosim.gui.devices.HRRMsrEditor;
import pyrosim.gui.devices.HeatDetectorEditor;
import pyrosim.gui.devices.HvacDevcEditor;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.LayerMsrEditor;
import pyrosim.gui.devices.NozzleEditor;
import pyrosim.gui.devices.PathObscMsrEditor;
import pyrosim.gui.devices.SimControlEditor;
import pyrosim.gui.devices.SmokeDetectorEditor;
import pyrosim.gui.devices.SolidPointDeviceEditor;
import pyrosim.gui.devices.SprinklerEditor;
import pyrosim.gui.devices.SprinklerLinkEditor;
import pyrosim.gui.devices.StatisticsDevcEditor;

public class DevcEditorFactory {
    private static final Map<Class<? extends IDevice>, EditorFunc> EDITORS = new LinkedHashMap<Class<? extends IDevice>, EditorFunc>();

    public static Collection<Class<? extends IDevice>> getAllDevcTypes() {
        return EDITORS.keySet();
    }

    public static Class<? extends IDevice> getEditorType(Collection<? extends IDevice> objs) {
        Set targets = objs.stream().map(obj -> obj.getClass()).collect(Collectors.toSet());
        Optional<Class> reference = null;
        for (Class targetClazz : targets) {
            Optional<Class> compare = EDITORS.keySet().stream().filter(clazz -> clazz.isAssignableFrom(targetClazz)).findFirst();
            if (reference == null) {
                reference = compare;
                continue;
            }
            if (!reference.isEmpty() && Objects.equals(reference, compare)) continue;
            return null;
        }
        return reference.orElse(null);
    }

    public static <T extends IDevice> IDevcEditor<T> create(PyroMod pyMod, Class<T> type, IDevcEditor.Mode mode, int hvacType) {
        for (Map.Entry<Class<? extends IDevice>, EditorFunc> entry : EDITORS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            EditorFunc func = entry.getValue();
            IDevcEditor<? extends IDevice> editor = func.create(pyMod, type, mode, hvacType);
            return editor;
        }
        return null;
    }

    static {
        EDITORS.put(Thermocouple.class, (pyMod, clazz, mode, hvacType) -> new GasPointDevcEditor(pyMod, Intl.intl("Thermocouple"), Intl.intl("THCP"), Quantity.THERMOCOUPLE.create(), mode));
        EDITORS.put(FEDMeasurer.class, (pyMod, clazz, mode, hvacType) -> new GasPointDevcEditor(pyMod, Intl.intl("Fractional Effective Dose (FED)"), Intl.intl("FED"), Quantity.FED.create(), mode));
        EDITORS.put(HvacDevice.class, (pyMod, clazz, mode, hvacType) -> new HvacDevcEditor(pyMod, mode, hvacType));
        EDITORS.put(Aspirator.class, (pyMod, clazz, mode, hvacType) -> new AspiratorEditor(pyMod));
        EDITORS.put(AspiratorSampler.class, (pyMod, clazz, mode, hvacType) -> new AspiratorSamplerEditor());
        EDITORS.put(ASimCtrlDevice.class, (pyMod, clazz, mode, hvacType) -> new SimControlEditor());
        EDITORS.put(DryPipe.class, (pyMod, clazz, mode, hvacType) -> new DryPipeEditor());
        EDITORS.put(FlowMeasurer.class, (pyMod, clazz, mode, hvacType) -> new FlowMeasurerEditor(pyMod));
        EDITORS.put(GasPointMeasurer.class, (pyMod, clazz, mode, hvacType) -> new GasPointDevcEditor(pyMod, mode));
        EDITORS.put(HeatDetector.class, (pyMod, clazz, mode, hvacType) -> new HeatDetectorEditor(pyMod));
        EDITORS.put(AABoxMeasurer.class, (pyMod, clazz, mode, hvacType) -> new HRRMsrEditor());
        EDITORS.put(LayerMeasurer.class, (pyMod, clazz, mode, hvacType) -> new LayerMsrEditor());
        EDITORS.put(Nozzle.class, (pyMod, clazz, mode, hvacType) -> new NozzleEditor(pyMod, mode));
        EDITORS.put(PathObscurationMeasurer.class, (pyMod, clazz, mode, hvacType) -> new PathObscMsrEditor());
        EDITORS.put(SmokeDetector.class, (pyMod, clazz, mode, hvacType) -> new SmokeDetectorEditor(pyMod));
        EDITORS.put(SolidPointMeasurer.class, (pyMod, clazz, mode, hvacType) -> new SolidPointDeviceEditor(mode));
        EDITORS.put(Sprinkler.class, (pyMod, clazz, mode, hvacType) -> new SprinklerEditor(pyMod, mode));
        EDITORS.put(SprinklerLink.class, (pyMod, clazz, mode, hvacType) -> new SprinklerLinkEditor(pyMod));
        EDITORS.put(StatisticsDevc.class, (pyMod, clazz, mode, hvacType) -> new StatisticsDevcEditor(pyMod, mode));
    }

    private static interface EditorFunc {
        public IDevcEditor<? extends IDevice> create(PyroMod var1, Class<? extends IDevice> var2, IDevcEditor.Mode var3, int var4);
    }
}

