/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.MathOps.ADualInputMathOp;
import pyrosim.domain.controls.MathOps.AManyInputMathOp;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.ASingleInputMathOp;
import pyrosim.domain.controls.MathOps.ArcCosOp;
import pyrosim.domain.controls.MathOps.ArcSinOp;
import pyrosim.domain.controls.MathOps.ArcTanOp;
import pyrosim.domain.controls.MathOps.ConstantMathSource;
import pyrosim.domain.controls.MathOps.CosOp;
import pyrosim.domain.controls.MathOps.DivideOp;
import pyrosim.domain.controls.MathOps.ExpOp;
import pyrosim.domain.controls.MathOps.LogOp;
import pyrosim.domain.controls.MathOps.MaxOp;
import pyrosim.domain.controls.MathOps.MinOp;
import pyrosim.domain.controls.MathOps.MultiplyOp;
import pyrosim.domain.controls.MathOps.PIDControllerOp;
import pyrosim.domain.controls.MathOps.PercentileOp;
import pyrosim.domain.controls.MathOps.PowerOp;
import pyrosim.domain.controls.MathOps.SinOp;
import pyrosim.domain.controls.MathOps.SubtractOp;
import pyrosim.domain.controls.MathOps.SumOp;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.DeviceEditorUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.SortCache;

public class MathematicControlEditorPnl
extends guiPanel
implements IEditor<ControlBridge> {
    static final long serialVersionUID = 1L;
    public static ConstantMathSource s_constMathSource = new ConstantMathSource(0.0);
    private final PyroMod d_pyMod;
    private final ControlPnl d_parent;
    private final SourcePinHelper d_sourceHelper;
    private final SingleInputMathCompProvider d_singleInputComps;
    private final DualInputMathCompProvider d_dualInputComps;
    private final ManyInputMathCompProvider d_manyInputComps;
    private final guiComboBox<IControlFuncEditor> d_funcTypeCB;
    private final Map<Class<?>, IControlFuncEditor> d_opToEditorMap;
    private IControlFuncEditor d_lastSelectedEditor;
    private final AlarmInfoPanel.AlarmInfoPanelModel d_alarmInfo;
    private AMathOp d_currOp;

    public MathematicControlEditorPnl(PyroMod pyMod, ControlPnl parent) {
        this.setLayout(new GridBagLayout());
        this.d_pyMod = pyMod;
        this.d_parent = parent;
        this.d_alarmInfo = new AlarmInfoPanel.AlarmInfoPanelModel(28);
        this.d_sourceHelper = new SourcePinHelper(this.d_parent);
        this.d_dualInputComps = new DualInputMathCompProvider(this.d_sourceHelper);
        this.d_singleInputComps = new SingleInputMathCompProvider(this.d_dualInputComps);
        this.d_manyInputComps = new ManyInputMathCompProvider(this.d_sourceHelper);
        this.d_opToEditorMap = new HashMap();
        this.d_opToEditorMap.put(DivideOp.class, new DivideFuncEditor(this.d_dualInputComps));
        this.d_opToEditorMap.put(SubtractOp.class, new SubtractFuncEditor(this.d_dualInputComps));
        this.d_opToEditorMap.put(PowerOp.class, new PowerFuncEditor(this.d_dualInputComps));
        this.d_opToEditorMap.put(ExpOp.class, new ExpFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(LogOp.class, new LogFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(CosOp.class, new CosFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(ArcCosOp.class, new ArcCosFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(SinOp.class, new SinFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(ArcSinOp.class, new ArcSinFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(ArcTanOp.class, new ArcTanFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(PercentileOp.class, new PercentileFuncEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(PIDControllerOp.class, new PIDControlEditor(this.d_singleInputComps));
        this.d_opToEditorMap.put(MultiplyOp.class, new MultiplyFuncEditor(this.d_manyInputComps));
        this.d_opToEditorMap.put(SumOp.class, new SumFuncEditor(this.d_manyInputComps));
        this.d_opToEditorMap.put(MaxOp.class, new MaxFuncEditor(this.d_manyInputComps));
        this.d_opToEditorMap.put(MinOp.class, new MinFuncEditor(this.d_manyInputComps));
        ArrayList<IControlFuncEditor> editors = new ArrayList<IControlFuncEditor>(this.d_opToEditorMap.values());
        editors.sort((func1, func2) -> func1.getDisplayName().compareToIgnoreCase(func2.getDisplayName()));
        this.d_funcTypeCB = new guiComboBox<IControlFuncEditor>((Collection<IControlFuncEditor>)editors);
        this.d_funcTypeCB.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((IControlFuncEditor)value).getDisplayName());
                return this;
            }
        });
        this.d_funcTypeCB.addActionListener(e -> this.refreshEditor());
        this.d_lastSelectedEditor = this.d_funcTypeCB.getSelectedItem();
        GridBagHelper gbh = new GridBagHelper(this);
        gbh.addRow(new guiLabel(Intl.intl("Function Type:")), this.d_funcTypeCB);
        gbh.addSeparator();
        int firstSectionRowStartIx = gbh.getCurrentRow();
        Object[] firstRowComps = this.d_dualInputComps.getFirstRowComps();
        gbh.addRow(new Object[]{firstRowComps[0], firstRowComps[1], GridBagHelper.Fill.HORIZONTAL, firstRowComps[2], GridBagHelper.Fill.HORIZONTAL});
        Object[] secondRowComps = this.d_dualInputComps.getSecondRowComps();
        gbh.addRow(new Object[]{secondRowComps[0], secondRowComps[1], GridBagHelper.Fill.HORIZONTAL, secondRowComps[2], GridBagHelper.Fill.HORIZONTAL});
        int dualInputRowIx = gbh.getCurrentRow();
        gbh.setCurrentRow(firstSectionRowStartIx);
        Object[] tableRowComps = this.d_manyInputComps.getSourceTableRow();
        gbh.addRow(new Object[]{tableRowComps[0], GridBagHelper.Anchor.TOP_LEFT, tableRowComps[1], GridBagHelper.Fill.BOTH, GridBagHelper.REMAINING});
        Object[] constRowComps = this.d_manyInputComps.getConstComponentRow();
        gbh.addRow(new Object[]{constRowComps[0], constRowComps[1], GridBagHelper.Fill.HORIZONTAL});
        int manyInputRowIx = gbh.getCurrentRow();
        gbh.setCurrentRow(Integer.max(dualInputRowIx, manyInputRowIx));
        for (ICustomComponentEditor customEditor : this.getCustomFieldEditors()) {
            customEditor.addCustomDisplayComponents(gbh);
        }
        gbh.addSeparator();
        this.d_alarmInfo.addComponents(gbh, 0);
        gbh.finalizeRows();
        this.setEnabled(false);
        this.setVisible(false);
        this.setModified(false);
    }

    private void refreshEditor() {
        List<IDoubleOutPin> selections = this.d_lastSelectedEditor.getComponentProvider().getSelectedPins();
        IControlFuncEditor editor = this.d_funcTypeCB.getSelectedItem();
        this.hideAll();
        editor.updateComponentVisibility();
        editor.refreshAvailableResources();
        editor.updateComponentLabels();
        editor.getComponentProvider().setSelectedPins(selections);
        this.d_lastSelectedEditor = editor;
    }

    private void hideAll() {
        for (Component component : this.d_dualInputComps.getDisplayComponents()) {
            component.setVisible(false);
        }
        for (Component component : this.d_manyInputComps.getDisplayComponents()) {
            component.setVisible(false);
        }
        for (ICustomComponentEditor iCustomComponentEditor : this.getCustomFieldEditors()) {
            iCustomComponentEditor.hideCustomDisplayComponents();
        }
    }

    public List<IDoubleOutPin> getAvailableSources() {
        return this.d_parent.getDblSrcPins();
    }

    private Collection<ICustomComponentEditor> getCustomFieldEditors() {
        return this.d_opToEditorMap.values().stream().filter(editor -> editor instanceof ICustomComponentEditor).map(editor -> (ICustomComponentEditor)((Object)editor)).collect(Collectors.toSet());
    }

    public void load(AMathOp op) {
        for (ICustomComponentEditor custEditor : this.getCustomFieldEditors()) {
            custEditor.clearCustomDisplayComponents();
        }
        this.d_currOp = op;
        this.d_sourceHelper.refresh(op);
        IControlFuncEditor editor = this.d_opToEditorMap.get(op.getClass());
        this.d_funcTypeCB.setSelectedItem(editor);
        editor.loadMathOp(op);
        this.d_alarmInfo.load(28, op.getMeasureInfo().getAlarmInfo());
    }

    @Override
    public void init(ControlBridge dataObj) {
        this.d_currOp = null;
        this.setEnabled(dataObj != null);
        if (dataObj != null) {
            ISignalSource src = dataObj.getInputPin().getConnectedSources().iterator().next();
            assert (src instanceof AMathOp);
            this.load((AMathOp)src);
        }
        this.setModified(false);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_currOp == null) {
            return true;
        }
        List<IDoubleOutPin> signalPins = this.d_funcTypeCB.getSelectedItem().getComponentProvider().getSelectedPins();
        HashSet<ISignalSink> sources = new HashSet<ISignalSink>();
        for (IDoubleOutPin signalPin : signalPins) {
            if (!(signalPin.getAttachedSource() instanceof ISignalSink)) continue;
            sources.add((ISignalSink)((Object)signalPin.getAttachedSource()));
        }
        for (ISignalSink src : sources) {
            if (!Util.containsCycle(this.d_currOp, src)) continue;
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Controls cannot create cyclic definitions."));
            }
            return false;
        }
        return true;
    }

    private void savePin(ControlBridge dataObj) {
        Optional<IControlFuncEditor> selection = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_funcTypeCB);
        AlarmInfo alarm = this.d_alarmInfo.save().orElse(null);
        ISignalSource oldSrc = dataObj.getInputPin().getConnectedSources().iterator().next();
        assert (oldSrc instanceof AMathOp);
        if (!AMathOp.class.isInstance(oldSrc)) {
            return;
        }
        AMathOp oldMathOp = (AMathOp)oldSrc;
        oldMathOp.getInputPin().disconnectAll();
        if (selection.isPresent()) {
            Object op = selection.get().saveMathOp();
            boolean needsLogicPinDisconnect = oldMathOp.getMeasureInfo() != null && alarm == null;
            ((AMathOp)op).getMeasureInfo().setAlarmInfo(alarm);
            dataObj.getInputPin().disconnectAll();
            for (IOutPin iOutPin : ((AMathOp)op).getOutputPins()) {
                dataObj.getInputPin().connect(iOutPin);
            }
            if (needsLogicPinDisconnect) {
                ControlBridge.disconnectLogicOutPins(dataObj, this.d_pyMod);
            }
            ((AControl)op).setName(dataObj.getName());
            dataObj.changedEvt(new Object[0]);
        }
    }

    @Override
    public ControlBridge preview(ControlBridge previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.savePin(previewObj);
        return previewObj;
    }

    @Override
    public ControlBridge commit(final ControlBridge dataObj) {
        System.out.println("commit obj: " + String.valueOf(dataObj) + "  " + String.valueOf(dataObj.getClass()));
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                MathematicControlEditorPnl.this.savePin(dataObj);
            }
        };
        this.d_pyMod.getTaskManager().exec(t, Intl.intl("Edit Control"));
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static boolean isConstInputPin(IDoubleOutPin pin) {
        return s_constMathSource.getOutputPins().iterator().next().equals(pin);
    }

    private static String getTableDisplayLbl(Object obj) {
        if (obj instanceof IDoubleOutPin) {
            return MathematicControlEditorPnl.getFullDisplayLbl((IDoubleOutPin)obj);
        }
        return ControlDesc.getName(obj);
    }

    private static String getFullDisplayLbl(IDoubleOutPin signalPin) {
        return MathematicControlEditorPnl.prependLabel(signalPin.getAttachedSource(), MathematicControlEditorPnl.getName(signalPin));
    }

    private static String getName(IDoubleOutPin signalPin) {
        ISignalSource src = signalPin.getAttachedSource();
        if (src instanceof INamed) {
            String srcName = ((INamed)((Object)src)).getName();
            return MathematicControlEditorPnl.countDoubleOutputs(src) > 1 ? String.format("%s->%s", srcName, signalPin.getName()) : srcName;
        }
        return signalPin.getName();
    }

    private static String prependLabel(ISignalSource src, String name) {
        if (src instanceof IControl) {
            return String.format(Intl.intl("Control: %s"), name);
        }
        if (src instanceof IDevice) {
            if (src instanceof Clock) {
                return Intl.intl("Time");
            }
            return String.format(Intl.intl("Device: %s"), name);
        }
        return name;
    }

    private static int countDoubleOutputs(ISignalSource src) {
        int count = 0;
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!(iOutPin instanceof IDoubleOutPin)) continue;
            ++count;
        }
        return count;
    }

    public static class SourcePinHelper {
        private final ControlPnl d_parentPnl;
        private List<IDoubleOutPin> d_availInputs;
        private final Map<AMathOp, IDoubleOutPin> d_mathBridgeMap = new HashMap<AMathOp, IDoubleOutPin>();
        private IDoubleOutPin d_disabledSource;

        public SourcePinHelper(ControlPnl parent) {
            this.d_parentPnl = parent;
            this.refresh(null);
        }

        public IDoubleOutPin getDisabledSourcePin() {
            return this.d_disabledSource;
        }

        public void setDisabledSource(AMathOp op) {
            this.d_disabledSource = this.d_mathBridgeMap.get(op);
        }

        public void refresh(AMathOp disabledOp) {
            if (!this.d_parentPnl.isSourceCacheValid() || this.d_availInputs == null) {
                this.d_availInputs = new ArrayList<IDoubleOutPin>(this.d_parentPnl.getDblSrcPins());
                this.d_availInputs.add((IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0));
                this.d_availInputs.sort((o1, o2) -> MathematicControlEditorPnl.getFullDisplayLbl(o1).compareToIgnoreCase(MathematicControlEditorPnl.getFullDisplayLbl(o2)));
                this.d_mathBridgeMap.clear();
                for (IDoubleOutPin pin : this.d_availInputs) {
                    ControlBridge cb;
                    ISignalSource nakedOp;
                    ISignalSource src = pin.getAttachedSource();
                    if (!(src instanceof ControlBridge) || !((nakedOp = (cb = (ControlBridge)src).getAdapterInPin().getConnectedSources().iterator().next()) instanceof AMathOp)) continue;
                    this.d_mathBridgeMap.put((AMathOp)nakedOp, pin);
                }
            }
            this.setDisabledSource(disabledOp);
        }

        public List<IDoubleOutPin> getSortedPins() {
            return this.d_availInputs;
        }
    }

    public static class DualInputMathCompProvider
    implements IMathComponentProvider<ADualInputMathOp> {
        private final SourcePinHelper d_srcHelper;
        private static final String s_defLabelSingle = Intl.intl("Function Input:");
        private static final String s_defLabel1 = Intl.intl("First Input:");
        private static final String s_defLabel2 = Intl.intl("Second Input:");
        private final guiLabel d_firstInputLbl = new guiLabel(s_defLabel1);
        private final guiLabel d_secondInputLbl = new guiLabel(s_defLabel2);
        private final guiComboBox<IDoubleOutPin> d_firstInputCombo = new guiComboBox();
        private final guiComboBox<IDoubleOutPin> d_secondInputCombo = new guiComboBox();
        private final ValueField<Double> d_constInput1 = ValueFields.doubleFld();
        private final ValueField<Double> d_constInput2 = ValueFields.doubleFld();
        private final List<IDoubleOutPin> d_availSources = new ArrayList<IDoubleOutPin>();
        private ActionListener d_comboListener = null;

        protected DualInputMathCompProvider(SourcePinHelper helper) {
            this.d_srcHelper = helper;
            DefaultListCellRenderer pinRenderer = new DefaultListCellRenderer(){
                static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value == null) {
                        return this;
                    }
                    IDoubleOutPin signalPin = (IDoubleOutPin)value;
                    this.setText(MathematicControlEditorPnl.getFullDisplayLbl(signalPin));
                    return this;
                }
            };
            this.d_firstInputCombo.setRenderer(pinRenderer);
            this.d_secondInputCombo.setRenderer(pinRenderer);
            this.d_firstInputCombo.addItemListener(e -> {
                this.d_constInput1.setVisible(MathematicControlEditorPnl.isConstInputPin(this.d_firstInputCombo.getSelectedItem()));
                this.d_constInput1.getParent().revalidate();
            });
            this.d_secondInputCombo.addItemListener(e -> {
                this.d_constInput2.setVisible(MathematicControlEditorPnl.isConstInputPin(this.d_secondInputCombo.getSelectedItem()));
                this.d_constInput2.getParent().revalidate();
            });
            this.d_comboListener = e -> this.updateOnComboSelection(this.d_firstInputCombo.getSelectedItem(), this.d_secondInputCombo.getSelectedItem());
            this.startComboListeners();
        }

        private void pauseComboListeners() {
            this.d_firstInputCombo.removeActionListener(this.d_comboListener);
            this.d_secondInputCombo.removeActionListener(this.d_comboListener);
        }

        private void startComboListeners() {
            this.d_firstInputCombo.addActionListener(this.d_comboListener);
            this.d_secondInputCombo.addActionListener(this.d_comboListener);
        }

        private void updateOnComboSelection(IDoubleOutPin sel1, IDoubleOutPin sel2) {
            this.pauseComboListeners();
            this.d_firstInputCombo.setItems((Collection<IDoubleOutPin>)new ArrayList<IDoubleOutPin>(this.d_availSources));
            this.d_secondInputCombo.setItems((Collection<IDoubleOutPin>)new ArrayList<IDoubleOutPin>(this.d_availSources));
            this.d_firstInputCombo.setSelectedItem(sel1);
            this.d_secondInputCombo.setSelectedItem(sel2);
            this.d_firstInputCombo.removeItem(sel2);
            this.d_secondInputCombo.removeItem(sel1);
            this.startComboListeners();
        }

        @Override
        public Set<? extends Component> getDisplayComponents() {
            return new HashSet<Component>(this.getDualInputDisplayComponents());
        }

        @Override
        public void refreshComponentVisibility() {
            for (Component component : this.getDisplayComponents()) {
                component.setVisible(true);
            }
            this.refreshConstFieldVisibility();
        }

        public void refreshConstFieldVisibility() {
            if (this.d_firstInputCombo.isVisible() && this.d_firstInputCombo.getSelectedItem() != null) {
                this.d_constInput1.setVisible(MathematicControlEditorPnl.isConstInputPin(this.d_firstInputCombo.getSelectedItem()));
            }
            if (this.d_secondInputCombo.isVisible() && this.d_secondInputCombo.getSelectedItem() != null) {
                this.d_constInput2.setVisible(MathematicControlEditorPnl.isConstInputPin(this.d_secondInputCombo.getSelectedItem()));
            }
        }

        @Override
        public List<IDoubleOutPin> getSelectedPins() {
            ConstantMathSource constSrc;
            ArrayList<IDoubleOutPin> pins = new ArrayList<IDoubleOutPin>();
            if (MathematicControlEditorPnl.isConstInputPin(this.d_firstInputCombo.getSelectedItem())) {
                constSrc = new ConstantMathSource((Double)this.d_constInput1.getValue());
                pins.add((IDoubleOutPin)constSrc.getOutputPins().iterator().next());
            } else if (this.d_firstInputCombo.getSelectedItem() != null) {
                pins.add(this.d_firstInputCombo.getSelectedItem());
            }
            if (MathematicControlEditorPnl.isConstInputPin(this.d_secondInputCombo.getSelectedItem())) {
                constSrc = new ConstantMathSource((Double)this.d_constInput2.getValue());
                pins.add((IDoubleOutPin)constSrc.getOutputPins().iterator().next());
            } else if (this.d_secondInputCombo.getSelectedItem() != null) {
                pins.add(this.d_secondInputCombo.getSelectedItem());
            }
            return pins;
        }

        @Override
        public void refreshAvailableSources() {
            this.d_availSources.clear();
            this.d_availSources.addAll(this.d_srcHelper.getSortedPins());
            this.d_availSources.add((IDoubleOutPin)s_constMathSource.getOutputPins().iterator().next());
            this.d_availSources.remove(this.d_srcHelper.getDisabledSourcePin());
            this.d_firstInputCombo.setItems((Collection<IDoubleOutPin>)new ArrayList<IDoubleOutPin>(this.d_availSources));
            this.d_secondInputCombo.setItems((Collection<IDoubleOutPin>)new ArrayList<IDoubleOutPin>(this.d_availSources));
        }

        @Override
        public void loadOp(ASingleInputMathOp singleMathOp) {
            this.refreshAvailableSources();
            this.setSelectedPins(singleMathOp.getInputPin().getConnections());
        }

        @Override
        public void setSelectedPins(Collection<? extends IOutPin> signals) {
            this.pauseComboListeners();
            Iterator<? extends IOutPin> signalPinIter = signals.iterator();
            if (signalPinIter.hasNext()) {
                IOutPin pin1 = signalPinIter.next();
                assert (pin1 instanceof IDoubleOutPin);
                if (pin1.getAttachedSource() instanceof ConstantMathSource) {
                    this.d_constInput1.setValue(((ConstantMathSource)pin1.getAttachedSource()).getConstInput());
                    this.d_firstInputCombo.setSelectedItem(s_constMathSource.getOutputPins().iterator().next());
                } else {
                    this.d_firstInputCombo.setSelectedItem(pin1);
                }
                if (signalPinIter.hasNext()) {
                    IOutPin pin2 = signalPinIter.next();
                    assert (pin2 instanceof IDoubleOutPin);
                    if (pin2.getAttachedSource() instanceof ConstantMathSource) {
                        this.d_constInput2.setValue(((ConstantMathSource)pin2.getAttachedSource()).getConstInput());
                        this.d_secondInputCombo.setSelectedItem(s_constMathSource.getOutputPins().iterator().next());
                    } else {
                        this.d_secondInputCombo.setSelectedItem(pin2);
                    }
                } else {
                    this.d_secondInputCombo.setSelectedItem(null);
                }
            } else {
                this.d_firstInputCombo.setSelectedItem(null);
                this.d_secondInputCombo.setSelectedItem(null);
            }
            this.d_firstInputCombo.removeItem(this.d_secondInputCombo.getSelectedItem());
            this.d_secondInputCombo.removeItem(this.d_firstInputCombo.getSelectedItem());
            this.startComboListeners();
            this.refreshConstFieldVisibility();
        }

        @Override
        public void loadOp(ADualInputMathOp dualMathOp) {
            this.refreshAvailableSources();
            this.setSelectedPins(dualMathOp.getInputPin().getConnections());
        }

        public void setLabels(String label1, String label2) {
            this.d_firstInputLbl.setText(label1);
            this.d_secondInputLbl.setText(label2);
        }

        public void resetLabels() {
            this.d_firstInputLbl.setText(s_defLabel1);
            this.d_secondInputLbl.setText(s_defLabel2);
        }

        public Object[] getFirstRowComps() {
            return new Object[]{this.d_firstInputLbl, this.d_firstInputCombo, this.d_constInput1};
        }

        public Object[] getSecondRowComps() {
            return new Object[]{this.d_secondInputLbl, this.d_secondInputCombo, this.d_constInput2};
        }

        public List<Component> getSingleInputDisplayComponents() {
            return Arrays.asList(this.d_firstInputLbl, this.d_firstInputCombo);
        }

        public List<Component> getSecondRowDisplayComponents() {
            return Arrays.asList(this.d_secondInputLbl, this.d_secondInputCombo);
        }

        public List<Component> getDualInputDisplayComponents() {
            return Arrays.asList(this.d_firstInputLbl, this.d_firstInputCombo, this.d_constInput1, this.d_secondInputLbl, this.d_secondInputCombo, this.d_constInput2);
        }
    }

    public static class SingleInputMathCompProvider
    implements IMathComponentProvider<ASingleInputMathOp> {
        private final DualInputMathCompProvider d_dualProvider;

        public SingleInputMathCompProvider(DualInputMathCompProvider source) {
            this.d_dualProvider = source;
        }

        @Override
        public void loadOp(ASingleInputMathOp op) {
            this.d_dualProvider.loadOp(op);
        }

        @Override
        public Set<? extends Component> getDisplayComponents() {
            return new HashSet<Component>(this.d_dualProvider.getSingleInputDisplayComponents());
        }

        public void setLabel(String label) {
            this.d_dualProvider.setLabels(label, "");
        }

        public void resetLabel() {
            this.d_dualProvider.setLabels(DualInputMathCompProvider.s_defLabelSingle, DualInputMathCompProvider.s_defLabel2);
        }

        @Override
        public void refreshComponentVisibility() {
            for (Component component : this.getDisplayComponents()) {
                component.setVisible(true);
            }
            this.d_dualProvider.refreshConstFieldVisibility();
        }

        @Override
        public List<IDoubleOutPin> getSelectedPins() {
            List<IDoubleOutPin> allPins = this.d_dualProvider.getSelectedPins();
            if (!allPins.isEmpty()) {
                return Arrays.asList(this.d_dualProvider.getSelectedPins().get(0));
            }
            return allPins;
        }

        @Override
        public void setSelectedPins(Collection<? extends IOutPin> signals) {
            IDoubleOutPin selectPin = null;
            Iterator<? extends IOutPin> signalIter = signals.iterator();
            while (signalIter.hasNext() && selectPin == null) {
                selectPin = (IDoubleOutPin)signalIter.next();
            }
            List toSelect = selectPin == null ? Collections.emptyList() : Arrays.asList(selectPin);
            this.d_dualProvider.setSelectedPins(toSelect);
        }

        @Override
        public void refreshAvailableSources() {
            this.d_dualProvider.refreshAvailableSources();
        }
    }

    public static class ManyInputMathCompProvider
    implements IMathComponentProvider<AManyInputMathOp> {
        private final SourcePinHelper d_srcHelper;
        private final guiLabel d_inputLbl;
        private final guiTableEditor d_editor;
        private final guiTable d_table;
        private MultiSelectTableModel<IDoubleOutPin> d_tableModel;
        private final guiCheckBox d_constCheckBox;
        private final ValueField<Double> d_constInput;

        public ManyInputMathCompProvider(SourcePinHelper sourceHelper) {
            this.d_srcHelper = sourceHelper;
            this.d_constCheckBox = new guiCheckBox(Intl.intl("Constant Input:"));
            this.d_constInput = ValueFields.doubleFld();
            LinkStatus.link((AbstractButton)this.d_constCheckBox, this.d_constInput);
            this.d_inputLbl = new guiLabel(Intl.intl("Input Signals:"));
            this.d_tableModel = new MultiSelectTableModel(Collections.emptyList());
            this.d_table = new guiTable(this.d_tableModel, 0);
            this.d_editor = new guiTableEditor(this.d_table, 0);
            this.d_table.setTableHeader(null);
            this.d_table.setColumnSelectionAllowed(false);
            this.d_table.setSelectionMode(0);
            TableCellRenderer rend = this.d_table.getCellRenderer(0, 0);
            Component comp = rend.getTableCellRendererComponent(this.d_table, Boolean.FALSE, false, false, 0, 0);
            int width = comp.getPreferredSize().width + 20;
            this.d_table.getColumnModel().getColumn(0).setMaxWidth(width);
            this.d_table.getColumnModel().getColumn(0).setMinWidth(width);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(100, 150));
        }

        @Override
        public void setSelectedPins(Collection<? extends IOutPin> signals) {
            this.d_constCheckBox.setSelected(false);
            HashSet<IDoubleOutPin> toMarkEnabled = new HashSet<IDoubleOutPin>();
            for (IOutPin iOutPin : signals) {
                if (iOutPin.getAttachedSource() instanceof ConstantMathSource) {
                    this.d_constCheckBox.setSelected(true);
                    this.d_constInput.setValue(((ConstantMathSource)iOutPin.getAttachedSource()).getConstInput());
                    continue;
                }
                if (!(iOutPin instanceof IDoubleOutPin)) continue;
                toMarkEnabled.add((IDoubleOutPin)iOutPin);
            }
            this.d_tableModel.load(toMarkEnabled);
        }

        @Override
        public void loadOp(AManyInputMathOp op) {
            this.refreshAvailableSources();
            this.setSelectedPins(op.getInputPin().getConnections());
        }

        @Override
        public void refreshAvailableSources() {
            ArrayList<IDoubleOutPin> displaySources = new ArrayList<IDoubleOutPin>(this.d_srcHelper.getSortedPins());
            displaySources.remove(this.d_srcHelper.getDisabledSourcePin());
            this.d_tableModel.refreshAvailObjs(displaySources);
        }

        public Object[] getConstComponentRow() {
            return new Object[]{this.d_constCheckBox, this.d_constInput};
        }

        public Object[] getSourceTableRow() {
            return new Object[]{this.d_inputLbl, this.d_editor};
        }

        @Override
        public Set<? extends Component> getDisplayComponents() {
            return Stream.of(this.d_constCheckBox, this.d_constInput, this.d_inputLbl, this.d_editor).collect(Collectors.toSet());
        }

        @Override
        public void refreshComponentVisibility() {
            for (Component component : this.getDisplayComponents()) {
                component.setVisible(true);
            }
            this.d_constInput.setEnabled(this.d_constCheckBox.isSelected());
        }

        @Override
        public List<IDoubleOutPin> getSelectedPins() {
            ArrayList<IDoubleOutPin> pins = new ArrayList<IDoubleOutPin>();
            if (this.d_constCheckBox.isSelected()) {
                ConstantMathSource constSrc = new ConstantMathSource((Double)this.d_constInput.getValue());
                pins.add((IDoubleOutPin)constSrc.getOutputPins().iterator().next());
            }
            pins.addAll(this.d_tableModel.save());
            return pins;
        }

        private static class MultiSelectTableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 8101300018625206497L;
            private static final int COL_ENABLED = 0;
            private static final int COL_DETECTOR = 1;
            private static final int NUM_COLS = 2;
            private SortCache<T> d_objCache;
            private final Set<Integer> d_selObjs;

            public MultiSelectTableModel(Collection<? extends T> availObjs) {
                this.d_objCache = new SortCache<T>(availObjs);
                this.d_selObjs = new TreeSet<Integer>();
            }

            public void refreshAvailObjs(Collection<? extends T> availObjs) {
                this.d_objCache = new SortCache<T>(availObjs);
                this.d_selObjs.clear();
                this.fireTableDataChanged();
            }

            public void selectAll() {
                for (int m = 0; m < this.d_objCache.size(); ++m) {
                    this.d_selObjs.add(m);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void clearSel() {
                this.d_selObjs.clear();
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void load(Collection<? extends T> sel) {
                this.d_selObjs.clear();
                for (T obj : sel) {
                    int ix = this.d_objCache.indexOf(obj);
                    this.d_selObjs.add(ix);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public List<T> save() {
                ArrayList<T> result = new ArrayList<T>(this.d_selObjs.size());
                for (Integer ix : this.d_selObjs) {
                    if (ix == -1) continue;
                    result.add(this.d_objCache.get(ix));
                }
                return result;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return this.d_objCache.size();
            }

            @Override
            public String getColumnName(int column) {
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_selObjs.contains(rowIndex) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 1: {
                        return MathematicControlEditorPnl.getTableDisplayLbl(this.d_objCache.get(rowIndex));
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (aValue == null) {
                    return;
                }
                switch (columnIndex) {
                    case 0: {
                        if (((Boolean)aValue).booleanValue()) {
                            this.d_selObjs.add(rowIndex);
                            break;
                        }
                        this.d_selObjs.remove(rowIndex);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, rowIndex));
            }
        }
    }

    public static class DivideFuncEditor
    implements IControlFuncEditor<DivideOp> {
        private final DualInputMathCompProvider d_compProvider;

        public DivideFuncEditor(DualInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public DivideOp saveMathOp() {
            DivideOp newOp = new DivideOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.setLabels(Intl.intl("Numerator:"), Intl.intl("Denominator:"));
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Divide");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class SubtractFuncEditor
    implements IControlFuncEditor<SubtractOp> {
        private final DualInputMathCompProvider d_compProvider;

        public SubtractFuncEditor(DualInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public SubtractOp saveMathOp() {
            SubtractOp newOp = new SubtractOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabels();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Subtract");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class PowerFuncEditor
    implements IControlFuncEditor<PowerOp> {
        private final DualInputMathCompProvider d_compProvider;

        public PowerFuncEditor(DualInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public PowerOp saveMathOp() {
            PowerOp newOp = new PowerOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.setLabels(Intl.intl("Base:"), Intl.intl("Exponent:"));
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Power");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class ExpFuncEditor
    implements IControlFuncEditor<ExpOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public ExpFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public ExpOp saveMathOp() {
            ExpOp newOp = new ExpOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.setLabel(Intl.intl("Exponent:"));
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Exponential Function");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class LogFuncEditor
    implements IControlFuncEditor<LogOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public LogFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public LogOp saveMathOp() {
            LogOp newOp = new LogOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Natural Logarithm");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class CosFuncEditor
    implements IControlFuncEditor<CosOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public CosFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public CosOp saveMathOp() {
            CosOp newOp = new CosOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Cosine");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class ArcCosFuncEditor
    implements IControlFuncEditor<ArcCosOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public ArcCosFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public ArcCosOp saveMathOp() {
            ArcCosOp newOp = new ArcCosOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Arccosine");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class SinFuncEditor
    implements IControlFuncEditor<SinOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public SinFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public SinOp saveMathOp() {
            SinOp newOp = new SinOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Sine");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class ArcSinFuncEditor
    implements IControlFuncEditor<ArcSinOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public ArcSinFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public ArcSinOp saveMathOp() {
            ArcSinOp newOp = new ArcSinOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Arcsine");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class ArcTanFuncEditor
    implements IControlFuncEditor<ArcTanOp> {
        private final SingleInputMathCompProvider d_compProvider;

        public ArcTanFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public ArcTanOp saveMathOp() {
            ArcTanOp newOp = new ArcTanOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Arctangent");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class PercentileFuncEditor
    implements IControlFuncEditor<PercentileOp>,
    ICustomComponentEditor {
        private final SingleInputMathCompProvider d_compProvider;
        private guiLabel d_percentileLbl;
        private ValueField<Double> d_percentileField;

        public PercentileFuncEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
            this.d_percentileLbl = new guiLabel(Intl.intl("Percentile:"));
            this.d_percentileField = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
        }

        @Override
        public PercentileOp saveMathOp() {
            PercentileOp newOp = new PercentileOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            newOp.setPercentile((Double)this.d_percentileField.getValue());
            return newOp;
        }

        @Override
        public void loadMathOp(PercentileOp op) {
            this.getComponentProvider().loadOp(op);
            this.d_percentileField.setValue(op.getPercentile());
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Percentile");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }

        @Override
        public void updateComponentVisibility() {
            this.getComponentProvider().refreshComponentVisibility();
            this.showCustomDisplayComponents();
        }

        @Override
        public List<Component[]> getCustomDisplayComponents() {
            return Collections.singletonList(new Component[]{this.d_percentileLbl, this.d_percentileField});
        }

        @Override
        public void clearCustomDisplayComponents() {
            this.d_percentileField.setValue(0.0);
        }
    }

    public static class PIDControlEditor
    implements IControlFuncEditor<PIDControllerOp>,
    ICustomComponentEditor {
        private final SingleInputMathCompProvider d_compProvider;
        private guiLabel d_targetLbl;
        private guiLabel d_propLbl;
        private guiLabel d_intLbl;
        private guiLabel d_derivLbl;
        private ValueField<Double> d_targetVal;
        private ValueField<Double> d_propGain;
        private ValueField<Double> d_intGain;
        private ValueField<Double> d_derivGain;

        public PIDControlEditor(SingleInputMathCompProvider comps) {
            this.d_compProvider = comps;
            this.d_targetLbl = new guiLabel(Intl.intl("Target Value:"));
            this.d_propLbl = new guiLabel(Intl.intl("Proportional Gain:"));
            this.d_intLbl = new guiLabel(Intl.intl("Integral Gain:"));
            this.d_derivLbl = new guiLabel(Intl.intl("Differential Gain:"));
            this.d_targetVal = ValueFields.doubleFld();
            this.d_propGain = ValueFields.doubleFld();
            this.d_intGain = ValueFields.doubleFld();
            this.d_derivGain = ValueFields.doubleFld();
        }

        @Override
        public PIDControllerOp saveMathOp() {
            PIDControllerOp newOp = new PIDControllerOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            newOp.setProportionalGain((Double)this.d_propGain.getValue());
            newOp.setIntegralGain((Double)this.d_intGain.getValue());
            newOp.setDerivativeGain((Double)this.d_derivGain.getValue());
            newOp.setTargetValue((Double)this.d_targetVal.getValue());
            return newOp;
        }

        @Override
        public void loadMathOp(PIDControllerOp op) {
            this.getComponentProvider().loadOp(op);
            this.d_propGain.setValue(op.getProportionalGain());
            this.d_intGain.setValue(op.getIntegralGain());
            this.d_derivGain.setValue(op.getDerivativeGain());
            this.d_targetVal.setValue(op.getTargetValue());
        }

        @Override
        public void updateComponentLabels() {
            this.d_compProvider.resetLabel();
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("PID");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }

        @Override
        public void updateComponentVisibility() {
            this.getComponentProvider().refreshComponentVisibility();
            this.showCustomDisplayComponents();
        }

        @Override
        public List<Component[]> getCustomDisplayComponents() {
            return Arrays.asList({this.d_targetLbl, this.d_targetVal}, {this.d_propLbl, this.d_propGain}, {this.d_intLbl, this.d_intGain}, {this.d_derivLbl, this.d_derivGain});
        }

        @Override
        public void clearCustomDisplayComponents() {
            this.d_propGain.setValue(0.0);
            this.d_intGain.setValue(0.0);
            this.d_derivGain.setValue(0.0);
            this.d_targetVal.setValue(0.0);
        }
    }

    public static class MultiplyFuncEditor
    implements IControlFuncEditor<MultiplyOp> {
        private final ManyInputMathCompProvider d_compProvider;

        public MultiplyFuncEditor(ManyInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public MultiplyOp saveMathOp() {
            MultiplyOp newOp = new MultiplyOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                newOp.getInputPin().connect(pin);
            }
            return newOp;
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Multiply");
        }
    }

    public static class SumFuncEditor
    implements IControlFuncEditor<SumOp> {
        private final ManyInputMathCompProvider d_compProvider;

        public SumFuncEditor(ManyInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public SumOp saveMathOp() {
            SumOp op = new SumOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                op.getInputPin().connect(pin);
            }
            return op;
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Sum");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class MaxFuncEditor
    implements IControlFuncEditor<MaxOp> {
        private final ManyInputMathCompProvider d_compProvider;

        public MaxFuncEditor(ManyInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public MaxOp saveMathOp() {
            MaxOp op = new MaxOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                op.getInputPin().connect(pin);
            }
            return op;
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Maximum");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static class MinFuncEditor
    implements IControlFuncEditor<MinOp> {
        private final ManyInputMathCompProvider d_compProvider;

        public MinFuncEditor(ManyInputMathCompProvider comps) {
            this.d_compProvider = comps;
        }

        @Override
        public MinOp saveMathOp() {
            MinOp op = new MinOp();
            for (IDoubleOutPin pin : this.d_compProvider.getSelectedPins()) {
                op.getInputPin().connect(pin);
            }
            return op;
        }

        @Override
        public String getDisplayName() {
            return Intl.intl("Minimum");
        }

        @Override
        public IMathComponentProvider getComponentProvider() {
            return this.d_compProvider;
        }
    }

    public static interface IControlFuncEditor<T extends AMathOp> {
        public T saveMathOp();

        default public void loadMathOp(T op) {
            this.getComponentProvider().loadOp(op);
        }

        public IMathComponentProvider getComponentProvider();

        default public Collection<? extends Component> getDisplayComponents() {
            return this.getComponentProvider().getDisplayComponents();
        }

        default public void updateComponentLabels() {
        }

        public String getDisplayName();

        default public void updateComponentVisibility() {
            this.getComponentProvider().refreshComponentVisibility();
        }

        default public void refreshAvailableResources() {
            this.getComponentProvider().refreshAvailableSources();
        }
    }

    public static interface ICustomComponentEditor {
        public List<Component[]> getCustomDisplayComponents();

        public void clearCustomDisplayComponents();

        default public void addCustomDisplayComponents(GridBagHelper gb) {
            for (Component[] row : this.getCustomDisplayComponents()) {
                gb.addRow(row);
            }
        }

        default public void setCustomDisplayVisibility(boolean show) {
            for (Component[] row : this.getCustomDisplayComponents()) {
                for (Component comp : row) {
                    comp.setVisible(show);
                }
            }
        }

        default public void hideCustomDisplayComponents() {
            this.setCustomDisplayVisibility(false);
        }

        default public void showCustomDisplayComponents() {
            this.setCustomDisplayVisibility(true);
        }
    }

    public static interface IMathComponentProvider<T extends AMathOp> {
        public void loadOp(T var1);

        public void setSelectedPins(Collection<? extends IOutPin> var1);

        public List<IDoubleOutPin> getSelectedPins();

        public Set<? extends Component> getDisplayComponents();

        public void refreshComponentVisibility();

        public void refreshAvailableSources();
    }
}

