/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class PyroComboBox<T extends IPyroObject>
extends guiComboBox<T>
implements IEventObserver {
    private static final long serialVersionUID = -5876637113437920205L;
    private final Class<T> d_objType;
    private final IPyroObject d_manager;
    private final String d_nullName;
    private Predicate<T> d_filter;
    private boolean d_includeImplicitObjs;

    public PyroComboBox(IPyroObject manager, Class<T> objType) {
        this(manager, (IPyroObject)null, objType);
        this.selectFirstInstance();
    }

    public PyroComboBox(IPyroObject manager, String nullName, Class<T> objType) {
        this(manager, null, nullName, objType);
        this.selectFirstInstance();
    }

    public PyroComboBox(IPyroObject manager, T defObj, Class<T> objType) {
        this(manager, defObj, null, objType);
    }

    public PyroComboBox(IPyroObject manager, T defObj, String nullName, Class<T> objType) {
        this.d_manager = manager;
        this.d_objType = objType;
        this.d_nullName = nullName;
        this.d_filter = Filters.acceptAll();
        this.setRenderer(this.createRenderer());
        Collection<?> objList = this.getObjList();
        this.setModel(this.createModel(objList.toArray(new Object[objList.size()])));
        this.setSelectedItem(defObj);
        if (manager.getDomain() != null) {
            ((PyroMod)manager.getDomain()).getEvents().addObserver(this);
        }
        this.setMinimumSize(this.getPreferredSize());
    }

    protected void selectFirstInstance() {
        for (int m = 0; m < this.getModel().getSize(); ++m) {
            Object obj = this.getModel().getElementAt(m);
            if (!this.d_objType.isInstance(obj)) continue;
            this.setSelectedIndex(m);
            break;
        }
    }

    protected ComboBoxModel createModel(Object[] items) {
        return new DefaultComboBoxModel<Object>(items);
    }

    public IPyroObject getManager() {
        return this.d_manager;
    }

    public Predicate<T> getFilter() {
        return this.d_filter;
    }

    public void setFilter(Predicate<T> filter) {
        assert (filter != null);
        this.d_filter = filter;
        this.updateList();
    }

    protected ListCellRenderer createRenderer() {
        return new UniqueObjCBRenderer();
    }

    protected String getObjName(IPyroObject manager, T val) {
        return Util.getName(val);
    }

    protected Collection<?> getDefaultList() {
        ANameSorter comparator = new ANameSorter<T>(){

            @Override
            protected String getName(T o) {
                return PyroComboBox.this.getObjName(PyroComboBox.this.d_manager, o);
            }
        };
        Collection<T> coll = Hierarchy.flatten(this.d_manager.getMembers(), this.d_objType, this.d_filter);
        Collection<T> sortedObjs = theUtil.sort(comparator, coll);
        return sortedObjs;
    }

    protected Collection<?> getObjList() {
        Collection<?> sortedObjs = this.getDefaultList();
        if (this.d_nullName != null) {
            ArrayList objs = new ArrayList(sortedObjs.size() + 1);
            objs.add(null);
            objs.addAll(sortedObjs);
            return objs;
        }
        return sortedObjs;
    }

    private T findFirstInstance(Collection<?> objs) {
        for (Object obj : objs) {
            if (!this.d_objType.isInstance(obj)) continue;
            return (T)((IPyroObject)this.d_objType.cast(obj));
        }
        return null;
    }

    private boolean isInList(Collection<?> objs, T obj) {
        for (Object o : objs) {
            if (obj != o) continue;
            return true;
        }
        return false;
    }

    protected void updateList() {
        IPyroObject selectedItem = (IPyroObject)this.getSelectedItem();
        Collection<?> objList = this.getObjList();
        IPyroObject newSelectedItem = selectedItem == null || this.isInList(objList, selectedItem) ? selectedItem : this.findFirstInstance(objList);
        this.setModel(this.createModel(objList.toArray(new Object[objList.size()])));
        if (newSelectedItem != selectedItem) {
            this.setSelectedItem(newSelectedItem);
        } else {
            boolean isAlreadyModified = this.isModified();
            ActionListener[] alisteners = this.getActionListeners();
            ItemListener[] ilisteners = this.getItemListeners();
            for (ActionListener actionListener : alisteners) {
                this.removeActionListener(actionListener);
            }
            for (EventListener eventListener : ilisteners) {
                this.removeItemListener((ItemListener)eventListener);
            }
            this.setSelectedItem(newSelectedItem);
            for (EventListener eventListener : alisteners) {
                this.addActionListener((ActionListener)eventListener);
            }
            for (EventListener eventListener : ilisteners) {
                this.addItemListener((ItemListener)eventListener);
            }
            this.setModified(isAlreadyModified);
        }
    }

    @Override
    public void update(Events events) {
        if (!events.getAffectedChannels(this.d_objType, new Class[0]).isEmpty() || !events.getAffectedChannels(this.d_manager.getClass(), new Class[0]).isEmpty()) {
            this.updateList();
        }
    }

    protected class UniqueObjCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4890010126789220647L;

        protected UniqueObjCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name;
            if (value instanceof Component) {
                return (Component)value;
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                if (PyroComboBox.this.d_nullName == null) {
                    return this;
                }
                name = PyroComboBox.this.d_nullName;
            } else {
                name = PyroComboBox.this.d_objType.isInstance(value) ? PyroComboBox.this.getObjName(PyroComboBox.this.d_manager, (IPyroObject)value) : value.toString();
            }
            this.setText(name);
            return this;
        }
    }
}

