/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.devices.DeviceEditorUtil;

public class DryPipeComboBox
extends PyroComboBox<DryPipe> {
    private static final long serialVersionUID = -2267683109441052553L;
    public static DryPipe NONE_ENTRY = new DryPipe(Intl.intl("<None>"));

    public DryPipeComboBox(DeviceManager manager) {
        super(manager, DryPipe.class);
        super.setSelectedItem(NONE_ENTRY);
    }

    protected String getObjName(Composite<? super DryPipe> manager, DryPipe val) {
        Object name = super.getObjName(manager, val);
        name = (String)name + String.format(Intl.intl(" (%s delay)"), val.getDelay().toString());
        return name;
    }

    @Override
    protected Collection<?> getObjList() {
        Collection<?> defList = this.getDefaultList();
        ArrayList<DryPipe> list = new ArrayList<DryPipe>(defList.size() + 3);
        list.add(NONE_ENTRY);
        list.addAll(defList);
        return list;
    }

    public void setSelectedforMultipleDevices(Collection<DryPipe> pipes) {
        if (pipes.size() == 1) {
            this.setSelectedItem(pipes.stream().filter(Objects::nonNull).findFirst().orElse(NONE_ENTRY));
        } else if (DeviceEditorUtil.testIfAllElementsAreEqual(pipes)) {
            Optional<DryPipe> opt = pipes.stream().filter(Objects::nonNull).findFirst();
            if (opt.isPresent()) {
                this.setSelectedItem(opt.get());
            } else {
                this.setSelectedItem(NONE_ENTRY);
            }
        } else {
            this.setSelectedItem(null);
        }
    }
}

