/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.HeatTransfer3D;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.LeakUtil;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.geom.Geometry;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TagEditor;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.VariantEditor;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.appearance.MaterialBtn;
import pyrosim.gui.boundcond.SurfacePanelEditCompDlg;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.comboboxes.ZoneComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.DefaultTableClipboard;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SurfacePanel
extends guiPanel
implements IEditor<Surface> {
    private static final long serialVersionUID = -5319937567981882745L;
    private final guiTextField d_surfID;
    private final guiTextField d_fyi;
    private final TagEditor d_tags;
    private final ColorButton d_color;
    private final MaterialBtn d_appearance;
    private final guiComboBox<String> d_profileListBox;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final SurfacePanel d_surfPanel;
    private final BurnerPanel d_burnerPanel;
    private final SpecInjPanel d_specInjPanel;
    private final PartInjPanel d_partInjPanel;
    private final ThermalPanel d_thermalPanel;
    private final GeomPanel d_geomPanel;
    private final GeomPanelLayered d_GeomPanelLayered;
    private final AirFlowPanel d_airFlowPanel;
    private final ReactionPanel d_reactionPanel;
    private final LayersPanel d_layersPanel;
    private final LayersPropPanel d_layerPropPanel;
    private final ItemListener d_surfTypeItemListener;
    private final LeakPanel d_leakPanel;
    private final CustomFDSPanel d_advancedPanel;
    private final guiPanel d_inertDescPanel;
    private final guiPanel d_mirroredDescPanel;
    private final guiPanel d_hvacDescPanel;
    private final guiPanel d_openDescPanel;
    private final guiPanel d_adiabaticDescPanel;
    private final guiPanel d_periodicDescPanel;
    private final guiPanel d_periodicFlowOnlyDescPanel;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final ChangeListener d_layeredGeomListener;
    private final SurfaceManager d_surfMgr;
    private final MaterialManager d_matMgr;
    private Surface d_currentSurf;
    private ExSpecList d_exSpecList;
    public static final String INERT = Intl.intl("Inert");
    public static final String BASIC = Intl.intl("Basic");
    public static final String ADIABATIC = Intl.intl("Adiabatic");
    public static final String MIRROR = Intl.intl("Mirror");
    public static final String OPEN = Intl.intl("Open");
    public static final String HVAC = Intl.intl("HVAC");
    public static final String PERIODIC = Intl.intl("Periodic");
    public static final String PERIODIC_FLOW_ONLY = Intl.intl("Periodic Flow Only");
    public static final String BURNER = Intl.intl("Burner");
    public static final String CONSTANT_TEMP = Intl.intl("Heater / Cooler");
    public static final String GENERAL = Intl.intl("General Surface");
    public static final String LAYERED = Intl.intl("Layered");
    public static final String SUPPLY = Intl.intl("Supply");
    public static final String EXHAUST = Intl.intl("Exhaust");
    public static final String AIR_FLOW = Intl.intl("Air Flow");
    public static final String AIR_DUCT = Intl.intl("Air Duct");
    public static final String LEAK = Intl.intl("Air Leak");
    public static final String SPECIES_INJECTION = Intl.intl("Species Injection");
    public static final String FUEL_COMPOSITION = Intl.intl("Fuel Composition");
    public static final String PARTICLE_INJECTION = Intl.intl("Particle Injection");
    public static final String HEAT_RELEASE = Intl.intl("Heat Release");
    public static final String GEOMETRY = Intl.intl("Geometry");
    public static final String TEMPERATURE = Intl.intl("Temperature");
    public static final String THERMAL = Intl.intl("Thermal");
    public static final String ADVANCED = Intl.intl("Advanced");
    public static final String LAYERS = Intl.intl("Material Layers");
    public static final String CALC_TEMP_OPT = Intl.intl("Temperature Calculated");
    public static final String ADIABATIC_OPT = Intl.intl("Adiabatic");
    public static final String FIXED_TEMP_OPT = Intl.intl("Fixed Temperature");
    public static final String NETFLUX_OPT = Intl.intl("Net Heat Flux");
    public static final String TOTALFLUX_OPT = Intl.intl("Total Heat Flux");

    public SurfacePanel(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_surfMgr = pyMod.getSurfaceMgr();
        this.d_matMgr = pyMod.getMaterialMgr();
        this.d_exSpecList = pyMod.getExSpecList();
        this.d_surfPanel = this;
        this.setLayout(new GridBagLayout());
        this.d_parent = parent;
        guiLabel labSurfID = new guiLabel(Intl.intl("Surface ID:"));
        labSurfID.setToolTipText("ID");
        this.d_surfID = new guiTextField();
        this.d_surfID.setEditable(false);
        guiLabel labFYI = new guiLabel(Intl.intl("Description:"));
        labFYI.setToolTipText("FYI");
        this.d_fyi = new guiTextField();
        guiLabel labTag = new guiLabel(Intl.intl("Tags:"));
        this.d_tags = new TagEditor();
        guiLabel labColor = new guiLabel(Intl.intl("Color:"));
        String colortt = "<html>" + Intl.intl("Specifies the color of objects using this surface in the absense<br>of an appearance and object color.") + "</html>";
        labColor.setToolTipText(colortt);
        this.d_color = new ColorButton();
        this.d_color.setMinimumSize(this.d_color.getPreferredSize());
        this.d_color.addObserver(this.d_comm);
        guiLabel labAppearance = new guiLabel(Intl.intl("Appearance:"));
        String apptt = "<html>" + Intl.intl("Controls how objects using this surface appear in the 3D and 2D<br>views when appearances are enabled.") + "</html>";
        labAppearance.setToolTipText(apptt);
        this.d_appearance = new MaterialBtn(true);
        this.d_appearance.setMinimumSize(this.d_appearance.getPreferredSize());
        this.d_appearance.addObserver((source, arg) -> this.d_comm.touch(arg), false);
        this.d_burnerPanel = new BurnerPanel();
        this.d_specInjPanel = new SpecInjPanel();
        this.d_partInjPanel = new PartInjPanel();
        this.d_airFlowPanel = new AirFlowPanel();
        this.d_reactionPanel = new ReactionPanel();
        this.d_layersPanel = new LayersPanel(pyMod);
        this.d_layerPropPanel = new LayersPropPanel();
        this.d_leakPanel = new LeakPanel();
        this.d_thermalPanel = new ThermalPanel();
        this.d_geomPanel = new GeomPanel();
        this.d_GeomPanelLayered = new GeomPanelLayered();
        this.d_advancedPanel = new CustomFDSPanel(7);
        this.d_inertDescPanel = new guiPanel();
        GridBagHelper gbh = new GridBagHelper(this.d_inertDescPanel, true);
        MultiLineLabel lbl = new MultiLineLabel(Intl.intl("The default FDS boundary condition representing a smooth wall with fixed temperature, TMPA, and emissivity, 0.9. Radiative and convective heat transfer is calculated."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_openDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_openDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("An FDS surface representing an opening on the boundary of the computational domain."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_mirroredDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_mirroredDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("An FDS surface used to denote a symmetry plane across which the flow is exactly opposite on the other side."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_hvacDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_hvacDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("An FDS surface used to denote vents that connect an HVAC system to the computational mesh."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_adiabaticDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_adiabaticDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("A surface where there is no net heat transfer. FDS internally calculates the wall temperature to assure the sum of the radiative and convective heat flux is zero."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_periodicDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_periodicDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("An FDS surface which can be used with vents on the boundary of the domain to define a periodic boundary condition."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        this.d_periodicFlowOnlyDescPanel = new guiPanel();
        gbh = new GridBagHelper(this.d_periodicFlowOnlyDescPanel, true);
        lbl = new MultiLineLabel(Intl.intl("An FDS surface which can be used with vents to enable wind."));
        lbl.setFont(lbl.getFont().deriveFont(2));
        lbl.setPreferredWidth(400);
        gbh.addRow(lbl);
        gbh.finalizeRows();
        int r = 0;
        GridBagUtil.add(this, labSurfID, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_surfID, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labFYI, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_fyi, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labTag, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_tags.getEditor(), 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labColor, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_color, 1, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0);
        GridBagUtil.add(this, labAppearance, 2, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_appearance, 3, r++, 1, 1, 0, 0, 6, 12, 0, 1.0, 0.0);
        this.d_layeredGeomListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SurfacePanel.this.d_tabs.getSelectedIndex() == -1) {
                    return;
                }
                if (SurfacePanel.this.d_tabs.getTitleAt(SurfacePanel.this.d_tabs.getSelectedIndex()).equals(GEOMETRY)) {
                    SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                }
            }
        };
        this.d_surfTypeItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String choice = e.getItem().toString();
                SurfacePanel.this.d_tabs.removeAll();
                SurfacePanel.this.d_tabs.removeChangeListener(SurfacePanel.this.d_layeredGeomListener);
                SurfacePanel.this.setModified(true);
                if (LAYERED.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(LAYERS, SurfacePanel.this.d_layersPanel);
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Surface Props"), SurfacePanel.this.d_layerPropPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_GeomPanelLayered);
                    SurfacePanel.this.d_tabs.addChangeListener(SurfacePanel.this.d_layeredGeomListener);
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Reaction"), SurfacePanel.this.d_reactionPanel);
                    SurfacePanel.this.d_reactionPanel.allowBurnAway(true);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(true, true);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof LayeredSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (EXHAUST.equals(choice)) {
                    SurfacePanel.this.d_tabs.add(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_airFlowPanel.enableExSpecMassFlux(false);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(choice);
                    SurfacePanel.this.d_tabs.add(THERMAL, SurfacePanel.this.d_thermalPanel);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof InFlowSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (SUPPLY.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_airFlowPanel.updateBlower();
                    SurfacePanel.this.d_airFlowPanel.enableExSpecMassFlux(true);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(choice);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof BlowerSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (CONSTANT_TEMP.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof ConstantTempSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (GENERAL.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_airFlowPanel.updateBlower();
                    SurfacePanel.this.d_tabs.addTab(HEAT_RELEASE, SurfacePanel.this.d_burnerPanel);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(choice);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof GeneralSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (BURNER.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(HEAT_RELEASE, SurfacePanel.this.d_burnerPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(FUEL_COMPOSITION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(false, true);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof BurnerSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (LEAK.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(LEAK, SurfacePanel.this.d_leakPanel);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof LeakSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (INERT.equals(choice) || BASIC.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_inertDescPanel);
                } else if (OPEN.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_openDescPanel);
                } else if (HVAC.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_hvacDescPanel);
                } else if (MIRROR.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_mirroredDescPanel);
                } else if (ADIABATIC.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_adiabaticDescPanel);
                } else if (PERIODIC.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_periodicDescPanel);
                } else if (PERIODIC_FLOW_ONLY.equals(choice)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_periodicFlowOnlyDescPanel);
                } else {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.getEmptyPanel());
                }
                SurfacePanel.this.d_tabs.addTab(Intl.intl("Advanced"), SurfacePanel.this.d_advancedPanel);
                SurfacePanel.this.d_thermalPanel.setSurfDesc(choice);
            }
        };
        this.d_profileListBox = new guiComboBox<Object>((T[])new Object[]{BASIC, BURNER, GENERAL, CONSTANT_TEMP, SUPPLY, EXHAUST, LAYERED, LEAK});
        this.d_profileListBox.addItemListener(this.d_surfTypeItemListener);
        guiLabel surfTypeLab = new guiLabel(Intl.intl("Surface Type") + ":");
        GridBagUtil.add(this, surfTypeLab, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_profileListBox, 1, r++, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.add((Component)this.getEmptyPanel(), Intl.intl("Properties"));
        this.d_tabs.setMinimumSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_burnerPanel, this.d_specInjPanel, this.d_partInjPanel, this.d_airFlowPanel, this.d_reactionPanel, this.d_layersPanel, this.d_layerPropPanel, this.d_leakPanel, this.d_thermalPanel));
        GridBagUtil.add(this, this.d_tabs, 0, r++, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(Surface surf) {
        this.setEnabled(surf != null);
        this.d_tabs.setEnabled(surf != null);
        if (surf != null) {
            this.loadSurface(surf);
            this.d_surfID.setText(surf.getName());
            this.d_fyi.setText(surf.getFYI());
            this.d_tags.initTags(surf);
            this.d_color.setColor(surf.getColor());
            this.d_appearance.setMaterial(surf.getAppearance());
            boolean readOnly = surf.isPredefined();
            if (readOnly) {
                this.setEnabled(false);
            }
        }
        this.setModified(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public Surface preview(Surface surf) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveSurface(null, surf);
        return surf;
    }

    @Override
    public Surface commit(Surface dest) {
        assert (!dest.isPredefined());
        Surface tmp = dest.clone();
        PyroMod domain = PyroSim.getApp().getMediator();
        this.saveSurface(domain, tmp);
        CompositeTask<PyroMod> editTask = new CompositeTask<PyroMod>(domain);
        editTask.addTask(dest.taskImprint(tmp));
        editTask.addTask(this.d_tags.getUpdateTagsTask(domain, dest));
        domain.getTaskManager().exec(editTask, Intl.intl("Edit Surface"));
        this.setModified(false);
        return dest;
    }

    public void saveSurface(PyroMod domain, Surface surf) {
        surf.setFYI(this.d_fyi.getText());
        surf.setColor(this.d_color.getColor());
        surf.setAppearance((pyrosim.domain.appearance.Material)this.d_appearance.getMaterial());
        String choice = this.d_profileListBox.getSelectedItem();
        if (choice == INERT) {
            surf.setSurfDesc(new SurfDescStatic.Inert());
        } else if (choice == BASIC) {
            surf.setSurfDesc(Surface.newBasicDesc());
        } else if (choice == EXHAUST) {
            surf.setSurfDesc(new InFlowSurfDesc(this.d_airFlowPanel.saveData(domain), this.d_thermalPanel.saveData()));
        } else if (choice == LAYERED) {
            Pair<List<SurfComposition.SurfLayer>, Double> layerData = this.d_layersPanel.layerData();
            SurfComposition sc = new SurfComposition(this.d_layerPropPanel.tempRampInternal(), this.d_layerPropPanel.backing(), (Double)layerData.v2, (List)layerData.v1);
            surf.setSurfDesc(new LayeredSurfDesc(this.d_GeomPanelLayered.saveData(), this.d_reactionPanel.saveData(), sc, this.d_specInjPanel.saveData(), this.d_partInjPanel.saveData(), this.d_reactionPanel.burnAway(), this.d_layerPropPanel.leakPath(), this.d_thermalPanel.saveData(), this.d_layersPanel.ht3d()));
        } else if (choice == LEAK) {
            surf.setSurfDesc(this.d_leakPanel.save());
        } else if (choice == SUPPLY) {
            surf.setSurfDesc(new BlowerSurfDesc(this.d_thermalPanel.saveData(), this.d_airFlowPanel.saveData(domain), this.d_partInjPanel.saveData(), this.d_geomPanel.saveData()));
        } else if (choice == CONSTANT_TEMP) {
            surf.setSurfDesc(new ConstantTempSurfDesc(this.d_thermalPanel.saveData(), this.d_partInjPanel.saveData(), this.d_geomPanel.saveData()));
        } else if (choice == GENERAL) {
            surf.setSurfDesc(new GeneralSurfDesc(this.d_thermalPanel.saveData(), this.d_partInjPanel.saveData(), this.d_specInjPanel.saveData(), this.d_burnerPanel.getHeatRelease(), this.d_airFlowPanel.saveData(domain), this.d_geomPanel.saveData()));
        } else if (choice == BURNER) {
            surf.setSurfDesc(new BurnerSurfDesc(this.d_burnerPanel.getHeatRelease(), this.d_partInjPanel.saveData(), this.d_specInjPanel.saveData(), this.d_thermalPanel.saveData(), this.d_geomPanel.saveData()));
        }
        this.d_advancedPanel.save(Collections.singleton(surf));
    }

    private void loadSurface(Surface surf) {
        guiPanel selectedPanel = (guiPanel)this.d_tabs.getSelectedComponent();
        this.d_tabs.removeAll();
        this.d_currentSurf = surf;
        this.clearPanels();
        ISurfDesc surfDesc = surf.getSurfDesc();
        this.d_profileListBox.setItems((String[])new String[]{BASIC, BURNER, GENERAL, CONSTANT_TEMP, SUPPLY, EXHAUST, LAYERED, LEAK});
        if (surfDesc instanceof SurfDescStatic) {
            guiPanel panel = this.getEmptyPanel();
            if (surfDesc instanceof SurfDescStatic.Adiabatic) {
                panel = this.d_adiabaticDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(ADIABATIC);
            } else if (surfDesc instanceof SurfDescStatic.Hvac) {
                panel = this.d_hvacDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(HVAC);
            } else if (surfDesc instanceof SurfDescStatic.Mirror) {
                panel = this.d_mirroredDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(MIRROR);
            } else if (surfDesc instanceof SurfDescStatic.Open) {
                panel = this.d_openDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(OPEN);
            } else if (surfDesc instanceof SurfDescStatic.Periodic) {
                panel = this.d_periodicDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(PERIODIC);
            } else if (surfDesc instanceof SurfDescStatic.PeriodicFlowOnly) {
                panel = this.d_periodicFlowOnlyDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                this.d_profileListBox.setSelectedItem(PERIODIC_FLOW_ONLY);
            } else {
                panel = this.d_inertDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), panel);
                if (surf.getName().equals("INERT")) {
                    this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC, PERIODIC_FLOW_ONLY});
                    this.d_profileListBox.setSelectedItem(INERT);
                }
                this.d_profileListBox.setSelectedItem(BASIC);
            }
        } else if (surfDesc instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)surfDesc;
            this.d_tabs.addTab(LAYERS, this.d_layersPanel);
            this.d_layersPanel.loadData(desc);
            this.d_layerPropPanel.loadData(desc);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(Intl.intl("Reaction"), this.d_reactionPanel);
            this.d_reactionPanel.loadData(desc.d_iReac, desc.d_burnAway);
            this.d_reactionPanel.allowBurnAway(true);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_GeomPanelLayered.loadData(desc.d_geometry);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_specInjPanel.loadData(desc.d_specInj);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_partInjPanel.loadData(desc.d_partInj);
            this.d_profileListBox.setSelectedItem(LAYERED);
            this.d_thermalPanel.loadData(desc.d_temperature);
        } else if (surfDesc instanceof LeakSurfDesc) {
            this.d_tabs.addTab(LEAK, this.d_leakPanel);
            this.d_leakPanel.loadData((LeakSurfDesc)surfDesc);
            this.d_profileListBox.setSelectedItem(LEAK);
        } else if (surfDesc instanceof InFlowSurfDesc) {
            this.d_tabs.add(AIR_FLOW, this.d_airFlowPanel);
            this.d_airFlowPanel.loadData(((InFlowSurfDesc)surf.getSurfDesc()).d_airFlow, true);
            this.d_tabs.add(THERMAL, this.d_thermalPanel);
            this.d_profileListBox.setSelectedItem(EXHAUST);
            this.d_thermalPanel.loadData(((InFlowSurfDesc)surf.getSurfDesc()).d_temperature);
        } else if (surfDesc instanceof BlowerSurfDesc) {
            this.d_tabs.addTab(AIR_FLOW, this.d_airFlowPanel);
            BlowerSurfDesc desc = (BlowerSurfDesc)surfDesc;
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_partInjPanel.loadData(desc.d_partInj);
            this.d_airFlowPanel.loadData(desc.d_airFlow, true);
            this.d_profileListBox.setSelectedItem(SUPPLY);
            this.d_thermalPanel.loadData(desc.d_tempReg);
            this.d_geomPanel.loadData(desc.d_geometry);
        } else if (surfDesc instanceof BurnerSurfDesc) {
            this.d_tabs.addTab(HEAT_RELEASE, this.d_burnerPanel);
            BurnerSurfDesc burnerSurf = (BurnerSurfDesc)surf.getSurfDesc();
            this.d_burnerPanel.loadData(burnerSurf.d_heatRelease);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(FUEL_COMPOSITION, this.d_specInjPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_partInjPanel.loadData(burnerSurf.d_partInj);
            this.d_specInjPanel.loadData(burnerSurf.d_fuelComps);
            this.d_profileListBox.setSelectedItem(BURNER);
            this.d_thermalPanel.loadData(burnerSurf.d_temperature);
            this.d_geomPanel.loadData(burnerSurf.d_geometry);
        } else if (surfDesc instanceof GeneralSurfDesc) {
            this.d_tabs.addTab(AIR_FLOW, this.d_airFlowPanel);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_tabs.addTab(HEAT_RELEASE, this.d_burnerPanel);
            this.d_airFlowPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_airflow, false);
            this.d_geomPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_geometry);
            this.d_specInjPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_specInj);
            this.d_partInjPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_partInj);
            this.d_burnerPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_heatRelease);
            this.d_profileListBox.setSelectedItem(GENERAL);
            this.d_thermalPanel.loadData(((GeneralSurfDesc)surf.getSurfDesc()).d_tempReg);
        } else if (surfDesc instanceof ConstantTempSurfDesc) {
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_partInjPanel.loadData(((ConstantTempSurfDesc)surf.getSurfDesc()).d_partInj);
            this.d_geomPanel.loadData(((ConstantTempSurfDesc)surf.getSurfDesc()).d_geometry);
            this.d_profileListBox.setSelectedItem(CONSTANT_TEMP);
            this.d_thermalPanel.loadData(((ConstantTempSurfDesc)surf.getSurfDesc()).d_tempReg);
        } else {
            this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
            this.d_profileListBox.setSelectedIndex(0);
        }
        this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
        this.d_advancedPanel.clear();
        this.d_advancedPanel.load(Collections.singleton(surf), new CustomFDSPanel.AdvPropWrapper<Boolean>(surf.isForceWrite(), 1));
        try {
            this.d_tabs.setSelectedComponent(selectedPanel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.d_profileListBox.revalidate();
    }

    private void clearPanels() {
        this.d_airFlowPanel.loadData(null, true);
        this.d_specInjPanel.loadData(null);
        this.d_partInjPanel.loadData(null);
        this.d_reactionPanel.loadData(null, false);
        this.d_layerPropPanel.loadData(null);
        this.d_layersPanel.loadData(null);
        this.d_burnerPanel.loadData(null);
        this.d_leakPanel.loadData(null);
        this.d_geomPanel.loadData(null);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private guiPanel getEmptyPanel() {
        guiPanel panel = new guiPanel();
        return panel;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_partInjPanel) > -1 && this.d_partInjPanel.d_emitPartCB.isSelected() && this.d_partInjPanel.d_particleCombo.getSelectedItem() == null) {
            if (allowModify) {
                this.d_tabs.setSelectedComponent(this.d_partInjPanel);
            }
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("A Particle Type must be chosen if Emit Particles is selected."));
            }
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_specInjPanel) > -1 && !this.d_specInjPanel.isMassFracOK()) {
            if (allowModify) {
                this.d_tabs.setSelectedComponent(this.d_specInjPanel);
            }
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("The values for mass fraction must add up to 1 or less."));
            }
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_specInjPanel) > -1 && !this.d_specInjPanel.isRampTableSet()) {
            if (allowModify) {
                this.d_tabs.setSelectedComponent(this.d_specInjPanel);
            }
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Included species cannot have empty ramp value tables."));
            }
            return false;
        }
        return true;
    }

    private TimeFunctionEditor newTimeFuncEditor() {
        return this.newTimeFuncEditor(Intl.intl("Ramp-Up Time"));
    }

    private TimeFunctionEditor newTimeFuncEditor(String title) {
        int options = 29;
        return new TimeFunctionEditor(title, options);
    }

    private class BurnerPanel
    extends guiPanel {
        private static final long serialVersionUID = 1193142382148046525L;
        private final HRPanel d_hrPanel;

        public BurnerPanel() {
            this.setLayout(new GridBagLayout());
            this.d_hrPanel = new HRPanel(Intl.intl("Heat Release"));
            GridBagUtil.add(this, this.d_hrPanel, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public HeatRelease getHeatRelease() {
            return this.d_hrPanel.saveData();
        }

        public void loadData(HeatRelease hr) {
            this.d_hrPanel.loadData(hr);
        }
    }

    private class SpecInjPanel
    extends guiPanel {
        private static final long serialVersionUID = 8326897486652703918L;
        private final guiTableEditor d_editor;
        private final guiTable d_table;
        private final guiRadioButton d_massFracRB;
        private final guiRadioButton d_massFluxRB;
        private final String DEFAULT = TimeFunctionEditor.STR_DEFAULT;
        private final String TANH = TimeFunctionEditor.STR_TANH;
        private final String TSQUARED = TimeFunctionEditor.STR_TSQUARED;
        private final String CUSTOM = TimeFunctionEditor.STR_CUSTOM;
        private final String MASSFRAC = Intl.intl("Mass Fraction");
        private final String MASSFLUX = Intl.intl("Mass Flux");
        private Map<ExSpec, Integer> d_esMap;
        private ExSpec[] d_availExSpec;

        public SpecInjPanel() {
            this.setLayout(new GridBagLayout());
            this.d_esMap = null;
            this.d_availExSpec = null;
            this.d_massFracRB = new guiRadioButton(String.format(Intl.intl("Inject by Mass Fraction (%1$s)"), SurfacePanel.this.d_currentUS.getMassFractionUnit().toString()));
            this.d_massFluxRB = new guiRadioButton(String.format(Intl.intl("Inject by Mass Flux (%1$s)"), SurfacePanel.this.d_currentUS.getMLRPUA().toString()));
            this.d_massFracRB.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_massFluxRB);
            group.add(this.d_massFracRB);
            ItemListener rbListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (SpecInjPanel.this.d_massFracRB.isSelected()) {
                        SpecInjPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(SpecInjPanel.this.MASSFRAC + " (" + SurfacePanel.this.d_currentUS.getMassFractionUnit().toString() + ")");
                    } else {
                        SpecInjPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(SpecInjPanel.this.MASSFLUX + " (" + SurfacePanel.this.d_currentUS.getMLRPUA().toString() + ")");
                    }
                    SpecInjPanel.this.d_table.forceColumnUpdate();
                }
            };
            this.d_massFluxRB.addItemListener(rbListener);
            this.d_massFracRB.addItemListener(rbListener);
            final guiTable.UnitDoubleEditor udEditor = new guiTable.UnitDoubleEditor(UnitSystem.getSource(2).getUnit(), UnitDoubleVR.above(0.0, SI.SECOND, true), false);
            final guiTable.UnitDoubleRenderer udRenderer = new guiTable.UnitDoubleRenderer();
            final RampTableCell rampCell = new RampTableCell(this);
            this.d_table = new guiTable(new SpecInjTable(), 0){
                private static final long serialVersionUID = 4751308018369244416L;

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    if (column == 3) {
                        if (this.isRampType(row, column)) {
                            return rampCell;
                        }
                        return udRenderer;
                    }
                    return super.getCellRenderer(row, column);
                }

                @Override
                public TableCellEditor getCellEditor(int row, int column) {
                    if (column == 3) {
                        if (this.isRampType(row, column)) {
                            return rampCell;
                        }
                        return udEditor;
                    }
                    return super.getCellEditor(row, column);
                }

                private boolean isRampType(int row, int column) {
                    Object val = this.getValueAt(row, column);
                    if (val instanceof Ramp) {
                        return true;
                    }
                    return val == null && SpecInjPanel.this.CUSTOM.equals(this.getValueAt(row, 2));
                }
            };
            this.d_table.getColumnModel().getColumn(0).setCellRenderer(new ExSpecRenderer());
            this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.guiDoubleEditor());
            this.d_table.getColumnModel().getColumn(1).setCellRenderer(new guiTable.guiDoubleRenderer());
            this.d_table.setColumnOptions(2, this.DEFAULT, this.TANH, this.TSQUARED, this.CUSTOM);
            this.d_table.setClipboard(3, (guiTableClipboard)new RampUpValueClipboard(this));
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(120);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(2).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(3).setPreferredWidth(100);
            this.d_table.getModel().addTableModelListener(e -> {
                if (e.getColumn() != 2 && e.getColumn() != 3) {
                    return;
                }
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    String currType = (String)this.d_table.getValueAt(row, 2);
                    Object currVal = this.d_table.getValueAt(row, 3);
                    if (e.getColumn() == 2) {
                        Object newVal = currVal;
                        if (currType == this.CUSTOM && !(currVal instanceof Ramp)) {
                            newVal = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
                        } else if (currType == this.DEFAULT) {
                            newVal = TimeFunction.newDefault().val;
                        } else if (currType != null && currType != this.CUSTOM && !(currVal instanceof UnitDouble)) {
                            newVal = SIUS.newud(1.0, 2);
                        }
                        if (Objects.equals(newVal, currVal)) continue;
                        this.d_table.setValueAt(newVal, row, 3);
                        continue;
                    }
                    if (e.getColumn() != 3) continue;
                    String newType = currType;
                    if (currVal instanceof Ramp) {
                        newType = this.CUSTOM;
                    } else if (currVal instanceof UnitDouble && this.CUSTOM.equals(currType)) {
                        newType = this.TANH;
                    }
                    if (Objects.equals(newType, currType)) continue;
                    this.d_table.setValueAt(newType, row, 2);
                }
            });
            this.d_editor = new guiTableEditor(this.d_table, 0);
            this.d_table.autoSizeColumns(100);
            GridBagUtil.add(this, this.d_massFracRB, 0, 0, 2, 1, 12, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxRB, 0, 1, 2, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_editor, 0, 4, 10, 1, 12, 12, 12, 12, 1, 1.0, 1.0);
        }

        public void setInjectionOptions(boolean massFlux, boolean massFraction) {
            assert (massFlux || massFraction);
            this.d_massFluxRB.setEnabled(massFlux);
            this.d_massFracRB.setEnabled(massFraction);
            boolean vis = true;
            if (massFlux && !massFraction) {
                this.d_massFluxRB.setSelected(true);
                vis = false;
            } else if (!massFlux && massFraction) {
                this.d_massFracRB.setSelected(true);
                vis = false;
            }
            this.d_massFluxRB.setVisible(vis);
            this.d_massFracRB.setVisible(vis);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            int m;
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (SurfacePanel.this.d_tabs.indexOfComponent(SurfacePanel.this.d_specInjPanel) > -1 && !this.isRampTableSet()) {
                if (allowModify) {
                    SurfacePanel.this.d_tabs.setSelectedComponent(SurfacePanel.this.d_specInjPanel);
                }
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Included species cannot have empty ramp value tables."));
                }
                return false;
            }
            for (m = 0; m < this.d_table.getRowCount(); ++m) {
                if (this.d_table.getValueAt(m, 1) != null && this.d_table.getValueAt(m, 2) != null && this.d_table.getValueAt(m, 3) != null) continue;
                this.d_table.flagInvalidCell(m, -1, showWarn, allowModify, Intl.intl("Empty cells are not allowed"));
                return false;
            }
            for (m = 0; m < this.d_table.getRowCount(); ++m) {
                Double d = (Double)this.d_table.getValueAt(m, 1);
                if (d == null || !(d < 0.0)) continue;
                if (allowModify) {
                    SurfacePanel.this.d_surfPanel.d_tabs.setSelectedComponent(SurfacePanel.this.d_surfPanel.d_specInjPanel);
                    this.d_table.setRowSelectionInterval(m, m);
                    this.d_table.setColumnSelectionInterval(1, 1);
                }
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(SurfacePanel.this.d_surfPanel, Intl.intl("The value must be positive."));
                }
                return false;
            }
            return true;
        }

        public void loadData(SpecInjList sil) {
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_massFracRB.setSelected(true);
            List<ExSpec> sortedSpecs = Util.sort(SurfacePanel.this.d_exSpecList);
            this.d_availExSpec = sortedSpecs.toArray(new ExSpec[sortedSpecs.size()]);
            this.d_esMap = new IdentityHashMap<ExSpec, Integer>();
            int es = 0;
            for (ExSpec e : this.d_availExSpec) {
                this.d_table.setValueAt(e, es, 0);
                this.d_table.setValueAt(0.0, es, 1);
                this.d_table.setValueAt(this.DEFAULT, es, 2);
                this.d_table.setValueAt(TimeFunction.newDefault().val, es, 3);
                this.d_esMap.put(e, es++);
            }
            Unit massFracUnit = SurfacePanel.this.d_currentUS.getMassFractionUnit();
            Unit massFluxUnit = SurfacePanel.this.d_currentUS.getUnit(45);
            if (sil == null || sil.getInjections() == null) {
                return;
            }
            if (sil.injType == 1) {
                this.d_table.getColumnModel().getColumn(1).setHeaderValue(this.MASSFRAC + " (" + String.valueOf(massFracUnit) + ")");
                this.d_massFracRB.setSelected(true);
            } else {
                this.d_massFluxRB.setSelected(true);
                this.d_table.getColumnModel().getColumn(1).setHeaderValue(this.MASSFLUX + " (" + String.valueOf(massFluxUnit) + ")");
            }
            for (SpeciesInjection si : sil.getInjections()) {
                int row = this.d_esMap.get(si.species);
                double dval = si.val instanceof UnitDouble ? ((UnitDouble)si.val).getValue(massFluxUnit) : ((Double)si.val).doubleValue();
                this.d_table.setValueAt(dval, row, 1);
                TimeFunction func = si.func;
                String type = null;
                Object val = func.val;
                if (TimeFunction.newDefault().equals(func)) {
                    type = this.DEFAULT;
                    val = TimeFunction.newDefault().val;
                } else if (func instanceof TimeFunction.Custom) {
                    type = this.CUSTOM;
                } else if (func instanceof TimeFunction.TanH) {
                    type = this.TANH;
                } else if (func instanceof TimeFunction.TSquared) {
                    type = this.TSQUARED;
                }
                this.d_table.setValueAt(type, row, 2);
                this.d_table.setValueAt(val, row, 3);
            }
        }

        public SpecInjList saveData() {
            ArrayList<SpeciesInjection> list = new ArrayList<SpeciesInjection>(this.d_table.getRowCount());
            int type = 0;
            if (this.d_massFracRB.isSelected()) {
                type = 1;
            }
            Unit massFluxUnit = SurfacePanel.this.d_currentUS.getUnit(45);
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                TimeFunction func;
                double dval = (Double)this.d_table.getValueAt(i, 1);
                Object val = this.d_table.getValueAt(i, 3);
                if (val instanceof Ramp) {
                    func = new TimeFunction.Custom((Ramp)val);
                } else {
                    if (!(val instanceof UnitDouble)) continue;
                    Object stype = this.d_table.getValueAt(i, 2);
                    func = this.TSQUARED.equals(stype) ? new TimeFunction.TSquared((UnitDouble)val) : (this.TANH.equals(stype) ? new TimeFunction.TanH((UnitDouble)val) : TimeFunction.newDefault());
                }
                if (dval == 0.0 && ((TimeFunction)func).equals(TimeFunction.newDefault())) continue;
                ExSpec species = (ExSpec)this.d_table.getValueAt(i, 0);
                Comparable<UnitDouble> ival = type == 0 ? new UnitDouble(dval, massFluxUnit) : Double.valueOf(dval);
                list.add(new SpeciesInjection(species, ival, func));
            }
            if (list.isEmpty()) {
                return null;
            }
            return new SpecInjList(type, list);
        }

        public boolean isRampTableSet() {
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                Object obj = this.d_table.getValueAt(i, 3);
                if ((!(obj instanceof Ramp) || !((Ramp)obj).getRecords().isEmpty()) && (!this.CUSTOM.equals(this.d_table.getValueAt(i, 2)) || obj != null)) continue;
                return false;
            }
            return true;
        }

        public boolean isMassFracOK() {
            if (this.d_massFracRB.isSelected()) {
                double sum = 0.0;
                for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                    sum += ((Double)this.d_table.getValueAt(i, 1)).doubleValue();
                }
                if (sum < 1.0E-8) {
                    return true;
                }
                if (sum > 1.00000001) {
                    return false;
                }
            }
            return true;
        }

        private String renderUD(JTable table, int row, int col, UnitDouble value, Unit u) {
            if (value != null) {
                return "" + value.getValue(u);
            }
            return "";
        }

        private UnitDouble parseUD(String text, Unit u) {
            try {
                double value = Global.parseDouble(text);
                return new UnitDouble(value, u);
            }
            catch (ParseException e) {
                return null;
            }
        }

        private UnitDouble getUDVal(TimeFunction value) {
            UnitDouble udVal = null;
            if (value instanceof TimeFunction.TanH) {
                udVal = (UnitDouble)((TimeFunction.TanH)value).val;
            } else if (value instanceof TimeFunction.TSquared) {
                udVal = (UnitDouble)((TimeFunction.TSquared)value).val;
            }
            return udVal;
        }

        private TimeFunction getDefaultValue(String type) {
            if (type.equals(this.CUSTOM)) {
                return new TimeFunction.Custom(new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28));
            }
            if (type.equals(this.TSQUARED)) {
                return new TimeFunction.TSquared();
            }
            if (type.equals(this.TANH)) {
                return new TimeFunction.TanH();
            }
            return TimeFunction.newDefault();
        }

        private class RampTableCell
        extends DefaultCellEditor
        implements TableCellEditor,
        TableCellRenderer {
            private static final long serialVersionUID = -8038458482938900162L;
            private final TimeFunctionEditor.RampAction d_rampAction;
            private final JButton d_editButton;
            private final DefaultTableCellRenderer d_defRend;
            private final JButton d_renderButton;

            public RampTableCell(Modifiable parent) {
                super(new JTextField());
                this.d_editButton = new JButton(Intl.intl("Edit Values..."));
                this.d_defRend = new DefaultTableCellRenderer();
                this.d_renderButton = new JButton(Intl.intl("Edit Values..."));
                this.d_rampAction = new TimeFunctionEditor.RampAction(parent){

                    @Override
                    protected void rampEdited(boolean committed) {
                        super.rampEdited(committed);
                        if (committed) {
                            RampTableCell.this.stopCellEditing();
                        } else {
                            RampTableCell.this.cancelCellEditing();
                        }
                    }
                };
                this.d_editButton.addActionListener(this.d_rampAction);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component defComp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                Ramp ramp = (Ramp)value;
                if (ramp == null) {
                    ramp = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
                }
                this.d_rampAction.setRamp(ramp);
                this.d_editButton.setBackground(defComp.getBackground());
                return this.d_editButton;
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_rampAction.getRamp();
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component defComp = this.d_defRend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.d_renderButton.setBackground(defComp.getBackground());
                return this.d_renderButton;
            }
        }

        private class SpecInjTable
        extends guiDefaultTableModel {
            private static final long serialVersionUID = -6046344371348853951L;

            private SpecInjTable() {
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return Intl.intl("Species");
                    }
                    case 1: {
                        if (SpecInjPanel.this.d_massFluxRB.isSelected()) {
                            return SpecInjPanel.this.MASSFLUX + " (" + SurfacePanel.this.d_currentUS.getMLRPUA().toString() + ")";
                        }
                        return SpecInjPanel.this.MASSFRAC + " (" + String.valueOf(SurfacePanel.this.d_currentUS.getMassFractionUnit()) + ")";
                    }
                    case 2: {
                        return Intl.intl("Ramp-Up Type");
                    }
                    case 3: {
                        return Intl.intl("Ramp Value");
                    }
                }
                return null;
            }

            @Override
            public Class getColumnClass(int c) {
                switch (c) {
                    case 0: {
                        return ExSpec.class;
                    }
                    case 1: {
                        return Double.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return Object.class;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                String selection;
                if (column == 0) {
                    return false;
                }
                return column != 3 || (selection = (String)SpecInjPanel.this.d_table.getValueAt(row, 2)) != null && !selection.equals(SpecInjPanel.this.DEFAULT) && !selection.equals("");
            }
        }

        private class ExSpecRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -9106653071693324395L;

            private ExSpecRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(((ExSpec)value).getName());
                return comp;
            }
        }

        private class RampUpValueClipboard
        extends DefaultTableClipboard {
            private RampUpValueClipboard(SpecInjPanel specInjPanel) {
            }

            @Override
            public boolean pasteObject(guiTable table, Object data, int pasteRow, int pasteCol) {
                if (data == null) {
                    return false;
                }
                if (data instanceof UnitDouble) {
                    return super.pasteObject(table, data, pasteRow, pasteCol);
                }
                if (!(data instanceof Ramp)) {
                    String strRep = data.toString();
                    try {
                        UnitDouble ud = Global.parseUnitDouble(strRep, UnitSystem.getSource(2).getUnit());
                        return super.pasteObject(table, ud, pasteRow, pasteCol);
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
                Ramp ramp = (Ramp)data;
                PyroMod domain = PyroSim.getApp().getMediator();
                DepSnapshot dsnapshot = new DepSnapshot(Collections.singleton(ramp));
                dsnapshot.takeSnapshot(ramp);
                ArrayList<IPyroObject> toPaste = new ArrayList<IPyroObject>();
                for (IPyroObject dep : dsnapshot.getAllDependedOn()) {
                    if (dep.getDomain() == domain) continue;
                    toPaste.add(dep);
                }
                Actions.UIPasteCallback pasteCallback = new Actions.UIPasteCallback(this, domain){

                    @Override
                    public Actions.PasteOverwrite getReplaceModelObject(IPyroObject modelObj, IPyroObject pasteObj) throws CancellationException {
                        return Actions.PasteOverwrite.KEEP_EXISTING;
                    }
                };
                Actions.PasteInfo pinfo = Actions.taskInsertObjects(domain, toPaste, pasteCallback, 2);
                for (Actions.PasteCommand cmd : pinfo.commands.values()) {
                    if (cmd.command == 1 && cmd.param instanceof IPyroObject) continue;
                    return false;
                }
                pinfo.task.run();
                for (IPyroObject pasteObj : toPaste) {
                    Actions.PasteCommand cmd = pinfo.commands.get(pasteObj);
                    IPyroObject replacement = (IPyroObject)cmd.param;
                    for (Dependency dependent : dsnapshot.getDependents(pasteObj)) {
                        if (dependent.source != ramp) continue;
                        ramp.taskReplaceDep(pasteObj, replacement).run();
                    }
                }
                return super.pasteObject(table, ramp, pasteRow, pasteCol);
            }
        }
    }

    private class PartInjPanel
    extends guiPanel {
        private static final long serialVersionUID = 1785549285173004487L;
        private guiCheckBox d_emitPartCB;
        private ValueField<Integer> d_nppc;
        private final ValueField<UnitDouble> d_dtInsert;
        private final guiLabel d_massFluxLab;
        private final ValueField<UnitDouble> d_massFlux;
        private final TimeFunctionEditor d_mfFuncEditor;
        private final ParticleComboBox d_particleCombo;

        public PartInjPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_emitPartCB = new guiCheckBox(Intl.intl("Emit Particles"));
            guiLabel partTypeLab = new guiLabel(Intl.intl("Particle Type") + ":");
            this.d_particleCombo = new ParticleComboBox(PyroSim.getApp().getMediator().getPartList(), null, null);
            JButton editParticles = new JButton(Intl.intl("Edit Particles") + "...");
            guiLabel nppcLab = new guiLabel(Intl.intl("Number of Particles Per Cell") + ":");
            this.d_nppc = ValueFields.intFld(1);
            guiLabel dtInsertLab = new guiLabel(Intl.intl("Insertion Interval:"));
            this.d_dtInsert = ValueFields.udFld(0.01, (Unit)SI.SECOND, UnitSystem.getSource(2));
            this.d_mfFuncEditor = SurfacePanel.this.newTimeFuncEditor();
            this.d_massFluxLab = new guiLabel(Intl.intl("Mass Flux") + ":");
            this.d_massFluxLab.setToolTipText("PARTICLE_MASS_FLUX");
            this.d_massFlux = ValueFields.udFld(UnitSystem.getSource(44));
            this.d_massFluxLab.setEnabled(false);
            this.d_massFlux.setEnabled(false);
            ActionListener massAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource() instanceof JButton) {
                        Actions.editParticles((Particle)PartInjPanel.this.d_particleCombo.getSelectedItem());
                        if (PartInjPanel.this.d_particleCombo.getSelectedItem() == null && PartInjPanel.this.d_particleCombo.getItemCount() > 0) {
                            PartInjPanel.this.d_particleCombo.setSelectedIndex(0);
                        }
                    }
                    PartInjPanel.this.updateMassFluxStatus();
                }
            };
            GridBagUtil.add(this, this.d_emitPartCB, 0, row++, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, partTypeLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_particleCombo, 2, row, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, editParticles, 3, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, nppcLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_nppc, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, dtInsertLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dtInsert, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFlux, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_mfFuncEditor.addToPanel(this, 0, row++, 0, 48, 6, 12);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_emitPartCB, partTypeLab, this.d_particleCombo, editParticles, nppcLab, this.d_nppc, dtInsertLab, this.d_dtInsert, this.d_massFluxLab, this.d_massFlux);
            LinkStatus.link((AbstractButton)this.d_emitPartCB, this.d_mfFuncEditor.getComponents());
            this.d_emitPartCB.addActionListener(massAction);
            this.d_particleCombo.addActionListener(massAction);
            editParticles.addActionListener(massAction);
        }

        private void updateMassFluxStatus() {
            Particle part = (Particle)this.d_particleCombo.getSelectedItem();
            boolean enabled = this.d_emitPartCB.isSelected() && part != null && !part.isType(Particle.Type.TRACER);
            this.d_massFluxLab.setEnabled(enabled);
            this.d_massFlux.setEnabled(enabled);
            for (Component c : this.d_mfFuncEditor.getComponents()) {
                c.setEnabled(enabled);
            }
        }

        public void loadData(ParticleInjection pInj) {
            this.d_nppc.setValue(new ParticleInjection().d_numPartsPerCell);
            TimeBasedValue<UnitDouble> defMF = new ParticleInjection().getMassFlux();
            this.d_massFlux.setValue(defMF != null ? defMF.val : null);
            this.d_mfFuncEditor.loadFunction(defMF != null ? defMF.func : TimeFunction.newDefault());
            if (pInj != null && pInj.getParticle() != null) {
                this.d_emitPartCB.setSelected(true);
                this.d_particleCombo.setSelectedItem(pInj.getParticle());
                this.d_nppc.setValue(pInj.d_numPartsPerCell);
                this.d_dtInsert.setValue(pInj.d_dtInsert);
                TimeBasedValue<UnitDouble> mf = pInj.getMassFlux();
                if (mf != null) {
                    this.d_massFlux.setValue(mf.val);
                    this.d_mfFuncEditor.loadFunction(mf.func);
                }
                this.updateMassFluxStatus();
            } else {
                this.d_emitPartCB.setSelected(false);
                for (int m = 0; m < this.d_particleCombo.getItemCount(); ++m) {
                    if (!((Particle)this.d_particleCombo.getItemAt(m)).isType(Particle.Type.TRACER)) continue;
                    this.d_particleCombo.setSelectedIndex(m);
                    break;
                }
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_mfFuncEditor.validateData(showWarn, allowModify);
        }

        public ParticleInjection saveData() {
            if (this.d_emitPartCB.isSelected()) {
                TimeBasedValue<UnitDouble> massFlux = null;
                if (this.d_massFlux.isEnabled()) {
                    UnitDouble mf = (UnitDouble)this.d_massFlux.getValue();
                    massFlux = new TimeBasedValue<UnitDouble>(mf, this.d_mfFuncEditor.saveFunction());
                }
                return new ParticleInjection((Particle)this.d_particleCombo.getSelectedItem(), (Integer)this.d_nppc.getValue(), massFlux, (UnitDouble)this.d_dtInsert.getValue());
            }
            return null;
        }
    }

    private class AirFlowPanel
    extends guiPanel {
        private static final long serialVersionUID = -2598076021382714315L;
        private guiRadioButton d_velRB;
        private guiRadioButton d_volumeFluxRB;
        private guiRadioButton d_massFluxTotalRB;
        private guiRadioButton d_exSpecMassFluxRB;
        private final ValueField<UnitDouble> d_vel;
        private final ValueField<UnitDouble> d_volumeFlux;
        private final ValueField<UnitDouble> d_massFluxTotal;
        private final ValueField<UnitDouble> d_velT;
        private final ValueField<UnitDouble> d_velBT;
        private final ValueField<UnitDouble> d_atmProfOrig;
        private ValueField<Double> d_atmProfExp;
        private guiComboBox d_windCombo;
        private final ComponentGroup d_windGroup;
        private final TimeFunctionEditor d_RampTimeEditor;
        private IAirflowConfig d_typeConfig;

        public AirFlowPanel() {
            this.setLayout(new GridBagLayout());
            this.d_velRB = new guiRadioButton(Intl.intl("Specify Velocity") + ":");
            this.d_vel = ValueFields.udFld(UnitSystem.getSource(8));
            this.d_volumeFluxRB = new guiRadioButton(Intl.intl("Specify Volume Flow") + ":");
            this.d_volumeFlux = ValueFields.udFld(UnitSystem.getSource(24));
            this.d_massFluxTotalRB = new guiRadioButton(Intl.intl("Specify Total Mass Flux") + ":");
            this.d_massFluxTotal = ValueFields.udFld(UnitSystem.getSource(44));
            this.d_massFluxTotal.setPreferredSize(new Dimension(150, 20));
            this.d_exSpecMassFluxRB = new guiRadioButton(Intl.intl("Specify Mass Flux of Individual Species"));
            this.d_velT = ValueFields.udFld(UnitSystem.getSource(8));
            this.d_velBT = ValueFields.udFld(UnitSystem.getSource(8));
            this.setColumns(6, this.d_velT, this.d_velBT);
            this.d_RampTimeEditor = SurfacePanel.this.newTimeFuncEditor();
            guiLabel atmProfExpLab = new guiLabel(Intl.intl("Atmospheric Profile Exponent") + ":");
            this.d_atmProfExp = ValueFields.doubleFld(0.3);
            guiLabel atmProfOrigLab = new guiLabel(Intl.intl("Atmospheric Profile Origin") + ":");
            this.d_atmProfOrig = ValueFields.udFld(UnitSystem.getSource(0));
            this.d_windGroup = new ComponentGroup();
            this.d_windGroup.add(atmProfExpLab);
            this.d_windGroup.add(this.d_atmProfExp);
            this.d_windGroup.add(atmProfOrigLab);
            this.d_windGroup.add(this.d_atmProfOrig);
            this.d_windGroup.setVisible(false);
            guiLabel windLab = new guiLabel(Intl.intl("Wind Profile") + ":");
            String topHatID = Intl.intl("Top Hat (Default)");
            String parabolicID = Intl.intl("Parabolic");
            final String atmosphericID = Intl.intl("Atmospheric");
            String[] windOpts = new String[]{topHatID, parabolicID, atmosphericID};
            this.d_windCombo = new guiComboBox<String>((T[])windOpts);
            this.d_windCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String choice = e.getItem().toString();
                    if (atmosphericID.equals(choice)) {
                        AirFlowPanel.this.d_windGroup.setVisible(true);
                    } else {
                        AirFlowPanel.this.d_windGroup.setVisible(false);
                    }
                }
            });
            int row = 0;
            TitleSeparator velocityTitle = new TitleSeparator(Intl.intl("Normal Flow Rate"));
            GridBagUtil.add(this, velocityTitle, 0, row++, 10, 1, 12, 12, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_volumeFluxRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_volumeFlux, 2, row++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_velRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_vel, 2, row++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxTotalRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxTotal, 2, row++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_exSpecMassFluxRB, 0, row++, 10, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            guiPanel tanVelPanel = new guiPanel(new GridBagLayout());
            GridBagUtil.add(tanVelPanel, this.d_velT, 0, 0, 1, 1, 0, 0, 0, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(tanVelPanel, this.d_velBT, 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, new guiLabel(Intl.intl("Tangential Velocity:")), 0, row, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, tanVelPanel, 2, row++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_RampTimeEditor.addToPanel(this, 0, row++, 0, 12, 6, 12);
            GridBagUtil.add(this, windLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_windCombo, 1, row++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, new JSeparator(0), 0, row++, 10, 1, 0, 12, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, atmProfExpLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_atmProfExp, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, atmProfOrigLab, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_atmProfOrig, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.d_velRB);
            bg.add(this.d_volumeFluxRB);
            bg.add(this.d_massFluxTotalRB);
            bg.add(this.d_exSpecMassFluxRB);
            this.d_velRB.setSelected(true);
            LinkStatus.link((AbstractButton)this.d_velRB, this.d_vel);
            LinkStatus.link((AbstractButton)this.d_volumeFluxRB, this.d_volumeFlux);
            LinkStatus.link((AbstractButton)this.d_massFluxTotalRB, this.d_massFluxTotal);
            ActionListener blowerMassFluxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AirFlowPanel.this.updateBlower();
                    AirFlowPanel.this.updateRampEditorEnabled();
                }
            };
            this.d_volumeFluxRB.addActionListener(blowerMassFluxListener);
            this.d_velRB.addActionListener(blowerMassFluxListener);
            this.d_massFluxTotalRB.addActionListener(blowerMassFluxListener);
            this.d_exSpecMassFluxRB.addActionListener(blowerMassFluxListener);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.d_RampTimeEditor.validateData(showWarn, allowModify)) {
                return false;
            }
            if (showWarn) {
                String msg;
                int choice;
                PyroMod pyMod = PyroSim.getApp().getMediator();
                SimParams sp = pyMod.getSimParams();
                SimParams.Wind wind = sp.getWind();
                UnitDouble udGroundLevel = wind.get(SimParams.Wind.GROUND_LEVEL);
                UnitDouble udZ0 = (UnitDouble)this.d_atmProfOrig.getValue();
                if (udZ0.compareTo(udGroundLevel) < 0 && (choice = JOptionPane.showConfirmDialog(this, msg = Intl.intl("Warning: Atmospheric profile origin below simulation\nparameter GROUND_LEVEL."), Intl.intl("Warning"), 2, 2)) == 2) {
                    return false;
                }
            }
            return true;
        }

        private void enableExSpecMassFlux(boolean enable) {
            if (!enable && this.d_exSpecMassFluxRB.isSelected()) {
                this.d_velRB.setSelected(true);
            }
            this.d_exSpecMassFluxRB.setVisible(enable);
        }

        public void setSurfaceDescription(String surfType) {
            if (SUPPLY.equals(surfType)) {
                this.d_massFluxTotalRB.setVisible(false);
                this.d_massFluxTotal.setVisible(false);
                if (this.d_massFluxTotalRB.isSelected()) {
                    this.d_velRB.setSelected(true);
                }
            } else {
                this.d_massFluxTotalRB.setVisible(true);
                this.d_massFluxTotal.setVisible(true);
            }
        }

        private void setColumns(int numCols, Component ... components) {
            for (Component c : components) {
                if (!(c instanceof JTextField)) continue;
                ((JTextField)c).setColumns(numCols);
            }
        }

        public void updateBlower() {
            if (SurfacePanel.this.d_profileListBox.getSelectedItem().equals(SUPPLY) || SurfacePanel.this.d_profileListBox.getSelectedItem().equals(GENERAL)) {
                if (this.d_exSpecMassFluxRB.isSelected()) {
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(true, false);
                } else {
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(false, true);
                }
            }
        }

        private void setVelAboveZeroOnly(boolean velAboveZero) {
            this.setVelAboveZero(this.d_vel, velAboveZero);
            this.setVelAboveZero(this.d_volumeFlux, velAboveZero);
            this.setVelAboveZero(this.d_massFluxTotal, velAboveZero);
        }

        private void setVelAboveZero(ValueField<UnitDouble> field, boolean velAboveZero) {
            UnitDoubleFormat prevForm = (UnitDoubleFormat)field.getFormat();
            Unit u = prevForm.getUnitType().getUnit();
            String text = field.getText();
            field.setFilter(velAboveZero ? UnitDoubleVR.above(0.0, u, true) : UnitDoubleVR.UNBOUNDED);
            field.setText(text);
        }

        public void updateRampEditorEnabled() {
            if (this.d_exSpecMassFluxRB.isSelected()) {
                this.d_RampTimeEditor.setEnabled(false);
            } else {
                this.d_RampTimeEditor.setEnabled(true);
            }
        }

        public void loadData(AirFlow af, boolean velAboveZero) {
            AirFlow defAirFlow = new AirFlow();
            this.d_volumeFlux.setValue(new AirFlow.VolumeFlux().val);
            this.d_velT.setValue(((AirFlow.VolumeFlux)defAirFlow.d_rate).tanVelU);
            this.d_velBT.setValue(((AirFlow.VolumeFlux)defAirFlow.d_rate).tanVelV);
            this.d_vel.setValue(new AirFlow.NormalVel().val);
            this.d_massFluxTotal.setValue(new AirFlow.TotalMassFlux().val);
            this.d_atmProfExp.setValue(new AirFlow.AtmosphericProf().d_exponent);
            this.d_atmProfOrig.setValue(new AirFlow.AtmosphericProf().d_origin);
            this.d_velRB.setSelected(true);
            this.updateBlower();
            this.d_windCombo.setSelectedIndex(0);
            this.setVelAboveZeroOnly(velAboveZero);
            if (af == null) {
                return;
            }
            if (af.d_rate instanceof AirFlow.NormalVel) {
                this.d_velRB.setSelected(true);
                this.d_vel.setValue(((AirFlow.NormalVel)af.d_rate).val);
            } else if (af.d_rate instanceof AirFlow.VolumeFlux) {
                this.d_volumeFluxRB.setSelected(true);
                this.d_volumeFlux.setValue(((AirFlow.VolumeFlux)af.d_rate).val);
            } else if (af.d_rate instanceof AirFlow.TotalMassFlux) {
                this.d_massFluxTotalRB.setSelected(true);
                this.d_massFluxTotal.setValue(((AirFlow.TotalMassFlux)af.d_rate).val);
            } else {
                this.d_exSpecMassFluxRB.setSelected(true);
            }
            if (SurfacePanel.this.d_profileListBox.getSelectedItem() != EXHAUST) {
                SurfacePanel.this.d_specInjPanel.loadData(af.d_rate.specInj);
            }
            this.updateRampEditorEnabled();
            this.d_velT.setValue(af.d_rate.tanVelU);
            this.d_velBT.setValue(af.d_rate.tanVelV);
            this.d_RampTimeEditor.loadFunction(af.d_rate.func);
            if (af.d_profile instanceof AirFlow.ParabolicProf) {
                this.d_windCombo.setSelectedIndex(1);
                this.d_windGroup.setVisible(false);
            } else if (af.d_profile instanceof AirFlow.AtmosphericProf) {
                this.d_windCombo.setSelectedIndex(2);
                this.d_windGroup.setVisible(true);
                AirFlow.AtmosphericProf atmProf = (AirFlow.AtmosphericProf)af.d_profile;
                this.d_atmProfExp.setValue(atmProf.d_exponent);
                this.d_atmProfOrig.setValue(atmProf.d_origin);
            } else {
                this.d_windCombo.setSelectedIndex(0);
                this.d_windGroup.setVisible(false);
            }
        }

        public AirFlow saveData(PyroMod domain) {
            SpecInjList specInj = null;
            if (SurfacePanel.this.d_profileListBox.getSelectedItem() != EXHAUST) {
                specInj = SurfacePanel.this.d_specInjPanel.saveData();
            }
            TimeFunction<?> rateRampup = this.d_RampTimeEditor.isEnabled() ? this.d_RampTimeEditor.saveFunction() : TimeFunction.newDefault();
            UnitDouble tanVelU = (UnitDouble)this.d_velT.getValue();
            UnitDouble tanVelV = (UnitDouble)this.d_velBT.getValue();
            AirFlow.Rate rate = this.d_velRB.isSelected() ? new AirFlow.NormalVel((UnitDouble)this.d_vel.getValue(), tanVelU, tanVelV, rateRampup, specInj) : (this.d_volumeFluxRB.isSelected() ? new AirFlow.VolumeFlux((UnitDouble)this.d_volumeFlux.getValue(), tanVelU, tanVelV, rateRampup, specInj) : (this.d_massFluxTotalRB.isSelected() ? new AirFlow.TotalMassFlux((UnitDouble)this.d_massFluxTotal.getValue(), tanVelU, tanVelV, rateRampup, specInj) : new AirFlow.ExSpecMassFlux(tanVelU, tanVelV, rateRampup, specInj)));
            int index = this.d_windCombo.getSelectedIndex();
            AirFlow.IProfile profile = index == 1 ? new AirFlow.ParabolicProf() : (index == 2 ? new AirFlow.AtmosphericProf((Double)this.d_atmProfExp.getValue(), (UnitDouble)this.d_atmProfOrig.getValue()) : new AirFlow.TopHatProf());
            return new AirFlow(rate, profile);
        }
    }

    private class ReactionPanel
    extends guiPanel {
        private static final long serialVersionUID = -4713295931358534790L;
        private guiRadioButton d_matRB;
        private guiRadioButton d_manualRB;
        private guiRadioButton d_burnImRB;
        private guiRadioButton d_igniteAtRB;
        private ValueField<UnitDouble> d_igniteAt;
        private ValueField<UnitDouble> d_hov;
        private guiCheckBox d_hovCB;
        private HRPanel d_hrReactionPanel;
        private guiCheckBox d_burnAwayCB;

        public ReactionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_matRB = new guiRadioButton(Intl.intl("Governed by Material"));
            this.d_manualRB = new guiRadioButton(Intl.intl("Governed Manually"));
            TitleSeparator ignitionLab = new TitleSeparator(Intl.intl("Ignition"));
            this.d_burnImRB = new guiRadioButton(Intl.intl("Burn Immediately"));
            this.d_igniteAtRB = new guiRadioButton(Intl.intl("Ignite at") + ":");
            this.d_igniteAt = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_hovCB = new guiCheckBox(Intl.intl("Heat of Vaporization") + ":");
            this.d_hov = ValueFields.udFld(UnitSystem.getSource(46));
            this.d_hrReactionPanel = new HRPanel(Intl.intl("Heat Release"));
            this.d_burnAwayCB = new guiCheckBox(Intl.intl("Allow obstruction to burn away"));
            guiPanel extraPanel = new guiPanel();
            extraPanel.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this, this.d_matRB, 0, row++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_manualRB, 0, row++, 1, 1, 0, 12, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hrReactionPanel, 0, row++, 0, 1, 0, 30, 0, 12, 1, 1.0, 0.0);
            int row2 = 0;
            GridBagUtil.add(extraPanel, ignitionLab, 0, row2++, 0, 1, 6, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(extraPanel, this.d_burnImRB, 0, row2++, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(extraPanel, this.d_igniteAtRB, 0, row2, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(extraPanel, this.d_igniteAt, 1, row2++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(extraPanel, this.d_hovCB, 0, row2, 1, 1, 0, 12, 6, 52, 0, 0.0, 0.0, 17);
            GridBagUtil.add(extraPanel, this.d_hov, 1, row2++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(extraPanel);
            GridBagUtil.add(this, extraPanel, 0, row++, 0, 1, -6, 30, 6, 12, 1, 1.0, 0.0);
            GridBagUtil.add(this, this.d_burnAwayCB, 0, row++, 4, 1, 0, 12, 12, 12, 0, 0.0, 0.0);
            GridBagUtil.addGlue(this);
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_matRB);
            group.add(this.d_manualRB);
            this.d_matRB.setSelected(true);
            ButtonGroup group2 = new ButtonGroup();
            group2.add(this.d_burnImRB);
            group2.add(this.d_igniteAtRB);
            this.d_burnImRB.setSelected(true);
            LinkStatus.link((AbstractButton)this.d_manualRB, this.d_hrReactionPanel);
            LinkStatus.link((AbstractButton)this.d_manualRB, extraPanel);
            LinkStatus.link((AbstractButton)this.d_igniteAtRB, this.d_igniteAt);
            LinkStatus.link((AbstractButton)this.d_hovCB, this.d_hov);
        }

        public void loadData(Fuel.IReaction reac, boolean burnAway) {
            this.d_hrReactionPanel.loadData(null);
            this.d_matRB.setSelected(true);
            this.d_burnImRB.setSelected(true);
            this.d_igniteAt.setValue(new Fuel.ManualReac.TemperatureIgnite().d_temperature);
            this.d_hov.setValue(new Fuel.ManualReac().d_heatOfVap);
            this.d_burnAwayCB.setSelected(burnAway);
            if (reac == null) {
                return;
            }
            if (reac instanceof Fuel.MaterialReac) {
                this.d_matRB.setSelected(true);
                this.d_hrReactionPanel.loadData(new Fuel.ManualReac().d_heatRelease);
                this.d_burnImRB.setSelected(true);
            } else {
                Fuel.ManualReac mr = (Fuel.ManualReac)reac;
                this.d_manualRB.setSelected(true);
                this.d_hrReactionPanel.loadData(mr.d_heatRelease);
                if (mr.d_ignition instanceof Fuel.ManualReac.ImmediateIgnite) {
                    this.d_burnImRB.setSelected(true);
                } else {
                    this.d_igniteAtRB.setSelected(true);
                    this.d_igniteAt.setValue(((Fuel.ManualReac.TemperatureIgnite)mr.d_ignition).d_temperature);
                }
                if (mr.d_heatOfVap != null) {
                    this.d_hovCB.setSelected(true);
                    this.d_hov.setValue(mr.d_heatOfVap);
                } else {
                    this.d_hovCB.setSelected(false);
                }
            }
        }

        public Fuel.IReaction saveData() {
            UnitDouble hov;
            if (this.d_matRB.isSelected()) {
                return new Fuel.MaterialReac();
            }
            UnitDouble unitDouble = hov = this.d_hovCB.isSelected() ? (UnitDouble)this.d_hov.getValue() : null;
            if (this.d_burnImRB.isSelected()) {
                return new Fuel.ManualReac(this.d_hrReactionPanel.saveData(), hov, new Fuel.ManualReac.ImmediateIgnite());
            }
            return new Fuel.ManualReac(this.d_hrReactionPanel.saveData(), hov, new Fuel.ManualReac.TemperatureIgnite((UnitDouble)this.d_igniteAt.getValue()));
        }

        public boolean burnAway() {
            return this.d_burnAwayCB.isSelected();
        }

        public void allowBurnAway(boolean allow) {
            this.d_burnAwayCB.setVisible(allow);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_igniteAtRB.isSelected() && ((UnitDouble)this.d_igniteAt.getValue()).ge(new UnitDouble(5000.0, SI.KELVIN), 0.0)) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("FDS treats an ignition temperature >= 5000 K (4726.85 \u2103) equivalent to the Burn Immediately option.\nOn the Reaction tab, decrease the ignition temperature under 5000 K, or select the Burn Immediately option."), Intl.intl("The ignition temperature is too high"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private class LayersPanel
    extends guiPanel {
        private static final long serialVersionUID = -888896091136552195L;
        private final guiTable d_table;
        private final guiCheckBox d_layerDivideCB = new guiCheckBox(Intl.intl("Layer Divide:"));
        private final ValueField<Double> d_layerDivideFld = ValueFields.doubleFld(DoubleVR.above(0.0, true));
        private final guiComboBox<HeatTransfer3D.HeatTransferModel> d_heatTransferModel = guiUtil.newCombo(htm -> new Pair<String, Object>(htm.name, null), HeatTransfer3D.HeatTransferModel.DEFAULT, HeatTransfer3D.HeatTransferModel.HT3D);
        private final guiLabel d_messageLabel = new guiLabel(" ");
        private final ValueField<UnitDouble> d_cellSize = ValueFields.udFld(DoubleVR.above(0.0, true), (Unit)SI.METER);
        private final int d_rowLimit = 20;
        private final PyroMod d_mod;

        public LayersPanel(PyroMod mod) {
            this.setLayout(new MigLayout("insets 12, fillx, gap 6"));
            this.d_mod = mod;
            if (!SurfacePanel.this.d_matMgr.flatten().isEmpty()) {
                this.d_table = new guiTable((TableModel)new SurfLayersTable(), 24);
            } else {
                this.d_table = new guiTable((TableModel)new SurfLayersTable(), 0);
                this.d_table.setEnabled(false);
            }
            Unit lu = PyroSim.getApp().getUnitSystem().getLengthUnit();
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(lu));
            this.d_table.getColumnModel().getColumn(1).setCellEditor(new SurfCompCollectionEditor(SurfacePanel.this.d_surfMgr, SurfacePanel.this.d_matMgr));
            this.d_table.getColumnModel().getColumn(1).setCellRenderer(new SurfCompCollectionRenderer());
            this.d_table.getColumnModel().getColumn(2).setCellEditor(new EditCompEditor());
            this.d_table.getColumnModel().getColumn(2).setCellRenderer(new EditCompRenderer());
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.d_table.getColumnModel().getColumn(2).setPreferredWidth(40);
            this.d_table.setClipboard(1, (guiTableClipboard)new SurfCompCollectionClipboard());
            this.d_table.setRowLimit(20);
            int width = this.d_table.autoSizeColumns(10);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(width, 10));
            int options = 30;
            guiTableEditor editor = new guiTableEditor(this.d_table, options);
            LinkStatus.link((AbstractButton)this.d_layerDivideCB, this.d_layerDivideFld);
            this.d_heatTransferModel.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    this.update();
                }
            });
            this.d_messageLabel.setForeground(Color.red);
            String htModelTT = String.format("<html>" + Intl.intl("<b>%s:</b> Transfers heat into the solid in 1-dimension, normal to the surface,<br>and cannot touch objects that use 3D heat transfer.<br><b>%s:</b> Transfers heat into the solid in 1-dimension, normal to the surface,<br>and can touch objects that use 3D heat transfer.<br><b>%s:</b> Transfers heat into the solid in 3-dimensions.") + "</html>", new Object[]{HeatTransfer3D.HeatTransferModel.DEFAULT, HeatTransfer3D.HeatTransferModel.HT3D_NORMAL_ONLY, HeatTransfer3D.HeatTransferModel.HT3D});
            guiLabel htModelLabel = new guiLabel(Intl.intl("Model:"));
            htModelLabel.setToolTipText(htModelTT);
            this.d_heatTransferModel.setToolTipText(htModelTT);
            String cellSizeTT = "<html>" + Intl.intl("<b>Typically the same as mesh cell size.</b><br>If this surface is applied to objects spanning meshes of different cell sizes,<br>choose the smallest mesh cell size for this value.") + "</html>";
            guiLabel cellSizeLabel = new guiLabel(Intl.intl("Cell Size:"));
            cellSizeLabel.setToolTipText(cellSizeTT);
            this.d_cellSize.setToolTipText(cellSizeTT);
            this.add((Component)new TitleSeparator(Intl.intl("Heat Transfer")), "span 2, growx, wrap");
            this.add((Component)htModelLabel, "gapleft 18");
            this.add(this.d_heatTransferModel, "wrap");
            this.add((Component)cellSizeLabel, "gapleft 18");
            this.add(this.d_cellSize, "wrap");
            this.add((Component)new TitleSeparator(LAYERS), "span 2, growx, wrap");
            this.add((Component)this.d_layerDivideCB, "gapleft 18");
            this.add(this.d_layerDivideFld, "wrap");
            this.add((Component)editor, "gapleft 18, span 2, growx, wrap");
            this.add((Component)this.d_messageLabel, "gapleft 18, span 2, growx, wrap");
            this.d_heatTransferModel.setPreferredSize(this.d_cellSize.getPreferredSize());
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + 12));
            this.update();
        }

        private String getStateString(boolean state) {
            return state ? Intl.intl("enabled") : Intl.intl("disabled");
        }

        private double getMinCellSize(Grid grid) {
            UnitPoint3D cellSize = grid.getCellSize(new boolean[]{true, true, true});
            return theUtil.parallelGetMin(new double[]{cellSize.xu().getValue(Geometry.LU), cellSize.yu().getValue(Geometry.LU), cellSize.zu().getValue(Geometry.LU)}, 0.0);
        }

        private void update() {
            HeatTransfer3D.HeatTransferModel htModel = this.d_heatTransferModel.getSelectedItem();
            if (htModel == null) {
                htModel = HeatTransfer3D.HeatTransferModel.DEFAULT;
            }
            if (htModel == HeatTransfer3D.HeatTransferModel.DEFAULT) {
                this.d_cellSize.setEnabled(false);
                this.d_layerDivideCB.setEnabled(true);
                return;
            }
            if (htModel == HeatTransfer3D.HeatTransferModel.HT3D) {
                this.d_cellSize.setEnabled(true);
                this.d_layerDivideCB.setSelected(false);
                this.d_layerDivideCB.setEnabled(false);
            }
        }

        public void loadData(LayeredSurfDesc sd) {
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_table.clearSelection();
            this.d_layerDivideCB.setSelected(false);
            Collection<Grid> meshes = ((APyroObject)this.d_mod.getGridManager()).flatten(Grid.class);
            Double minCellSize = meshes.stream().map(this::getMinCellSize).min((a, b) -> theUtil.compare(a, b, 1.0E-6)).orElse(0.0);
            this.d_cellSize.setValue(new UnitDouble(minCellSize, Geometry.LU));
            if (sd == null || sd.d_surfComp == null) {
                return;
            }
            SurfComposition sc = sd.d_surfComp;
            HeatTransfer3D ht3d = sd.d_ht3d;
            HeatTransfer3D.HeatTransferModel htModel = HeatTransfer3D.HeatTransferModel.DEFAULT;
            if (ht3d != null) {
                this.d_cellSize.setValue(ht3d.d_cellSize);
                htModel = HeatTransfer3D.HeatTransferModel.HT3D;
            }
            this.d_heatTransferModel.setSelectedItem((Object)htModel);
            if (sc.d_layerDivide != null) {
                this.d_layerDivideCB.setSelected(true);
                this.d_layerDivideFld.setValue(sc.d_layerDivide);
            }
            List<SurfComposition.SurfLayer> layerList = sc.d_layers;
            ResizableTableModel mod = (ResizableTableModel)this.d_table.getModel();
            for (int i = 0; i < layerList.size(); ++i) {
                Object[] row = new Object[]{layerList.get((int)i).d_thickness, new ArrayList<SurfComposition.SurfLayer.SurfComponent>(layerList.get(i).getComponents()), null};
                mod.insertRow(i, row);
            }
            if (this.d_mod.getMaterialMgr().flatten().isEmpty()) {
                this.d_messageLabel.setText(Intl.intl("No materials currently exist in the model."));
            } else {
                this.d_messageLabel.setText(" ");
            }
            this.update();
        }

        public HeatTransfer3D ht3d() {
            HeatTransfer3D.HeatTransferModel htModel = this.d_heatTransferModel.getSelectedItem();
            if (htModel != null && htModel.ht3d) {
                return new HeatTransfer3D((UnitDouble)this.d_cellSize.getValue());
            }
            return null;
        }

        public Pair<List<SurfComposition.SurfLayer>, Double> layerData() {
            ArrayList<SurfComposition.SurfLayer> layerList = new ArrayList<SurfComposition.SurfLayer>(this.d_table.getRowCount());
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                if (this.d_table.getValueAt(i, 1) == null) continue;
                layerList.add(new SurfComposition.SurfLayer((UnitDouble)this.d_table.getValueAt(i, 0), (Collection)this.d_table.getValueAt(i, 1)));
            }
            Double layerDivide = null;
            if (this.d_layerDivideCB.isSelected() && (Double)this.d_layerDivideFld.getValue() <= (double)layerList.size()) {
                layerDivide = (Double)this.d_layerDivideFld.getValue();
            }
            return new Pair(layerList, layerDivide);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean isValid;
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            ArrayList<Integer> nonEmptyRows = new ArrayList<Integer>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                Object thicknessObj = this.d_table.getValueAt(i, 0);
                Iterator matCompObject = this.d_table.getValueAt(i, 1);
                if (thicknessObj == null && matCompObject == null) continue;
                nonEmptyRows.add(i);
            }
            String errorMessage = null;
            HeatTransfer3D.HeatTransferModel htModel = this.d_heatTransferModel.getSelectedItem();
            if (htModel == null) {
                htModel = HeatTransfer3D.HeatTransferModel.DEFAULT;
            }
            if (htModel == HeatTransfer3D.HeatTransferModel.HT3D && nonEmptyRows.size() > 1) {
                errorMessage = String.format(Intl.intl("Only one Material Layer is allowed for the %s Heat Transfer Model."), new Object[]{htModel});
                nonEmptyRows = new ArrayList();
            }
            for (Integer row : nonEmptyRows) {
                Object thicknessObj = this.d_table.getValueAt(row, 0);
                Object matCompObject = this.d_table.getValueAt(row, 1);
                if (matCompObject == null) {
                    errorMessage = Intl.intl("Material Composition is required.");
                    break;
                }
                if (htModel == HeatTransfer3D.HeatTransferModel.HT3D && thicknessObj != null) {
                    errorMessage = String.format(Intl.intl("Thickness should be empty for the %s Heat Transfer Model."), new Object[]{htModel});
                    break;
                }
                if (htModel != HeatTransfer3D.HeatTransferModel.DEFAULT && htModel != HeatTransfer3D.HeatTransferModel.HT3D_NORMAL_ONLY || thicknessObj != null) continue;
                errorMessage = String.format(Intl.intl("Thickness is required for the %s Heat Transfer Model."), new Object[]{htModel});
                break;
            }
            int numLayers = nonEmptyRows.size();
            if (this.d_layerDivideCB.isSelected() && (Double)this.d_layerDivideFld.getValue() > (double)numLayers) {
                errorMessage = String.format(Intl.intl("Layer Divide must be less than or equal to %d (the number of layers)."), numLayers);
            }
            boolean bl = isValid = errorMessage == null;
            if (!isValid) {
                if (allowModify) {
                    SurfacePanel.this.d_tabs.setSelectedComponent(SurfacePanel.this.d_layersPanel);
                }
                this.error(showWarn, errorMessage);
            }
            return isValid;
        }

        private void error(boolean show, String msg) {
            if (show) {
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Layer Error"), 0);
            }
        }

        private String sanitizeNameIfNeeded(String name) {
            String nastyChars = " ;,";
            boolean hit = false;
            for (char c : nastyChars.toCharArray()) {
                if (name.indexOf(c) == -1) continue;
                hit = true;
                break;
            }
            return hit ? "\"" + name + "\"" : name;
        }

        private String renderSCCollection(JTable table, int row, int col, Collection<SurfComposition.SurfLayer.SurfComponent> list) {
            StringBuffer buffer = new StringBuffer();
            if (list != null && list.size() > 0) {
                int m = 0;
                for (SurfComposition.SurfLayer.SurfComponent sc : list) {
                    if (m > 0) {
                        buffer.append("; ");
                    }
                    buffer.append(Global.format(sc.d_massFraction) + " " + this.sanitizeNameIfNeeded(sc.d_material.getName()));
                    m = 2;
                }
            }
            return buffer.toString();
        }

        private Collection<SurfComposition.SurfLayer.SurfComponent> parseSCCollection(String text, MaterialManager matMgr) throws ParseException {
            String matName;
            Material mat;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> result = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            List<String> toks = CSVLineParser.parse(text, " ;", "\"");
            if (toks.size() == 1 && (mat = (Material)matMgr.get(matName = toks.get(0))) != null) {
                result.add(new SurfComposition.SurfLayer.SurfComponent(1.0, mat));
                return result;
            }
            for (int i = 0; i < toks.size() - 1; i += 2) {
                String sVal = toks.get(i);
                String sMATL = toks.get(i + 1);
                double value = Global.parseDouble(sVal);
                if (value <= 0.0 || value > 1.0) {
                    throw new ParseException(Intl.intl("Mass fraction must range from 0 to 1."), 0);
                }
                Material mat2 = (Material)matMgr.get(sMATL);
                if (mat2 == null) {
                    throw new ParseException(String.format(Intl.intl("%1$s is not a valid material."), sMATL), 0);
                }
                result.add(new SurfComposition.SurfLayer.SurfComponent(value, mat2));
            }
            if (toks.size() % 2 == 1) {
                String lastVal = toks.get(toks.size() - 1);
                throw new ParseException(String.format(Intl.intl("A material is needed after the value %1$s."), lastVal), 0);
            }
            return result;
        }

        private String renderUD(JTable table, int row, int col, UnitDouble value) {
            if (value != null) {
                return Global.format(value.getValue(SurfacePanel.this.d_currentUS.getLengthUnit()));
            }
            return "";
        }

        private UnitDouble parseUD(String text) {
            Unit u = SurfacePanel.this.d_currentUS.getLengthUnit();
            try {
                double value = Global.parseDouble(text);
                return new UnitDouble(value, u);
            }
            catch (ParseException e) {
                return null;
            }
        }

        private class SurfLayersTable
        extends guiDefaultTableModel {
            private static final long serialVersionUID = -8986329050233327583L;

            private SurfLayersTable() {
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return String.format(Intl.intl("Thickness (%s)"), SurfacePanel.this.d_currentUS.getLengthUnit().toString());
                    }
                    case 1: {
                        return Intl.intl("Material Composition");
                    }
                    case 2: {
                        return Intl.intl("Edit");
                    }
                }
                return null;
            }

            @Override
            public Class getColumnClass(int c) {
                switch (c) {
                    case 0: {
                        return UnitDouble.class;
                    }
                    case 1: {
                        return Collection.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        }

        private class SurfCompCollectionEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = -5465749326982964478L;
            private Collection<SurfComposition.SurfLayer.SurfComponent> d_list;
            private SurfaceManager d_surfMgr;
            private MaterialManager d_matMgr;

            public SurfCompCollectionEditor(SurfaceManager surfMgr, MaterialManager matMgr) {
                super(new JTextField());
                ((JTextField)this.getComponent()).setHorizontalAlignment(4);
                this.d_surfMgr = surfMgr;
                this.d_matMgr = matMgr;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JTextField c = (JTextField)this.getComponent();
                this.d_list = (Collection)value;
                c.setText(LayersPanel.this.renderSCCollection(table, row, column, this.d_list));
                return c;
            }

            protected void showError(String msg) {
                Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, SurfacePanel.this);
                if (parent != null) {
                    guiDialog.showInvalidEntryMessage(parent, msg);
                }
            }

            @Override
            public boolean stopCellEditing() {
                JTextField c = (JTextField)this.getComponent();
                Collection<SurfComposition.SurfLayer.SurfComponent> result = null;
                try {
                    result = LayersPanel.this.parseSCCollection(c.getText(), this.d_matMgr);
                }
                catch (ParseException e) {
                    this.showError(e.getLocalizedMessage());
                    c.grabFocus();
                    return false;
                }
                Collection<SurfComposition.SurfLayer.SurfComponent> hold = this.d_list;
                if (result.size() < 1) {
                    this.d_list = null;
                } else {
                    double sum = 0.0;
                    for (SurfComposition.SurfLayer.SurfComponent sc : result) {
                        sum += sc.d_massFraction;
                    }
                    if (!theUtil.eq(sum, 1.0, 1.0E-6)) {
                        this.showError(Intl.intl("Mass fraction values must add up to 1."));
                        return false;
                    }
                    this.d_list = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(result.size());
                    ArrayList<Material> mats = new ArrayList<Material>(result.size());
                    for (SurfComposition.SurfLayer.SurfComponent sc : result) {
                        if (mats.contains(sc.d_material)) continue;
                        mats.add(sc.d_material);
                    }
                    if (mats.size() != result.size()) {
                        for (Material mat : mats) {
                            double massFraction = 0.0;
                            for (SurfComposition.SurfLayer.SurfComponent sc : result) {
                                if (!mat.equals(sc.d_material)) continue;
                                massFraction += sc.d_massFraction;
                            }
                            this.d_list.add(new SurfComposition.SurfLayer.SurfComponent(massFraction, mat));
                        }
                    } else {
                        this.d_list = result;
                    }
                    if (this.d_list.size() > 20) {
                        LayersPanel.this.d_messageLabel.setText(Intl.intl("No more than 20 materials are allowed."));
                        this.d_list = hold;
                        return false;
                    }
                }
                return super.stopCellEditing();
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_list;
            }
        }

        private class SurfCompCollectionRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 4314216411336090376L;

            public SurfCompCollectionRenderer() {
                this.setHorizontalAlignment(4);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Collection list = (Collection)value;
                this.setText(LayersPanel.this.renderSCCollection(table, row, column, list));
                return comp;
            }
        }

        private class EditCompEditor
        extends DefaultCellEditor
        implements TableCellEditor,
        ActionListener {
            private static final long serialVersionUID = -2409153443271011851L;
            private final JButton d_button;
            private int d_row;

            public EditCompEditor() {
                super(new JTextField());
                this.d_button = new JButton(Intl.intl("Edit") + "...");
                this.d_button.addActionListener(this);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                this.d_row = row;
                this.d_button.setBackground(comp.getBackground());
                return this.d_button;
            }

            @Override
            public Object getCellEditorValue() {
                return "";
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection<SurfComposition.SurfLayer.SurfComponent> comp = (Collection<SurfComposition.SurfLayer.SurfComponent>)LayersPanel.this.d_table.getValueAt(this.d_row, 1);
                SurfacePanelEditCompDlg compDlg = new SurfacePanelEditCompDlg(comp, SurfacePanel.this.d_matMgr);
                if (compDlg.doModal() == 1) {
                    comp = compDlg.getSurfComponent();
                    this.stopCellEditing();
                    LayersPanel.this.d_table.setValueAt(comp, this.d_row, 1);
                    LayersPanel.this.d_table.setModified(true);
                } else {
                    this.cancelCellEditing();
                }
            }
        }

        private class EditCompRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 863885343655302852L;
            private final JButton d_button = new JButton(Intl.intl("Edit") + "...");

            private EditCompRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.d_button.setBackground(comp.getBackground());
                return this.d_button;
            }
        }

        private class SurfCompCollectionClipboard
        extends DefaultTableClipboard {
            private SurfCompCollectionClipboard() {
            }

            @Override
            public boolean pasteObject(guiTable table, Object data, int pasteRow, int pasteCol) {
                assert (pasteCol == 1);
                if (data instanceof Collection) {
                    Collection coll = data;
                    IFilteredCollection<SurfComposition.SurfLayer.SurfComponent> comps = theUtil.filter(coll, SurfComposition.SurfLayer.SurfComponent.class);
                    if (!comps.isExclusive()) {
                        return false;
                    }
                    LinkedIdentityHashSet toPaste = new LinkedIdentityHashSet();
                    for (SurfComposition.SurfLayer.SurfComponent comp : comps) {
                        if (comp.d_material.getDomain() == LayersPanel.this.d_mod) continue;
                        toPaste.add(comp.d_material);
                    }
                    Actions.UIPasteCallback pasteCallback = new Actions.UIPasteCallback(this, LayersPanel.this.d_mod){

                        @Override
                        public Actions.PasteOverwrite getReplaceModelObject(IPyroObject modelObj, IPyroObject pasteObj) throws CancellationException {
                            return Actions.PasteOverwrite.KEEP_EXISTING;
                        }
                    };
                    Actions.PasteInfo pinfo = Actions.taskInsertObjects(LayersPanel.this.d_mod, toPaste, pasteCallback, 2);
                    for (Actions.PasteCommand cmd : pinfo.commands.values()) {
                        if (cmd.command == 1 && cmd.param instanceof IPyroObject) continue;
                        return false;
                    }
                    pinfo.task.run();
                    ArrayList<SurfComposition.SurfLayer.SurfComponent> newComps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(comps.size());
                    for (SurfComposition.SurfLayer.SurfComponent comp : comps) {
                        Actions.PasteCommand cmd = pinfo.commands.get(comp.d_material);
                        if (cmd != null) {
                            if (!(cmd.param instanceof Material)) {
                                return false;
                            }
                            Material replacement = (Material)cmd.param;
                            comp = new SurfComposition.SurfLayer.SurfComponent(comp.d_massFraction, replacement);
                        }
                        newComps.add(comp);
                    }
                    data = newComps;
                }
                return super.pasteObject(table, data, pasteRow, pasteCol);
            }
        }
    }

    private class LayersPropPanel
    extends guiPanel {
        private static final long serialVersionUID = 1720376837829116774L;
        private final ZonePathPanel d_leakPath = new ZonePathPanel(Intl.intl("Enable Leakage"), true);
        private final VariantEditor d_innerTempVariantEditor = new VariantEditor(Intl.intl("Initial Internal Temperature"), Intl.intl("Initial Internal Temperature"), SurfComposition.TEMP_RAMP_INTERNAL, false);
        private final BackingEditor d_backingCombo;

        public LayersPropPanel() {
            this.d_backingCombo = new BackingEditor(SurfacePanel.this.d_currentUS);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_leakPath, GridBagHelper.REMAINING);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Temperature")));
            gb.addIdentRow(this.d_innerTempVariantEditor.getLabel(), this.d_innerTempVariantEditor.getCombo(), 1.0, this.d_innerTempVariantEditor.getEditor(), 1.0);
            gb.addIdentRow(Intl.intl("Backing") + ":", this.d_backingCombo, 1.0);
            gb.indent();
            gb.addIdentRow(this.d_backingCombo.d_airTempLab, this.d_backingCombo.d_airTempFld, 1.0);
            gb.addIdentRow(this.d_backingCombo.d_backTempRampEditor.getLabel(), this.d_backingCombo.d_backTempRampEditor.getCombo(), 1.0, this.d_backingCombo.d_backTempRampEditor.getEditor(), 1.0);
            gb.unindent();
            gb.finalizeRows();
        }

        public void loadData(LayeredSurfDesc sd) {
            LayeredSurfDesc defDesc = new LayeredSurfDesc();
            SurfComposition defComp = defDesc.d_surfComp;
            this.d_backingCombo.setBacking(defComp.d_backing);
            this.d_leakPath.loadData(defDesc.d_leakPath);
            this.d_innerTempVariantEditor.init(defComp.d_innerTempVariant);
            if (sd == null) {
                return;
            }
            this.d_backingCombo.setBacking(sd.d_surfComp.d_backing);
            this.d_leakPath.loadData(sd.d_leakPath);
            this.d_innerTempVariantEditor.init(sd.d_surfComp.d_innerTempVariant);
        }

        public ZonePath leakPath() {
            return this.d_leakPath.saveData();
        }

        public Variant tempRampInternal() {
            return this.d_innerTempVariantEditor.getValue();
        }

        public Backing backing() {
            return this.d_backingCombo.getBacking();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.d_innerTempVariantEditor.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_leakPath.validateLeakage(showWarn, allowModify);
        }
    }

    private static class LeakPanel
    extends guiPanel {
        private static final long serialVersionUID = -4136467863673605251L;
        private final ZonePathPanel d_leakPath = new ZonePathPanel(Intl.intl("Leak Path:"), false);

        public LeakPanel() {
            super(new GridBagLayout());
            GridBagUtil.add(this, this.d_leakPath, 0, 0, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(LeakSurfDesc desc) {
            if (desc == null) {
                this.d_leakPath.loadData(null);
                return;
            }
            this.d_leakPath.loadData(desc.d_leak);
        }

        public LeakSurfDesc save() {
            return new LeakSurfDesc(this.d_leakPath.saveData());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_leakPath.validateLeakage(showWarn, allowModify);
        }
    }

    private class ThermalPanel
    extends guiPanel {
        private static final long serialVersionUID = 1360048921292861572L;
        private final guiRadioButton d_defaultHTModelRb;
        private final guiRadioButton d_logHTModelRb;
        private final guiRadioButton d_userHTModelRb;
        private final VariantEditor d_htCoefVariant;
        private final guiComboBox<String> d_bcOptCombo;
        private final ValueField<UnitDouble> d_surfaceTemp;
        private final ValueField<UnitDouble> d_netFlux;
        private final ValueField<UnitDouble> d_convFlux;
        private final ValueField<Double> d_emissivity;
        private final TimeFunctionEditor d_tempRampEditor;
        private final TimeFunctionEditor d_netRampEditor;
        private final TimeFunctionEditor d_convRampEditor;

        public ThermalPanel() {
            this.setLayout(new GridBagLayout());
            this.d_defaultHTModelRb = new guiRadioButton(Intl.intl("Default"));
            this.d_logHTModelRb = new guiRadioButton(Intl.intl("Logarithmic"));
            this.d_userHTModelRb = new guiRadioButton(Intl.intl("Specify Heat Transfer Coefficient"));
            new guiButtonGroup(this.d_defaultHTModelRb, this.d_logHTModelRb, this.d_userHTModelRb);
            this.d_defaultHTModelRb.setSelected(true);
            this.d_htCoefVariant = new VariantEditor(Intl.intl("Heat Transfer Coefficient"), TempRegulation.HTCOEF_PROFILE, false);
            LinkStatus.link((AbstractButton)this.d_userHTModelRb, this.d_htCoefVariant.getCombo(), this.d_htCoefVariant.getEditor());
            guiLabel bcModelLbl = new guiLabel(Intl.intl("Boundary Condition Model:"));
            this.d_bcOptCombo = new guiComboBox<String>((T[])new String[]{ADIABATIC_OPT, FIXED_TEMP_OPT, NETFLUX_OPT, TOTALFLUX_OPT});
            guiLabel surfTempLbl = new guiLabel(Intl.intl("Surface Temperature:"));
            guiLabel emissivityLbl = new guiLabel(Intl.intl("Emissivity:"));
            guiLabel netFluxLbl = new guiLabel(Intl.intl("Net Heat Flux:"));
            guiLabel convFluxLbl = new guiLabel(Intl.intl("Convective Heat Flux:"));
            this.d_surfaceTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_surfaceTemp.setNullAllowed(true);
            ValueFields.getFormat(this.d_surfaceTemp).alias(null, "", "TMPA");
            this.d_netFlux = ValueFields.udFld(UnitSystem.getSource(33));
            this.d_convFlux = ValueFields.udFld(UnitSystem.getSource(33));
            this.d_emissivity = ValueFields.doubleFld();
            this.d_tempRampEditor = SurfacePanel.this.newTimeFuncEditor(Intl.intl("Temperature Ramp-Up Time"));
            this.d_netRampEditor = SurfacePanel.this.newTimeFuncEditor(Intl.intl("Net Flux Ramp-Up Time"));
            this.d_convRampEditor = SurfacePanel.this.newTimeFuncEditor(Intl.intl("Convective Flux Ramp-Up Time"));
            this.d_bcOptCombo.addActionListener(e -> {
                surfTempLbl.setEnabled(false);
                emissivityLbl.setEnabled(false);
                netFluxLbl.setEnabled(false);
                convFluxLbl.setEnabled(false);
                this.d_surfaceTemp.setEnabled(false);
                this.d_emissivity.setEnabled(false);
                this.d_netFlux.setEnabled(false);
                this.d_convFlux.setEnabled(false);
                this.d_tempRampEditor.setEnabled(false);
                this.d_netRampEditor.setEnabled(false);
                this.d_convRampEditor.setEnabled(false);
                if (this.d_bcOptCombo.getSelectedItem().equals(ADIABATIC_OPT)) {
                    this.d_emissivity.setValue(1.0);
                } else if (this.d_bcOptCombo.getSelectedItem().equals(FIXED_TEMP_OPT)) {
                    surfTempLbl.setEnabled(true);
                    emissivityLbl.setEnabled(true);
                    this.d_surfaceTemp.setEnabled(true);
                    this.d_tempRampEditor.setEnabled(true);
                    this.d_emissivity.setEnabled(true);
                } else if (this.d_bcOptCombo.getSelectedItem().equals(NETFLUX_OPT)) {
                    netFluxLbl.setEnabled(true);
                    emissivityLbl.setEnabled(true);
                    this.d_netFlux.setEnabled(true);
                    this.d_netRampEditor.setEnabled(true);
                    this.d_emissivity.setEnabled(true);
                } else if (this.d_bcOptCombo.getSelectedItem().equals(TOTALFLUX_OPT)) {
                    convFluxLbl.setEnabled(true);
                    surfTempLbl.setEnabled(true);
                    emissivityLbl.setEnabled(true);
                    this.d_convFlux.setEnabled(true);
                    this.d_convRampEditor.setEnabled(true);
                    this.d_surfaceTemp.setEnabled(true);
                    this.d_tempRampEditor.setEnabled(true);
                    this.d_emissivity.setEnabled(true);
                }
            });
            this.loadData(null);
            int row = 0;
            TitleSeparator convTitle = new TitleSeparator(Intl.intl("Convective Heat Transfer Model"));
            GridBagUtil.add(this, convTitle, 0, row++, 0, 1, 12, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_defaultHTModelRb, 0, row++, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_logHTModelRb, 0, row++, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_userHTModelRb, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_htCoefVariant.getCombo(), 1, row, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_htCoefVariant.getEditor(), 2, row++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            TitleSeparator bcTitle = new TitleSeparator(Intl.intl("Thermal Boundary Conditions"));
            GridBagUtil.add(this, bcTitle, 0, row++, 0, 1, 12, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, bcModelLbl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_bcOptCombo, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, emissivityLbl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emissivity, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, surfTempLbl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_surfaceTemp, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_tempRampEditor.addToPanel(this, 0, row++, 0, 30, 6, 12);
            GridBagUtil.add(this, convFluxLbl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_convFlux, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_convRampEditor.addToPanel(this, 0, row++, 0, 30, 6, 12);
            GridBagUtil.add(this, netFluxLbl, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_netFlux, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_netRampEditor.addToPanel(this, 0, row++, 0, 30, 6, 12);
            GridBagUtil.addGlue(this);
        }

        public void setSurfDesc(String surfType) {
            if (surfType.equals(LAYERED)) {
                this.setBCComboOptions(CALC_TEMP_OPT);
            } else if (surfType.equals(EXHAUST)) {
                this.setBCComboOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
            } else if (surfType.equals(SUPPLY)) {
                this.setBCComboOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
            } else if (surfType.equals(CONSTANT_TEMP)) {
                this.setBCComboOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
            } else if (surfType.equals(GENERAL)) {
                this.setBCComboOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
            } else if (surfType.equals(BURNER)) {
                this.setBCComboOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
            }
        }

        private void setBCComboOptions(String ... options) {
            this.d_bcOptCombo.setItems((String[])options);
            this.loadData(null);
        }

        public void loadData(TempRegulation tr) {
            TempRegulation defTempReg = null;
            if (this.d_bcOptCombo.contains(FIXED_TEMP_OPT)) {
                defTempReg = TempRegulation.defaultFixedTempTR();
            } else if (this.d_bcOptCombo.contains(CALC_TEMP_OPT)) {
                defTempReg = TempRegulation.defaultCalcTempTR();
            } else if (this.d_bcOptCombo.contains(NETFLUX_OPT)) {
                defTempReg = TempRegulation.defaultNetHeatFluxTR();
            } else if (this.d_bcOptCombo.contains(ADIABATIC_OPT)) {
                defTempReg = TempRegulation.defaultAdiabaticTR();
            } else if (this.d_bcOptCombo.contains(TOTALFLUX_OPT)) {
                defTempReg = TempRegulation.defaultFixedHeatFluxTR();
            } else assert (false);
            this.forceLoad(defTempReg);
            if (tr == null) {
                return;
            }
            this.forceLoad(tr);
        }

        private void forceLoad(TempRegulation tr) {
            if (tr.d_logarithmic) {
                this.d_logHTModelRb.setSelected(true);
            } else if (!tr.d_heatTransferCoef.isDefault()) {
                this.d_userHTModelRb.setSelected(true);
                this.d_htCoefVariant.init(tr.d_heatTransferCoef);
            } else {
                this.d_defaultHTModelRb.setSelected(true);
            }
            if (tr.isAdiabaticTR()) {
                this.d_bcOptCombo.setSelectedItem(ADIABATIC_OPT);
            } else if (tr.isNetHeatFluxTR()) {
                this.d_bcOptCombo.setSelectedItem(NETFLUX_OPT);
                this.d_netFlux.setValue(tr.d_thermalBCs.d_netHeatFlux);
                this.d_netRampEditor.loadFunction(tr.d_thermalBCs.d_netFluxRamp);
                this.d_emissivity.setValue(tr.d_thermalBCs.d_emissivity);
            } else if (tr.isGrossFluxTR()) {
                this.d_bcOptCombo.setSelectedItem(TOTALFLUX_OPT);
                this.d_surfaceTemp.setValue(tr.d_thermalBCs.d_temp);
                this.d_tempRampEditor.loadFunction(tr.d_thermalBCs.d_tempRamp);
                this.d_convFlux.setValue(tr.d_thermalBCs.d_convHeatFlux);
                this.d_convRampEditor.loadFunction(tr.d_thermalBCs.d_convFluxRamp);
                this.d_emissivity.setValue(tr.d_thermalBCs.d_emissivity);
            } else if (tr.isCalcTempTR()) {
                this.d_bcOptCombo.setSelectedItem(CALC_TEMP_OPT);
                this.d_emissivity.setValue(tr.d_thermalBCs.d_emissivity);
            } else if (tr.isFixedTempTR()) {
                this.d_bcOptCombo.setSelectedItem(FIXED_TEMP_OPT);
                this.d_surfaceTemp.setValue(tr.d_thermalBCs.d_temp);
                this.d_tempRampEditor.loadFunction(tr.d_thermalBCs.d_tempRamp);
                this.d_emissivity.setValue(tr.d_thermalBCs.d_emissivity);
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        public TempRegulation saveData() {
            Variant htCoef = Variant.def();
            if (this.d_userHTModelRb.isSelected()) {
                htCoef = this.d_htCoefVariant.getValue();
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(ADIABATIC_OPT)) {
                return TempRegulation.newAdiabaticTR(htCoef, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(FIXED_TEMP_OPT)) {
                return TempRegulation.newFixedTempTR((UnitDouble)this.d_surfaceTemp.getValue(), this.d_tempRampEditor.saveFunction(), (Double)this.d_emissivity.getValue(), htCoef, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(CALC_TEMP_OPT)) {
                return TempRegulation.newCalcTempTR((Double)this.d_emissivity.getValue(), htCoef, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(NETFLUX_OPT)) {
                return TempRegulation.newNetHeatFluxTR((UnitDouble)this.d_netFlux.getValue(), this.d_netRampEditor.saveFunction(), (Double)this.d_emissivity.getValue(), htCoef, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(TOTALFLUX_OPT)) {
                return TempRegulation.newFixedHeatFluxTR((UnitDouble)this.d_surfaceTemp.getValue(), this.d_tempRampEditor.saveFunction(), (UnitDouble)this.d_convFlux.getValue(), this.d_convRampEditor.saveFunction(), (Double)this.d_emissivity.getValue(), htCoef, this.d_logHTModelRb.isSelected());
            }
            return null;
        }
    }

    private class GeomPanel
    extends guiPanel {
        private static final long serialVersionUID = -4216547888912977493L;
        protected final guiComboBox d_geomCombo;
        protected final CardLayout d_cards;
        protected final guiPanel d_cardPanel;
        protected final guiPanel d_defaultCard;
        protected final guiPanel d_cartesianCard;
        protected final guiPanel d_sphereCard;
        protected final guiPanel d_cylinderCard;

        public GeomPanel() {
            this.setLayout(new GridBagLayout());
            this.d_geomCombo = new guiComboBox<Object>((T[])new Object[]{IGeometry.DEFAULT.getName(), IGeometry.CARTESIAN.getName(), IGeometry.SPHERICAL.getName(), IGeometry.CYLINDRICAL.getName()});
            this.d_defaultCard = new guiPanel();
            this.d_cartesianCard = new CartesianOptionPanel();
            this.d_sphereCard = new SphereOptionPanel();
            this.d_cylinderCard = new CylinderOptionPanel();
            this.d_cards = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_geomCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GeomPanel.this.d_cards.show(GeomPanel.this.d_cardPanel, (String)GeomPanel.this.d_geomCombo.getSelectedItem());
                }
            });
            this.d_cardPanel.add((Component)this.d_defaultCard, IGeometry.DEFAULT.getName());
            this.d_cardPanel.add((Component)this.d_cartesianCard, IGeometry.CARTESIAN.getName());
            this.d_cardPanel.add((Component)this.d_sphereCard, IGeometry.SPHERICAL.getName());
            this.d_cardPanel.add((Component)this.d_cylinderCard, IGeometry.CYLINDRICAL.getName());
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addRow(new guiLabel(Intl.intl("Geometry:")), this.d_geomCombo);
            gbh.addFilledRow(new guiSeparator());
            GridBagUtil.add(this, this.d_cardPanel, 0, 2, 2, 3, 12, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(IGeometry geom) {
            IGeometry.Default defGeom = IGeometry.DEFAULT;
            this.forceLoad(defGeom);
            if (geom == null) {
                return;
            }
            this.forceLoad(geom);
        }

        private void forceLoad(IGeometry geom) {
            if (geom instanceof IGeometry.Cartesian) {
                this.d_geomCombo.setSelectedItem(IGeometry.CARTESIAN.getName());
                ((CartesianOptionPanel)this.d_cartesianCard).loadGeometry((IGeometry.Cartesian)geom);
            } else if (geom instanceof IGeometry.Cylindrical) {
                this.d_geomCombo.setSelectedItem(IGeometry.CYLINDRICAL.getName());
                ((CylinderOptionPanel)this.d_cylinderCard).loadGeometry((IGeometry.Cylindrical)geom);
            } else if (geom instanceof IGeometry.Spherical) {
                this.d_geomCombo.setSelectedItem(IGeometry.SPHERICAL.getName());
                ((SphereOptionPanel)this.d_sphereCard).loadGeometry((IGeometry.Spherical)geom);
            } else {
                this.d_geomCombo.setSelectedItem(IGeometry.DEFAULT.getName());
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        public IGeometry saveData() {
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                return ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                return ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                return ((SphereOptionPanel)this.d_sphereCard).getGeometry();
            }
            return IGeometry.DEFAULT;
        }

        private class CartesianOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = -2887564389888201359L;
            private ValueField<UnitDouble> d_length;
            private ValueField<UnitDouble> d_width;
            private ValueField<UnitDouble> d_thickness;

            public CartesianOptionPanel() {
                super(new GridBagLayout());
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_width = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_thickness = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Length:")), this.d_length);
                gbh.addRow(new guiLabel(Intl.intl("Width:")), this.d_width);
                gbh.addRow(new guiLabel(Intl.intl("Half-Thickness:")), this.d_thickness);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cartesian((UnitDouble)this.d_length.getValue(), (UnitDouble)this.d_width.getValue(), (UnitDouble)this.d_thickness.getValue());
            }

            public void loadGeometry(IGeometry.Cartesian geom) {
                this.d_length.setValue(geom.length);
                this.d_width.setValue(geom.width);
                this.d_thickness.setValue(geom.thickness);
            }
        }

        private class SphereOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 6001552169751128600L;
            private ValueField<UnitDouble> d_radius;

            public SphereOptionPanel() {
                super(new GridBagLayout());
                this.d_radius = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Radius:")), this.d_radius);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Spherical(null, (UnitDouble)this.d_radius.getValue());
            }

            public void loadGeometry(IGeometry.Spherical geom) {
                this.d_radius.setValue(geom.radius);
            }
        }

        private class CylinderOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 80517855847721380L;
            private ValueField<UnitDouble> d_radius;
            private ValueField<UnitDouble> d_length;
            private guiCheckBox d_lengthCB;

            public CylinderOptionPanel() {
                super(new GridBagLayout());
                this.d_radius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_lengthCB = new guiCheckBox(Intl.intl("Length:"));
                LinkStatus.link((AbstractButton)this.d_lengthCB, this.d_length);
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Radius:")), this.d_radius);
                gbh.addRow(this.d_lengthCB, this.d_length);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cylindrical(null, (UnitDouble)this.d_radius.getValue(), this.getLength());
            }

            private Variant getLength() {
                return this.d_lengthCB.isSelected() ? Variant.constant((UnitDouble)this.d_length.getValue()) : Variant.DEFAULT;
            }

            public void loadGeometry(IGeometry.Cylindrical geom) {
                this.d_radius.setValue(geom.radius);
                if (geom.lengthVar.isDefault()) {
                    this.d_lengthCB.setSelected(false);
                } else {
                    this.d_lengthCB.setSelected(true);
                    this.d_length.setValue(geom.lengthVar.val);
                }
            }
        }
    }

    private class GeomPanelLayered
    extends guiPanel {
        private static final long serialVersionUID = -6304593908868597087L;
        protected final guiComboBox d_geomCombo;
        protected final CardLayout d_cards;
        protected final guiPanel d_cardPanel;
        protected final guiPanel d_defaultCard;
        protected final guiPanel d_cartesianCard;
        protected final guiPanel d_sphereCard;
        protected final guiPanel d_cylinderCard;
        private String d_selected;
        protected guiLabel d_thickLbl;

        public GeomPanelLayered() {
            this.setLayout(new GridBagLayout());
            this.d_geomCombo = new guiComboBox<Object>((T[])new Object[]{IGeometry.DEFAULT.getName(), IGeometry.CARTESIAN.getName(), IGeometry.SPHERICAL.getName(), IGeometry.CYLINDRICAL.getName()});
            this.d_thickLbl = new guiLabel();
            this.d_thickLbl.setFont(this.getFont().deriveFont(2));
            this.d_defaultCard = new guiPanel();
            this.d_cartesianCard = new CartesianOptionPanel();
            this.d_sphereCard = new SphereOptionPanel();
            this.d_cylinderCard = new CylinderOptionPanel();
            this.d_cards = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_geomCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GeomPanelLayered.this.d_cards.show(GeomPanelLayered.this.d_cardPanel, (String)GeomPanelLayered.this.d_geomCombo.getSelectedItem());
                    GeomPanelLayered.this.updateCardData();
                    GeomPanelLayered.this.updateThicknessLbl();
                }
            });
            this.d_selected = IGeometry.DEFAULT.getName();
            this.d_geomCombo.setSelectedItem(this.d_selected);
            this.d_cardPanel.add((Component)this.d_defaultCard, IGeometry.DEFAULT.getName());
            this.d_cardPanel.add((Component)this.d_cartesianCard, IGeometry.CARTESIAN.getName());
            this.d_cardPanel.add((Component)this.d_sphereCard, IGeometry.SPHERICAL.getName());
            this.d_cardPanel.add((Component)this.d_cylinderCard, IGeometry.CYLINDRICAL.getName());
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addRow(new guiLabel(Intl.intl("Geometry:")), this.d_geomCombo);
            gbh.addFilledRow(new guiSeparator());
            GridBagUtil.add(this, this.d_cardPanel, 0, 1, 2, 3, 12, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thickLbl, 0, 4, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void updateCardData() {
            if (this.d_selected.equals(IGeometry.CARTESIAN.getName())) {
                IGeometry cart = ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
                UnitDouble length = ((IGeometry.Cartesian)cart).length;
                ((CylinderOptionPanel)this.d_cylinderCard).setLength(length);
            } else if (this.d_selected.equals(IGeometry.SPHERICAL.getName())) {
                IGeometry sphere = ((SphereOptionPanel)this.d_sphereCard).getGeometry();
                UnitDouble innerRad = ((IGeometry.Spherical)sphere).innerRadius;
                ((CylinderOptionPanel)this.d_cylinderCard).setInnerRadius(innerRad);
            } else if (this.d_selected.equals(IGeometry.CYLINDRICAL.getName())) {
                IGeometry cylinder = ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                UnitDouble innerRad = ((IGeometry.Cylindrical)cylinder).innerRadius;
                Variant lengthVar = ((IGeometry.Cylindrical)cylinder).lengthVar;
                if (lengthVar.isConstant()) {
                    ((CartesianOptionPanel)this.d_cartesianCard).setLength((UnitDouble)lengthVar.val);
                }
                ((SphereOptionPanel)this.d_sphereCard).setInnerRadius(innerRad);
            }
            this.d_selected = (String)this.d_geomCombo.getSelectedItem();
        }

        public void updateThicknessLbl() {
            UnitDouble totalThickness = new UnitDouble(0.0, SurfacePanel.this.d_currentUS.getLengthUnit());
            DecimalFormat nf = new DecimalFormat("#,###,###,##0.000");
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.DEFAULT.getName())) {
                this.d_thickLbl.setText("");
            } else if (SurfacePanel.this.d_layersPanel.validateData(false, false)) {
                Pair<List<SurfComposition.SurfLayer>, Double> layerInfo = SurfacePanel.this.d_layersPanel.layerData();
                for (SurfComposition.SurfLayer layer : (List)layerInfo.v1) {
                    if (layer.d_thickness == null) continue;
                    totalThickness = totalThickness.add(layer.d_thickness);
                }
                if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Half-Thickness: %s"), totalThickness.format(nf)));
                } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                    geom = (IGeometry.Spherical)((SphereOptionPanel)this.d_sphereCard).getGeometry();
                    if (geom.innerRadius != null) {
                        totalThickness = totalThickness.add(geom.innerRadius);
                    }
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), totalThickness.format(nf)));
                } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                    geom = (IGeometry.Cylindrical)((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                    if (((IGeometry.Cylindrical)geom).innerRadius != null) {
                        totalThickness = totalThickness.add(((IGeometry.Cylindrical)geom).innerRadius);
                    }
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), totalThickness.format(nf)));
                }
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                this.d_thickLbl.setText(String.format(Intl.intl("Total Thickness: %s"), totalThickness.format(nf)));
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                IGeometry.Spherical geom = (IGeometry.Spherical)((SphereOptionPanel)this.d_sphereCard).getGeometry();
                this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), geom.innerRadius.format(nf)));
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                IGeometry.Cylindrical geom = (IGeometry.Cylindrical)((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), geom.innerRadius.format(nf)));
            }
            this.repaint();
        }

        public void loadData(IGeometry geom) {
            IGeometry.Default defGeom = IGeometry.DEFAULT;
            this.forceLoad(defGeom);
            if (geom == null) {
                return;
            }
            this.forceLoad(geom);
        }

        private void forceLoad(IGeometry geom) {
            if (geom instanceof IGeometry.Cartesian) {
                this.d_selected = IGeometry.CARTESIAN.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((CartesianOptionPanel)this.d_cartesianCard).loadGeometry((IGeometry.Cartesian)geom);
            } else if (geom instanceof IGeometry.Cylindrical) {
                this.d_selected = IGeometry.CYLINDRICAL.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((CylinderOptionPanel)this.d_cylinderCard).loadGeometry((IGeometry.Cylindrical)geom);
            } else if (geom instanceof IGeometry.Spherical) {
                this.d_selected = IGeometry.SPHERICAL.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((SphereOptionPanel)this.d_sphereCard).loadGeometry((IGeometry.Spherical)geom);
            } else {
                this.d_selected = IGeometry.DEFAULT.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        public IGeometry saveData() {
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                return ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                return ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                return ((SphereOptionPanel)this.d_sphereCard).getGeometry();
            }
            return IGeometry.DEFAULT;
        }

        private class CartesianOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 579132339706118256L;
            private ValueField<UnitDouble> d_length;
            private ValueField<UnitDouble> d_width;

            public CartesianOptionPanel() {
                super(new GridBagLayout());
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_width = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Length:")), this.d_length);
                gbh.addRow(new guiLabel(Intl.intl("Width:")), this.d_width);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cartesian((UnitDouble)this.d_length.getValue(), (UnitDouble)this.d_width.getValue());
            }

            public void loadGeometry(IGeometry.Cartesian geom) {
                this.d_length.setValue(geom.length);
                this.d_width.setValue(geom.width);
            }

            public void setLength(UnitDouble length) {
                this.d_length.setValue(length);
            }
        }

        private class SphereOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = -6509577654014076105L;
            private ValueField<UnitDouble> d_innerRadius;

            public SphereOptionPanel() {
                super(new GridBagLayout());
                this.d_innerRadius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_innerRadius.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                    }
                });
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Inner Radius:")), this.d_innerRadius);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Spherical((UnitDouble)this.d_innerRadius.getValue(), null);
            }

            public void loadGeometry(IGeometry.Spherical geom) {
                this.d_innerRadius.setValue(geom.innerRadius);
            }

            public void setInnerRadius(UnitDouble rad) {
                this.d_innerRadius.setValue(rad);
            }
        }

        private class CylinderOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 6780542549225340270L;
            private ValueField<UnitDouble> d_innerRadius;
            private ValueField<UnitDouble> d_length;
            private guiCheckBox d_lengthCB;

            public CylinderOptionPanel() {
                super(new GridBagLayout());
                this.d_innerRadius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_innerRadius.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                    }
                });
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_lengthCB = new guiCheckBox(Intl.intl("Length"));
                LinkStatus.link((AbstractButton)this.d_lengthCB, this.d_length);
                GridBagHelper gbh = new GridBagHelper(this, false);
                gbh.addRow(new guiLabel(Intl.intl("Inner Radius:")), this.d_innerRadius);
                gbh.addRow(this.d_lengthCB, this.d_length);
                gbh.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cylindrical((UnitDouble)this.d_innerRadius.getValue(), null, this.getLength());
            }

            private Variant getLength() {
                return this.d_lengthCB.isSelected() ? Variant.constant((UnitDouble)this.d_length.getValue()) : Variant.DEFAULT;
            }

            public void loadGeometry(IGeometry.Cylindrical geom) {
                this.d_innerRadius.setValue(geom.innerRadius);
                if (geom.lengthVar.isDefault()) {
                    this.d_lengthCB.setSelected(false);
                } else {
                    this.d_lengthCB.setSelected(true);
                    this.d_length.setValue(geom.lengthVar.val);
                }
            }

            public void setInnerRadius(UnitDouble rad) {
                this.d_innerRadius.setValue(rad);
            }

            public void setLength(UnitDouble length) {
                this.d_length.setValue(length);
            }
        }
    }

    private static interface IAirflowConfig
    extends IPanelConfig<AirFlowPanel> {
        public boolean supportTotalMassFlux();
    }

    private static interface IPanelConfig<T> {
    }

    private static class BackingEditor
    extends guiComboBox<String> {
        private static final long serialVersionUID = 1275890324314380067L;
        private static final String AIR_GAP = Intl.intl("Air Gap");
        private static final String EXPOSED = Intl.intl("Exposed");
        private static final String INSULATED = Intl.intl("Insulated");
        public final guiLabel d_airTempLab;
        public final ValueField<UnitDouble> d_airTempFld;
        public final TimeFunctionEditor d_backTempRampEditor;
        private int d_timeFuncOpts = 17;

        public BackingEditor(UnitSystem currentUS) {
            super((T[])new String[]{AIR_GAP, EXPOSED, INSULATED});
            this.setMinimumSize(this.getPreferredSize());
            this.d_airTempLab = new guiLabel(Intl.intl("Gap Temperature:"));
            this.d_airTempFld = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_airTempFld.setMinimumSize(this.d_airTempFld.getPreferredSize());
            this.d_backTempRampEditor = new TimeFunctionEditor(Intl.intl("Ramp-Up Time"), this.d_timeFuncOpts);
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.updateVisibility();
                }
            });
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            this.updateVisibility();
        }

        public void updateVisibility() {
            boolean visible = this.getSelectedItem() == AIR_GAP;
            this.d_airTempLab.setVisible(visible);
            this.d_airTempFld.setVisible(visible);
            this.d_backTempRampEditor.setVisible(visible);
        }

        public Backing getBacking() {
            String sel = (String)this.getSelectedItem();
            if (sel == AIR_GAP) {
                TimeFunction<?> rateRampup = this.d_backTempRampEditor.saveFunction();
                return new Backing.AirGap((UnitDouble)this.d_airTempFld.getValue(), rateRampup);
            }
            if (sel == EXPOSED) {
                return Backing.EXPOSED;
            }
            return Backing.INSULATED;
        }

        public void setBacking(Backing backing) {
            if (backing == null) {
                return;
            }
            if (backing instanceof Backing.AirGap) {
                this.setSelectedItem(AIR_GAP);
                this.d_airTempFld.setValue(new Backing.AirGap().d_airTemp);
                Backing.AirGap b = (Backing.AirGap)backing;
                this.d_airTempFld.setValue(((Backing.AirGap)backing).d_airTemp);
                this.d_backTempRampEditor.loadFunction(b.d_airTempRamp);
            } else if (backing instanceof Backing.Exposed) {
                this.setSelectedItem(EXPOSED);
            } else {
                this.setSelectedItem(INSULATED);
            }
        }
    }

    private static class ZonePathPanel
    extends guiPanel {
        private static final long serialVersionUID = 8086116205197119986L;
        private final ZoneComboBox d_zone1;
        private final ZoneComboBox d_zone2;
        private final Component d_label;

        public ZonePathPanel(String label, boolean disableable) {
            super(new GridBagLayout());
            ZoneMgr zones = PyroSim.getApp().getMediator().getZoneMgr();
            this.d_zone1 = new ZoneComboBox(zones);
            this.d_zone2 = new ZoneComboBox(zones);
            this.d_label = disableable ? new guiCheckBox(label) : new guiLabel(label);
            guiLabel connectorLbl = new guiLabel("<->");
            if (disableable) {
                LinkStatus.link((AbstractButton)((guiCheckBox)this.d_label), this.d_zone1, this.d_zone2, connectorLbl);
            }
            GridBagUtil.add(this, this.d_label, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_zone1, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, connectorLbl, 2, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_zone2, 3, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void loadData(ZonePath path) {
            if (this.d_label instanceof guiCheckBox) {
                ((guiCheckBox)this.d_label).setSelected(path != null);
            }
            if (path == null) {
                this.d_zone1.setSelectedIndex(-1);
                this.d_zone2.setSelectedIndex(-1);
                return;
            }
            Zone[] zones = path.getZones();
            this.d_zone1.setSelectedItem(zones[0]);
            this.d_zone2.setSelectedItem(zones[1]);
        }

        public ZonePath saveData() {
            if (this.d_label instanceof guiCheckBox && !((guiCheckBox)this.d_label).isSelected()) {
                return null;
            }
            return new ZonePath((Zone)this.d_zone1.getSelectedItem(), (Zone)this.d_zone2.getSelectedItem());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.isEnabled() || this.d_label instanceof guiCheckBox && !((guiCheckBox)this.d_label).isSelected()) {
                return true;
            }
            Zone zone1 = (Zone)this.d_zone1.getSelectedItem();
            Zone zone2 = (Zone)this.d_zone2.getSelectedItem();
            if (zone1 != null && zone2 != null && zone1 == zone2) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("The selected zones must be different."), Intl.intl("Invalid Zones"), 0);
                }
                return false;
            }
            return true;
        }

        public boolean validateLeakage(boolean showWarn, boolean allowModify) {
            int sel;
            Leak leak;
            ZonePath path = this.saveData();
            if (path == null) {
                return true;
            }
            Zone[] zones = path.getZones();
            Zone zone1 = zones[0];
            Zone zone2 = zones[1];
            return zone1 == null || zone2 == null || !showWarn || (leak = LeakUtil.getLeak(PyroSim.getApp().getMediator(), zone1, zone2)) != null || (sel = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("No leakage area has been specified between zones %1$s and %2$s.\nWould you still like to save this leakage path?"), zone1.getName(), zone2.getName()), Intl.intl("Warning"), 0, 2)) == 0;
        }
    }

    private class HRPanel
    extends guiPanel {
        private static final long serialVersionUID = -6586194214395766727L;
        private JRadioButton d_hrrpuaRB;
        private JRadioButton d_mlrpuaRB;
        private ValueField<UnitDouble> d_hrrpua;
        private ValueField<UnitDouble> d_mlrpua;
        private ValueField<UnitDouble> d_extCoeff;
        private final TimeFunctionEditor d_RampTimeEditor;

        public HRPanel(String title) {
            this.setLayout(new GridBagLayout());
            int row = 0;
            TitleSeparator velocityTitle = new TitleSeparator(title);
            GridBagUtil.add(this, velocityTitle, 0, row++, 0, 1, 12, 12, 6, 0, 2, 1.0, 0.0, 17);
            this.d_hrrpuaRB = new JRadioButton(Intl.intl("Heat Release Rate Per Area (HRRPUA)") + ":");
            this.d_hrrpuaRB.setToolTipText("HRRPUA");
            this.d_hrrpua = ValueFields.udFld(UnitSystem.getSource(22));
            GridBagUtil.add(this, this.d_hrrpuaRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hrrpua, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_mlrpuaRB = new JRadioButton(Intl.intl("Mass Loss Rate") + ":");
            this.d_mlrpuaRB.setToolTipText("MLRPUA");
            this.d_mlrpua = ValueFields.udFld(UnitSystem.getSource(44));
            GridBagUtil.add(this, this.d_mlrpuaRB, 0, row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_mlrpua, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_RampTimeEditor = SurfacePanel.this.newTimeFuncEditor();
            this.d_RampTimeEditor.addToPanel(this, 0, row, 0, 30, 6, 12);
            guiLabel extCoeffLab = new guiLabel(Intl.intl("Extinguishing Coefficient") + ":");
            extCoeffLab.setToolTipText("E_COEFFICIENT");
            this.d_extCoeff = ValueFields.udFld(UnitSystem.getSource(21));
            GridBagUtil.add(this, extCoeffLab, 0, ++row, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_extCoeff, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            this.d_hrrpuaRB.setSelected(true);
            this.d_mlrpua.setEnabled(false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_hrrpuaRB);
            group.add(this.d_mlrpuaRB);
            ItemListener rbChangeListener = e -> {
                this.setModified(true);
                this.getComm().touch(e);
            };
            this.d_hrrpuaRB.addItemListener(rbChangeListener);
            this.d_mlrpuaRB.addItemListener(rbChangeListener);
            LinkStatus.link((AbstractButton)this.d_mlrpuaRB, this.d_mlrpua);
            LinkStatus.link((AbstractButton)this.d_hrrpuaRB, this.d_hrrpua);
        }

        public void loadData(HeatRelease hr) {
            this.d_hrrpuaRB.setSelected(true);
            this.d_hrrpua.setValue(new HeatRelease.HRRType().val);
            this.d_mlrpua.setValue(new HeatRelease.MLRType().val);
            this.d_extCoeff.setValue(new HeatRelease().d_extingCoeff);
            if (hr == null) {
                return;
            }
            if (hr.d_type instanceof HeatRelease.HRRType) {
                this.d_hrrpuaRB.setSelected(true);
                this.d_hrrpua.setValue(hr.d_type.val);
            } else {
                this.d_mlrpuaRB.setSelected(true);
                this.d_mlrpua.setValue(hr.d_type.val);
            }
            this.d_RampTimeEditor.loadFunction(hr.d_type.func);
            this.d_extCoeff.setValue(hr.d_extingCoeff);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_RampTimeEditor.validateData(showWarn, allowModify);
        }

        public HeatRelease saveData() {
            TimeFunction<?> rateRampup = this.d_RampTimeEditor.saveFunction();
            if (this.d_hrrpuaRB.isSelected()) {
                return new HeatRelease(new HeatRelease.HRRType((UnitDouble)this.d_hrrpua.getValue(), rateRampup), (UnitDouble)this.d_extCoeff.getValue());
            }
            return new HeatRelease(new HeatRelease.MLRType((UnitDouble)this.d_mlrpua.getValue(), rateRampup), (UnitDouble)this.d_extCoeff.getValue());
        }
    }

    private static class SlipData {
        private final String FREE_SLIP = Intl.intl("Free Slip");
        private final String NO_SLIP = Intl.intl("No Slip");
        private final String ROUGH_SLIP = Intl.intl("Default Slip");
        private final guiComboBox<String> d_slipCB = new guiComboBox<Object>((T[])new Object[]{this.ROUGH_SLIP, this.FREE_SLIP, this.NO_SLIP});
        private final guiLabel d_roughnessLbl = new guiLabel(Intl.intl("Roughness:"));
        private final ValueField<UnitDouble> d_roughnessFld = ValueFields.udFld(UnitSystem.getSource(0));

        public SlipData() {
            this.d_slipCB.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateRoughVis();
                }
            });
            this.updateRoughVis();
        }

        private void updateRoughVis() {
            boolean vis = this.d_slipCB.getSelectedItem() == this.ROUGH_SLIP;
            this.d_roughnessLbl.setVisible(vis);
            this.d_roughnessFld.setVisible(vis);
        }

        public void add(GridBagHelper gb) {
            gb.addRow(Intl.intl("Tangential Boundary Condition:"), this.d_slipCB, this.d_roughnessLbl, this.d_roughnessFld, 1.0);
        }

        public void loadData(ISlip slip) {
            this.d_roughnessFld.setValue(new UnitDouble(0.0, SI.METER));
            if (slip instanceof ISlip.FreeSlip) {
                this.d_slipCB.setSelectedItem(this.FREE_SLIP);
            } else if (slip instanceof ISlip.NoSlip) {
                this.d_slipCB.setSelectedItem(this.NO_SLIP);
            } else if (slip instanceof ISlip.RoughSlip) {
                this.d_slipCB.setSelectedItem(this.ROUGH_SLIP);
                ISlip.RoughSlip rs = (ISlip.RoughSlip)slip;
                this.d_roughnessFld.setValue(rs.roughness);
            }
        }

        public ISlip saveData() {
            String selItem = this.d_slipCB.getSelectedItem();
            if (selItem == this.FREE_SLIP) {
                return ISlip.FREE_SLIP;
            }
            if (selItem == this.NO_SLIP) {
                return ISlip.NO_SLIP;
            }
            if (selItem == this.ROUGH_SLIP) {
                return new ISlip.RoughSlip((UnitDouble)this.d_roughnessFld.getValue());
            }
            assert (false);
            return null;
        }
    }
}

