/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.boundcond.NewSurfaceDlg;
import pyrosim.gui.boundcond.SurfacePanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SurfaceManagerDlg
extends ManagerDlg<Surface, SurfaceManager> {
    private static final long serialVersionUID = -4241798481548645763L;
    private final Action[] d_actions;
    private final IEditor<Surface> d_editor;
    private SurfaceManager d_surfMgr;
    private JFrame d_owner;

    public SurfaceManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Surfaces"), true);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, Surface.class), new RenameAction<Surface, SurfaceManager>(this, Intl.intl("surface")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new SurfacePanel(this);
    }

    private void updateActions() {
        boolean isPreDef;
        int selIx = this.getList().getSelectedIx();
        if (selIx > -1) {
            Surface s = (Surface)this.getList().getItem(selIx);
            isPreDef = s.isPredefined();
        } else {
            isPreDef = false;
        }
        this.d_actions[0].setEnabled(this.d_surfMgr != null);
        this.d_actions[1].setEnabled(this.d_surfMgr != null);
        this.d_actions[2].setEnabled(this.d_surfMgr != null && selIx > -1 && !isPreDef);
        this.d_actions[3].setEnabled(this.d_surfMgr != null && selIx > -1 && !isPreDef);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(SurfaceManager surfMgr, Surface selSurf) {
        this.d_surfMgr = surfMgr;
        ((RenameAction)this.d_actions[2]).init(surfMgr);
        super.init(this.d_surfMgr, this.d_editor, this.d_actions, selSurf);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -4464281587526765803L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SurfaceManagerDlg.this.preSave()) {
                return;
            }
            int selIx = SurfaceManagerDlg.this.getList().getSelectedIx();
            Surface surf = selIx >= 0 ? (Surface)SurfaceManagerDlg.this.getList().getItem(selIx) : null;
            NewSurfaceDlg dlg = new NewSurfaceDlg((Window)SurfaceManagerDlg.this, SurfaceManagerDlg.this.d_surfMgr, surf);
            PyroMod domain = (PyroMod)SurfaceManagerDlg.this.d_surfMgr.getDomain();
            if (dlg.doModal() == 1) {
                Surface base = dlg.getBaseMat();
                if (base == null) {
                    base = SurfaceManagerDlg.this.d_surfMgr.get(PredefSurf.INERT);
                }
                Surface newSurface = new Surface(dlg.getName(), base.getColor(), base.getAppearance(), base.getSurfDesc());
                newSurface.setCustomFDSProps(base.getCustomFDSProps());
                AddTask t = new AddTask((IPyroObject)SurfaceManagerDlg.this.d_surfMgr, new IPyroObject[]{newSurface});
                SelectTask wrapper = new SelectTask(domain, newSurface);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Surface"));
                SurfaceManagerDlg.this.getList().updateModelView(SurfaceManagerDlg.this.d_surfMgr);
                SurfaceManagerDlg.this.getList().select(newSurface);
                SurfaceManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SurfaceManagerDlg.this.updateActions();
            }
        }
    }
}

