/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sourceforge.jeuclid.swing.JMathComponent;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;

public class SolidPyrolysisReacDlg
extends guiDialog {
    private static final long serialVersionUID = 3098408654232113512L;
    private final RatePanel d_ratePanel;
    private final MaterialPanel.ByproductsPanel d_byproductsPanel;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();

    public SolidPyrolysisReacDlg(String title, MaterialPanel.ByproductsPanel byproductsPanel) {
        super((Window)Application.getApp().getActiveFrame(), title, 9);
        this.d_byproductsPanel = byproductsPanel;
        guiPanel dlgPanel = this.getDialogPane();
        JTabbedPane tabs = new JTabbedPane();
        dlgPanel.add(tabs);
        this.d_ratePanel = new RatePanel();
        tabs.addTab(Intl.intl("Rate"), this.d_ratePanel);
        tabs.addTab(Intl.intl("Byproducts"), this.d_byproductsPanel);
    }

    public void loadByproducts(ReacByproducts rb, Material currentMat) {
        this.d_byproductsPanel.loadData(rb, currentMat);
    }

    public ReacByproducts saveByproducts() {
        return this.d_byproductsPanel.saveData();
    }

    public void loadRate(SolidReaction.Rate rate) {
        this.d_ratePanel.loadData(rate);
    }

    public SolidReaction.Rate saveRate() {
        return this.d_ratePanel.saveData();
    }

    private class RatePanel
    extends guiPanel {
        private static final long serialVersionUID = -7797851926745888581L;
        private final guiRadioButton d_aNeRB;
        private final guiRadioButton d_rateNtempRB;
        private final ValueField<UnitDouble> d_a;
        private final ValueField<UnitDouble> d_e;
        private final ValueField<UnitDouble> d_temp;
        private final ValueField<UnitDouble> d_heatingRate;
        private final ValueField<UnitDouble> d_pyrolysisRange;
        private final ValueField<UnitDouble> d_thresholdValue;
        private final ValueField<Double> d_massFracExp;
        private final ValueField<Double> d_thresholdTempExp;

        public RatePanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_aNeRB = new guiRadioButton(Intl.intl("Specify A and E"));
            this.d_aNeRB.setSelected(true);
            this.d_rateNtempRB = new guiRadioButton(Intl.intl("Match rate curve") + ":");
            guiLabel tempLbl = new guiLabel(Intl.intl("Reference Temperature") + ":");
            this.d_temp = ValueFields.udFld(UnitSystem.getSource(1));
            guiLabel heatingRateLbl = new guiLabel(Intl.intl("Heating Rate") + ":");
            this.d_heatingRate = ValueFields.udFld(UnitSystem.getSource(74));
            guiLabel pyroRangeLbl = new guiLabel(Intl.intl("Pyrolysis Range") + ":");
            this.d_pyrolysisRange = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_a = ValueFields.udFld(UnitSystem.getSource(50));
            guiLabel aLab = new guiLabel(Intl.intl("A (Pre-exponential Factor)") + ":");
            this.d_e = ValueFields.udFld(UnitSystem.getSource(54));
            guiLabel eLab = new guiLabel(Intl.intl("E (Activation Energy)") + ":");
            guiLabel massFracLab = new guiLabel(Intl.intl("<html>Mass Fraction Exponent (n<sub>s</sub>):</html>"));
            this.d_massFracExp = ValueFields.doubleFld();
            guiLabel ignExpLab = new guiLabel(Intl.intl("<html>Exponent (n<sub>t</sub>):</html>"));
            this.d_thresholdTempExp = ValueFields.doubleFld();
            final guiLabel ignValueLab = new guiLabel(Intl.intl("<html>Value (T<sub>thr</sub>):</html>"));
            this.d_thresholdValue = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_thresholdValue.setNullAllowed(true);
            JMathComponent equation = new JMathComponent(){
                private static final long serialVersionUID = -1752303893278533470L;

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    return new Dimension(d.width, d.height + 10);
                }
            };
            TitleSeparator ignTitle = new TitleSeparator(Intl.intl("Threshold Temperature"));
            GridBagUtil.add(this, equation, 0, row++, 5, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_rateNtempRB, 0, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, tempLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_temp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, heatingRateLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatingRate, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, pyroRangeLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_pyrolysisRange, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_aNeRB, 0, row++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, aLab, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_a, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, eLab, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_e, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, massFracLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFracExp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, ignTitle, 0, row++, 2, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, ignExpLab, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thresholdTempExp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, ignValueLab, 0, row, 1, 1, 0, 30, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thresholdValue, 1, row++, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
            this.d_thresholdTempExp.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent arg0) {
                    try {
                        if (RatePanel.this.d_thresholdTempExp.validateData(false, false)) {
                            double x = (Double)RatePanel.this.d_thresholdTempExp.getValue();
                            boolean valid = x != 0.0;
                            ignValueLab.setEnabled(valid);
                            RatePanel.this.d_thresholdValue.setEnabled(valid);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_aNeRB);
            group.add(this.d_rateNtempRB);
            LinkStatus.link((AbstractButton)this.d_aNeRB, aLab, this.d_a, eLab, this.d_e);
            LinkStatus.link((AbstractButton)this.d_rateNtempRB, tempLbl, this.d_temp, heatingRateLbl, this.d_heatingRate, pyroRangeLbl, this.d_pyrolysisRange);
            SolidReaction.Rate defRate = new SolidReaction.Rate();
            this.d_massFracExp.setValue(defRate.d_massFracExponent);
            this.d_thresholdTempExp.setValue(defRate.d_tempExponent);
            this.d_thresholdValue.setValue(defRate.d_thresholdTemp);
            this.d_a.setValue(new SolidReaction.Rate.AESpec().d_a);
            this.d_e.setValue(new SolidReaction.Rate.AESpec().d_e);
            this.d_temp.setValue(new SolidReaction.Rate.RefSpec().d_refTemp);
            this.d_heatingRate.setValue(new SolidReaction.Rate.RefSpec().d_heatingRate);
            this.d_pyrolysisRange.setValue(new SolidReaction.Rate.RefSpec().d_pyrolysisRange);
            if (defRate.d_spec instanceof SolidReaction.Rate.AESpec) {
                this.d_aNeRB.setSelected(true);
            } else {
                this.d_rateNtempRB.setSelected(true);
            }
            String A = "<mstyle mathcolor=\"blue\"><mo>A</mo></mstyle>";
            String E = "<mrow><mo>-</mo><mstyle mathcolor=\"blue\"><mo>E</mo></mstyle><mo> </mo></mrow>";
            String massFracN = "<mstyle mathcolor=\"blue\"><msub><mo>n</mo><mo>s</mo></msub></mstyle>";
            String masFrac = "<mfenced><mfrac><msub><mi>&#961;</mi><mrow><mo>s,i</mo></mrow></msub><msub><mi>&#961;</mi><mrow><mo>s0</mo></mrow></msub></mfrac></mfenced>";
            String massFracWexp = "<msup>" + masFrac + massFracN + "</msup>";
            String exponent = "<mrow><mo>exp</mo><mfenced><mrow><mfrac>" + E + "<msub><mo>RT</mo><mo>s</mo></msub></mfrac></mrow></mfenced></mrow>";
            String ignTemp = "<mstyle mathcolor=\"blue\"><msub><mo>T</mo><mo>thr</mo></msub></mstyle>";
            String ignTempN = "<mstyle mathcolor=\"blue\"><msub><mo>n</mo><mo>t</mo></msub></mstyle>";
            String max = "<mrow><mo>max</mo><msup><mfenced open=\"[\" close=\"]\"><mo>0</mo><mrow><msub><mo>T</mo><mo>s</mo></msub><mo>-</mo>" + ignTemp + "</mrow></mfenced>" + ignTempN + "</msup></mrow>";
            equation.setContent("<mstyle mathsize=\"8mm\"><mrow>" + massFracWexp + A + exponent + max + "</mrow></mstyle>");
        }

        public void loadData(SolidReaction.Rate rate) {
            this.d_massFracExp.setValue(rate.d_massFracExponent);
            this.d_thresholdTempExp.setValue(rate.d_tempExponent);
            if (rate.d_tempExponent != 0.0) {
                this.d_thresholdValue.setValue(rate.d_thresholdTemp);
            }
            if (rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                this.d_aNeRB.setSelected(true);
                this.d_a.setValue(((SolidReaction.Rate.AESpec)rate.d_spec).d_a);
                this.d_e.setValue(((SolidReaction.Rate.AESpec)rate.d_spec).d_e);
            } else {
                SolidReaction.Rate.RefSpec spec = (SolidReaction.Rate.RefSpec)rate.d_spec;
                this.d_rateNtempRB.setSelected(true);
                this.d_heatingRate.setValue(spec.d_heatingRate);
                this.d_pyrolysisRange.setValue(spec.d_pyrolysisRange);
                this.d_temp.setValue(spec.d_refTemp);
            }
        }

        public SolidReaction.Rate saveData() {
            SolidReaction.Rate.ISpecification spec = this.d_aNeRB.isSelected() ? new SolidReaction.Rate.AESpec((UnitDouble)this.d_a.getValue(), (UnitDouble)this.d_e.getValue()) : new SolidReaction.Rate.RefSpec((UnitDouble)this.d_temp.getValue(), (UnitDouble)this.d_pyrolysisRange.getValue(), (UnitDouble)this.d_heatingRate.getValue());
            UnitDouble ignValue = null;
            if (this.d_thresholdValue.isEnabled()) {
                ignValue = (UnitDouble)this.d_thresholdValue.getValue();
            }
            return new SolidReaction.Rate((Double)this.d_massFracExp.getValue(), (Double)this.d_thresholdTempExp.getValue(), ignValue, spec);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_thresholdValue.isEnabled() && this.d_thresholdValue.getValue() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Threshold temperature value must be specified."));
                }
                return false;
            }
            return true;
        }
    }
}

