/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckManager;
import pyrosim.domain.auditing.ModelWarning;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.WarningReport;

public class RunModelCheckDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final PyroMod d_pyroMod;
    private static final Logger LOGGER = Logger.getLogger(RunModelCheckDlg.class.getName());

    public RunModelCheckDlg(Window owner, PyroMod pyroMod) {
        super(owner, Intl.intl("Model Check Results"), 16);
        this.d_pyroMod = pyroMod;
        this.setPreferredSize(new Dimension(900, 500));
        this.setSize(new Dimension(500, 300));
    }

    public void process() {
        ModelCheckManager modelCheckManager = this.d_pyroMod.getModelCheckMgr();
        List<ModelCheck> modelChecks = ((APyroObject)modelCheckManager).flatten(ModelCheck.class).stream().filter(mc -> mc.isEnabled()).collect(Collectors.toList());
        this.startChecksTask(modelChecks);
    }

    private WarningDlg<ModelWarning> createWarningDlg(WarningReport<ModelWarning> report) {
        WarningDlg<ModelWarning> warningDlg = new WarningDlg<ModelWarning>(PyroSim.getApp().getActiveFrame(), Intl.intl("Model Check Results"), null, report, 16, WarningDlg.Severity.INFO);
        JButton resetToSelectedBtn = new JButton(Intl.intl("Show Selected Objects"));
        resetToSelectedBtn.setToolTipText(Intl.intl("Reset the view to the objects that may have caused the problems."));
        BiConsumer<List, ActionEvent> selectObjs = (objs, e) -> SwingUtilities.invokeLater(() -> {
            this.d_pyroMod.pauseUpdates();
            try {
                this.d_pyroMod.getTaskManager().exec(new SelectTask(this.d_pyroMod, (Collection<?>)objs), Intl.intl("Select Warnings"));
                ModelView mv = PyroSim.getApp().getModelView();
                ModelView.ResetToSelectedObjectsAction action = mv.getResetToSelectedAction();
                ((guiAction)action).actionPerformed((ActionEvent)e);
            }
            finally {
                this.d_pyroMod.resumeUpdates();
            }
        });
        resetToSelectedBtn.addActionListener(e -> {
            List warnings = warningDlg.getSelectedWarnings();
            if (warnings.isEmpty()) {
                JOptionPane.showMessageDialog(warningDlg, Intl.intl("Select at least one row first."), Intl.intl("Select a Row"), 2);
                return;
            }
            List objs = warnings.stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
            if (objs.isEmpty()) {
                JOptionPane.showMessageDialog(warningDlg, Intl.intl("There are no objects associated with the selected rows."), Intl.intl("No Objects"), 2);
                return;
            }
            selectObjs.accept(objs, e);
        });
        warningDlg.getActionPanel().add((Component)resetToSelectedBtn, 0);
        final IEventObserver cancelObserver = events -> {
            IEventRecord<IPyroObject> oevts = events.getEvents(IPyroObject.class, new Class[0]);
            if (oevts.hasRemovedObjs()) {
                Set<IPyroObject> removed = oevts.getRemovedObjs();
                warningDlg.removeIf(err -> err.causeObjs.stream().anyMatch(removed::contains));
            }
        };
        this.d_pyroMod.getEvents().addObserver(cancelObserver);
        resetToSelectedBtn.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RunModelCheckDlg.this.d_pyroMod.getEvents().removeObserver(cancelObserver);
            }
        });
        this.getContentPane().remove(this.getDialogPane());
        int width = Integer.min(warningDlg.getDialogPane().getPreferredSize().width, this.getPreferredSize().width);
        this.setSize(width, warningDlg.getDialogPane().getPreferredSize().height);
        this.setLocationRelativeTo(this.getParent());
        warningDlg.getTable().setAutoResizeMode(4);
        this.getContentPane().add(warningDlg.getDialogPane());
        return warningDlg;
    }

    private WarningReport<ModelWarning> createWarningReport() {
        return new WarningReport<ModelWarning>(ModelWarning.class, new int[]{1, 0, 2, 3}, new String[]{Intl.intl("Name"), Intl.intl("Result"), Intl.intl("Description"), Intl.intl("Objects")}, 0);
    }

    private void startChecksTask(List<ModelCheck> modelChecks) {
        WarningReport<ModelWarning> warningReport = this.createWarningReport();
        WarningDlg<ModelWarning> warningDlg = this.createWarningDlg(warningReport);
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setMax(modelChecks.size());
        guiProgressMonitor progMon = new guiProgressMonitor(this.getOwner(), Intl.intl("Running Model Checks..."), true, taskProgress);
        guiProgressMonitor.PMRunnable checksTask = () -> {
            try (PyroMod.Lock lock = this.d_pyroMod.beginRead();){
                this.runModelChecks(warningReport, modelChecks, taskProgress, warningDlg);
            }
            catch (CancellationException e) {
                LOGGER.log(Level.INFO, "Model Checks task cancelled.");
            }
        };
        try {
            progMon.exec(checksTask);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.WARNING, "Model Checks task failed.");
        }
    }

    private void runModelChecks(WarningReport<ModelWarning> warningReport, List<ModelCheck> modelChecks, TaskProgress taskProgress, WarningDlg<?> warningDlg) throws CancellationException {
        for (int i = 0; i < modelChecks.size(); ++i) {
            taskProgress.check();
            ModelCheck modelCheck = modelChecks.get(i);
            taskProgress.setProgress(i);
            String msg = modelCheck.getName().length() > 35 ? String.format("%s \u2026", modelCheck.getName().substring(0, 31)) : modelCheck.getName();
            taskProgress.setMessage(msg);
            Collection<ModelWarning> warnings = modelCheck.getModelWarnings(this.d_pyroMod);
            for (ModelWarning warning : warnings) {
                warningReport.addWarning(warning);
            }
            warningDlg.refresh();
        }
        taskProgress.setProgress(modelChecks.size());
        taskProgress.setMessage("");
        LOGGER.log(Level.INFO, warningReport.prepareReport());
        LOGGER.log(Level.INFO, "Model Checks task finished.");
    }
}

