/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import pyrosim.Intl;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckFilter;
import pyrosim.domain.auditing.RecordCheckDesc;
import pyrosim.domain.auditing.ResultContainsCondition;
import pyrosim.domain.auditing.ResultsEmptyCondition;
import pyrosim.gui.auditing.ICheckRenderer;
import pyrosim.gui.auditing.ModelCheckEditor;
import pyrosim.gui.auditing.ModelFilterTable;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTableEditor;

public class RecordCheckRenderer
implements ICheckRenderer {
    private final guiRadioButton d_matchingRecordsFail;
    private final guiRadioButton d_matchingRecordsPass;
    private final guiLabel d_checkConditionLabel = new guiLabel(Intl.intl("Check Condition:"));
    private final guiLabel d_tableLabel;
    private final ModelFilterTable d_table;
    private final guiTableEditor d_tableEditor;

    RecordCheckRenderer() {
        this.d_checkConditionLabel.setToolTipText(Intl.intl("Defines whether the test will pass with at least one record found or if none are found"));
        this.d_matchingRecordsFail = new guiRadioButton(ResultsEmptyCondition.RESULTS_EMPTY);
        this.d_matchingRecordsFail.setToolTipText(Intl.intl("Records matching the filters indicate the check failed. Model objects associated with matching records can be selected from the check results."));
        this.d_matchingRecordsPass = new guiRadioButton(ResultContainsCondition.RESULTS_CONTAIN);
        this.d_matchingRecordsPass.setToolTipText("Records matching the filters indicate the check passed. If no records match, a failure will be reported in check results.");
        new guiButtonGroup(this.d_matchingRecordsFail, this.d_matchingRecordsPass);
        this.d_tableLabel = new guiLabel(Intl.intl("Filters:"));
        this.d_tableLabel.setToolTipText(Intl.intl("Model records will be filtered by this criteria."));
        guiDefaultTableModel model = new guiDefaultTableModel(0, 5, true, Integer.MAX_VALUE, false, 5);
        this.d_table = new ModelFilterTable(model, new String[]{Intl.intl("Op"), Intl.intl("Record"), Intl.intl("Field"), Intl.intl("Condition"), Intl.intl("Value")}, new Class[]{ModelCheck.Op.class, String.class, String.class, ModelCheck.Condition.class, String.class});
        guiComboBox<ModelCheck.Op> opBox = new guiComboBox<ModelCheck.Op>(ModelCheck.Op.values());
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(opBox));
        guiComboBox recordBox = new guiComboBox(this.d_table.getRecordSpec().keySet().stream().sorted().collect(Collectors.toList()));
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(recordBox));
        guiComboBox<ModelCheck.Condition> conBox = new guiComboBox<ModelCheck.Condition>(ModelCheck.Condition.values());
        this.d_table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(conBox));
        this.d_tableEditor = new guiTableEditor(this.d_table, 22);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(400, this.d_tableEditor.getPreferredSize().height));
    }

    @Override
    public void render(ModelCheckEditor modelCheckEditor) {
        modelCheckEditor.add((Component)this.d_checkConditionLabel, "wrap");
        modelCheckEditor.add((Component)this.d_matchingRecordsFail, "span 2, wrap");
        modelCheckEditor.add((Component)this.d_matchingRecordsPass, "span 2, wrap");
        modelCheckEditor.add((Component)this.d_tableLabel, "wrap");
        modelCheckEditor.add((Component)this.d_tableEditor, "span 3, grow, wrap");
    }

    @Override
    public void init(ModelCheck modelCheck) {
        ICheckDesc iCheckDesc;
        String resultCondition = modelCheck.getResultCondition().getID();
        if (resultCondition.equals(ResultContainsCondition.RESULTS_CONTAIN)) {
            this.d_matchingRecordsPass.setSelected(true);
        }
        if (resultCondition.equals(ResultsEmptyCondition.RESULTS_EMPTY)) {
            this.d_matchingRecordsFail.setSelected(true);
        }
        if ((iCheckDesc = modelCheck.getCheckDesc()) instanceof RecordCheckDesc) {
            RecordCheckDesc rcd = (RecordCheckDesc)iCheckDesc;
            this.d_table.clearRows();
            ArrayList<ModelCheckFilter<?>> filters = rcd.getFilters();
            if (filters.size() > 0) {
                ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(filters.size());
                for (int i = 0; i < filters.size(); ++i) {
                    ModelCheckFilter<?> f = filters.get(i);
                    this.d_table.setValueAt((Object)f.getOp(), i, 0);
                    this.d_table.setValueAt(f.getRecord(), i, 1);
                    this.d_table.setValueAt(f.getField(), i, 2);
                    this.d_table.setValueAt((Object)f.getCondition(), i, 3);
                    this.d_table.setValueAt(f.getValue(), i, 4);
                }
            }
        }
    }

    public void clearRows() {
        this.d_table.clearRows();
    }

    @Override
    public void updateCheck(ModelCheck modelCheck) {
        String condition = ResultsEmptyCondition.RESULTS_EMPTY;
        if (this.d_matchingRecordsPass.isSelected()) {
            condition = ResultContainsCondition.RESULTS_CONTAIN;
        }
        if (condition.equals(ResultsEmptyCondition.RESULTS_EMPTY)) {
            modelCheck.setResultCondition(new ResultsEmptyCondition());
        } else if (condition.equals(ResultContainsCondition.RESULTS_CONTAIN)) {
            modelCheck.setResultCondition(new ResultContainsCondition());
        }
        ICheckDesc iCheckDesc = modelCheck.getCheckDesc();
        if (iCheckDesc instanceof RecordCheckDesc) {
            RecordCheckDesc checkDesc = (RecordCheckDesc)iCheckDesc;
            int numRows = this.d_table.getRowCount() - 1;
            if (numRows > 0) {
                ArrayList checkFilters = new ArrayList();
                for (int row = 0; row < numRows; ++row) {
                    ModelCheckFilter<?> mcf = this.d_table.createCheckFilter(row);
                    checkFilters.add(mcf);
                }
                checkDesc.setFilters(checkFilters);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_checkConditionLabel.setVisible(visible);
        this.d_matchingRecordsFail.setVisible(visible);
        this.d_matchingRecordsPass.setVisible(visible);
        this.d_tableLabel.setVisible(visible);
        this.d_tableEditor.setVisible(visible);
    }
}

