/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import javax.vecmath.Point2d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.io.fds.EnabledFilter;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.units.UnitDouble;

public class VentCollapseValidation
extends ARunFDSValidation {
    private static double s_tolerance = 1.0E-6;

    public VentCollapseValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        GeomLocator geomfinder = this.d_pyroMod.getGeomLocator();
        HashSet<IPyroObject> warnFor = new HashSet<IPyroObject>();
        Collection<Vent> vents = this.d_pyroMod.getObstructions().flatten(Vent.class, new EnabledFilter());
        for (Vent v : vents) {
            CollResult findResult = new CollResult(Grid.class, new EnabledFilter());
            geomfinder.find(new AABoxTest(v.getBounds(), 1.0E-5), findResult, true, true);
            boolean collapse = false;
            for (Grid m : findResult.coll) {
                double nmaxZ;
                double nminZ;
                double nmaxY;
                double nminY;
                double nmaxX;
                UnitDouble[] mesh_xps = m.getXLinePositions();
                UnitDouble[] mesh_yps = m.getYLinePositions();
                UnitDouble[] mesh_zps = m.getZLinePositions();
                AABox aa_vent = v.getBounds();
                double nminX = this.getSnapMin(aa_vent.getMinX(), mesh_xps);
                if (VentCollapseValidation.testIfVentIsOutsideMesh(v, m, nminX, nmaxX = this.getSnapMax(aa_vent.getMaxX(), mesh_xps), nminY = this.getSnapMin(aa_vent.getMinY(), mesh_yps), nmaxY = this.getSnapMax(aa_vent.getMaxY(), mesh_yps), nminZ = this.getSnapMin(aa_vent.getMinZ(), mesh_zps), nmaxZ = this.getSnapMax(aa_vent.getMaxZ(), mesh_zps))) continue;
                switch (v.getVentGeom().d_plane) {
                    case 0: {
                        collapse = nmaxY - nminY < s_tolerance || nmaxZ - nminZ < s_tolerance;
                        break;
                    }
                    case 1: {
                        collapse = nmaxX - nminX < s_tolerance || nmaxZ - nminZ < s_tolerance;
                        break;
                    }
                    case 2: {
                        boolean bl = collapse = nmaxX - nminX < s_tolerance || nmaxY - nminY < s_tolerance;
                    }
                }
                if (!collapse) continue;
                break;
            }
            if (!collapse) continue;
            warnFor.add(v);
        }
        return warnFor;
    }

    private static boolean boundsCompareOnAxis(double snapMin, double snapMax, double ventMin, double ventMax, double meshDivisionLength) {
        return snapMax - snapMin < s_tolerance && ventMax - ventMin > meshDivisionLength / 2.0;
    }

    private static boolean testIfVentIsOutsideMesh(Vent v, Grid m, double snapMinX, double snapMaxX, double snapMinY, double snapMaxY, double snapMinZ, double snapMaxZ) {
        Point2d ventMin = v.getVentGeom().getMin();
        Point2d ventMax = v.getVentGeom().getMax();
        double xDivLength = m.getXDivisionLength().get(Geometry.LU);
        double yDivLength = m.getYDivisionLength().get(Geometry.LU);
        double zDivLength = m.getZDivisionLength().get(Geometry.LU);
        switch (v.getVentGeom().d_plane) {
            case 0: {
                if (VentCollapseValidation.boundsCompareOnAxis(snapMinY, snapMaxY, ventMin.x, ventMax.x, yDivLength)) {
                    return true;
                }
                if (!VentCollapseValidation.boundsCompareOnAxis(snapMinZ, snapMaxZ, ventMin.y, ventMax.y, zDivLength)) break;
                return true;
            }
            case 1: {
                if (VentCollapseValidation.boundsCompareOnAxis(snapMinX, snapMaxX, ventMin.x, ventMax.x, xDivLength)) {
                    return true;
                }
                if (!VentCollapseValidation.boundsCompareOnAxis(snapMinZ, snapMaxZ, ventMin.y, ventMax.y, zDivLength)) break;
                return true;
            }
            case 2: {
                if (VentCollapseValidation.boundsCompareOnAxis(snapMinX, snapMaxX, ventMin.x, ventMax.x, xDivLength)) {
                    return true;
                }
                if (!VentCollapseValidation.boundsCompareOnAxis(snapMinY, snapMaxY, ventMin.y, ventMax.y, yDivLength)) break;
                return true;
            }
        }
        return false;
    }

    private double getSnapMin(double min, UnitDouble[] ps) {
        double result = ps[0].get(Geometry.LU);
        if (min <= result) {
            return result;
        }
        if (min >= ps[ps.length - 1].get(Geometry.LU)) {
            return ps[ps.length - 1].get(Geometry.LU);
        }
        for (int i = 0; i < ps.length - 1; ++i) {
            if (!(min >= ps[i].get(Geometry.LU)) || !(min < ps[i + 1].get(Geometry.LU))) continue;
            if (min < (ps[i + 1].get(Geometry.LU) + ps[i].get(Geometry.LU)) / 2.0) {
                result = ps[i].get(Geometry.LU);
                break;
            }
            result = ps[i + 1].get(Geometry.LU);
            break;
        }
        return result;
    }

    private double getSnapMax(double max, UnitDouble[] ps) {
        double result = ps[ps.length - 1].get(Geometry.LU);
        if (max >= result) {
            return result;
        }
        if (max <= ps[0].get(Geometry.LU)) {
            return ps[0].get(Geometry.LU);
        }
        for (int i = ps.length - 1; i > 0; --i) {
            if (!(max >= ps[i - 1].get(Geometry.LU)) || !(max < ps[i].get(Geometry.LU))) continue;
            if (max < (ps[i - 1].get(Geometry.LU) + ps[i].get(Geometry.LU)) / 2.0) {
                result = ps[i - 1].get(Geometry.LU);
                break;
            }
            result = ps[i].get(Geometry.LU);
            break;
        }
        return result;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = String.format(Intl.intl("The model contains %d vents that will be collapsed to a point or\nline in FDS.\n\nClick OK to select the vents that will collapse.\n\nClick Ignore to continue.\n"), issueSize);
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Vent Collapse Validation");
    }
}

