/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.ARunFDSValidation;

public class SimpleReactionValidation
extends ARunFDSValidation {
    public SimpleReactionValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        HashSet<Reaction> simpleReactions = new HashSet<Reaction>();
        for (Reaction reaction : this.d_pyroMod.getReactions().getActiveReactions()) {
            if (!reaction.isSimpleChemReaction()) continue;
            simpleReactions.add(reaction);
        }
        return simpleReactions.size() > 1 ? simpleReactions : Collections.emptySet();
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("Multiple active simple reactions (&REAC) are detected in this model.\n\nClick OK to select the active simple reactions.\n\nClick Ignore to disregard this warning and run FDS.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Simple Reaction Validation");
    }
}

