/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.Grid;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimError;
import pyrosim.domain.SimParams;
import pyrosim.gui.CancelledException;
import pyrosim.gui.CloudFDSDlg;
import pyrosim.gui.ClusterFDSDlg;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.actions.FdsIoUtil;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiAction;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theTimer;

public class RunFdsActions {
    private static final Logger LOGGER = Logger.getLogger(RunFdsActions.class.getName());
    public static final RunFDSAction RUN_FDS_ACTION = new RunFDSAction();
    public static final ResumeFDSAction RESUME_FDS_ACTION = new ResumeFDSAction();
    public static final RunFDSmpiAction RUN_FDS_MPI_ACTION = new RunFDSmpiAction();
    public static final ResumeFDSmpiAction RESUME_FDS_MPI_ACTION = new ResumeFDSmpiAction();
    public static final RunFDSClusterAction RUN_FDS_CLUSTER_ACTION = new RunFDSClusterAction();
    public static final ResumeFDSClusterAction RESUME_FDS_CLUSTER_ACTION = new ResumeFDSClusterAction();
    public static final RunFDSCloudAction RUN_FDS_CLOUD_ACTION = new RunFDSCloudAction();

    private static class RunFDSAction
    extends ARunFDSAction {
        private static final long serialVersionUID = 6124293910171361477L;

        public RunFDSAction() {
            super(Intl.intl("Run FDS") + "...", (Icon)PyroGuiUtil.loadPyroSimIcon("run16.png"), FDSRun.Mode.SINGLE);
        }

        @Override
        public void run() {
            PyroMod pyMod;
            PyroSim app = (PyroSim)Application.getApp();
            if (!FdsIoUtil.validateModel(app, pyMod = app.getMediator(), FDSRenderer.RENDER_ORIGIN.RUN_FDS)) {
                return;
            }
            File tempFile = this.d_outFile;
            if (tempFile == null || !app.writeFDSFile(tempFile, false, FDSRenderer.RENDER_ORIGIN.RUN_FDS)) {
                return;
            }
            FDSRunMonitor runner = new FDSRunMonitor(Intl.intl("FDS Simulation") + " - " + tempFile.getName(), tempFile.getAbsolutePath());
            SimParams.OpenMp ompInput = pyMod.getSimParams().getOpenMp();
            runner.startFDSmpi(1, GridProcessUtil.PROC_COUNT.ONE_PROC, new FDSRunMonitor.OpenMpOptions(ompInput.getOmpNumThreadsFlag(), ompInput.getOmpNumThreads(), ompInput.getOmpStacksizeFlag(), ompInput.getOmpStacksize()));
        }
    }

    private static class ResumeFDSAction
    extends RunFDSAction {
        private static final long serialVersionUID = -6901847619976469970L;
        private static final ImageIcon ICON = null;

        public ResumeFDSAction() {
            this.putValue("Name", Intl.intl("Resume FDS..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            PyroMod pyMod = app.getMediator();
            SimParams simParams = pyMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    private static class RunFDSmpiAction
    extends ARunFDSAction {
        private static final long serialVersionUID = -7891598376681965087L;

        public RunFDSmpiAction() {
            super(Intl.intl("Run FDS Parallel") + "...", (Icon)PyroGuiUtil.loadPyroSimIcon("runparallel16.png"), FDSRun.Mode.PARALLEL);
        }

        @Override
        public void run() {
            PyroMod pyMod;
            PyroSim app = (PyroSim)Application.getApp();
            if (!FdsIoUtil.validateModel(app, pyMod = app.getMediator(), FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI)) {
                return;
            }
            GridProcessUtil.PROC_COUNT processRule = GridProcessUtil.getProcCountForString(PyroPrefs.getString(PyroPrefs.PREF_MPI_PROC_COUNT));
            WarningReport<SimError> warnings = SimError.makeWarningReport();
            RefinementZoneUtil.RefinementResults results = RefinementZoneUtil.refineMeshesNoInterrupt(pyMod, warnings::addWarning);
            int numGrids = Math.max(1, (int)results.streamLeaves().count());
            File inputFile = this.d_outFile;
            if (inputFile == null || !PyroSim.getApp().writeFDSFile(inputFile, false, FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI)) {
                return;
            }
            FDSRunMonitor runner = new FDSRunMonitor(Intl.intl("FDS Parallel") + " - " + inputFile.getName(), inputFile.getAbsolutePath());
            SimParams.OpenMp ompInput = pyMod.getSimParams().getOpenMp();
            runner.startFDSmpi(numGrids, processRule, new FDSRunMonitor.OpenMpOptions(ompInput.getOmpNumThreadsMPIFlag(), ompInput.getOmpNumThreadsMPI(), ompInput.getOmpStacksizeFlag(), ompInput.getOmpStacksize()));
        }
    }

    private static class ResumeFDSmpiAction
    extends RunFDSmpiAction {
        private static final long serialVersionUID = 9184979190758384730L;
        private static final ImageIcon ICON = null;

        public ResumeFDSmpiAction() {
            this.putValue("Name", Intl.intl("Resume FDS Parallel..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            PyroMod pyMod = app.getMediator();
            SimParams simParams = pyMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    private static class RunFDSClusterAction
    extends ARunFDSAction {
        private static final long serialVersionUID = -5511615526467851768L;
        private Map<String, Integer> d_hosts;

        public RunFDSClusterAction() {
            super(Intl.intl("Run FDS Cluster..."), (Icon)PyroGuiUtil.loadPyroSimIcon("runcluster.png"), FDSRun.Mode.CLUSTER);
        }

        @Override
        public File getFdsInputFile(File pyroFile, PyroMod pyMod) {
            FDSClusterOptions options = pyMod.getClusterOptions();
            if (options != null) {
                return new File(options.lastFDSLocation);
            }
            return pyMod.getLastFDSRun().fdsFilepath != null ? new File(pyMod.getLastFDSRun().fdsFilepath) : FdsIoUtil.getDefaultFDSInputFile(pyMod, pyroFile);
        }

        @Override
        protected File[] getFilesToWrite(File pyroFile) throws CancelledException {
            PyroSim app = PyroSim.getApp();
            PyroMod pyMod = app.getMediator();
            List<Grid> gridsList = RefinementZoneUtil.refineMeshesNoInterrupt(pyMod, err -> {}).streamLeaves().toList();
            ClusterFDSDlg dlg = new ClusterFDSDlg(app.getMainFrame(), gridsList, pyMod);
            File fdsFile = this.getFdsInputFile(pyroFile, pyMod);
            dlg.setFDSFile(fdsFile);
            FDSClusterOptions options = pyMod.getClusterOptions();
            if (options != null) {
                dlg.setHosts(options.hosts);
            }
            if (dlg.doModal() != 1) {
                throw new CancelledException();
            }
            this.d_hosts = dlg.getHosts();
            return FdsIoUtil.getFDSFiles(dlg.getOutFile());
        }

        @Override
        protected void makeModelChanges(PyroMod model) throws CancelledException {
            if (model.getClusterOptions() != null) {
                model.getEvents().removeObserver(model.getClusterOptions());
            }
            FDSClusterOptions opt = new FDSClusterOptions(this.d_outFile.getAbsolutePath(), this.d_hosts);
            model.getEvents().addObserver(opt);
            model.setClusterOptions(opt);
        }

        private Map<String, Integer> limitHosts(Map<String, Integer> hosts, int numGrids) {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>(hosts.size());
            int remaining = numGrids;
            for (Map.Entry<String, Integer> entry : hosts.entrySet()) {
                int count = Math.min(remaining, entry.getValue());
                if (count == 0) continue;
                result.put(entry.getKey(), count);
                if ((remaining -= count) != 0) continue;
                break;
            }
            return result;
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            if (!PyroSim.getApp().writeFDSFile(this.d_outFile, false, FDSRenderer.RENDER_ORIGIN.RUN_FDS_CLUSTER)) {
                JOptionPane.showMessageDialog(app.getMainFrame(), Intl.intl("Unable to write FDS file."));
                return;
            }
            File simulatorExe = new File(PyroPrefs.getFDSLocation());
            PyroMod pyMod = app.getMediator();
            WarningReport<SimError> warnings = SimError.makeWarningReport();
            RefinementZoneUtil.RefinementResults results = RefinementZoneUtil.refineMeshesNoInterrupt(pyMod, warnings::addWarning);
            int numGrids = Math.max(1, (int)results.streamLeaves().count());
            if (!FdsIoUtil.validateModel(app, pyMod, results, warnings, FDSRenderer.RENDER_ORIGIN.RUN_FDS_CLUSTER)) {
                return;
            }
            FDSRunMonitor runner = new FDSRunMonitor(Intl.intl("FDS Cluster") + " - " + this.d_outFile.getName(), this.d_outFile.getAbsolutePath());
            SimParams.OpenMp ompInput = pyMod.getSimParams().getOpenMp();
            FDSRunMonitor.OpenMpOptions omp = new FDSRunMonitor.OpenMpOptions(ompInput.getOmpNumThreadsMPIFlag(), ompInput.getOmpNumThreadsMPI(), ompInput.getOmpStacksizeFlag(), ompInput.getOmpStacksize());
            runner.startClusterFDS(this.limitHosts(this.d_hosts, numGrids), numGrids, simulatorExe, omp);
        }
    }

    private static class ResumeFDSClusterAction
    extends RunFDSClusterAction {
        private static final long serialVersionUID = 1834321905800219436L;
        private static final ImageIcon ICON = null;

        public ResumeFDSClusterAction() {
            this.putValue("Name", Intl.intl("Resume FDS Cluster..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            PyroMod pyMod = app.getMediator();
            SimParams simParams = pyMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    private static class RunFDSCloudAction
    extends ARunFDSAction {
        private static final long serialVersionUID = 1L;

        public RunFDSCloudAction() {
            super(Intl.intl("Run FDS Cloud") + "...", (Icon)PyroGuiUtil.loadPyroSimIcon("run16.png"), FDSRun.Mode.CLOUD);
        }

        @Override
        public void run() {
            PyroSim app = (PyroSim)Application.getApp();
            PyroMod pyMod = app.getMediator();
            CloudFDSDlg dlg = new CloudFDSDlg(app.getMainFrame());
            String chid = FilenameUtils.removeExtension(this.d_outFile.getName());
            FDSRenderer.Filenames filenames = new FDSRenderer.Filenames(this.d_outFile.getParentFile(), chid);
            if (dlg.doModal() == 8) {
                return;
            }
            if (!PyroSim.getApp().writeFDSFile(this.d_outFile, false, FDSRenderer.RENDER_ORIGIN.RUN_FDS_CLOUD)) {
                JOptionPane.showMessageDialog(app.getMainFrame(), Intl.intl("Unable to write FDS file."));
                return;
            }
            if (!FdsIoUtil.validateModel(app, pyMod, FDSRenderer.RENDER_ORIGIN.RUN_FDS_CLOUD)) {
                return;
            }
            FDSRunMonitor runner = new FDSRunMonitor(Intl.intl("FDS Simulation - ") + this.d_outFile.getName(), this.d_outFile.getAbsolutePath());
            CloudFDSDlg.CFD_FEA_Params params = dlg.getParams();
            runner.startCloudFDS(params, filenames, this.d_outFile);
        }
    }

    public static abstract class ARunFDSAction
    extends guiAction
    implements Runnable {
        private static final long serialVersionUID = -6295012538846486394L;
        private final FDSRun.Mode d_mode;
        protected File d_outFile;

        public ARunFDSAction(String name, Icon icon, FDSRun.Mode mode) {
            super(name, icon);
            this.putValue("ShortDescription", this.getName());
            this.d_mode = mode;
        }

        public File getFdsInputFile(File pyroFile, PyroMod pyMod) {
            return FdsIoUtil.getDefaultFDSInputFile(pyMod, pyroFile);
        }

        protected File[] getFilesToWrite(File pyroFile) throws CancelledException {
            return FdsIoUtil.getFDSFiles(this.getFdsInputFile(pyroFile, PyroSim.getApp().getMediator()));
        }

        protected void makeModelChanges(PyroMod model) throws CancelledException {
        }

        protected boolean showOverwriteWarn() {
            return true;
        }

        private void getOverwriteWarning(File pyroFile, File[] files, PyroSim app) throws CancelledException {
            ArrayList<File> existingFiles = new ArrayList<File>();
            String fileName = pyroFile.getName().split("\\.")[0];
            String message = "";
            if (fileName.length() > 50) {
                message = String.format(Intl.intl("Warning: Your filename is longer than %1$d characters.\nDifferences in filename past the %1$dth character will be dropped in the CHID parameter.\nThis may result in overwriting of existing data if the first %1$d characters are the same as existing output data filenames.\n\n"), 50);
            }
            for (File file : files) {
                if (!file.exists()) continue;
                existingFiles.add(file);
            }
            if (!existingFiles.isEmpty() && this.showOverwriteWarn()) {
                message = message.concat(String.format(Intl.intl("Output already exists in %s.%nWould you like to overwrite and continue?"), files[0].getParent()));
                int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), message, Intl.intl("Overwrite Output?"), 0);
                if (option != 0) {
                    throw new CancelledException();
                }
            }
        }

        private void prepare() throws IOException, CancelledException {
            PyroSim app = PyroSim.getApp();
            File pyroFile = null;
            if (app.getPromptOnNextSave()) {
                pyroFile = app.promptSaveFile();
                if (pyroFile == null) {
                    throw new CancelledException();
                }
            } else {
                pyroFile = new File(app.getFilename());
            }
            File[] files = this.getFilesToWrite(pyroFile);
            this.getOverwriteWarning(pyroFile, files, app);
            this.d_outFile = files[0];
            File parentDir = this.d_outFile.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                JOptionPane.showMessageDialog(app.getActiveFrame(), String.format(Intl.intl("Could not create directory, \"%s\"."), parentDir.getAbsolutePath()), Intl.intl("Error"), 0);
                throw new CancelledException();
            }
            String runFilename = FilenameManager.equal(this.d_outFile, FdsIoUtil.getDefaultFDSInputFile(app.getMediator(), pyroFile)) ? null : this.d_outFile.getAbsolutePath();
            FDSRun run = new FDSRun(this.d_mode, runFilename);
            app.getMediator().pauseUpdates();
            app.getMediator().setLastFDSRun(run);
            this.makeModelChanges(app.getMediator());
            app.getMediator().resumeUpdates();
            if (app.getPromptOnNextSave() && !app.doSave(pyroFile)) {
                throw new CancelledException();
            }
            theTimer timer = new theTimer();
            File outputPyroFile = new File(this.d_outFile.getParentFile(), pyroFile.getName());
            int zipLevel = 0;
            if (PyroPrefs.getBoolean(PyroPrefs.AUTOSAVE_ON_RUN_FDS)) {
                if (!app.saveIfModified()) {
                    throw new CancelledException();
                }
                try {
                    CopyFile.copyAndZipFileStream(pyroFile, new File(outputPyroFile.getAbsolutePath() + ".zip"), zipLevel);
                }
                catch (IOException e) {
                    Actions.showIOException(e, Intl.intl("Could not copy PyroSim file to FDS output directory."));
                    throw new CancelledException();
                }
            }
            try (FileOutputStream fos = new FileOutputStream(String.valueOf(outputPyroFile) + ".zip");
                 ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
                zos.setLevel(zipLevel);
                zos.putNextEntry(new ZipEntry(outputPyroFile.getName()));
                try (PyroSimObjectOutputStream oos = new PyroSimObjectOutputStream(zos);){
                    PyroSim.getApp().writeModel(PyroSim.getApp().getMediator(), oos);
                }
            }
            catch (IOException e) {
                Actions.showIOException(e, Intl.intl("Could not write PyroSim file to FDS output directory."));
                throw new CancelledException();
            }
            LOGGER.log(Level.INFO, String.format("Saved file in %g s", timer.curr()));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                this.prepare();
            }
            catch (CancelledException e) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                PyroSim.getApp().error(Intl.intl("Unknown Error"), String.format("%s: %s", Intl.intl("Message:"), e.getLocalizedMessage()));
                return;
            }
            new Thread(this).start();
        }
    }
}

