/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import org.apache.commons.io.FilenameUtils;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimError;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.gui.actions.AspiratorSamplerValidation;
import pyrosim.gui.actions.DefaultStopTimeValidation;
import pyrosim.gui.actions.Domain3DHeatTransferModelValidation;
import pyrosim.gui.actions.DomainSealedValidation;
import pyrosim.gui.actions.ExposedOverlapValidation;
import pyrosim.gui.actions.FlameConditionValidation;
import pyrosim.gui.actions.FuelMolecularWeightValidation;
import pyrosim.gui.actions.GeomNamelistValidation;
import pyrosim.gui.actions.ISimErrorValidation;
import pyrosim.gui.actions.MPIProcessConflictValidation;
import pyrosim.gui.actions.PriorWarningsValidation;
import pyrosim.gui.actions.SimpleReactionValidation;
import pyrosim.gui.actions.VentCollapseValidation;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class FdsIoUtil {
    public static final int FDSFILE_INPUT = 0;
    public static final int FDSFILE_OUTPUT = 1;
    public static final int FDSFILE_SMOKEVIEW = 2;
    public static final int FDSFILE_HRR = 3;
    public static final int FDSFILE_DEVC = 4;
    public static final int FDSFILE_CTRL = 5;

    public static boolean validateModel(PyroSim app, PyroMod pyMod, FDSRenderer.RENDER_ORIGIN callFrom) {
        WarningReport<SimError> warnings = SimError.makeWarningReport();
        RefinementZoneUtil.RefinementResults results = RefinementZoneUtil.refineMeshesNoInterrupt(pyMod, warnings::addWarning);
        return FdsIoUtil.validateModel(app, pyMod, results, warnings, callFrom);
    }

    public static boolean validateModel(PyroSim app, PyroMod pyMod, RefinementZoneUtil.RefinementResults refinementResults, WarningReport<SimError> priorWarnings, FDSRenderer.RENDER_ORIGIN callFrom) {
        GeomNamelistValidation geomVal = new GeomNamelistValidation(app, pyMod);
        List<ARunFDSValidation> validationRules = Arrays.asList(new ExposedOverlapValidation(app, pyMod, refinementResults), new FlameConditionValidation(app, pyMod), new VentCollapseValidation(app, pyMod), new AspiratorSamplerValidation(app, pyMod), new MPIProcessConflictValidation(app, pyMod, callFrom), new DomainSealedValidation(app, pyMod), new Domain3DHeatTransferModelValidation(app, pyMod), new GeomNamelistValidation.GeomControlValidation(geomVal, app, pyMod), new GeomNamelistValidation.GeomHt3dValidation(geomVal, app, pyMod), new GeomNamelistValidation.GeomBurnAwayValidation(geomVal, app, pyMod), new DefaultStopTimeValidation(app, pyMod), new FuelMolecularWeightValidation(app, pyMod), new SimpleReactionValidation(app, pyMod));
        for (ARunFDSValidation rule : validationRules) {
            ARunFDSValidation.Prompt prompt;
            int userSelection;
            boolean ignoreWarning;
            Collection<IPyroObject> warnFor = rule.validateModel();
            if (warnFor.isEmpty() || (ignoreWarning = rule.getResponse(userSelection = (prompt = rule.getPrompt(app.getMainFrame(), warnFor.size())).doModal(), warnFor).get().booleanValue())) continue;
            return false;
        }
        WarningReport<SimError> warnings = SimError.makeWarningReport();
        List<PriorWarningsValidation> simErrorValidations = List.of(new PriorWarningsValidation(priorWarnings));
        for (ISimErrorValidation iSimErrorValidation : simErrorValidations) {
            iSimErrorValidation.addWarnings(warnings);
        }
        if (!warnings.isEmpty()) {
            IFilteredCollection<SimError> criticalErrors = theUtil.filter(warnings.getWarnings(), e -> e.level == SimError.Level.CRITICAL);
            IFilteredCollection<SimError> iFilteredCollection = theUtil.filter(warnings.getWarnings(), e -> e.level == SimError.Level.MODERATE);
            int ignore = 16;
            WarningDlg<SimError> dlg = new WarningDlg<SimError>(app.getActiveFrame(), !criticalErrors.isEmpty() ? Intl.intl("Model Errors") : Intl.intl("Model Warnings"), !criticalErrors.isEmpty() ? Intl.intl("The following errors must be fixed before continuing.") : Intl.intl("The following issues might cause problems with the simulation. What would you like to do?"), warnings, !criticalErrors.isEmpty() ? 8 : ignore | 8, !criticalErrors.isEmpty() ? WarningDlg.Severity.ERROR : WarningDlg.Severity.WARNING);
            JButton ignoreBtn = dlg.getButton(ignore);
            if (ignoreBtn != null) {
                ignoreBtn.setPreferredSize(null);
                ignoreBtn.setText(Intl.intl("Ignore"));
            }
            if (dlg.doModal() != ignore) {
                return false;
            }
        }
        return true;
    }

    public static File getDefaultFDSInputFile(PyroMod pyMod, File psmFile) {
        String chid = FDSRenderer.generateChid(psmFile.getName(), FDSRenderer.getDefaultScenarioNameForChid(pyMod.getScenarios()));
        return FdsIoUtil.getDefaultFDSInputFile(psmFile, chid);
    }

    public static File getDefaultFDSInputFile(File psmFile, String chid) {
        return new File(new File(psmFile.getParentFile(), chid), chid + ".fds");
    }

    public static File[] getFDSFiles(File fdsFile) {
        String basename = FilenameUtils.removeExtension(fdsFile.getName());
        return new File[]{fdsFile, new File(fdsFile.getParentFile(), basename + ".out"), new File(fdsFile.getParentFile(), basename + ".smv"), new File(fdsFile.getParentFile(), basename + "_hrr.csv"), new File(fdsFile.getParentFile(), basename + "_devc.csv"), new File(fdsFile.getParentFile(), basename + "_ctrl.csv")};
    }
}

