/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tags.TagRoot;
import pyrosim.domain.tags.TagsUtil;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.ComponentSensitiveAction;
import pyrosim.util.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.CompositeTask;

public class EditTagsAction
extends ComponentSensitiveAction {
    private static final long serialVersionUID = 1L;

    public EditTagsAction() {
        super(Intl.intl("Edit Tags..."));
        this.putValue("ShortDescription", Intl.intl("Edit Tags"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        EditTagsDialog editor = new EditTagsDialog((Window)PyroSim.getApp().getActiveFrame(), pyMod);
        Collection<ITaggable> taggables = pyMod.getSelectionModel().flatten(ITaggable.class);
        editor.addTaggables(taggables);
        if (editor.doModal() == 1) {
            TagRoot tagsRoot = pyMod.getTags();
            CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(pyMod);
            if (!editor.isMixed()) {
                Set<String> newBaseTags = editor.getTagsAsEntered();
                Set<Tag> assignTags = TagsUtil.getTagsForStrings(compTask, tagsRoot, newBaseTags);
                TagsUtil.queueEditTagsDirect(compTask, taggables, assignTags);
            }
            Set<String> adds = editor.getExplicitAdds();
            Set<String> removes = editor.getExplicitRemoves();
            Set<Tag> addTags = TagsUtil.getTagsForStrings(compTask, tagsRoot, adds);
            Set<Tag> removeTags = tagsRoot.getTagsForTagStrings(removes);
            TagsUtil.queueAddRemoveTags(compTask, taggables, addTags, removeTags);
            pyMod.getTaskManager().exec(compTask, Intl.intl("Edit Tags"));
        }
    }

    @Override
    public void updateEnabled() {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        this.setEnabled(!pyMod.getSelectionModel().flatten(ITaggable.class).isEmpty());
    }

    public static ReceiveTextInputDialog newAddTagsDialog(Window parent) {
        return new ReceiveTextInputDialog(parent, Intl.intl("Add Tags"), Intl.intl("Add Tags:"), Intl.intl("A list of all Tags to be added, if present."));
    }

    public static ReceiveTextInputDialog newRemoveTagsDialog(Window parent) {
        return new ReceiveTextInputDialog(parent, Intl.intl("Remove Tags"), Intl.intl("Remove Tags:"), Intl.intl("A list of all Tags to be removed, if present."));
    }

    public static class EditTagsDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private static final String s_mixedLbl = Intl.intl("<mixed>");
        private final PyroMod d_pyro;
        private final guiLabel d_setTagsLabel = new guiLabel(Intl.intl("Set Tags:"));
        private final guiTextField d_setTagsField = new guiTextField();
        private final guiLabel d_addTagsLabel = new guiLabel(Intl.intl("Add Tags:"));
        private final guiTextField d_addTagsField = new guiTextField();
        private final guiLabel d_removeTagsLabel = new guiLabel(Intl.intl("Remove Tags:"));
        private final guiTextField d_removeTagsField = new guiTextField();
        private final DefaultListModel<ITaggable> d_objListModel = new DefaultListModel();

        public EditTagsDialog(Window parent, PyroMod pyMod) {
            super(parent, Intl.intl("Edit Tags"), 9);
            this.setResizable(true);
            this.d_pyro = pyMod;
            JList<ITaggable> tagObjList = new JList<ITaggable>(this.d_objListModel);
            tagObjList.setCellRenderer(new ObjectRenderer());
            JScrollPane tagObjScrollPane = new JScrollPane(tagObjList);
            tagObjScrollPane.setMinimumSize(new Dimension(140, 200));
            guiPanel mainPnl = this.getDialogPane();
            mainPnl.setLayout(new MigLayout("insets 0, gap 6", "[grow][][grow]", "[][][][grow]"));
            mainPnl.add((Component)tagObjScrollPane, "cell 0 0, spany 4, grow");
            mainPnl.add((Component)this.d_setTagsLabel, "cell 1 0");
            mainPnl.add((Component)this.d_setTagsField, "cell 2 0, growx, width pref*2, span");
            mainPnl.add((Component)this.d_addTagsLabel, "cell 1 1");
            mainPnl.add((Component)this.d_addTagsField, "cell 2 1, growx");
            mainPnl.add((Component)this.d_removeTagsLabel, "cell 1 2");
            mainPnl.add((Component)this.d_removeTagsField, "cell 2 2, growx");
        }

        public void addTaggables(Collection<ITaggable> tagObjs) {
            this.d_objListModel.addAll(tagObjs);
            if (tagObjs.isEmpty()) {
                this.d_setTagsField.setText("");
                return;
            }
            Set<Tag> refTags = tagObjs.iterator().next().getTags();
            boolean isMixed = false;
            for (ITaggable obj : tagObjs) {
                Set<Tag> objTags = obj.getTags();
                if (objTags.equals(refTags)) continue;
                isMixed = true;
                break;
            }
            if (isMixed) {
                this.d_setTagsField.setText(s_mixedLbl);
            } else {
                this.d_setTagsField.setText(TagsUtil.renderTagsAsString(TagsUtil.tagsToStrings(refTags)));
            }
            this.d_addTagsLabel.setVisible(isMixed);
            this.d_addTagsField.setVisible(isMixed);
            this.d_removeTagsLabel.setVisible(isMixed);
            this.d_removeTagsField.setVisible(isMixed);
        }

        public Set<String> getExplicitAdds() {
            return TagsUtil.splitStrings(this.d_addTagsField.getText().trim());
        }

        public Set<String> getExplicitRemoves() {
            return TagsUtil.splitStrings(this.d_removeTagsField.getText().trim());
        }

        public Set<String> getTagsAsEntered() {
            return TagsUtil.splitStrings(this.d_setTagsField.getText().trim());
        }

        public boolean isMixed() {
            return this.d_setTagsField.getText().trim().equals(s_mixedLbl);
        }

        private class ObjectRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            private ObjectRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.decorateCells(list, value, index, isSelected, cellHasFocus);
                return this;
            }

            private void decorateCells(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                PyroGuiUtil.decorateCellRenderer(EditTagsDialog.this.d_pyro, icons -> {
                    this.setIcon(icons[0]);
                    this.setIcon(icons[1]);
                    list.repaint();
                }, value, this, isSelected, cellHasFocus);
                IPyroObject obj = (IPyroObject)value;
                this.setText(Util.getName(obj));
            }
        }
    }

    public static class ReceiveTextInputDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final guiLabel description;
        private final guiTextField inputField = new guiTextField();

        public ReceiveTextInputDialog(Window owner, String title, String message, String tooltip) {
            super(owner, title, 9);
            this.description = new guiLabel(message);
            this.description.setToolTipText(tooltip);
            GridBagHelper gbh = new GridBagHelper(this.getDialogPane());
            gbh.addRow(this.description, this.inputField);
            gbh.finalizeRows();
        }

        public String getUserInput() {
            return this.inputField.getValue();
        }
    }
}

