/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tags.TagsUtil;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;

public class TagEditor {
    private static final String s_mixedLbl = Intl.intl("<mixed>");
    private final guiTextField d_editorField = new guiTextField("");

    public guiTextField getEditor() {
        return this.d_editorField;
    }

    public void initTags(ITaggable editObj) {
        this.initTags(Collections.singleton(editObj));
    }

    public void initTags(Collection<ITaggable> editObjs) {
        this.d_editorField.setValue("");
        if (editObjs.isEmpty()) {
            return;
        }
        Set<Tag> refTags = editObjs.iterator().next().getTags();
        boolean isMixed = false;
        for (ITaggable obj : editObjs) {
            Set<Tag> objTags = obj.getTags();
            if (objTags.equals(refTags)) continue;
            isMixed = true;
            break;
        }
        if (isMixed) {
            this.d_editorField.setText(s_mixedLbl);
        } else {
            this.d_editorField.setText(TagsUtil.renderTagsAsString(TagsUtil.tagsToStrings(refTags)));
        }
    }

    public Task getUpdateTagsTask(PyroMod pyMod, ITaggable editObj) {
        return this.getUpdateTagsTask(pyMod, Collections.singleton(editObj));
    }

    public Task getUpdateTagsTask(PyroMod pyMod, Collection<ITaggable> editObjs) {
        Set<String> tagsEntered = TagsUtil.splitStrings(this.d_editorField.getText().trim());
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(pyMod);
        Set<Tag> assignTags = TagsUtil.getTagsForStrings(compTask, pyMod.getTags(), tagsEntered);
        TagsUtil.queueEditTagsDirect(compTask, editObjs, assignTags);
        return compTask;
    }

    public boolean isMixed() {
        return this.d_editorField.getText().trim().equals(s_mixedLbl);
    }

    public void clear() {
        this.d_editorField.setText("");
    }
}

