/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class ReplaceDlg<E extends IPyroObject>
extends guiDialog {
    private static final long serialVersionUID = 6661616822406494505L;
    private Collection<E> d_replacementOptions = null;
    private E d_toReplace = null;
    private guiComboBox<E> d_combo = null;
    private final guiCheckBox d_rememberDecision;

    public ReplaceDlg(String typeDesc, E toReplace, Collection<E> replacementOptions) {
        this(String.format(Intl.intl("Replace %s"), typeDesc), String.format(Intl.intl("Warning!  The %1$s, %2$s, is in use."), typeDesc, Util.getName(toReplace)), toReplace, replacementOptions, 9);
    }

    public ReplaceDlg(String title, String msg, E toReplace, Collection<E> replacementOptions, int dlgBtns) {
        super((Window)Application.getApp().getMainFrame(), title, dlgBtns);
        this.d_replacementOptions = replacementOptions;
        this.d_toReplace = toReplace;
        this.d_combo = this.getCombo(replacementOptions);
        this.d_rememberDecision = new guiCheckBox(Intl.intl("Use this choice for remaining related references."));
        MultiLineLabel line1 = new MultiLineLabel(msg);
        line1.setColumns(40);
        guiLabel lab = new guiLabel(Intl.intl("Replace with:"));
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(dlgPanel, line1, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, lab, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_combo, 1, 1, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(dlgPanel, this.d_rememberDecision, 0, 2, 2, 1, 12, 0, 0, 0, 2, 1.0, 0.0);
    }

    public E getReplacer() {
        return (E)((IPyroObject)this.d_combo.getSelectedItem());
    }

    public boolean getRemember() {
        return this.d_rememberDecision.isSelected();
    }

    private guiComboBox<E> getCombo(Collection<E> list) {
        List<E> sortedElements = Util.sort(list);
        guiComboBox<Object> cb = new guiComboBox<Object>((Collection<Object>)sortedElements);
        cb.setRenderer(new CellRenderer());
        if (!list.isEmpty()) {
            cb.setSelectedIndex(0);
        }
        return cb;
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1305437490239228566L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                label.setText(Intl.intl("None"));
            } else {
                String text = Util.getName((IPyroObject)value);
                label.setText(text);
            }
            return label;
        }
    }
}

