/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TagEditor;
import pyrosim.gui.VariantEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.theUtil;

public class ExSpecEditor
extends guiPanel
implements IEditor<ExSpec> {
    private static final long serialVersionUID = -412288340484103187L;
    private ExSpecList d_exSpecList;
    private guiDialog d_parent;
    private guiTextField d_ID;
    private guiTextField d_FYI;
    private TagEditor d_tags;
    private ValueField<Double> d_massFrac;
    private PrimitivePanel d_primitivePanel;
    private LumpedPanel d_lumpedPanel;
    private CustomFDSPanel d_advancedPanel;
    private VisDifPanel d_visDifPanel;
    private RadiationPanel d_radiationPanel;
    private DepositionPanel d_depositionPanel;
    private LiquidPanel d_liquidPanel;
    private GasPanel d_gasPanel;
    private JTabbedPane d_tabs;
    private static String CONST = Intl.intl("Constant");
    private static String RAMP = Intl.intl("Custom");

    public ExSpecEditor(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_exSpecList = pyMod.getExSpecList();
        this.d_parent = parent;
        this.setLayout(new GridBagLayout());
        this.d_primitivePanel = new PrimitivePanel();
        this.d_lumpedPanel = new LumpedPanel(this.d_exSpecList);
        this.d_advancedPanel = new CustomFDSPanel(7);
        this.d_visDifPanel = new VisDifPanel();
        this.d_radiationPanel = new RadiationPanel();
        this.d_depositionPanel = new DepositionPanel();
        this.d_liquidPanel = new LiquidPanel();
        this.d_gasPanel = new GasPanel();
        HTMLLabel labID = new HTMLLabel(Intl.intl("Species ID") + ":");
        labID.setToolTipText("ID");
        this.d_ID = new guiTextField();
        this.d_ID.setEnabled(false);
        HTMLLabel labFYI = new HTMLLabel(Intl.intl("Description") + ":");
        labFYI.setToolTipText("FYI");
        this.d_FYI = new guiTextField();
        HTMLLabel tagLbl = new HTMLLabel(Intl.intl("Tags:"));
        this.d_tags = new TagEditor();
        HTMLLabel labMassFrac = new HTMLLabel(Intl.intl("Initial Mass Fraction") + ":");
        labMassFrac.setToolTipText("MASS_FRACTION_O");
        this.d_massFrac = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_primitivePanel, this.d_lumpedPanel, this.d_advancedPanel, this.d_visDifPanel, this.d_radiationPanel, this.d_depositionPanel, this.d_liquidPanel, this.d_gasPanel));
        int r = 0;
        GridBagUtil.add(this, labID, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_ID, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labFYI, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_FYI, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, tagLbl, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_tags.getEditor(), 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labMassFrac, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_massFrac, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_tabs, 0, r, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        guiLabel bgMsg;
        int option;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (showWarn && theUtil.equal(ExSpecList.Predefined.AIR.getName(), this.d_ID.getValue()) && (Double)this.d_massFrac.getValue() != 0.0 && (option = JOptionPane.showConfirmDialog(this, bgMsg = new guiLabel(PyroGuiUtil.encodeToHtmlLabel(Intl.intl("AIR is usually the background species and should be set to 0. It will\nautomatically account for any unspecified mass fraction. If you have\ndefined a custom background species other than AIR, click OK to ignore\nthis warning."))), Intl.intl("Warning"), 2, 2)) != 0) {
            return false;
        }
        if (showWarn && this.d_gasPanel.isRefEnthalpySelected() && this.d_liquidPanel.isEOFSelected()) {
            guiLabel enthalpyMsg = new guiLabel(PyroGuiUtil.encodeToHtmlLabel(Intl.intl("Enthalpy of Formation (Liquid tab) and Reference Enthalpy\n(Gas tab) are mutually exclusive. Only one can be defined in\nthe species.")));
            JOptionPane.showMessageDialog(this, enthalpyMsg, Intl.intl("Species Enthalpy Error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public ExSpec preview(ExSpec previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(previewObj);
        return previewObj;
    }

    @Override
    public ExSpec commit(ExSpec dest) {
        assert (dest != null);
        assert (this.isModified());
        if (!this.d_primitivePanel.validateChemicalFormula()) {
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("SPEC FORMULA can only contain C,H,O, and N when using simple chemistry."), Intl.intl("Error Chemical Formula"), 0);
        }
        PyroMod domain = PyroSim.getApp().getMediator();
        ExSpec tmp = (ExSpec)dest.clone();
        this.save(tmp);
        CompositeTask<PyroMod> editTask = new CompositeTask<PyroMod>(domain);
        editTask.addTask(dest.taskImprint(tmp));
        editTask.addTask(this.d_tags.getUpdateTagsTask(domain, dest));
        PyroSim.getApp().getMediator().getTaskManager().exec(editTask, Intl.intl("Edit Species"));
        this.setModified(false);
        return dest;
    }

    protected void save(ExSpec dataObj) {
        dataObj.setFYI(this.d_FYI.getText());
        dataObj.setMassFrac0((Double)this.d_massFrac.getValue());
        this.d_primitivePanel.saveData(dataObj);
        if (this.d_visDifPanel.isModified()) {
            this.d_visDifPanel.saveData(dataObj.getPrimParams());
        }
        if (this.d_radiationPanel.isModified()) {
            this.d_radiationPanel.saveData(dataObj.getPrimParams());
        }
        if (this.d_depositionPanel.isModified()) {
            this.d_depositionPanel.saveData(dataObj.getPrimParams());
        }
        if (this.d_gasPanel.isModified()) {
            this.d_gasPanel.saveData(dataObj.getPrimParams());
        }
        if (this.d_liquidPanel.isModified()) {
            this.d_liquidPanel.saveData(dataObj.getPrimParams());
        }
        if (this.d_lumpedPanel.isModified()) {
            this.d_lumpedPanel.saveData(dataObj);
        }
        this.d_advancedPanel.save(Collections.singleton(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    public guiPanel getEmptyPanel() {
        return new guiPanel();
    }

    public guiPanel getPrimitivePanel() {
        return this.d_primitivePanel;
    }

    public guiPanel getLumpedPanel() {
        return this.d_lumpedPanel;
    }

    public guiPanel getAdvancedPanel() {
        return this.d_advancedPanel;
    }

    private static void setEnabled(boolean state, JComponent ... cs) {
        for (JComponent c : cs) {
            c.setEnabled(state);
        }
    }

    private void setEditable(boolean state, JTextField ... fields) {
        for (JTextField fld : fields) {
            fld.setEditable(state);
        }
    }

    @Override
    public void init(ExSpec exSpec) {
        this.setEnabled(exSpec != null);
        this.setModified(false);
        if (exSpec == null) {
            return;
        }
        this.d_ID.setValue(exSpec.getName());
        this.d_FYI.setValue(exSpec.getFYI());
        this.d_FYI.setEnabled(true);
        this.d_tags.initTags(exSpec);
        this.d_massFrac.setValue(exSpec.getMassFrac0());
        this.d_massFrac.setEnabled(true);
        this.d_tabs.removeAll();
        this.clearPanels();
        this.d_ID.setEnabled(false);
        if (exSpec.getType() == 1) {
            this.d_tabs.addTab(Intl.intl("Primitive"), this.d_primitivePanel);
            this.d_primitivePanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Vis/Dif"), this.d_visDifPanel);
            this.d_visDifPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Radiation"), this.d_radiationPanel);
            this.d_radiationPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Aerosol"), this.d_depositionPanel);
            this.d_depositionPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Liquid"), this.d_liquidPanel);
            this.d_liquidPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Gas"), this.d_gasPanel);
            this.d_gasPanel.init(exSpec);
        } else if (exSpec.getType() == 0) {
            this.d_tabs.addTab(Intl.intl("Primitive"), this.d_primitivePanel);
            this.d_primitivePanel.init(exSpec);
        } else if (exSpec.getType() == 2 || exSpec.getType() == 3) {
            this.d_tabs.addTab(Intl.intl("Lumped"), this.d_lumpedPanel);
            this.d_lumpedPanel.init(exSpec);
        } else if (exSpec.getType() == 4) {
            this.d_tabs.addTab(Intl.intl("Reaction Fuel"), new guiPanel());
            this.d_FYI.setEnabled(false);
            this.d_massFrac.setEnabled(false);
        }
        if (exSpec.getType() != 4) {
            this.d_advancedPanel.load(Collections.singleton(exSpec), new CustomFDSPanel.AdvPropWrapper<Boolean>(exSpec.isForceWrite(), 1));
            this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
        }
    }

    public void clearPanels() {
        this.d_primitivePanel.init(null);
        this.d_lumpedPanel.init(null);
        this.d_visDifPanel.init(null);
        this.d_radiationPanel.init(null);
        this.d_depositionPanel.init(null);
        this.d_liquidPanel.init(null);
        this.d_gasPanel.init(null);
        this.d_advancedPanel.clear();
    }

    private class PrimitivePanel
    extends guiPanel {
        private static final long serialVersionUID = -5637863651944340892L;
        private final ValueField<UnitDouble> d_molecularWeight;
        private final guiTextField d_formula;
        private final guiRadioButton d_rbMolecularWeight;
        private final guiRadioButton d_rbFormula;
        private final guiComboBox<ExSpec.LUMPED_RULE> d_lumpedOnlyCB;

        public PrimitivePanel() {
            this.setLayout(new GridBagLayout());
            this.d_rbMolecularWeight = new guiRadioButton(Intl.intl("Molecular Weight:"));
            this.d_rbMolecularWeight.setToolTipText("MW");
            this.d_rbFormula = new guiRadioButton(Intl.intl("Chemical Formula:"));
            this.d_rbFormula.setToolTipText("FORMULA");
            this.d_molecularWeight = ValueFields.udFld(UnitSystem.getSource(17));
            this.d_formula = new guiTextField("");
            this.d_lumpedOnlyCB = new guiComboBox<ExSpec.LUMPED_RULE>((Collection<ExSpec.LUMPED_RULE>)Arrays.asList(ExSpec.LUMPED_RULE.values()));
            this.d_lumpedOnlyCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof ExSpec.LUMPED_RULE) {
                        this.setText(((ExSpec.LUMPED_RULE)((Object)value)).id);
                    }
                    return this;
                }
            });
            ButtonGroup bgroup = new ButtonGroup();
            bgroup.add(this.d_rbMolecularWeight);
            bgroup.add(this.d_rbFormula);
            LinkStatus.link((AbstractButton)this.d_rbMolecularWeight, this.d_molecularWeight);
            LinkStatus.link((AbstractButton)this.d_rbFormula, this.d_formula);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_rbMolecularWeight, this.d_molecularWeight);
            gb.addRow(this.d_rbFormula, this.d_formula);
            gb.addRow(Intl.intl("Lumped Component Only:"), this.d_lumpedOnlyCB);
            gb.indent();
            gb.finalizeRows();
        }

        public void saveData(ExSpec dataObj) {
            if (this.d_rbMolecularWeight.isSelected()) {
                dataObj.setMolecularWeight((UnitDouble)this.d_molecularWeight.getValue());
            } else if (this.d_rbFormula.isSelected()) {
                dataObj.setChemFormula(this.d_formula.getText());
            }
            if (dataObj.isPrimitive() || dataObj.isPredefined()) {
                dataObj.setLumpedComponentOnlyRule(this.d_lumpedOnlyCB.getSelectedItem());
            }
        }

        public void init(ExSpec exspec) {
            if (exspec == null) {
                return;
            }
            this.d_molecularWeight.setValue(exspec.getMolecularWeight());
            this.d_formula.setValue(exspec.getChemFormula());
            boolean isFormula = exspec.getWtType() == 2;
            this.d_rbFormula.setSelected(isFormula);
            this.d_rbMolecularWeight.setSelected(!isFormula);
            this.d_lumpedOnlyCB.setSelectedItem((Object)exspec.getLumpedComponentOnlyRule());
            if (exspec.getType() == 0) {
                ExSpecEditor.setEnabled(false, this.d_rbMolecularWeight, this.d_rbFormula, this.d_formula, this.d_molecularWeight);
            } else {
                this.d_rbFormula.setEnabled(true);
                this.d_rbMolecularWeight.setEnabled(true);
                this.d_formula.setEnabled(isFormula);
                this.d_molecularWeight.setEnabled(!isFormula);
            }
            this.setModified(false);
        }

        public boolean validateChemicalFormula() {
            for (char c : this.d_formula.getText().toCharArray()) {
                if (!Character.isLetter(c) || Character.compare(c, 'C') == 0 || Character.compare(c, 'H') == 0 || Character.compare(c, 'O') == 0 || Character.compare(c, 'N') == 0) continue;
                return false;
            }
            return true;
        }
    }

    private class LumpedPanel
    extends guiPanel {
        private static final long serialVersionUID = 459896813178766128L;
        private ExSpecList d_exSpecs;
        private guiRadioButton d_rbMass;
        private guiRadioButton d_rbVolume;
        private guiTable d_table;

        public LumpedPanel(ExSpecList exSpecs) {
            this.d_exSpecs = exSpecs;
            guiLabel labComposition = new guiLabel(Intl.intl("Composition:"));
            this.d_rbMass = new guiRadioButton(Intl.intl("by Mass"));
            this.d_rbMass.setToolTipText("MASS_FRACTION(:)");
            this.d_rbVolume = new guiRadioButton(Intl.intl("by Volume"));
            this.d_rbVolume.setToolTipText("VOLUME_FRACTION(:)");
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.d_rbMass);
            bg.add(this.d_rbVolume);
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Primitive Species"), ""}, new Class[]{ExSpec.class, Double.class}, 16);
            this.d_table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 8427323169820811293L;

                @Override
                public void setValue(Object value) {
                    this.setText(value == null ? "" : ((ExSpec)value).getName());
                }
            });
            this.d_table.setColumnEditable(0, false);
            this.d_table.setNullValuesAllowed(false);
            this.d_rbMass.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (LumpedPanel.this.d_rbMass.isSelected()) {
                        LumpedPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(Intl.intl("Mass Fraction"));
                    } else {
                        LumpedPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(Intl.intl("Volume Fraction"));
                    }
                    LumpedPanel.this.d_table.updateUI();
                }
            });
            this.d_table.setPreferredScrollableViewportSize(new Dimension(150, 200));
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(labComposition, this.d_rbMass, this.d_rbVolume);
            gb.addRow(new JScrollPane(this.d_table), new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.indent();
            gb.finalizeRows();
        }

        public void saveData(ExSpec dataObj) {
            if (!this.isModified()) {
                return;
            }
            LinkedHashMap<ExSpec, Double> newCompMap = new LinkedHashMap<ExSpec, Double>();
            int numRows = this.d_table.getRowCount();
            if (numRows > 0) {
                for (int row = 0; row < numRows; ++row) {
                    Double tableVal;
                    Object val = this.d_table.getValueAt(row, 1);
                    Double d = tableVal = val == null ? Double.valueOf(0.0) : (Double)val;
                    assert (val != null);
                    if (!(tableVal > 0.0)) continue;
                    newCompMap.put((ExSpec)this.d_table.getValueAt(row, 0), tableVal);
                }
            }
            int newType = this.d_rbMass.isSelected() ? 2 : 3;
            dataObj.setComposition(newType, newCompMap);
        }

        public void init(ExSpec exspec) {
            if (exspec == null) {
                ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(0);
                this.setModified(false);
                return;
            }
            ArrayList specList = new ArrayList(this.d_exSpecs.flatten());
            Collections.sort(specList, new Comparator<ExSpec>(this){

                @Override
                public int compare(ExSpec o1, ExSpec o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            int row = 0;
            for (ExSpec primSpec : specList) {
                if (primSpec.getType() == 2 || primSpec.getType() == 3 || primSpec.getType() == 5) continue;
                this.d_table.getModel().setValueAt(primSpec, row, 0);
                if (exspec.getComposition().containsKey(primSpec)) {
                    this.d_table.getModel().setValueAt(exspec.getComposition().get(primSpec), row, 1);
                } else {
                    this.d_table.getModel().setValueAt(0.0, row, 1);
                }
                ++row;
            }
            if (row > 0) {
                this.d_table.setRowLimit(row);
            } else {
                this.d_table.setRowLimit(1);
            }
            if (exspec.getType() == 2) {
                this.d_rbMass.setSelected(true);
            } else {
                this.d_rbVolume.setSelected(true);
            }
            this.setModified(false);
        }
    }

    private class VisDifPanel
    extends guiPanel {
        private static final long serialVersionUID = -2292736655909204022L;
        private VariantEditor d_diffEditor;
        private VariantEditor d_viscEditor;
        private ValueField<Double> d_sigma;
        private ValueField<Double> d_epsilonK;
        private guiCheckBox d_sigmaSet;
        private guiCheckBox d_epsilonSet;

        public VisDifPanel() {
            this.setLayout(new GridBagLayout());
            this.d_diffEditor = new VariantEditor(Intl.intl("Diffusivity"), ExSpec.DIFFUSIVITY_PROFILE, false);
            this.d_viscEditor = new VariantEditor(Intl.intl("Viscosity"), ExSpec.VISCOSITY_PROFILE, false);
            this.d_sigmaSet = new guiCheckBox(Intl.intl("<html>&#963;:"));
            this.d_sigmaSet.setToolTipText("SIGMALJ");
            this.d_sigma = ValueFields.doubleFld();
            LinkStatus.link((AbstractButton)this.d_sigmaSet, this.d_sigma);
            this.d_epsilonSet = new guiCheckBox(Intl.intl("<html>&#949;/&#954;:"));
            this.d_epsilonSet.setToolTipText("EPSILONKLJ");
            this.d_epsilonK = ValueFields.doubleFld();
            LinkStatus.link((AbstractButton)this.d_epsilonSet, this.d_epsilonK);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_diffEditor.getVisLabel(), this.d_diffEditor.getCombo(), this.d_diffEditor.getEditor());
            gb.addRow(this.d_viscEditor.getVisLabel(), this.d_viscEditor.getCombo(), this.d_viscEditor.getEditor());
            gb.addFilledRow(new TitleSeparator(Intl.intl("Leonard-Jones Parameters")));
            gb.addRow(this.d_sigmaSet, this.d_sigma);
            gb.addRow(this.d_epsilonSet, this.d_epsilonK);
            gb.finalizeRows();
        }

        public void init(ExSpec spec) {
            if (spec == null) {
                return;
            }
            ExSpec.PrimitiveParams initParams = spec.getPrimParams();
            this.d_diffEditor.init(initParams.getDiffusivity());
            this.d_viscEditor.init(initParams.getViscosity());
            this.d_sigma.setValue(initParams.getSigmaLJ());
            this.d_sigmaSet.setSelected(initParams.isSigmaLJSet());
            this.d_epsilonK.setValue(initParams.getEpsilonKLJ());
            this.d_epsilonSet.setSelected(initParams.isEpsilonKLJSet());
            this.setModified(false);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_diffEditor.validateData(showWarn, allowModify) && this.d_viscEditor.validateData(showWarn, allowModify);
        }

        public void saveData(ExSpec.PrimitiveParams dataObj) {
            dataObj.setDiffusivity(this.d_diffEditor.getValue());
            dataObj.setViscosity(this.d_viscEditor.getValue());
            dataObj.setSigmaLJ((Double)this.d_sigma.getValue(), this.d_sigmaSet.isSelected());
            dataObj.setEpsilonKLJ((Double)this.d_epsilonK.getValue(), this.d_epsilonSet.isSelected());
        }
    }

    private class RadiationPanel
    extends guiPanel {
        private static final long serialVersionUID = -7784499667585708166L;
        private guiCheckBox d_cbRadCal;
        private guiComboBox d_surrogateCombo;

        public RadiationPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cbRadCal = new guiCheckBox(Intl.intl("RadCal Surrogate:"));
            this.d_surrogateCombo = new guiComboBox<String>((T[])ExSpecList.getRadCalSurrogates());
            this.d_surrogateCombo.setToolTipText("RADCAL_ID");
            LinkStatus.link((AbstractButton)this.d_cbRadCal, this.d_surrogateCombo);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_cbRadCal, this.d_surrogateCombo);
            gb.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams initParams = exSpec.getPrimParams();
            if (initParams.getRadCalSurrogate().length() > 0) {
                this.d_surrogateCombo.setSelectedItem(initParams.getRadCalSurrogate());
                this.d_cbRadCal.setSelected(true);
            } else {
                this.d_cbRadCal.setSelected(false);
                this.d_surrogateCombo.setSelectedItem("METHANE");
            }
            this.setModified(false);
        }

        public void saveData(ExSpec.PrimitiveParams dataObj) {
            if (this.d_cbRadCal.isSelected()) {
                dataObj.setRadCalSurrogate((String)this.d_surrogateCombo.getSelectedItem());
            } else {
                dataObj.setRadCalSurrogate("");
            }
        }
    }

    private class DepositionPanel
    extends guiPanel {
        private static final long serialVersionUID = 3948098942033021371L;
        private guiCheckBox d_cbAerosol;
        private ValueField<UnitDouble> d_density;
        private ValueField<UnitDouble> d_conductivity;
        private ValueField<UnitDouble> d_diameter;

        public DepositionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cbAerosol = new guiCheckBox(Intl.intl("Aerosol"));
            this.d_cbAerosol.setToolTipText("AEROSOL");
            HTMLLabel labDensity = new HTMLLabel(Intl.intl("Density (Solid):"));
            labDensity.setToolTipText("DENSITY_SOLID");
            HTMLLabel labConductivity = new HTMLLabel(Intl.intl("Conductivity (Solid):"));
            labConductivity.setToolTipText("CONDUCTIVITY_SOLID");
            HTMLLabel labDiameter = new HTMLLabel(Intl.intl("Mean Diameter:"));
            labDiameter.setToolTipText("MEAN_DIAMETER");
            this.d_density = ValueFields.udFld(UnitSystem.getSource(4));
            this.d_conductivity = ValueFields.udFld(UnitSystem.getSource(19));
            this.d_diameter = ValueFields.udFld(UnitSystem.getSource(0));
            LinkStatus.link((AbstractButton)this.d_cbAerosol, this.d_density, this.d_conductivity, this.d_diameter);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_cbAerosol);
            gb.addIdentRow(labDensity, this.d_density);
            gb.addIdentRow(labConductivity, this.d_conductivity);
            gb.addIdentRow(labDiameter, this.d_diameter);
            gb.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams initParams = exSpec.getPrimParams();
            if (initParams.isAerosol()) {
                this.d_cbAerosol.setSelected(true);
            }
            this.d_density.setValue(initParams.getDensitySolid());
            this.d_conductivity.setValue(initParams.getConductivitySolid());
            this.d_diameter.setValue(initParams.getMeanDiameter());
            this.setModified(false);
        }

        public void saveData(ExSpec.PrimitiveParams dataObj) {
            dataObj.setAerosol(this.d_cbAerosol.isSelected());
            if (dataObj.isAerosol()) {
                dataObj.setDensitySolid((UnitDouble)this.d_density.getValue());
                dataObj.setConductivitySolid((UnitDouble)this.d_conductivity.getValue());
                dataObj.setMeanDiameter((UnitDouble)this.d_diameter.getValue());
            }
        }
    }

    private class LiquidPanel
    extends guiPanel {
        private static final long serialVersionUID = 451490820008081996L;
        private VariantEditor d_specHeatLiquid = new VariantEditor(Intl.intl("Specific Heat"), ExSpec.SPECHEAT_PROFILE, false);
        private ValueField<UnitDouble> d_density = ValueFields.udFld(UnitSystem.getSource(4));
        private ValueField<UnitDouble> d_vapTemp;
        private ValueField<UnitDouble> d_meltTemp;
        private ValueField<UnitDouble> d_HoV;
        private ValueField<UnitDouble> d_EoF;
        private ValueField<UnitDouble> d_HVRefTemp;
        private guiCheckBox d_densitySet = new guiCheckBox(Intl.intl("Density:"));
        private guiCheckBox d_vapTempSet;
        private guiCheckBox d_meltTempSet;
        private guiCheckBox d_HoVSet;
        private guiCheckBox d_EoFSet;
        private guiCheckBox d_HVRefTempSet;

        public LiquidPanel() {
            this.d_densitySet.setToolTipText("DENSITY_LIQUID");
            LinkStatus.link((AbstractButton)this.d_densitySet, this.d_density);
            this.d_vapTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_vapTempSet = new guiCheckBox(Intl.intl("Vaporization Temperature:"));
            this.d_vapTempSet.setToolTipText("VAPORIZATION_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_vapTempSet, this.d_vapTemp);
            this.d_meltTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_meltTempSet = new guiCheckBox(Intl.intl("Melting Temperature:"));
            this.d_meltTempSet.setToolTipText("MELTING_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_meltTempSet, this.d_meltTemp);
            this.d_HoV = ValueFields.udFld(UnitSystem.getSource(46));
            this.d_HoVSet = new guiCheckBox(Intl.intl("Heat of Vaporization:"));
            this.d_HoVSet.setToolTipText("HEAT_OF_VAPORIZATION");
            LinkStatus.link((AbstractButton)this.d_HoVSet, this.d_HoV);
            this.d_EoF = ValueFields.udFld(UnitSystem.getSource(86));
            this.d_EoFSet = new guiCheckBox(Intl.intl("Enthalpy of Formation:"));
            this.d_EoFSet.setToolTipText("ENTHALPY_OF_FORMATION");
            LinkStatus.link((AbstractButton)this.d_EoFSet, this.d_EoF);
            this.d_HVRefTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_HVRefTempSet = new guiCheckBox(Intl.intl("H-V Reference Temperature:"));
            this.d_HVRefTempSet.setToolTipText("H_V_REFERENCE_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_HVRefTempSet, this.d_HVRefTemp);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_specHeatLiquid.getVisLabel(), this.d_specHeatLiquid.getCombo(), this.d_specHeatLiquid.getEditor());
            gb.addRow(this.d_densitySet, null, this.d_density);
            gb.addRow(this.d_vapTempSet, null, this.d_vapTemp);
            gb.addRow(this.d_meltTempSet, null, this.d_meltTemp);
            gb.addRow(this.d_HoVSet, null, this.d_HoV);
            gb.addRow(this.d_EoFSet, null, this.d_EoF);
            gb.addRow(this.d_HVRefTempSet, null, this.d_HVRefTemp);
            gb.finalizeRows();
        }

        protected boolean isEOFSelected() {
            return this.d_EoFSet.isSelected();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams initParams = exSpec.getPrimParams();
            this.d_specHeatLiquid.init(initParams.getSpecHeatLiquid());
            if (initParams.getDensityLiquid().isConstant()) {
                this.d_density.setValue((UnitDouble)initParams.getDensityLiquid().val);
            }
            this.d_densitySet.setSelected(initParams.isDensityLiquidSet());
            if (initParams.getVapTemp().isConstant()) {
                this.d_vapTemp.setValue((UnitDouble)initParams.getVapTemp().val);
            }
            this.d_vapTempSet.setSelected(initParams.isVapTempSet());
            if (initParams.getMeltTemp().isConstant()) {
                this.d_meltTemp.setValue((UnitDouble)initParams.getMeltTemp().val);
            }
            this.d_meltTempSet.setSelected(initParams.isMeltingTempSet());
            if (initParams.getHoVaporization().isConstant()) {
                this.d_HoV.setValue((UnitDouble)initParams.getHoVaporization().val);
            }
            this.d_HoVSet.setSelected(initParams.isHoVaporizationSet());
            if (initParams.getEoFormation().isConstant()) {
                this.d_EoF.setValue((UnitDouble)initParams.getEoFormation().val);
            }
            this.d_EoFSet.setSelected(initParams.isEoFormationSet());
            if (initParams.getHVRefTemp().isConstant()) {
                this.d_HVRefTemp.setValue((UnitDouble)initParams.getHVRefTemp().val);
            }
            this.d_HVRefTempSet.setSelected(initParams.isHVRefTempSet());
            this.setModified(false);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_specHeatLiquid.validateData(showWarn, allowModify);
        }

        public void saveData(ExSpec.PrimitiveParams dataObj) {
            dataObj.setSpecHeatLiquid(this.d_specHeatLiquid.getValue());
            if (this.d_densitySet.isSelected()) {
                dataObj.setDensityLiquid((UnitDouble)this.d_density.getValue());
            } else {
                dataObj.setDensityLiquid(null);
            }
            if (this.d_vapTempSet.isSelected()) {
                dataObj.setVapTemp((UnitDouble)this.d_vapTemp.getValue());
            } else {
                dataObj.setVapTemp(null);
            }
            if (this.d_meltTempSet.isSelected()) {
                dataObj.setMeltingTemp((UnitDouble)this.d_meltTemp.getValue());
            } else {
                dataObj.setMeltingTemp(null);
            }
            if (this.d_HoVSet.isSelected()) {
                dataObj.setHoVaporization((UnitDouble)this.d_HoV.getValue());
            } else {
                dataObj.setHoVaporization(null);
            }
            if (this.d_EoFSet.isSelected()) {
                dataObj.setEoFormation((UnitDouble)this.d_EoF.getValue());
            } else {
                dataObj.setEoFormation(null);
            }
            if (this.d_HVRefTempSet.isSelected()) {
                dataObj.setHVRefTemp((UnitDouble)this.d_HVRefTemp.getValue());
            } else {
                dataObj.setHVRefTemp(null);
            }
        }
    }

    private class GasPanel
    extends guiPanel {
        private static final long serialVersionUID = 4588646765321711448L;
        private VariantEditor d_specHeat = new VariantEditor(Intl.intl("Specific Heat"), ExSpec.SPECHEAT_PROFILE, false);
        private ValueField<UnitDouble> d_referenceTemperature = ValueFields.udFld(UnitSystem.getSource(1));
        private ValueField<UnitDouble> d_referenceEnthalpy;
        private guiCheckBox d_refTempSet = new guiCheckBox(Intl.intl("Reference Temperature:"));
        private guiCheckBox d_refEnthalpySet;

        public GasPanel() {
            this.d_refTempSet.setToolTipText("REFERENCE_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_refTempSet, this.d_referenceTemperature);
            this.d_referenceEnthalpy = ValueFields.udFld(UnitSystem.getSource(65));
            this.d_refEnthalpySet = new guiCheckBox(Intl.intl("Reference Enthalpy:"));
            this.d_refEnthalpySet.setToolTipText("REFERENCE_ENTHALPY");
            LinkStatus.link((AbstractButton)this.d_refEnthalpySet, this.d_referenceEnthalpy);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_specHeat.getVisLabel(), this.d_specHeat.getCombo(), this.d_specHeat.getEditor());
            gb.addRow(this.d_refTempSet, null, this.d_referenceTemperature);
            gb.addRow(this.d_refEnthalpySet, null, this.d_referenceEnthalpy);
            gb.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams initParams = exSpec.getPrimParams();
            this.d_specHeat.init(initParams.getSpecHeat());
            this.d_referenceTemperature.setValue(initParams.getRefTemp());
            this.d_refTempSet.setSelected(initParams.isRefTempSet());
            if (initParams.getRefEnthalpy().isConstant()) {
                this.d_referenceEnthalpy.setValue((UnitDouble)initParams.getRefEnthalpy().val);
            }
            this.d_refEnthalpySet.setSelected(initParams.isRefEnthalpySet());
            this.setModified(false);
        }

        protected boolean isRefEnthalpySelected() {
            return this.d_refEnthalpySet.isSelected();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_specHeat.validateData(showWarn, allowModify);
        }

        public void saveData(ExSpec.PrimitiveParams dataObj) {
            dataObj.setSpecHeat(this.d_specHeat.getValue());
            dataObj.setRefTemp((UnitDouble)this.d_referenceTemperature.getValue(), this.d_refTempSet.isSelected());
            if (this.d_refEnthalpySet.isSelected()) {
                dataObj.setRefEnthalpy((UnitDouble)this.d_referenceEnthalpy.getValue());
            } else {
                dataObj.setRefEnthalpy(null);
            }
        }
    }

    private static class HTMLLabel
    extends guiLabel {
        private static final long serialVersionUID = 2811808823405044338L;

        public HTMLLabel() {
            this("");
        }

        public HTMLLabel(String s) {
            super(s);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.setForeground(b ? (Color)UIManager.get("Label.foreground") : (Color)UIManager.get("Label.disabledForeground"));
        }
    }
}

