/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.CloudFDSUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiPlaceholderTextField;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.TaskProgress;

public class CloudFDSJobsDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CloudFDSJobsDlg.class.getName());
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 500;
    private final JTable d_table;
    private TableRowSorter<TableModel> d_sorter;
    private guiPlaceholderTextField d_searchField = new guiPlaceholderTextField(Intl.intl("Search..."));
    private final Color SELECTION_BACKGROUND;
    private final Color SELECTION_FOREGROUND;

    public CloudFDSJobsDlg(JFrame owner, ArrayList<CloudFDSJob> jobsList) {
        super((Window)owner, Intl.intl("Cloud FDS Jobs"), 1);
        this.setResizable(true);
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new MigLayout("wrap 1, insets 0, gap 6, fillx"));
        Object[] columnHeaders = new String[]{Intl.intl("Cloud Job"), Intl.intl("Status"), ""};
        DefaultTableModel mod = new DefaultTableModel(columnHeaders, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int col) {
                if (col >= 0 && col < this.getColumnCount()) {
                    return this.getValueAt(0, col).getClass();
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.d_table = new JTable(mod);
        this.SELECTION_FOREGROUND = this.d_table.getSelectionForeground();
        this.SELECTION_BACKGROUND = this.d_table.getSelectionBackground();
        this.d_table.setCellSelectionEnabled(true);
        this.d_sorter = new TableRowSorter<1>(mod);
        this.d_table.setRowSorter(this.d_sorter);
        this.d_table.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.d_table);
        this.d_table.setFillsViewportHeight(true);
        this.d_table.getColumnModel().getColumn(1).setMaxWidth(150);
        this.d_table.getColumnModel().getColumn(2).setMaxWidth(50);
        this.d_table.setShowGrid(false);
        this.d_table.setIntercellSpacing(new Dimension(0, 0));
        Object[] row = new Object[3];
        ImageIcon img = PyroGuiUtil.loadPyroSimIcon("cloudDownload.png");
        for (CloudFDSJob job : jobsList) {
            URLCell download = new URLCell(img, job.name, job.folder);
            download.setEnabled(job.status == CloudFDSUtil.FDS_FEA_STATUS.COMPLETED || job.status == CloudFDSUtil.FDS_FEA_STATUS.STOPPED);
            row[0] = new URLCell(job.name, job.viewURL);
            row[1] = job.status;
            row[2] = download;
            mod.addRow(row);
        }
        this.d_table.getColumnModel().getColumn(0).setCellRenderer(new URLCellRenderer());
        this.d_table.getColumnModel().getColumn(2).setCellRenderer(new URLCellRenderer());
        this.d_table.addMouseListener(new LinkNavigateListener(this));
        this.d_table.addMouseMotionListener(new LinkCursorListener());
        this.d_searchField.setToolTipText(Intl.intl("Filter filenames"));
        this.d_searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CloudFDSJobsDlg.this.updateRowFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CloudFDSJobsDlg.this.updateRowFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CloudFDSJobsDlg.this.updateRowFilter();
            }
        });
        panel.add((Component)this.d_searchField, "span, grow");
        panel.add((Component)scrollPane, "span, grow");
        panel.add((Component)new guiLabel(Intl.intl("Click Cloud Job to open simulation details in browser.")), "span, grow");
        panel.add((Component)new guiLabel(Intl.intl("Click download button to download simulation files.")), "span, grow");
        this.setSize(400, 500);
        EventQueue.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
    }

    private void updateRowFilter() {
        RowFilter<TableModel, Integer> rf = new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                Object object = entry.getValue(0);
                if (object instanceof URLCell) {
                    URLCell cell = (URLCell)object;
                    String tableEntry = cell.d_label.toUpperCase();
                    if (tableEntry.contains(CloudFDSJobsDlg.this.d_searchField.getText().toUpperCase())) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.d_sorter.setRowFilter(rf);
    }

    private static void openLink(String link) {
        try {
            Desktop.getDesktop().browse(new URI(link));
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.toString(), e);
        }
    }

    public static class CloudFDSJob {
        public static final String FDS_EXT = ".fds_";
        public final String name;
        public final String folder;
        public final CloudFDSUtil.FDS_FEA_STATUS status;
        public final String viewURL;
        public final long id;

        public CloudFDSJob(String folder, long id, CloudFDSUtil.FDS_FEA_STATUS status) {
            int extensionIndex = folder.lastIndexOf(FDS_EXT);
            String modelName = folder;
            if (extensionIndex > 0) {
                modelName = folder.substring(0, extensionIndex);
            }
            this.name = String.format("%s (%d)", modelName, id);
            this.status = status;
            this.id = id;
            this.folder = folder;
            this.viewURL = String.format(Locale.US, "%s/en/simulation/view/%d", CloudFDSUtil.CLOUD_PROVIDERS.CFD_FEA.URI, id);
        }

        protected static void downloadSimData(String jobName, String folder, guiProgressMonitor progressMonitor) {
            ForkJoinPool.commonPool().execute(() -> {
                block7: {
                    try {
                        progressMonitor.begin();
                        JSONObject result = CloudFDSUtil.getSimulationResults(folder);
                        if (result == null) {
                            throw new NullPointerException();
                        }
                        long id = (Long)result.get("id");
                        String url = CloudFDSUtil.getDownloadMetadata(id);
                        if (url != null) {
                            Desktop.getDesktop().browse(URI.create(url));
                            break block7;
                        }
                        throw new Exception(Intl.intl("Unable to retrieve the results location."));
                    }
                    catch (Exception e) {
                        String msg = String.format(Intl.intl("An error occured while downloading results for %s."), jobName);
                        guiUtil.showError(PyroSim.getApp(), Intl.intl("Error While Downloading Results"), Intl.intl(msg), (Throwable)e);
                        LOGGER.log(Level.WARNING, msg, e);
                    }
                    finally {
                        progressMonitor.end();
                    }
                }
            });
        }
    }

    private class URLCell
    extends JLabel
    implements Comparable<URLCell> {
        private static final long serialVersionUID = 1L;
        protected String d_label;
        protected String d_URL;
        private String d_textColor;

        public URLCell(String label, String url) {
            super(label);
            this.d_label = label;
            this.d_URL = url;
            this.d_textColor = guiUtil.getPreferredLinkColor();
            this.setOpaque(true);
        }

        public URLCell(Icon img, String label, String url) {
            super(img);
            this.d_label = label;
            this.d_URL = url;
            this.setOpaque(true);
        }

        protected String getFormattedLabel() {
            return String.format("<html><a href=\"%s\">%s</a></html>", this.d_URL, this.d_label);
        }

        @Override
        public int compareTo(URLCell o) {
            if (o == null) {
                return 1;
            }
            if (this.equals(o)) {
                return 0;
            }
            return this.d_label.compareToIgnoreCase(o.d_label);
        }
    }

    private class URLCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private URLCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof URLCell) {
                URLCell url = (URLCell)value;
                if (isSelected) {
                    url.setBackground(CloudFDSJobsDlg.this.SELECTION_BACKGROUND);
                    url.setForeground(CloudFDSJobsDlg.this.SELECTION_FOREGROUND);
                } else {
                    url.setBackground(CloudFDSJobsDlg.this.d_table.getBackground());
                    url.setForeground(CloudFDSJobsDlg.this.d_table.getForeground());
                }
                if (column == 2) {
                    url.setIcon(url.getIcon());
                    url.setText("");
                    url.setHorizontalAlignment(0);
                    url.setToolTipText(Intl.intl("Click to download simulation files."));
                } else {
                    url.setText(url.getFormattedLabel());
                    url.setToolTipText("Click to view simulation details.");
                }
                return url;
            }
            return cell;
        }
    }

    private class LinkNavigateListener
    implements MouseListener {
        private Window parent;

        LinkNavigateListener(Window parent) {
            this.parent = parent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = CloudFDSJobsDlg.this.d_table.rowAtPoint(p);
            int col = CloudFDSJobsDlg.this.d_table.columnAtPoint(p);
            if (row < 0 || col == 1) {
                return;
            }
            Object o = CloudFDSJobsDlg.this.d_table.getValueAt(row, col);
            if (o instanceof URLCell) {
                URLCell cell = (URLCell)o;
                if (col == 0) {
                    CloudFDSJobsDlg.openLink(cell.d_URL);
                }
                if (col == 2) {
                    TaskProgress progress = new TaskProgress();
                    String msg = Intl.intl("Retrieving Simulation Files...");
                    guiProgressMonitor monitor = new guiProgressMonitor(this.parent, msg, true, progress, 0);
                    if (cell.isEnabled()) {
                        CloudFDSJob.downloadSimData(cell.d_label, cell.d_URL, monitor);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class LinkCursorListener
    implements MouseMotionListener {
        private LinkCursorListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = CloudFDSJobsDlg.this.d_table.rowAtPoint(e.getPoint());
            int col = CloudFDSJobsDlg.this.d_table.columnAtPoint(e.getPoint());
            switch (col) {
                case 0: 
                case 2: {
                    CloudFDSJobsDlg.this.d_table.changeSelection(row, col, false, false);
                    CloudFDSJobsDlg.this.d_table.setCursor(Cursor.getPredefinedCursor(12));
                    CloudFDSJobsDlg.this.d_table.repaint();
                    break;
                }
                default: {
                    CloudFDSJobsDlg.this.d_table.clearSelection();
                    CloudFDSJobsDlg.this.d_table.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

