/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.zones;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.geom.Geometry;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.util.Task;

public class Zone
extends NamedPyroObject
implements IPyroGeomSrc,
ITaggable {
    static final long serialVersionUID = 1L;
    public static final Color DEF_COLOR = new Color(0.8f, 0.1f, 0.1f);
    @Deprecated
    private UnitAABox d_box;
    private Point d_geom;
    private boolean d_visible;
    private Color d_color;
    private Set<Tag> d_tags;

    public Zone(String name, Point geom) {
        super(name);
        this.d_geom = geom;
        this.d_visible = true;
        this.d_color = DEF_COLOR;
        this.d_tags = Collections.emptySet();
    }

    public boolean isOuter() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)obj;
        return this.getName().equals(zone.getName()) && this.d_geom.equals(zone.d_geom) && this.d_color.equals(zone.d_color) && Util.identitySetsEqual(this.getTags(), zone.getTags()) && this.isOuter() == zone.isOuter();
    }

    @Override
    public Object clone() {
        Zone clone = (Zone)super.clone();
        return clone;
    }

    @Deprecated
    public UnitAABox getBox() {
        return this.d_box;
    }

    @Deprecated
    public void setBox(UnitAABox box) {
        if (!this.d_box.equals(box)) {
            this.d_box = box;
            this.changedEvt(new Object[0]);
        }
    }

    public Point getLocation() {
        return this.d_geom;
    }

    public void setLocation(Point loc) {
        this.d_geom = loc;
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        if (!this.d_color.equals(color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getZoneGeom());
    }

    public IGeom getZoneGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            assert (false);
            AABoxGeom bg = (AABoxGeom)geom;
            this.d_geom = new Point(new Point3d((bg.max.x + bg.min.x) / 2.0, (bg.max.y + bg.min.y) / 2.0, (bg.max.z + bg.min.z) / 2.0));
            this.changedEvt(new Object[0]);
        } else if (geom instanceof Point) {
            this.d_geom = (Point)geom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Vertex(this.d_color, 10.0));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public String toString() {
        return String.format("Zone[name=\"%s\", location=%s", this.getName(), this.d_geom.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_geom == null) {
            this.d_geom = new Point(this.d_box.getCenter().getPoint3dValue(Geometry.LU));
            this.d_box = null;
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return ITaggable.getTagUpdateDep();
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }
}

