/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.view.AViewGeomProp;
import pyrosim.domain.view.ViewMode;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class CameraState
extends AViewGeomProp<CameraRecord>
implements ITaggable,
INamed {
    static final long serialVersionUID = 1L;
    private Set<Tag> d_tags = Collections.emptySet();

    public CameraState(CameraRecord record) {
        super(record);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public CameraState clone() {
        return (CameraState)super.clone();
    }

    @Override
    public String getName() {
        return Intl.intl("Viewpoint");
    }

    @Override
    public void setName(String id) {
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof CameraGeom) {
            this.set(((CameraGeom)geom).record);
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            Vector3d moveDir = Util3D.vector(((CameraRecord)this.get()).loc, p.loc);
            ITransform xform = TransformUtil.translate(moveDir.x, moveDir.y, moveDir.z);
            CameraGeom newGeom = this.getCameraGeom().transform(xform.getInfo(), 1);
            this.setGeom(newGeom);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getCameraGeom());
    }

    private CameraGeom getCameraGeom() {
        return new CameraGeom((CameraRecord)this.get());
    }

    public CameraRecord getCameraRecord() {
        return this.getCameraGeom().record;
    }

    public ViewMode getViewMode() {
        return ((CameraRecord)this.get()).frustum instanceof OrthoCamera.FrustumRecord ? ViewMode.MV_2D : ViewMode.MV_3D;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Vertex(Color.GREEN, 10.0));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this == obj;
    }

    private static class CameraGeom
    extends Point {
        private static final long serialVersionUID = -2076150722662797833L;
        public final CameraRecord record;

        public CameraGeom(CameraRecord record) {
            super(record.loc);
            this.record = record;
        }

        @Override
        public CameraGeom optimize(IPointOptimizer pool) {
            Point3d loc = pool.getExisting(this.record.loc);
            Point3d ref = pool.getExisting(this.record.ref);
            if (loc == this.record.loc && ref == this.record.ref) {
                return this;
            }
            CameraRecord rec = new CameraRecord(loc, ref, this.record.up, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum);
            return new CameraGeom(rec);
        }

        @Override
        public CameraGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            ITransform.ITransformer xform = ti.getTransformer();
            Point3d loc = xform.transformNew(this.record.loc);
            Point3d ref = xform.transformNew(this.record.ref);
            Vector3d up = xform.transformNew(this.record.up);
            Vector3d view = Util3D.vector(loc, ref);
            Vector3d right = Util3D.cross(view, up);
            up.cross(right, view);
            double upLen = Util3D.safeNormalize(up, 1.0E-6);
            if (upLen == 0.0) {
                return this;
            }
            return new CameraGeom(new CameraRecord(loc, ref, up, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum));
        }
    }
}

