/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ReplacePreserveTask
extends AUndoableTask {
    private final ReplaceRecord[] d_replacements;

    public ReplacePreserveTask(List<? extends IPyroObject> originals, List<? extends IPyroObject> replacements) {
        this.d_replacements = new ReplaceRecord[originals.size()];
        for (int m = 0; m < originals.size(); ++m) {
            this.d_replacements[m] = new ReplaceRecord(originals.get(m), replacements.get(m));
        }
    }

    @Override
    public void run() {
        if (this.d_replacements.length > 0 && this.d_replacements[0].index == -1) {
            IdentityHashMap<IPyroObject, ReplaceRecord> objRecMap = new IdentityHashMap<IPyroObject, ReplaceRecord>();
            LinkedIdentityHashSet groups = new LinkedIdentityHashSet();
            for (ReplaceRecord rec : this.d_replacements) {
                objRecMap.put(rec.original, rec);
                groups.add(rec.original.getParent());
            }
            for (IPyroObject group : groups) {
                int ix = 0;
                for (IPyroObject iPyroObject : group.getMembers()) {
                    ReplaceRecord rec = (ReplaceRecord)objRecMap.get(iPyroObject);
                    if (rec != null) {
                        rec.index = ix;
                    }
                    ++ix;
                }
            }
        }
        this.runReplacements();
    }

    @Override
    public void undo() {
        this.runReplacements();
    }

    private void runReplacements() {
        LinkedIdentityHashMap<IPyroObject, ArrayList<ReplaceRecord>> parentRecMap = new LinkedIdentityHashMap<IPyroObject, ArrayList<ReplaceRecord>>();
        for (ReplaceRecord rec : this.d_replacements) {
            IPyroObject parent = rec.original.getParent();
            ArrayList<ReplaceRecord> recs = (ArrayList<ReplaceRecord>)parentRecMap.get(parent);
            if (recs == null) {
                recs = new ArrayList<ReplaceRecord>();
                parentRecMap.put(parent, recs);
            }
            recs.add(rec);
        }
        for (Map.Entry entry : parentRecMap.entrySet()) {
            IPyroObject parent = (IPyroObject)entry.getKey();
            TVEntryPoint<IPyroObject> parentep = TVEntryPoints.ep(parent);
            ArrayList<? extends IPyroObject> members = new ArrayList<IPyroObject>(parent.getMembers());
            for (ReplaceRecord rec : (List)entry.getValue()) {
                parentep.remove(parent, rec.original);
                parentep.add(parent, rec.replacement);
                members.set(rec.index, rec.replacement);
                rec.swap();
            }
            parentep.reorder(parent, members);
        }
    }

    private static class ReplaceRecord {
        public IPyroObject original;
        public IPyroObject replacement;
        public int index;

        public ReplaceRecord(IPyroObject original, IPyroObject replacement) {
            this.original = original;
            this.replacement = replacement;
            this.index = -1;
        }

        public void swap() {
            IPyroObject temp = this.original;
            this.original = this.replacement;
            this.replacement = temp;
        }
    }
}

