/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SetHoleGeomTask;
import pyrosim.domain.tasks.SetObstGeomTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;

public class RasterizeTask
extends CompositeTask<PyroMod> {
    private final PyroMod d_pyMod;
    private final RasterizationOptions d_props;
    private final Collection<? extends FDSObject> d_objs;

    public RasterizeTask(PyroMod pyMod, Collection<? extends FDSObject> objs, RasterizationOptions props) {
        super(pyMod);
        this.d_pyMod = pyMod;
        this.d_objs = new ArrayList<FDSObject>(objs);
        this.d_props = props;
    }

    @Override
    public boolean isMajor() {
        return true;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        this.d_pyMod.pauseUpdates();
        RasterizationOptions oldOptions = this.d_pyMod.getRastOptions();
        this.d_pyMod.pauseUpdates(false);
        this.d_pyMod.setRastProps(this.d_props);
        this.d_pyMod.resumeUpdates();
        if (this.d_props.mergeIdentical) {
            this.rasterizeAsOne();
        } else {
            this.rasterizeSeparately();
        }
        this.d_pyMod.pauseUpdates(false);
        this.d_pyMod.setRastProps(oldOptions);
        this.d_pyMod.resumeUpdates();
        this.d_pyMod.resumeUpdates();
    }

    private static boolean isEmptyParent(IPyroObject obj) {
        if (!(obj instanceof Composite)) {
            return false;
        }
        Composite comp = (Composite)obj;
        for (IPyroObject member : comp.getMembers()) {
            if (RasterizeTask.isEmptyParent(member)) continue;
            return false;
        }
        return true;
    }

    private void rasterizeAsOne() {
        FDSRasterization rast = this.d_pyMod.getRasterizations();
        FDSObjectRasterization[] objRasts = rast.rasterize(this.d_objs);
        LinkedIdentityHashSet delObjs = new LinkedIdentityHashSet();
        ArrayList<Pair<FDSObject, IPyroObject>> replacements = new ArrayList<Pair<FDSObject, IPyroObject>>();
        ArrayList<AddTask> tasks = new ArrayList<AddTask>();
        for (FDSObjectRasterization rastObjs : objRasts) {
            IPyroObject newObj = rastObjs.getFrags(this.d_props.geomGroups);
            if (rastObjs.sources.size() == 1) {
                replacements.add(new Pair<FDSObject, IPyroObject>(rastObjs.sources.get(0), newObj));
                continue;
            }
            for (FDSObject src : rastObjs.sources) {
                delObjs.add(src);
            }
            if (newObj == null) continue;
            IPyroObject commonParent = Hierarchy.getCommonParent(rastObjs.sources);
            if (!(commonParent instanceof ModelComposite)) {
                commonParent = this.d_pyMod.getObstructions();
            }
            tasks.add(new AddTask((IPyroObject)((ModelComposite)commonParent), new IPyroObject[]{newObj}));
        }
        this.addTask(Tasks.delete(delObjs));
        this.addTask(RasterizeTask.newConvertTask(this.d_pyMod, replacements));
        for (Task task : tasks) {
            this.addTask(task);
        }
    }

    private void rasterizeSeparately() {
        FDSRasterization rast = this.d_pyMod.getRasterizations();
        ArrayList<Pair<FDSObject, IPyroObject>> replacements = new ArrayList<Pair<FDSObject, IPyroObject>>();
        for (FDSObject fDSObject : this.d_objs) {
            FDSObjectRasterization objRast = rast.rasterize(fDSObject);
            if (objRast == null) continue;
            IPyroObject newObj = objRast.getFrags(this.d_props.geomGroups);
            replacements.add(new Pair<FDSObject, IPyroObject>(fDSObject, newObj));
        }
        this.addTask(RasterizeTask.newConvertTask(this.d_pyMod, replacements));
    }

    private static Task newConvertTask(PyroMod mediator, List<Pair<FDSObject, IPyroObject>> replacements) {
        CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(mediator);
        ArrayList<IPyroObject> toDelete = new ArrayList<IPyroObject>();
        ArrayList<FDSObject> originals = new ArrayList<FDSObject>(replacements.size());
        ArrayList<IPyroObject> replObjs = new ArrayList<IPyroObject>(replacements.size());
        for (Pair<FDSObject, IPyroObject> replacement : replacements) {
            FDSObject obj = (FDSObject)replacement.v1;
            IPyroObject newObj = (IPyroObject)replacement.v2;
            if (newObj == null) {
                toDelete.add((IPyroObject)replacement.v1);
                continue;
            }
            if (newObj instanceof ModelComposite) {
                originals.add(obj);
                replObjs.add(newObj);
                continue;
            }
            if (obj instanceof IObstruction) {
                IObstruction newObst = (IObstruction)newObj;
                task.addTask(new SetObstGeomTask((IObstruction)obj, ((IObstruction)newObj).getGeom(), newObst.getSurfaces(), newObst.getColors()));
                continue;
            }
            if (!(obj instanceof IHole)) continue;
            task.addTask(new SetHoleGeomTask((IHole)obj, ((IHole)newObj).getGeom(), ((IHole)newObj).getColors()));
        }
        if (!toDelete.isEmpty()) {
            task.addTask(Tasks.delete(toDelete));
        }
        if (!originals.isEmpty()) {
            task.addTask(Tasks.replace(originals, replObjs, true));
        }
        return task;
    }
}

