/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import pyrosim.Intl;
import pyrosim.PyroMod;
import thunderheadeng.util.Task;

public class InsertAdditionalRecordsTask
implements Task {
    private final String d_toAdd;
    private final PyroMod d_pyroMod;

    public InsertAdditionalRecordsTask(PyroMod model, String addRecs) {
        this.d_pyroMod = model;
        this.d_toAdd = addRecs;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        if (this.d_toAdd.trim().length() == 0) {
            return;
        }
        String existRecs = this.d_pyroMod.getUnprocessedRecords();
        if (existRecs.contains(this.d_toAdd)) {
            String newAddRecs = existRecs.replace(this.d_toAdd, "");
            this.d_pyroMod.setUnprocessedRecords(newAddRecs);
            this.d_pyroMod.getEvents().changed(this.d_pyroMod, PyroMod.EVT_UNPROC_RECS_CHANGED);
        } else {
            System.out.println(Intl.intl("Unable to undo changes to modified additional records."));
        }
    }

    @Override
    public void run() {
        if (this.d_toAdd.trim().length() == 0) {
            return;
        }
        String existRecs = this.d_pyroMod.getUnprocessedRecords();
        if (existRecs.contains(this.d_toAdd)) {
            System.out.println("proposed unprocessed records already present in this model");
            return;
        }
        StringBuilder newAddRecs = new StringBuilder(existRecs);
        if (existRecs.length() > 0 && !existRecs.endsWith(System.getProperty("line.separator"))) {
            newAddRecs.append(System.getProperty("line.separator"));
        }
        newAddRecs.append(this.d_toAdd);
        this.d_pyroMod.setUnprocessedRecords(newAddRecs.toString());
        this.d_pyroMod.getEvents().changed(this.d_pyroMod, PyroMod.EVT_UNPROC_RECS_CHANGED);
    }
}

