/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.RefinementZoneUtil;
import pyrosim.domain.SimParams;
import pyrosim.domain.scenario.Scenario;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.MpiUtil;
import pyrosim.gui.actions.FdsIoUtil;
import pyrosim.io.fds.FDSRenderer;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.MultiSelectTableWithSearch;
import thunderheadeng.gui.Win32;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class ExportScenariosAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    final PyroSim d_app;

    public ExportScenariosAction(PyroSim app) {
        this.d_app = app;
        this.putValue("Name", Intl.intl("Export Scenarios..."));
        this.putValue("ShortDescription", Intl.intl("Batch Export Scenario FDS Files"));
        this.putValue("LongDescription", Intl.intl("Batch Export Scenario FDS Files"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExportScenariosAction.run(this.d_app);
    }

    private static void run(PyroSim app) {
        PyroMod pyMod = app.getMediator();
        if (!app.doSave(true)) {
            return;
        }
        File psmFile = new File(app.getFilename());
        if (!FdsIoUtil.validateModel(app, pyMod, FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI)) {
            return;
        }
        guiDialog scenarioChooser = new guiDialog((Window)app.getMainFrame(), Intl.intl("Export Scenarios"), 9);
        Collection availableScenarios = pyMod.getScenarios().flatten();
        MultiSelectTableWithSearch<Scenario> dataTable = new MultiSelectTableWithSearch<Scenario>(Intl.intl("Scenario (CHID)"), obj -> {
            String chid = FDSRenderer.generateChid(psmFile.getName(), obj.getName());
            return String.format("%s (%s)", obj.getName(), chid);
        });
        dataTable.setObjs(availableScenarios, availableScenarios);
        guiPanel dlgComp = scenarioChooser.getDialogPane();
        dlgComp.setLayout(new MigLayout("fill, insets 0", "", "[]6[grow]"));
        dlgComp.add((Component)new guiLabel(Intl.intl("Select Scenarios to Export:")), "wrap");
        dlgComp.add((Component)dataTable.getEditor(), "grow");
        scenarioChooser.setResizable(true);
        if (scenarioChooser.doModal() != 1) {
            return;
        }
        Collection scenariosToExport = availableScenarios.stream().filter(obj -> dataTable.isSelected(obj)).collect(Collectors.toList());
        ArrayList<String> overwriteWarnings = new ArrayList<String>();
        for (Scenario scenario2 : scenariosToExport) {
            String chid = FDSRenderer.generateChid(psmFile.getName(), scenario2.getName());
            File fdsInputFile = FdsIoUtil.getDefaultFDSInputFile(psmFile, chid);
            File[] files = FdsIoUtil.getFDSFiles(fdsInputFile);
            boolean willOverwrite = Arrays.stream(files).anyMatch(f -> f.exists());
            if (!willOverwrite) continue;
            overwriteWarnings.add(fdsInputFile.getParent());
        }
        if (!overwriteWarnings.isEmpty()) {
            String msg = String.format(Intl.intl("Output already exists in %s.%nWould you like to overwrite and continue?"), overwriteWarnings.get(0));
            int choice = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Overwrite Output?"), 0);
            if (0 != choice) {
                return;
            }
        }
        ExportScenariosAction.activateAndPerform(pyMod, scenariosToExport, scenario -> {
            boolean result;
            String chid = FDSRenderer.generateChid(psmFile.getName(), scenario.getName());
            File fdsInputFile = FdsIoUtil.getDefaultFDSInputFile(psmFile, chid);
            if (!fdsInputFile.getParentFile().exists()) {
                fdsInputFile.getParentFile().mkdirs();
            }
            if (!(result = app.writeFDSFile(fdsInputFile, false, FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI))) {
                JOptionPane.showMessageDialog(app.getMainFrame(), Intl.intl("Unable to write FDS file."));
                return;
            }
        });
        File fdsExeFile = new File(PyroPrefs.getFDSLocation());
        File runfdsFile = new File(PyroPrefs.getRunFDSLocation());
        File mpiexecFile = new File(PyroPrefs.getMPIExecLocation());
        LinkedHashSet<Object> envPath = new LinkedHashSet<Object>();
        envPath.add(runfdsFile.getParent());
        envPath.add(mpiexecFile.getParent());
        envPath.add(fdsExeFile.getParent());
        envPath.add(System.getenv("WINDIR"));
        envPath.add(System.getenv("WINDIR") + "\\system32");
        String sharedChid = FDSRenderer.generateChid(psmFile.getName(), null);
        String runnerFn = String.format("run_scenarios-%s.bat", sharedChid);
        File batFile = new File(psmFile.getParentFile(), runnerFn);
        try (PrintWriter writer = new PrintWriter(batFile, StandardCharsets.US_ASCII.name());){
            writer.println("@SETLOCAL");
            writer.println("@ECHO off");
            writer.println("@ECHO [%~n0] Beginning at %time%");
            writer.println();
            writer.println("SET PATH=");
            for (String string : envPath) {
                writer.println("SET PATH=%PATH%;" + string);
            }
            writer.println();
            SimParams.OpenMp omp = pyMod.getSimParams().getOpenMp();
            FDSRunMonitor.OpenMpOptions openMpOptions = new FDSRunMonitor.OpenMpOptions(omp.getOmpNumThreadsMPIFlag(), omp.getOmpNumThreadsMPI(), omp.getOmpStacksizeFlag(), omp.getOmpStacksize());
            Map<String, String> envEx = MpiUtil.getMpiEnvEx(openMpOptions);
            for (Map.Entry<String, String> entry : envEx.entrySet()) {
                writer.println(String.format("SET %s=%s", entry.getKey(), entry.getValue()));
            }
            writer.println();
            ExportScenariosAction.activateAndPerform(pyMod, scenariosToExport, scenario -> {
                String chid = FDSRenderer.generateChid(psmFile.getName(), scenario.getName());
                File fdsInputFile = FdsIoUtil.getDefaultFDSInputFile(psmFile, chid);
                GridProcessUtil.PROC_COUNT processRule = GridProcessUtil.getProcCountForString(PyroPrefs.getString(PyroPrefs.PREF_MPI_PROC_COUNT));
                int enabledGrids = (int)RefinementZoneUtil.refineMeshesNoInterrupt(pyMod, err -> {}).streamLeaves().count();
                int numProcs = MpiUtil.getNumProcs(processRule, enabledGrids);
                writer.println();
                writer.println("ECHO [%~n0] Scenario \"" + scenario.getName() + "\" beginning at %time%");
                writer.println("PUSHD " + ExportScenariosAction.strToBatArg(fdsInputFile.getParentFile().getName()));
                writer.println(String.format("%s %s -n %s -localonly %s %s", ExportScenariosAction.strToBatArg(runfdsFile.getName()), ExportScenariosAction.strToBatArg(mpiexecFile.getName()), Integer.toString(numProcs), ExportScenariosAction.strToBatArg(fdsExeFile.getPath()), ExportScenariosAction.strToBatArg(fdsInputFile.getName())));
                writer.println("POPD");
            });
            writer.println();
            writer.println("ECHO [%~n0] Completed at %time%");
            writer.println("pause");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(app.getMainFrame(), e.getLocalizedMessage());
            return;
        }
        try {
            Win32.openExplorerToItem(batFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (Application.isVerbose()) {
                JOptionPane.showMessageDialog(app.getMainFrame(), e.getLocalizedMessage());
            }
            return;
        }
    }

    private static void activateAndPerform(PyroMod pyMod, Collection<Scenario> items, Consumer<Scenario> func) {
        pyMod.pauseUpdates(false);
        Scenario original = pyMod.getScenarios().getActive();
        for (Scenario obj : items) {
            pyMod.getScenarios().setActive(obj);
            func.accept(obj);
        }
        pyMod.getScenarios().setActive(original);
        pyMod.resumeUpdates();
    }

    private static String strToBatArg(String str) {
        if (str.contains(" ")) {
            return "\"" + str + "\"";
        }
        return str;
    }
}

