/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.devices.statistics.IStatGeom;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public final class QuantityStat
extends Enum<QuantityStat> {
    public static final /* enum */ QuantityStat STAT_TIME_AVERAGE = new QuantityStat(Intl.intl("Time Average"), "TIME AVERAGE", Integral.NONE, u -> u, 0x80000000L, 0x40000000000L);
    public static final /* enum */ QuantityStat STAT_RUNNING_AVERAGE = new QuantityStat(Intl.intl("Running Average"), "RUNNING AVERAGE", Integral.NONE, u -> u, 0x100000000L, 0x80000000000L);
    public static final /* enum */ QuantityStat STAT_INSTANT_VALUE = new QuantityStat(Intl.intl("Instant Value"), "INSTANT VALUE", Integral.NONE, u -> u, 0x200000000L, 0x100000000000L);
    public static final /* enum */ QuantityStat STAT_TIME_INTEGRAL = new QuantityStat(Intl.intl("Time Integral"), "TIME INTEGRAL", Integral.TIME, QuantityStat.integrateTime(), 0x1000000L, 0x200000000000L);
    public static final /* enum */ QuantityStat STAT_TEMPORAL_MIN = new QuantityStat(Intl.intl("Minimum"), "MIN", Integral.NONE, u -> u, 0x400000000L, 0x400000000000L);
    public static final /* enum */ QuantityStat STAT_TEMPORAL_MAX = new QuantityStat(Intl.intl("Maximum"), "MAX", Integral.NONE, u -> u, 0x800000000L, 0x800000000000L);
    public static final /* enum */ QuantityStat STAT_RMS = new QuantityStat(Intl.intl("RMS"), "RMS", Integral.NONE, u -> u, 0x8000000L, 0x40000000L);
    public static final /* enum */ QuantityStat STAT_COVARIANCE = new QuantityStat(Intl.intl("Covariance"), "COV", Integral.NONE, u -> 28, 0x10000000L, 0x2000000000000L);
    public static final /* enum */ QuantityStat STAT_CORR_COEFFICIENT = new QuantityStat(Intl.intl("Correlation Coefficient"), "CORRCOEF", Integral.NONE, u -> 28, 0x20000000L, 0x1000000000000L);
    public static final /* enum */ QuantityStat STAT_FAVRE_AVERAGE = new QuantityStat(Intl.intl("Favre Average"), "FAVRE AVERAGE", Integral.NONE, u -> u, 0x80000000000000L, 0x200000000000000L);
    public static final /* enum */ QuantityStat STAT_FAVRE_RMS = new QuantityStat(Intl.intl("Favre RMS"), "FAVRE RMS", Integral.NONE, u -> u, 0x100000000000000L, 0x400000000000000L);
    public static final /* enum */ QuantityStat STAT_MIN_TIME = new QuantityStat(Intl.intl("Min Time"), "MIN TIME", Integral.NONE, u -> 2, new long[0]);
    public static final /* enum */ QuantityStat STAT_MAX_TIME = new QuantityStat(Intl.intl("Max Time"), "MAX TIME", Integral.NONE, u -> 2, new long[0]);
    public static final /* enum */ QuantityStat STAT_MIN = new QuantityStat(Intl.intl("Minimum"), "MIN", QuantityStat.allQuantTypes(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> u, QuantityStat.acceptAll(), 65536L);
    public static final /* enum */ QuantityStat STAT_MAX = new QuantityStat(Intl.intl("Maximum"), "MAX", QuantityStat.allQuantTypes(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> u, QuantityStat.acceptAll(), 131072L);
    public static final /* enum */ QuantityStat STAT_MEAN = new QuantityStat(Intl.intl("Mean"), "MEAN", QuantityStat.allQuantTypes(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> u, QuantityStat.acceptAll(), 262144L);
    public static final /* enum */ QuantityStat STAT_VOLUME_MEAN = new QuantityStat(Intl.intl("Volume Mean"), "VOLUME MEAN", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> u, QuantityStat.acceptAll(), 524288L);
    public static final /* enum */ QuantityStat STAT_MASS_MEAN = new QuantityStat(Intl.intl("Mass Mean"), "MASS MEAN", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> u, QuantityStat.acceptAll(), 0x100000L);
    public static final /* enum */ QuantityStat STAT_VOLUME_INTEGRAL = new QuantityStat(Intl.intl("Volume Integral"), "VOLUME INTEGRAL", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.VOLUME, QuantityStat.integrateVolume(), QuantityStat.acceptAll(), 0x200000L);
    public static final /* enum */ QuantityStat STAT_MASS_INTEGRAL = new QuantityStat(Intl.intl("Mass Integral"), "MASS INTEGRAL", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.MASS, QuantityStat.integrateMass(), QuantityStat.acceptAll(), 0x4000000L);
    public static final /* enum */ QuantityStat STAT_CENTROID_X = new QuantityStat(Intl.intl("Centroid X"), "CENTROID X", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x10000000000000L);
    public static final /* enum */ QuantityStat STAT_CENTROID_Y = new QuantityStat(Intl.intl("Centroid Y"), "CENTROID Y", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x20000000000000L);
    public static final /* enum */ QuantityStat STAT_CENTROID_Z = new QuantityStat(Intl.intl("Centroid Z"), "CENTROID Z", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x40000000000000L);
    public static final /* enum */ QuantityStat STAT_MINLOC_X = new QuantityStat(Intl.intl("Min Location X"), "MINLOC X", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x1000000000L);
    public static final /* enum */ QuantityStat STAT_MINLOC_Y = new QuantityStat(Intl.intl("Min Location Y"), "MINLOC Y", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x2000000000L);
    public static final /* enum */ QuantityStat STAT_MINLOC_Z = new QuantityStat(Intl.intl("Min Location Z"), "MINLOC Z", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x4000000000L);
    public static final /* enum */ QuantityStat STAT_MAXLOC_X = new QuantityStat(Intl.intl("Max Location X"), "MAXLOC X", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x8000000000L);
    public static final /* enum */ QuantityStat STAT_MAXLOC_Y = new QuantityStat(Intl.intl("Max Location Y"), "MAXLOC Y", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x10000000000L);
    public static final /* enum */ QuantityStat STAT_MAXLOC_Z = new QuantityStat(Intl.intl("Max Location Z"), "MAXLOC Z", QuantityStat.gasOnly(), IStatGeom.SpatialType.VOLUME, Integral.NONE, u -> 0, QuantityStat.nonIntegrated(new Integral[0]), 0x20000000000L);
    public static final /* enum */ QuantityStat STAT_AREA_INTEGRAL = new QuantityStat(Intl.intl("Area Integral"), "AREA INTEGRAL", QuantityStat.gasOnly(), IStatGeom.SpatialType.AREA, Integral.AREA, QuantityStat.integrateArea(), QuantityStat.acceptAll(), 0x400000L);
    public static final /* enum */ QuantityStat STAT_AREA = new QuantityStat(Intl.intl("Area"), "AREA", QuantityStat.gasOnly(), IStatGeom.SpatialType.AREA, Integral.NONE, u -> 79, QuantityStat.nonIntegrated(new Integral[0]), 0x8000000000000L);
    public static final /* enum */ QuantityStat STAT_SURFACE_INTEGRAL = new QuantityStat(Intl.intl("Surface Integral"), "SURFACE INTEGRAL", QuantityStat.solidOnly(), Type.SPATIAL, QuantityStat.geomTypes(type -> type.isSpatial()), Integral.AREA, QuantityStat.integrateArea(), QuantityStat.acceptAll(), false, 0x800000L, 0x4000000000000L);
    public static final /* enum */ QuantityStat STAT_SURFACE_AREA = new QuantityStat(Intl.intl("Surface Area"), "SURFACE AREA", QuantityStat.solidOnly(), Type.SPATIAL, QuantityStat.geomTypes(type -> type.isSpatial()), Integral.NONE, u -> 79, QuantityStat.nonIntegrated(new Integral[0]), false, new long[0]);
    private static Map<Long, QuantityStat> s_legacyLookup;
    private static Map<Pair<Type, String>, QuantityStat> s_fdsLookup;
    public final Type type;
    public final Set<QuantityType> quantityTypes;
    public final String displayName;
    public final String fdsName;
    public final Set<IStatGeom.Type> geomTypes;
    public final Set<Long> legacyIds;
    public final Integral integral;
    public final Predicate<QuantityStat> compatibleTemporal;
    public final boolean deprecated;
    private final IToStatUnit toStatUnit;
    private static final /* synthetic */ QuantityStat[] $VALUES;

    public static QuantityStat[] values() {
        return (QuantityStat[])$VALUES.clone();
    }

    public static QuantityStat valueOf(String name) {
        return Enum.valueOf(QuantityStat.class, name);
    }

    private static void register(QuantityStat stat) {
        if (s_legacyLookup == null) {
            s_legacyLookup = new HashMap<Long, QuantityStat>();
        }
        if (s_fdsLookup == null) {
            s_fdsLookup = new HashMap<Pair<Type, String>, QuantityStat>();
        }
        stat.legacyIds.forEach(id -> s_legacyLookup.put((Long)id, stat));
        assert (!s_fdsLookup.containsKey(new Pair<Type, String>(stat.type, stat.fdsName)));
        s_fdsLookup.put(new Pair<Type, String>(stat.type, stat.fdsName), stat);
    }

    private QuantityStat(String displayName, String fdsName, Integral integral, IToStatUnit toStatUnit, long ... legacyIds) {
        this(displayName, fdsName, QuantityStat.allQuantTypes(), Type.TEMPORAL, QuantityStat.geomTypes(type -> !type.isSpatial()), integral, toStatUnit, Predicates.alwaysFalse(), false, legacyIds);
    }

    private QuantityStat(String displayName, String fdsName, Set<QuantityType> quantTypes, IStatGeom.SpatialType spatialType, Integral spaceIntegral, IToStatUnit toStatUnit, Predicate<QuantityStat> compatibleTemporal, long ... legacyIds) {
        this(displayName, fdsName, quantTypes, Type.SPATIAL, QuantityStat.geomTypes(type -> type.spatial == spatialType), spaceIntegral, toStatUnit, compatibleTemporal, false, legacyIds);
    }

    private QuantityStat(String displayName, String fdsName, Set<QuantityType> quantTypes, Type type, Integral spaceIntegral, long ... legacyIds) {
        this(displayName, fdsName, quantTypes, type, Set.of(), spaceIntegral, (int u) -> u, QuantityStat.acceptAll(), true, legacyIds);
    }

    private QuantityStat(String displayName, String fdsName, Set<QuantityType> quantTypes, Type statType, Set<IStatGeom.Type> geomTypes, Integral integral, IToStatUnit toStatUnit, Predicate<QuantityStat> compatibleTemporal, boolean deprecated, long ... legacyIds) {
        this.quantityTypes = quantTypes;
        this.type = statType;
        this.fdsName = fdsName;
        this.displayName = displayName;
        this.geomTypes = geomTypes;
        this.legacyIds = LongStream.of(legacyIds).boxed().collect(Collectors.toSet());
        this.integral = integral;
        this.deprecated = deprecated;
        this.toStatUnit = toStatUnit;
        this.compatibleTemporal = compatibleTemporal;
        QuantityStat.register(this);
    }

    public boolean isSpatial() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
        };
    }

    public boolean isTemporal() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> true;
        };
    }

    public boolean isCompatibleWith(QuantityStat temporalStat) {
        assert (this.isSpatial() && temporalStat.isTemporal());
        return this.compatibleTemporal.test(temporalStat);
    }

    public int toStatUnit(int quantityUnit) {
        try {
            return this.toStatUnit.convert(quantityUnit);
        }
        catch (Exception e) {
            return 28;
        }
    }

    protected int tryToStatUnit(int quantityUnit) throws MissingUnitTypeException {
        return this.toStatUnit.convert(quantityUnit);
    }

    public static QuantityStat fromLegacy(long id) {
        QuantityStat result = s_legacyLookup.get(id);
        if (result == null) {
            assert (false);
            throw new IllegalArgumentException(String.format("Missing statistic entry in %s for legacy statistic ID, %d.", QuantityStat.class.getSimpleName(), id));
        }
        return result;
    }

    public static QuantityStat fromFds(Type type, String fdsName) {
        return s_fdsLookup.get(new Pair<Type, String>(type, fdsName));
    }

    public static Stream<QuantityStat> nonDeprecated() {
        return QuantityStat.nonDeprecated(Stream.of(QuantityStat.values()));
    }

    public static Stream<QuantityStat> nonDeprecated(Stream<QuantityStat> statStream) {
        return statStream.filter(stat -> !stat.deprecated);
    }

    public static Stream<QuantityStat> getAllOfType(Stream<QuantityStat> statStream, Type type) {
        return statStream.filter(stat -> stat.type == type);
    }

    public static List<QuantityStat> getSupportedSpatialList() {
        return QuantityStat.getAllOfType(QuantityStat.nonDeprecated(), Type.SPATIAL).sorted(Comparator.comparing(stat -> stat.displayName)).collect(Collectors.toList());
    }

    public static List<QuantityStat> getSupportedTemporalList() {
        return QuantityStat.getAllOfType(QuantityStat.nonDeprecated(), Type.TEMPORAL).sorted(Comparator.comparing(stat -> stat.displayName)).collect(Collectors.toList());
    }

    public String toString() {
        return this.displayName;
    }

    private static Set<QuantityType> accept(QuantityType ... types) {
        return theUtil.toEnumSet(QuantityType.class, (Enum[])types);
    }

    private static Set<QuantityType> gasOnly() {
        return QuantityStat.accept(QuantityType.GAS);
    }

    private static Set<QuantityType> solidOnly() {
        return QuantityStat.accept(QuantityType.SOLID);
    }

    private static Set<QuantityType> allQuantTypes() {
        return QuantityStat.accept(QuantityType.values());
    }

    private static <T> Predicate<T> acceptAll() {
        return Predicates.alwaysTrue();
    }

    private static Predicate<QuantityStat> nonIntegrated(Integral ... exceptions) {
        EnumSet intSet = theUtil.toEnumSet(Integral.class, (Enum[])exceptions);
        intSet.add(Integral.NONE);
        return stat -> intSet.contains((Object)stat.integral);
    }

    private static Set<IStatGeom.Type> geomTypes(Predicate<? super IStatGeom.Type> filter) {
        return theUtil.filterEnum(IStatGeom.Type.class, filter);
    }

    private static IToStatUnit integrateMass() {
        return QuantityStat.integrate(SI.KILOGRAM);
    }

    private static IToStatUnit integrateArea() {
        return QuantityStat.integrate(SI.METER.pow(2));
    }

    private static IToStatUnit integrateVolume() {
        return QuantityStat.integrate(SI.METER.pow(3));
    }

    private static IToStatUnit integrateTime() {
        return QuantityStat.integrate(SI.SECOND);
    }

    private static IToStatUnit integrate(Unit siDelta) {
        return i -> {
            Unit testUnit = SIUS.unit(i);
            if (testUnit.isCompatible(Unit.ONE)) {
                testUnit = Unit.ONE;
            }
            Unit integratedUnit = testUnit.multiply(siDelta);
            int result = SIUS.getInstance().getType(integratedUnit, true);
            if (!UnitSystem.isValidUnit(result)) {
                throw new MissingUnitTypeException(integratedUnit);
            }
            return result;
        };
    }

    public static boolean isCompatible(QuantityStat spatial, QuantityStat temporal) {
        return temporal == null || spatial == null || spatial.isCompatibleWith(temporal);
    }

    private static /* synthetic */ QuantityStat[] $values() {
        return new QuantityStat[]{STAT_TIME_AVERAGE, STAT_RUNNING_AVERAGE, STAT_INSTANT_VALUE, STAT_TIME_INTEGRAL, STAT_TEMPORAL_MIN, STAT_TEMPORAL_MAX, STAT_RMS, STAT_COVARIANCE, STAT_CORR_COEFFICIENT, STAT_FAVRE_AVERAGE, STAT_FAVRE_RMS, STAT_MIN_TIME, STAT_MAX_TIME, STAT_MIN, STAT_MAX, STAT_MEAN, STAT_VOLUME_MEAN, STAT_MASS_MEAN, STAT_VOLUME_INTEGRAL, STAT_MASS_INTEGRAL, STAT_CENTROID_X, STAT_CENTROID_Y, STAT_CENTROID_Z, STAT_MINLOC_X, STAT_MINLOC_Y, STAT_MINLOC_Z, STAT_MAXLOC_X, STAT_MAXLOC_Y, STAT_MAXLOC_Z, STAT_AREA_INTEGRAL, STAT_AREA, STAT_SURFACE_INTEGRAL, STAT_SURFACE_AREA};
    }

    static {
        $VALUES = QuantityStat.$values();
    }

    public static enum Type {
        SPATIAL,
        TEMPORAL;

    }

    public static enum Integral {
        NONE,
        AREA,
        VOLUME,
        TIME,
        MASS;

    }

    public static interface IToStatUnit {
        public int convert(int var1) throws MissingUnitTypeException;
    }

    public static class MissingUnitTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MissingUnitTypeException(Unit unit) {
            super(unit.toString());
        }
    }
}

