/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.QuantityCategory;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.io.fds.v6.FDS6QuantityMap;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadFunction;
import thunderheadeng.util.theUtil;

public final class Quantity
extends Enum<Quantity> {
    public static final /* enum */ Quantity ABSORPTION_COEFFICIENT = new Quantity(Intl.intl("Absorption Coefficient"), "ABSORPTION COEFFICIENT", 13, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity ADIABATIC_SURFACE_TEMPERATURE_GAS = new Quantity(Intl.intl("Adiabatic Surface Temperature Gas"), "ADIABATIC SURFACE TEMPERATURE GAS", 1, QuantityType.GAS, 1L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity ASPIRATION = new Quantity(Intl.intl("Aspiration"), "ASPIRATION", 57, QuantityType.GAS, 0L, Quantity.gasNonIntegratedStats(), true);
    @FDSDeprecated(vFDS="6.6.0", vPyro=121)
    public static final /* enum */ Quantity AVERAGE_SPECIFIC_HEAT = new Quantity(Intl.intl("Average Specific Heat"), "AVERAGE SPECIFIC HEAT", 11, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.MASS));
    @FDSDeprecated(vFDS="6.0.1", vPyro=83)
    public static final /* enum */ Quantity CABLE_TEMPERATURE = new Quantity(Intl.intl("Cable Temperature"), "CABLE TEMPERATURE", 1, QuantityType.GAS, 0L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity CONDUCTIVITY = new Quantity(Intl.intl("Conductivity"), "CONDUCTIVITY", 19, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity DENSITY = new Quantity(Intl.intl("Density"), "DENSITY", 4, QuantityType.GAS, 481L, Quantity.gasStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity DIVERGENCE = new Quantity(Intl.intl("Divergence"), "DIVERGENCE", 35, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity ENTHALPY = new Quantity(Intl.intl("Enthalpy"), "ENTHALPY", 62, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Sensible Enthalpy"), "SENSIBLE ENTHALPY", 62, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity EXTINCTION = new Quantity(Intl.intl("Extinction"), "EXTINCTION", 28, QuantityType.GAS, 129L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity EXTINCTION_COEFFICIENT = new Quantity(Intl.intl("Extinction Coefficient"), "EXTINCTION COEFFICIENT", 51, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity EFFECTIVE_FLAME_TEMP = new Quantity(Intl.intl("Effective Flame Temperature"), "EFFECTIVE FLAME TEMPERATURE", 1, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity FED = new Quantity(Intl.intl("Fractional Effective Dose (FED)"), "FED", 28, QuantityType.GAS, 33L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity FIC = new Quantity(Intl.intl("Fractional Irritant Concentration (FIC)"), "FIC", 28, QuantityType.GAS, 129L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity H = new Quantity(Intl.intl("H"), "H", 36, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity HRRPUL = new Quantity(Intl.intl("Heat Release Rate per Unit Length"), "HRRPUL", 88, QuantityType.GAS, 1L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity HRRPUV = new Quantity(Intl.intl("Heat Release Rate per Unit Volume"), "HRRPUV", 25, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity MIXTURE_FRACTION = new Quantity(Intl.intl("Mixture Fraction"), "MIXTURE FRACTION", 26, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.MASS));
    public static final /* enum */ Quantity OPTICAL_DENSITY = new Quantity(Intl.intl("Optical Density"), "OPTICAL DENSITY", 63, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity PRESSURE = new Quantity(Intl.intl("Pressure"), "PRESSURE", 39, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity BACKGROUND_PRESSURE = new Quantity(Intl.intl("Background Pressure"), "BACKGROUND PRESSURE", 39, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity RADIATIVE_HEAT_FLUX_GAS = new Quantity(Intl.intl("Radiative Heat Flux Gas"), "RADIATIVE HEAT FLUX GAS", 33, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity GAUGE_HEAT_FLUX_GAS = new Quantity(Intl.intl("Gauge Heat Flux Gas"), "GAUGE HEAT FLUX GAS", 33, QuantityType.GAS, 17L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity RELATIVE_HUMIDITY = new Quantity(Intl.intl("Relative Humidity"), "RELATIVE HUMIDITY", 64, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity SPECIFIC_ENTHALPY = new Quantity(Intl.intl("Specific Enthalpy"), "SPECIFIC ENTHALPY", 65, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.MASS));
    public static final /* enum */ Quantity SPECIFIC_SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Specific Sensible Enthalpy"), "SPECIFIC SENSIBLE ENTHALPY", 65, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.MASS));
    public static final /* enum */ Quantity SPECIFIC_HEAT = new Quantity(Intl.intl("Specific Heat"), "SPECIFIC HEAT", 11, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity TEMPERATURE = new Quantity(Intl.intl("Temperature"), "TEMPERATURE", 1, QuantityType.GAS, 481L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity THERMOCOUPLE = new Quantity(Intl.intl("Thermocouple"), "THERMOCOUPLE", 1, QuantityType.GAS, 1L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity U_VELOCITY = new Quantity(Intl.intl("U-Velocity"), "U-VELOCITY", 8, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity V_VELOCITY = new Quantity(Intl.intl("V-Velocity"), "V-VELOCITY", 8, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity W_VELOCITY = new Quantity(Intl.intl("W-Velocity"), "W-VELOCITY", 8, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity VELOCITY = new Quantity(Intl.intl("Velocity"), "VELOCITY", 8, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity VISCOSITY = new Quantity(Intl.intl("Viscosity"), "VISCOSITY", 41, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity VISIBILITY = new Quantity(Intl.intl("Visibility"), "VISIBILITY", 16, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity ADIABATIC_SURFACE_TEMPERATURE = new Quantity(Intl.intl("Adiabatic Surface Temperature"), "ADIABATIC SURFACE TEMPERATURE", 1, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity BACK_WALL_TEMPERATURE = new Quantity(Intl.intl("Back Wall Temperature"), "BACK WALL TEMPERATURE", 1, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity BURNING_RATE = new Quantity(Intl.intl("Burning Rate"), "BURNING RATE", 20, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity CONVECTIVE_FLUX = new Quantity(Intl.intl("Convective Heat Flux"), "CONVECTIVE HEAT FLUX", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity FRICTION_VELOCITY = new Quantity(Intl.intl("Friction Velocity"), "FRICTION VELOCITY", 28, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity GAS_TEMPERATURE = new Quantity(Intl.intl("Gas Temperature"), "GAS TEMPERATURE", 1, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity GAUGE_HEAT_FLUX = new Quantity(Intl.intl("Gauge Heat Flux"), "GAUGE HEAT FLUX", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity HEAT_FLUX = new Quantity(Intl.intl("Net Heat Flux"), "NET HEAT FLUX", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity HEAT_TRANSFER_COEFFICIENT = new Quantity(Intl.intl("Heat Transfer Coefficient"), "HEAT TRANSFER COEFFICIENT", 22, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity HRRPUA = new Quantity(Intl.intl("Heat Release Rate per Unit Area"), "HRRPUA", 22, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity INCIDENT_HEAT_FLUX = new Quantity(Intl.intl("Incident Heat Flux"), "INCIDENT HEAT FLUX", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity INSIDE_WALL_TEMPERATURE = new Quantity(Intl.intl("Inside Wall Temperature"), "INSIDE WALL TEMPERATURE", 1, QuantityType.SOLID, 1L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity NORMAL_VELOCITY = new Quantity(Intl.intl("Normal Velocity"), "NORMAL VELOCITY", 8, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity PRESSURE_COEFFICIENT = new Quantity(Intl.intl("Pressure Coefficient"), "PRESSURE COEFFICIENT", 28, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity RADIATIVE_FLUX = new Quantity(Intl.intl("Radiative Heat Flux"), "RADIATIVE HEAT FLUX", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity RADIOMETER = new Quantity(Intl.intl("Radiometer"), "RADIOMETER", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity SOLID_CONDUCTIVITY = new Quantity(Intl.intl("Solid Conductivity"), "SOLID CONDUCTIVITY", 19, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity SOLID_SPECIFIC_HEAT = new Quantity(Intl.intl("Solid Specific Heat"), "SOLID SPECIFIC HEAT", 11, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity SOLID_ENTHALPY = new Quantity(Intl.intl("Solid Enthalpy"), "SOLID ENTHALPY", 62, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity SOLID_CONDUCTIVITY_MAT = new Quantity(Intl.intl("Solid Conductivity"), "SOLID CONDUCTIVITY", 19, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats(), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity SOLID_ENTHALPY_MAT = new Quantity(Intl.intl("Solid Enthalpy"), "SOLID ENTHALPY", 62, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.VOLUME), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity SOLID_MASS_FRACTION_MAT = new Quantity(Intl.intl("Solid Mass Fraction"), "SOLID MASS FRACTION", 18, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.MASS), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity SOLID_SPECIFIC_HEAT_MAT = new Quantity(Intl.intl("Solid Specific Heat"), "SOLID SPECIFIC HEAT", 11, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats(), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity SURFACE_DENSITY = new Quantity(Intl.intl("Surface Density"), "SURFACE DENSITY", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity WALL_TEMPERATURE = new Quantity(Intl.intl("Wall Temperature"), "WALL TEMPERATURE", 1, QuantityType.SOLID, 17L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity WALL_THICKNESS = new Quantity(Intl.intl("Wall Thickness"), "WALL THICKNESS", 0, QuantityType.SOLID, 1L, Quantity.solidNonIntegratedStats());
    public static final /* enum */ Quantity NORMALIZED_HEATING_RATE = new Quantity(Intl.intl("Normalized Heating Rate"), "NORMALIZED HEATING RATE", 89, QuantityType.SOLID, 1L, Quantity.noStats());
    public static final /* enum */ Quantity NORMALIZED_HEAT_RELEASE_RATE = new Quantity(Intl.intl("Normalized Heat Release Rate"), "NORMALIZED HEAT RELEASE RATE", 89, QuantityType.SOLID, 1L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.0.1", vPyro=52)
    public static final /* enum */ Quantity MASS_LOSS = new Quantity(Intl.intl("Mass Loss"), "MASS LOSS", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity HRR = new Quantity(Intl.intl("Heat Release Rate"), "HRR", 37, QuantityType.GAS, 4L, Quantity.gasNonIntegratedStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity HEAT_FLOW = new Quantity(Intl.intl("Heat Flow"), "HEAT FLOW", 37, QuantityType.GAS, 2L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity HEAT_FLOW_WALL = new Quantity(Intl.intl("Heat Flow Wall"), "HEAT FLOW WALL", 37, QuantityType.SOLID, 2L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), "MASS FLOW", 38, QuantityType.GAS, 2L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), "MASS FLOW WALL", 38, QuantityType.SOLID, 2L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity VOLUME_FLOW = new Quantity(Intl.intl("Volume Flow"), "VOLUME FLOW", 24, QuantityType.GAS, 2L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity VOLUME_FLOW_WALL = new Quantity(Intl.intl("Volume Flow Wall"), "VOLUME FLOW WALL", 24, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity ENTHALPY_FLUX_X = new Quantity(Intl.intl("Enthalpy Flux in X Direction"), "ENTHALPY FLUX X", 97, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity ENTHALPY_FLUX_Y = new Quantity(Intl.intl("Enthalpy Flux in Y Direction"), "ENTHALPY FLUX Y", 97, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity ENTHALPY_FLUX_Z = new Quantity(Intl.intl("Enthalpy Flux in Z Direction"), "ENTHALPY FLUX Z", 97, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity ENTHALPY_FLUX_WALL = new Quantity(Intl.intl("Enthalpy Flux Wall"), "ENTHALPY FLUX WALL", 97, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX = new Quantity(Intl.intl("Mass Flux"), "MASS FLUX", 45, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_WALL = new Quantity(Intl.intl("Mass Flux Wall"), "MASS FLUX WALL", 45, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_TOTAL_MASS_FLUX_WALL = new Quantity(Intl.intl("Total Mass Flux Wall"), "TOTAL MASS FLUX WALL", 45, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_X = new Quantity(Intl.intl("Mass Flux in X Direction"), "MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Y = new Quantity(Intl.intl("Mass Flux in Y Direction"), "MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Z = new Quantity(Intl.intl("Mass Flux in Z Direction"), "MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_X_TOTAL = new Quantity(Intl.intl("Total Mass Flux in X Direction"), "TOTAL MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flux in Y Direction"), "TOTAL MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flux in Z Direction"), "TOTAL MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in X Direction"), "ADVECTIVE MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in Y Direction"), "ADVECTIVE MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in Z Direction"), "ADVECTIVE MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in X Direction"), "DIFFUSIVE MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in Y Direction"), "DIFFUSIVE MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity NOSPEC_MASS_FLUX_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in Z Direction"), "DIFFUSIVE MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity VOLUME_FLOW_X = new Quantity(Intl.intl("Volume Flow in X Direction"), "", 24, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity VOLUME_FLOW_Y = new Quantity(Intl.intl("Volume Flow in Y Direction"), "", 24, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity VOLUME_FLOW_Z = new Quantity(Intl.intl("Volume Flow in Z Direction"), "", 24, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity VOLUME_FLOW_BOUNDARY = new Quantity(Intl.intl("Volume Flow in X Direction"), "", 24, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity ENTHALPY_FLOW_X = new Quantity(Intl.intl("Enthalpy Flow in X Direction"), "", 94, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity ENTHALPY_FLOW_Y = new Quantity(Intl.intl("Enthalpy Flow in Y Direction"), "", 94, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity ENTHALPY_FLOW_Z = new Quantity(Intl.intl("Enthalpy Flow in Z Direction"), "", 94, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity ENTHALPY_FLOW_WALL = new Quantity(Intl.intl("Enthalpy Wall"), "", 94, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_TOTAL_MASS_FLOW_WALL = new Quantity(Intl.intl("Total Mass Flow Wall"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X = new Quantity(Intl.intl("Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y = new Quantity(Intl.intl("Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z = new Quantity(Intl.intl("Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_TOTAL = new Quantity(Intl.intl("Total Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats());
    public static final /* enum */ Quantity LAYER_HEIGHT = new Quantity(Intl.intl("Layer Height"), "LAYER HEIGHT", 0, QuantityType.GAS, 8L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity LOWER_TEMPERATURE = new Quantity(Intl.intl("Lower Temperature"), "LOWER TEMPERATURE", 1, QuantityType.GAS, 8L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity PATH_OBSCURATION = new Quantity(Intl.intl("Path Obscuration"), "PATH OBSCURATION", 80, QuantityType.GAS, 8L, Quantity.gasNonIntegratedStats(), true);
    public static final /* enum */ Quantity TRANSMISSION = new Quantity(Intl.intl("Transmission"), "TRANSMISSION", 31, QuantityType.GAS, 8L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity UPPER_TEMPERATURE = new Quantity(Intl.intl("Upper Temperature"), "UPPER TEMPERATURE", 1, QuantityType.GAS, 8L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity CHAMBER_OBSCURATION = new Quantity(Intl.intl("Chamber Obscuration"), "CHAMBER OBSCURATION", 31, QuantityType.GAS, 0L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity LINK_TEMPERATURE = new Quantity(Intl.intl("Link Temperature"), "LINK TEMPERATURE", 1, QuantityType.GAS, 0L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity SPRINKLER_LINK_TEMPERATURE = new Quantity(Intl.intl("Sprinkler Link Temperature"), "SPRINKLER LINK TEMPERATURE", 1, QuantityType.GAS, 0L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity CONTROL_VALUE = new Quantity(Intl.intl("Control Value"), "", 28, QuantityType.GAS, 0L, Quantity.noStats());
    public static final /* enum */ Quantity ACTUATED_SPRINKLERS = new Quantity(Intl.intl("Actuated Sprinklers"), "ACTUATED SPRINKLERS", 28, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity CPU_TIME = new Quantity(Intl.intl("CPU Time"), "CPU TIME", 2, QuantityType.GAS, 1L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.7.6", vPyro=139)
    public static final /* enum */ Quantity CPU_TIME_PER_STEP = new Quantity(Intl.intl("CPU Time per Step"), "CPU TIME PER STEP", 2, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity DEPOSITION_VELOCITY = new Quantity(Intl.intl("Deposition Velocity"), "DEPOSITION VELOCITY", 8, QuantityType.GAS, 17L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity ITERATION = new Quantity(Intl.intl("Iteration"), "ITERATION", 28, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity NUMBER_OF_PARTICLES = new Quantity(Intl.intl("Number of Particles"), "NUMBER OF PARTICLES", 28, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity OPEN_NOZZLES = new Quantity(Intl.intl("Open Nozzles"), "OPEN NOZZLES", 28, QuantityType.GAS, 1L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity PRESSURE_ZONE = new Quantity(Intl.intl("Pressure Zone"), "PRESSURE ZONE", 28, QuantityType.GAS, 129L, Quantity.noStats());
    public static final /* enum */ Quantity TIME = new Quantity(Intl.intl("Time"), "TIME", 2, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats());
    public static final /* enum */ Quantity TIME_STEP = new Quantity(Intl.intl("Time Step"), "TIME STEP", 2, QuantityType.GAS, 1L, Quantity.noStats());
    @FDSDeprecated(vFDS="6.3", vPyro=85)
    public static final /* enum */ Quantity TURBULENCE_RESOLUTION = new Quantity(Intl.intl("Turbulence Resolution"), "TURBULENCE RESOLUTION", 28, QuantityType.GAS, 129L, Quantity.noStats());
    public static final /* enum */ Quantity WALL_CLOCK_TIME = new Quantity(Intl.intl("Wall Clock Time"), "WALL CLOCK TIME", 2, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity WALL_CLOCK_TIME_ITERATIONS = new Quantity(Intl.intl("Wall Clock Time Iterations"), "WALL CLOCK TIME ITERATIONS", 2, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity AERO_VOLUME_FRACTION = new Quantity(Intl.intl("Aerosol Volume Fraction"), "AEROSOL VOLUME FRACTION", 32, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction"), "MASS FRACTION", 18, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.MASS), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction"), "VOLUME FRACTION", 32, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_X = new Quantity(Intl.intl("Mass Flux in X Direction"), "MASS FLUX X", 45, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Y = new Quantity(Intl.intl("Mass Flux in Y Direction"), "MASS FLUX Y", 45, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Z = new Quantity(Intl.intl("Mass Flux in Z Direction"), "MASS FLUX Z", 45, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX = new Quantity(Intl.intl("Mass Flux"), "MASS FLUX", 45, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_DENSITY = new Quantity(Intl.intl("Density"), "DENSITY", 4, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.VOLUME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_VISIBILITY = new Quantity(Intl.intl("Visibility"), "VISIBILITY", 16, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_OPTICAL_DENSITY = new Quantity(Intl.intl("Optical Density"), "OPTICAL DENSITY", 63, QuantityType.GAS, 225L, Quantity.gasNonIntegratedStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_SURFACE_DEPOSITION = new Quantity(Intl.intl("Surface Deposition"), "SURFACE DEPOSITION", 83, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_AMPUA = new Quantity(Intl.intl("Accumulated Mass Per Unit Area"), "AMPUA_Z", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_CPUA = new Quantity(Intl.intl("Cooling Per Unit Area"), "CPUA_Z", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MPUA = new Quantity(Intl.intl("Mass Per Unit Area"), "MPUA_Z", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MPUV = new Quantity(Intl.intl("Mass Per Unit Volume"), "MPUV_Z", 4, QuantityType.GAS, 193L, Quantity.gasStats(QuantityStat.Integral.VOLUME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_WALL = new Quantity(Intl.intl("Mass Flux Wall"), "MASS FLUX WALL", 45, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_TOTAL_MASS_FLUX_WALL = new Quantity(Intl.intl("Total Mass Flux Wall"), "TOTAL MASS FLUX WALL", 45, QuantityType.SOLID, 226L, Quantity.solidStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_X_TOTAL = new Quantity(Intl.intl("Total Mass Flux in X Direction"), "TOTAL MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flux in Y Direction"), "TOTAL MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flux in Z Direction"), "TOTAL MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in X Direction"), "ADVECTIVE MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in Y Direction"), "ADVECTIVE MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flux in Z Direction"), "ADVECTIVE MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in X Direction"), "DIFFUSIVE MASS FLUX X", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in Y Direction"), "DIFFUSIVE MASS FLUX Y", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flux in Z Direction"), "DIFFUSIVE MASS FLUX Z", 45, QuantityType.GAS, 226L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_TOTAL_MASS_FLOW_WALL = new Quantity(Intl.intl("Total Mass Flow Wall"), "", 38, QuantityType.SOLID, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X = new Quantity(Intl.intl("Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y = new Quantity(Intl.intl("Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z = new Quantity(Intl.intl("Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_TOTAL = new Quantity(Intl.intl("Total Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in X Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Y Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Z Direction"), "", 38, QuantityType.GAS, 2L, Quantity.noStats(), QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity MATL_DENSITY = new Quantity(Intl.intl("Density"), "", 4, QuantityType.GAS, 256L, Quantity.gasStats(QuantityStat.Integral.VOLUME), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity MATL_SOLID_DENSITY = new Quantity(Intl.intl("Solid Density"), "SOLID DENSITY", 4, QuantityType.SOLID, 1L, Quantity.solidStats(QuantityStat.Integral.VOLUME), QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity PART_ACMPUA = new Quantity(Intl.intl("Accumulated Mass Per Unit Area"), "AMPUA", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_CPUA = new Quantity(Intl.intl("Cooling Per Unit Area"), "CPUA", 33, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_X = new Quantity(Intl.intl("Mass Flux of Particles in X Direction"), "PARTICLE FLUX X", 45, QuantityType.GAS, 192L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_Y = new Quantity(Intl.intl("Mass Flux of Particles in Y Direction"), "PARTICLE FLUX Y", 45, QuantityType.GAS, 192L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_Z = new Quantity(Intl.intl("Mass Flux of Particles in Z Direction"), "PARTICLE FLUX Z", 45, QuantityType.GAS, 192L, Quantity.gasStats(QuantityStat.Integral.AREA, QuantityStat.Integral.TIME), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MPUA = new Quantity(Intl.intl("Mass Per Unit Area"), "MPUA", 23, QuantityType.SOLID, 17L, Quantity.solidStats(QuantityStat.Integral.AREA), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MPUV = new Quantity(Intl.intl("Mass Per Unit Volume"), "MPUV", 4, QuantityType.GAS, 193L, Quantity.gasStats(QuantityStat.Integral.VOLUME), QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity HVAC_AIRCOIL_HEAT_EXCHANGE = new Quantity(Intl.intl("Heat Exchange Rate for an Aircoil"), "AIRCOIL HEAT EXCHANGE", 37, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_DENSITY = new Quantity(Intl.intl("Density of the Flow in a Duct"), "DUCT DENSITY", 4, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_CELL_DENSITY = new Quantity(Intl.intl("Gas density in a Duct cell"), "DUCT CELL DENSITY", 4, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_CELL_MASS_FRACTION = new Quantity(Intl.intl("Mass fraction of a species in a Duct cell"), "DUCT CELL MASS FRACTION", 18, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_DUCT_CELL_TEMPERATURE = new Quantity(Intl.intl("Gas temperature in a Duct cell"), "DUCT CELL TEMPERATURE", 1, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_CELL_VOLUME_FRACTION = new Quantity(Intl.intl("Volume fraction of a species in a Duct cell"), "DUCT CELL VOLUME FRACTION", 32, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_DUCT_ENTHALPY_FLOW = new Quantity(Intl.intl("Enthalpy flow in a Duct"), "DUCT ENTHALPY FLOW", 62, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_LOSS = new Quantity(Intl.intl("Total flow loss coefficient for a Duct"), "DUCT LOSS", 28, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_MASS_FLOW = new Quantity(Intl.intl("Mass Flow in a Duct"), "DUCT MASS FLOW", 38, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Duct"), "DUCT MASS FRACTION", 18, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_DUCT_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow in a Duct"), "DUCT TEMPERATURE", 1, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VELOCITY = new Quantity(Intl.intl("Velocity of a Duct"), "DUCT VELOCITY", 8, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VOLUME_FLOW = new Quantity(Intl.intl("Volumetric Flow in a Duct"), "DUCT VOLUME FLOW", 24, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Duct"), "DUCT VOLUME FRACTION", 32, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    @FDSDeprecated(vFDS="6.8.0", vPyro=162)
    public static final /* enum */ Quantity HVAC_DUCT_ENERGY_FLOW = new Quantity(Intl.intl("Energy Flow in a Duct"), "DUCT ENERGY FLOW", 37, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_FAN_PRESSURE = new Quantity(Intl.intl("Pressure output of a Fan in a Duct"), "FAN PRESSURE", 39, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_FILTER_LOADING = new Quantity(Intl.intl("Loading of a Species in a Filter"), "FILTER LOADING", 77, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_FILTER_LOSS = new Quantity(Intl.intl("Flow Loss through a Filter"), "FILTER LOSS", 28, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_DENSITY = new Quantity(Intl.intl("Density of the Flow through a Node"), "NODE DENSITY", 4, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_ENTHALPY = new Quantity(Intl.intl("Enthalpy of the Flow through a Node"), "NODE ENTHALPY", 62, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Sensible Enthalpy of the Flow through a Node"), "NODE SENSIBLE ENTHALPY", 62, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Node"), "NODE MASS FRACTION", 18, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_NODE_PRESSURE = new Quantity(Intl.intl("Pressure of a Node"), "NODE PRESSURE", 39, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_PRESSURE_DIFFERENCE = new Quantity(Intl.intl("Pressure Difference between Two Nodes"), "NODE PRESSURE DIFFERENCE", 39, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow through a Node"), "NODE TEMPERATURE", 1, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Node"), "NODE VOLUME FRACTION", 32, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_AIRCOIL_HEAT_EXCHANGE = new Quantity(Intl.intl("Heat Exchange Rate for an Aircoil"), "AIRCOIL HEAT EXCHANGE", 37, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_DENSITY = new Quantity(Intl.intl("Density of the Flow in a Duct"), "DUCT DENSITY", 4, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_CELL_DENSITY = new Quantity(Intl.intl("Gas density in a Duct cell"), "DUCT CELL DENSITY", 4, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_CELL_MASS_FRACTION = new Quantity(Intl.intl("Mass fraction of a species in a Duct cell"), "DUCT CELL MASS FRACTION", 18, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_CELL_TEMPERATURE = new Quantity(Intl.intl("Gas temperature in a Duct cell"), "DUCT CELL TEMPERATURE", 1, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_CELL_VOLUME_FRACTION = new Quantity(Intl.intl("Volume fraction of a species in a Duct cell"), "DUCT CELL VOLUME FRACTION", 32, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_ENTHALPY_FLOW = new Quantity(Intl.intl("Enthalpy flow in a Duct"), "DUCT ENTHALPY FLOW", 62, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_LOSS = new Quantity(Intl.intl("Total flow loss coefficient for a Duct"), "DUCT LOSS", 28, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_MASS_FLOW = new Quantity(Intl.intl("Mass Flow in a Duct"), "DUCT MASS FLOW", 38, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Duct"), "DUCT MASS FRACTION", 18, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow in a Duct"), "DUCT TEMPERATURE", 1, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_VELOCITY = new Quantity(Intl.intl("Velocity of a Duct"), "DUCT VELOCITY", 8, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_VOLUME_FLOW = new Quantity(Intl.intl("Volumetric Flow in a Duct"), "DUCT VOLUME FLOW", 24, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_DUCT_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Duct"), "DUCT VOLUME FRACTION", 32, QuantityType.HVAC_DUCT, 512L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_FAN_PRESSURE = new Quantity(Intl.intl("Pressure output of a fan in a Duct"), "FAN PRESSURE", 39, QuantityType.HVAC_DUCT, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_FILTER_LOADING = new Quantity(Intl.intl("Loading of a Species in a Filter"), "FILTER LOADING", 77, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_FILTER_LOSS = new Quantity(Intl.intl("Flow Loss through a Filter"), "FILTER LOSS", 28, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_DENSITY = new Quantity(Intl.intl("Density of the Flow through a Node"), "NODE DENSITY", 4, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_ENTHALPY = new Quantity(Intl.intl("Enthalpy of the Flow through a Node"), "NODE ENTHALPY", 62, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Sensible Enthalpy of the Flow through a Node"), "NODE SENSIBLE ENTHALPY", 62, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Node"), "NODE MASS FRACTION", 18, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity OUT_HVAC_NODE_PRESSURE = new Quantity(Intl.intl("Pressure of a Node"), "NODE PRESSURE", 39, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_PRESSURE_DIFFERENCE = new Quantity(Intl.intl("Pressure Difference between Two Nodes"), "NODE PRESSURE DIFFERENCE", 39, QuantityType.HVAC_NODE, 0L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow through a Node"), "NODE TEMPERATURE", 1, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, new Object[0]);
    public static final /* enum */ Quantity OUT_HVAC_NODE_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Node"), "NODE VOLUME FRACTION", 32, QuantityType.HVAC_NODE, 1024L, Quantity.noStats(), QuantityCategory.HVAC, ExSpec.class);
    public static final /* enum */ Quantity CELL_U = new Quantity(Intl.intl("Cell U"), "CELL U", 8, QuantityType.GAS, 161L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity CELL_V = new Quantity(Intl.intl("Cell V"), "CELL V", 8, QuantityType.GAS, 161L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity CELL_W = new Quantity(Intl.intl("Cell W"), "CELL W", 8, QuantityType.GAS, 161L, Quantity.gasStats(QuantityStat.Integral.TIME));
    public static final /* enum */ Quantity YPLUS = new Quantity(Intl.intl("Viscous Wall Units"), "VISCOUS WALL UNITS", 28, QuantityType.SOLID, 17L, Quantity.noStats());
    public static final /* enum */ Quantity PDPA = new Quantity(Intl.intl("Particle Diagnostics"), "PDPA", 28, QuantityType.GAS, 1L, Quantity.noStats());
    public static final /* enum */ Quantity INTEGRATED_INTENSITY = new Quantity(Intl.intl("Integrated Intensity"), "INTEGRATED INTENSITY", 22, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.AREA));
    public static final /* enum */ Quantity RADIATION_LOSS = new Quantity(Intl.intl("Radiation Loss"), "RADIATION LOSS", 25, QuantityType.GAS, 225L, Quantity.gasStats(QuantityStat.Integral.VOLUME));
    public static final /* enum */ Quantity CHEMISTRY_ITER = new Quantity(Intl.intl("Chemical Subiterations"), "CHEMICAL SUBITERATIONS", 28, QuantityType.GAS, 128L, Quantity.gasNonIntegratedStats());
    public final String name;
    public final String fdsName;
    public final int unitType;
    public final QuantityType quantityType;
    public final long outputTypes;
    public final boolean mixFracOnly;
    public final Set<QuantityStat> statistics;
    public final String category;
    public final Class<? extends IPyroObject>[] requiredTypes;
    public final Predicate[] typeFilters;
    private static final /* synthetic */ Quantity[] $VALUES;

    public static Quantity[] values() {
        return (Quantity[])$VALUES.clone();
    }

    public static Quantity valueOf(String name) {
        return Enum.valueOf(Quantity.class, name);
    }

    private Quantity(String name, String fdsName, int unitType, QuantityType quantityType, long outputTypes, Set<QuantityStat> stats) {
        this(name, fdsName, unitType, quantityType, outputTypes, stats, false);
    }

    private Quantity(String name, String fdsName, int unitType, QuantityType quantityType, long outputTypes, Set<QuantityStat> stats, QuantityCategory category, Object ... args) {
        this(name, fdsName, unitType, quantityType, outputTypes, false, category, stats, args);
    }

    private Quantity(String name, String fdsName, int unitType, QuantityType quantityType, long outputTypes, Set<QuantityStat> stats, boolean mixFracOnly) {
        this(name, fdsName, unitType, quantityType, outputTypes, mixFracOnly, null, stats, new Object[0]);
    }

    private Quantity(String name, String fdsName, int unitType, QuantityType quantityType, long outputTypes, boolean mixFracOnly, QuantityCategory category, Set<QuantityStat> stats, Object ... args) {
        this.name = name;
        this.fdsName = fdsName;
        this.unitType = unitType;
        this.quantityType = quantityType;
        this.outputTypes = outputTypes;
        this.mixFracOnly = mixFracOnly;
        this.statistics = stats;
        String string2 = this.category = category == null ? null : category.category;
        if (fdsName.isBlank() && !stats.isEmpty()) {
            TeciLogging.log(TeciLogging.getEnumLogger(), Level.WARNING, "[Quantity:%s] fdsName is blank, but statistics are supported. If this is an actual FDS quantity, make sure there is special handling for this quantity in %s.renderQuantity() and parseQuantity(). Otherwise, remove the statistics.", name, FDS6QuantityMap.class.getSimpleName());
        }
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<Predicate> filters = new ArrayList<Predicate>();
        int m = 0;
        while (m < args.length) {
            Class type = (Class)args[m];
            Predicate filter = Predicates.alwaysTrue();
            if (++m < args.length && args[m] instanceof Predicate) {
                filter = (Predicate)args[m];
                ++m;
            }
            types.add(type);
            filters.add(filter);
        }
        this.requiredTypes = types.toArray(new Class[types.size()]);
        this.typeFilters = filters.toArray(new Predicate[filters.size()]);
        assert (this.testValidStatUnits());
    }

    private boolean testValidStatUnits() {
        Function<QuantityStat.Type, List> getStats = type -> Stream.concat(Stream.of((QuantityStat)null), this.statistics.stream().filter(stat -> stat.type == type)).toList();
        List spatialStats = getStats.apply(QuantityStat.Type.SPATIAL);
        List temporalStats = getStats.apply(QuantityStat.Type.TEMPORAL);
        QuadFunction<QuantityStat, QuantityStat, Integer, QuantityStat, Integer> tryStat = (spatial, temporal, baseUnitType, stat) -> {
            try {
                if (stat != null) {
                    return stat.tryToStatUnit((int)baseUnitType);
                }
                return baseUnitType;
            }
            catch (QuantityStat.MissingUnitTypeException e) {
                assert (false) : String.format("[Quantity=%s] Statistic combo, '%s':'%s', requires a unit type for '%s' in %s.class.", this.name, spatial != null ? spatial.displayName : "[none]", temporal != null ? temporal.displayName : "[none]", e.getMessage(), UnitSystem.class.getSimpleName());
                return -1;
            }
        };
        for (QuantityStat spatial2 : spatialStats) {
            int spatialUnit = tryStat.apply(spatial2, null, this.unitType, spatial2);
            for (QuantityStat temporal2 : temporalStats) {
                if (spatial2 == null && temporal2 == null || spatial2 != null && temporal2 != null && !spatial2.isCompatibleWith(temporal2)) continue;
                tryStat.apply(spatial2, temporal2, spatialUnit, temporal2);
            }
        }
        return true;
    }

    public boolean isDeprecated() {
        try {
            return Quantity.class.getField(this.name()).isAnnotationPresent(FDSDeprecated.class);
        }
        catch (NoSuchFieldException e) {
            assert (false);
            return false;
        }
    }

    public StaticQuantity create() {
        assert (this.requiredTypes.length == 0);
        return new StaticQuantity(this);
    }

    public ObjectQuantity create(IPyroObject ... args) {
        assert (args.length > 0 && this.isValidArgs(args));
        return new ObjectQuantity(this, args);
    }

    public IQuantity create(Collection<? extends IPyroObject> args) {
        IPyroObject[] vargs = args.toArray(new IPyroObject[args.size()]);
        assert (this.isValidArgs(vargs));
        if (this.requiredTypes.length > 0) {
            return new ObjectQuantity(this, vargs);
        }
        return new StaticQuantity(this);
    }

    public boolean isValidArgs(IPyroObject ... args) {
        try {
            this.checkArgs(args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkArgs(IPyroObject ... args) throws Exception {
        if (args.length != this.requiredTypes.length) {
            String msg = String.format(Intl.intl("%d objects must be specified."), this.requiredTypes.length);
            throw new Exception(msg);
        }
        for (int m = 0; m < args.length; ++m) {
            Class<? extends IPyroObject> type = this.requiredTypes[m];
            if (!type.isInstance(args[m])) {
                String msg = String.format(Intl.intl("Object %1$d must be a %2$s."), m, TVEntryPoints.ep(type).getCategoryName((Class<? extends IPyroObject>)((Object)args[m])));
                throw new Exception(msg);
            }
            if (this.typeFilters[m].test(type.cast(args[m]))) continue;
            String msg = this.typeFilters[m].toString();
            throw new Exception(msg);
        }
    }

    public int getNumArgs() {
        return this.requiredTypes.length;
    }

    public boolean isCompatible(QuantityStat stat) {
        return stat == null || this.statistics.contains((Object)stat);
    }

    private static Set<QuantityStat> noStats() {
        return Set.of();
    }

    private static final Set<QuantityStat> gasNonIntegratedStats() {
        return Quantity.gasStats(new QuantityStat.Integral[0]);
    }

    private static final Set<QuantityStat> gasStats(QuantityStat.Integral ... integrals) {
        return Quantity.stats(QuantityType.GAS, integrals);
    }

    private static final Set<QuantityStat> solidNonIntegratedStats() {
        return Quantity.solidStats(new QuantityStat.Integral[0]);
    }

    private static final Set<QuantityStat> solidStats(QuantityStat.Integral ... integrals) {
        return Quantity.stats(QuantityType.SOLID, integrals);
    }

    private static final Set<QuantityStat> stats(QuantityType type, QuantityStat.Integral ... integralTypes) {
        EnumSet integrals = theUtil.toEnumSet(QuantityStat.Integral.class, (Enum[])integralTypes);
        integrals.add(QuantityStat.Integral.NONE);
        return QuantityStat.nonDeprecated().filter(stat -> stat.quantityTypes.contains((Object)type)).filter(stat -> integrals.contains((Object)stat.integral)).collect(Collectors.toCollection(() -> EnumSet.noneOf(QuantityStat.class)));
    }

    private static /* synthetic */ Quantity[] $values() {
        return new Quantity[]{ABSORPTION_COEFFICIENT, ADIABATIC_SURFACE_TEMPERATURE_GAS, ASPIRATION, AVERAGE_SPECIFIC_HEAT, CABLE_TEMPERATURE, CONDUCTIVITY, DENSITY, DIVERGENCE, ENTHALPY, SENSIBLE_ENTHALPY, EXTINCTION, EXTINCTION_COEFFICIENT, EFFECTIVE_FLAME_TEMP, FED, FIC, H, HRRPUL, HRRPUV, MIXTURE_FRACTION, OPTICAL_DENSITY, PRESSURE, BACKGROUND_PRESSURE, RADIATIVE_HEAT_FLUX_GAS, GAUGE_HEAT_FLUX_GAS, RELATIVE_HUMIDITY, SPECIFIC_ENTHALPY, SPECIFIC_SENSIBLE_ENTHALPY, SPECIFIC_HEAT, TEMPERATURE, THERMOCOUPLE, U_VELOCITY, V_VELOCITY, W_VELOCITY, VELOCITY, VISCOSITY, VISIBILITY, ADIABATIC_SURFACE_TEMPERATURE, BACK_WALL_TEMPERATURE, BURNING_RATE, CONVECTIVE_FLUX, FRICTION_VELOCITY, GAS_TEMPERATURE, GAUGE_HEAT_FLUX, HEAT_FLUX, HEAT_TRANSFER_COEFFICIENT, HRRPUA, INCIDENT_HEAT_FLUX, INSIDE_WALL_TEMPERATURE, NORMAL_VELOCITY, PRESSURE_COEFFICIENT, RADIATIVE_FLUX, RADIOMETER, SOLID_CONDUCTIVITY, SOLID_SPECIFIC_HEAT, SOLID_ENTHALPY, SOLID_CONDUCTIVITY_MAT, SOLID_ENTHALPY_MAT, SOLID_MASS_FRACTION_MAT, SOLID_SPECIFIC_HEAT_MAT, SURFACE_DENSITY, WALL_TEMPERATURE, WALL_THICKNESS, NORMALIZED_HEATING_RATE, NORMALIZED_HEAT_RELEASE_RATE, MASS_LOSS, HRR, HEAT_FLOW, HEAT_FLOW_WALL, MASS_FLOW, MASS_FLOW_WALL, VOLUME_FLOW, VOLUME_FLOW_WALL, ENTHALPY_FLUX_X, ENTHALPY_FLUX_Y, ENTHALPY_FLUX_Z, ENTHALPY_FLUX_WALL, NOSPEC_MASS_FLUX, NOSPEC_MASS_FLUX_WALL, NOSPEC_TOTAL_MASS_FLUX_WALL, NOSPEC_MASS_FLUX_X, NOSPEC_MASS_FLUX_Y, NOSPEC_MASS_FLUX_Z, NOSPEC_MASS_FLUX_X_TOTAL, NOSPEC_MASS_FLUX_Y_TOTAL, NOSPEC_MASS_FLUX_Z_TOTAL, NOSPEC_MASS_FLUX_X_ADVECTIVE, NOSPEC_MASS_FLUX_Y_ADVECTIVE, NOSPEC_MASS_FLUX_Z_ADVECTIVE, NOSPEC_MASS_FLUX_X_DIFFUSIVE, NOSPEC_MASS_FLUX_Y_DIFFUSIVE, NOSPEC_MASS_FLUX_Z_DIFFUSIVE, VOLUME_FLOW_X, VOLUME_FLOW_Y, VOLUME_FLOW_Z, VOLUME_FLOW_BOUNDARY, ENTHALPY_FLOW_X, ENTHALPY_FLOW_Y, ENTHALPY_FLOW_Z, ENTHALPY_FLOW_WALL, NOSPEC_MASS_FLOW, NOSPEC_MASS_FLOW_WALL, NOSPEC_TOTAL_MASS_FLOW_WALL, NOSPEC_MASS_FLOW_X, NOSPEC_MASS_FLOW_Y, NOSPEC_MASS_FLOW_Z, NOSPEC_MASS_FLOW_X_TOTAL, NOSPEC_MASS_FLOW_Y_TOTAL, NOSPEC_MASS_FLOW_Z_TOTAL, NOSPEC_MASS_FLOW_X_ADVECTIVE, NOSPEC_MASS_FLOW_Y_ADVECTIVE, NOSPEC_MASS_FLOW_Z_ADVECTIVE, NOSPEC_MASS_FLOW_X_DIFFUSIVE, NOSPEC_MASS_FLOW_Y_DIFFUSIVE, NOSPEC_MASS_FLOW_Z_DIFFUSIVE, LAYER_HEIGHT, LOWER_TEMPERATURE, PATH_OBSCURATION, TRANSMISSION, UPPER_TEMPERATURE, CHAMBER_OBSCURATION, LINK_TEMPERATURE, SPRINKLER_LINK_TEMPERATURE, CONTROL_VALUE, ACTUATED_SPRINKLERS, CPU_TIME, CPU_TIME_PER_STEP, DEPOSITION_VELOCITY, ITERATION, NUMBER_OF_PARTICLES, OPEN_NOZZLES, PRESSURE_ZONE, TIME, TIME_STEP, TURBULENCE_RESOLUTION, WALL_CLOCK_TIME, WALL_CLOCK_TIME_ITERATIONS, AERO_VOLUME_FRACTION, SPEC_MASS_FRACTION, SPEC_VOLUME_FRACTION, SPEC_MASS_FLUX_X, SPEC_MASS_FLUX_Y, SPEC_MASS_FLUX_Z, SPEC_MASS_FLUX, SPEC_DENSITY, SPEC_VISIBILITY, SPEC_OPTICAL_DENSITY, SPEC_SURFACE_DEPOSITION, SPEC_AMPUA, SPEC_CPUA, SPEC_MPUA, SPEC_MPUV, SPEC_MASS_FLUX_WALL, SPEC_TOTAL_MASS_FLUX_WALL, SPEC_MASS_FLUX_X_TOTAL, SPEC_MASS_FLUX_Y_TOTAL, SPEC_MASS_FLUX_Z_TOTAL, SPEC_MASS_FLUX_X_ADVECTIVE, SPEC_MASS_FLUX_Y_ADVECTIVE, SPEC_MASS_FLUX_Z_ADVECTIVE, SPEC_MASS_FLUX_X_DIFFUSIVE, SPEC_MASS_FLUX_Y_DIFFUSIVE, SPEC_MASS_FLUX_Z_DIFFUSIVE, SPEC_MASS_FLOW, SPEC_MASS_FLOW_WALL, SPEC_TOTAL_MASS_FLOW_WALL, SPEC_MASS_FLOW_X, SPEC_MASS_FLOW_Y, SPEC_MASS_FLOW_Z, SPEC_MASS_FLOW_X_TOTAL, SPEC_MASS_FLOW_Y_TOTAL, SPEC_MASS_FLOW_Z_TOTAL, SPEC_MASS_FLOW_X_ADVECTIVE, SPEC_MASS_FLOW_Y_ADVECTIVE, SPEC_MASS_FLOW_Z_ADVECTIVE, SPEC_MASS_FLOW_X_DIFFUSIVE, SPEC_MASS_FLOW_Y_DIFFUSIVE, SPEC_MASS_FLOW_Z_DIFFUSIVE, MATL_DENSITY, MATL_SOLID_DENSITY, PART_ACMPUA, PART_CPUA, PART_MASS_FLUX_X, PART_MASS_FLUX_Y, PART_MASS_FLUX_Z, PART_MPUA, PART_MPUV, HVAC_AIRCOIL_HEAT_EXCHANGE, HVAC_DUCT_DENSITY, HVAC_CELL_DENSITY, HVAC_DUCT_CELL_MASS_FRACTION, HVAC_DUCT_CELL_TEMPERATURE, HVAC_DUCT_CELL_VOLUME_FRACTION, HVAC_DUCT_ENTHALPY_FLOW, HVAC_DUCT_LOSS, HVAC_DUCT_MASS_FLOW, HVAC_DUCT_MASS_FRACTION, HVAC_DUCT_TEMPERATURE, HVAC_DUCT_VELOCITY, HVAC_DUCT_VOLUME_FLOW, HVAC_DUCT_VOLUME_FRACTION, HVAC_DUCT_ENERGY_FLOW, HVAC_FAN_PRESSURE, HVAC_FILTER_LOADING, HVAC_FILTER_LOSS, HVAC_NODE_DENSITY, HVAC_NODE_ENTHALPY, HVAC_NODE_SENSIBLE_ENTHALPY, HVAC_NODE_MASS_FRACTION, HVAC_NODE_PRESSURE, HVAC_NODE_PRESSURE_DIFFERENCE, HVAC_NODE_TEMPERATURE, HVAC_NODE_VOLUME_FRACTION, OUT_HVAC_AIRCOIL_HEAT_EXCHANGE, OUT_HVAC_DUCT_DENSITY, OUT_HVAC_CELL_DENSITY, OUT_HVAC_DUCT_CELL_MASS_FRACTION, OUT_HVAC_DUCT_CELL_TEMPERATURE, OUT_HVAC_DUCT_CELL_VOLUME_FRACTION, OUT_HVAC_DUCT_ENTHALPY_FLOW, OUT_HVAC_DUCT_LOSS, OUT_HVAC_DUCT_MASS_FLOW, OUT_HVAC_DUCT_MASS_FRACTION, OUT_HVAC_DUCT_TEMPERATURE, OUT_HVAC_DUCT_VELOCITY, OUT_HVAC_DUCT_VOLUME_FLOW, OUT_HVAC_DUCT_VOLUME_FRACTION, OUT_HVAC_FAN_PRESSURE, OUT_HVAC_FILTER_LOADING, OUT_HVAC_FILTER_LOSS, OUT_HVAC_NODE_DENSITY, OUT_HVAC_NODE_ENTHALPY, OUT_HVAC_NODE_SENSIBLE_ENTHALPY, OUT_HVAC_NODE_MASS_FRACTION, OUT_HVAC_NODE_PRESSURE, OUT_HVAC_NODE_PRESSURE_DIFFERENCE, OUT_HVAC_NODE_TEMPERATURE, OUT_HVAC_NODE_VOLUME_FRACTION, CELL_U, CELL_V, CELL_W, YPLUS, PDPA, INTEGRATED_INTENSITY, RADIATION_LOSS, CHEMISTRY_ITER};
    }

    static {
        $VALUES = Quantity.$values();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FDSDeprecated {
        public String vFDS();

        public int vPyro();
    }

    private static class MasslessPartFilter
    implements Predicate<Particle> {
        private MasslessPartFilter() {
        }

        @Override
        public boolean test(Particle o) {
            return !o.isType(Particle.Type.TRACER);
        }

        public String toString() {
            return Intl.intl("Particle must have mass.");
        }
    }
}

