/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import pyrosim.Intl;
import thunderheadeng.cad.bim.BIMType;

public enum ImportType {
    IGNORE(Intl.intl("<ignored>"), Intl.intl("The object will not be converted.")),
    SLAB(Intl.intl("Slab"), Intl.intl("The object will be converted into slab geometry.")),
    WALL(Intl.intl("Wall"), Intl.intl("The object will be converted into wall geometry.")),
    DOOR(Intl.intl("Door"), Intl.intl("The object will be converted into an obstruction and a hole. The best geometry will be automatically detected.")),
    WINDOW(Intl.intl("Window"), Intl.intl("The object will be converted into an obstruction and a hole. The best geometry will be automatically detected.")),
    REMOVE(Intl.intl("Remove"), Intl.intl("The object will be deleted."));

    public final String name;
    public final String desc;

    private ImportType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public static ImportType fromBIMType(BIMType bimType) {
        if (bimType.isDescendentOf(BIMType.Slab)) {
            return SLAB;
        }
        if (bimType.isDescendentOf(BIMType.Wall)) {
            return WALL;
        }
        if (bimType.isDescendentOf(BIMType.CurtainWall)) {
            return WALL;
        }
        if (bimType.isDescendentOf(BIMType.Window)) {
            return WINDOW;
        }
        if (bimType.isDescendentOf(BIMType.Door)) {
            return DOOR;
        }
        if (bimType.isDescendentOf(BIMType.BuildingElementProxy)) {
            return IGNORE;
        }
        if (bimType.isDescendentOf(BIMType.Space)) {
            return REMOVE;
        }
        return IGNORE;
    }
}

