/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.HoleFragGenerator;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.picking.IPickable;

public class Hole
extends AFDSObject
implements IHole {
    static final long serialVersionUID = 1L;
    public static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);
    private Object d_geom;

    public Hole(String name, IGeomNode geom) {
        super(name);
        this.d_geom = geom;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean prior87;
        in.defaultReadObject();
        boolean bl = prior87 = PyroSimObjectInputStream.getVersion(in) < 87;
        if (prior87) {
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("HOLE");
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public IModelObj getRestoreObject() {
        return (Hole)this.clone();
    }

    @Override
    public void imprint(IModelObj obj) {
        if (!(obj instanceof Hole)) {
            assert (false);
        } else {
            this.pauseUpdates();
            super.imprint(obj);
            this.resumeUpdates();
        }
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dprops, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dprops.isWireframe(this));
        return new DisplayGeom(pickable, IPickable.DEF_PROPS);
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (geom == this.d_geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    private static IPrimProps toProps(Color c, boolean cull) {
        c = c == null ? DEF_COLOR : new Color(c.getRed(), c.getGreen(), c.getBlue(), 102);
        return new IPrimProps.Face(c, null, cull ? 2 : 0);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPropsSrc props;
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        DisplayGeom disp = FDSUtil.getRastDisplay(pyroProps, this, TexOrigin.DEF_WORLD);
        if (disp != null) {
            return disp;
        }
        Color[] c = this.getColors();
        boolean cullGeom = GeomUtil.isCullGeom(this.getGeom());
        if (c.length == 1) {
            props = new UniformProps(Hole.toProps(c[0], cullGeom));
        } else {
            IPrimProps[] fprops = new IPrimProps[c.length];
            for (int m = 0; m < c.length; ++m) {
                fprops[m] = Hole.toProps(c[m], cullGeom);
            }
            props = new FlattenedProps(fprops);
        }
        return new DisplayGeom(this.getGeom(), props);
    }

    private class FragGen
    implements IFDSObjProps {
        private FaceProps d_faceProps;

        private FragGen() {
            this.d_faceProps = new FaceProps(Hole.this.getColors()[0]);
        }

        @Override
        public FaceProps getFace(int ix) {
            return this.d_faceProps;
        }

        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rastOptions) {
            return new HoleFragGenerator(Hole.this, rastOptions);
        }

        @Override
        public boolean thickenEnabled() {
            return true;
        }
    }
}

